<?php
/**
 * Vendor Dashboard View
 * 
 * @var array $vendor Vendor data from session
 * @var array $stats Dashboard statistics
 * @var array $recentJobs List of recent jobs
 */
?>

<div class="container-fluid py-4">
    <!-- Page Header -->
    <div class="d-flex justify-content-between align-items-center mb-4">
        <h1 class="h3 mb-0">Vendor Dashboard</h1>
        <div class="text-muted">Welcome back, <?= htmlspecialchars($vendor['name'] ?? 'Vendor') ?></div>
    </div>

    <!-- Stats Cards -->
    <div class="row g-4 mb-4">
        <div class="col-md-3">
            <div class="card border-0 shadow-sm h-100">
                <div class="card-body">
                    <div class="d-flex align-items-center">
                        <div class="bg-primary bg-opacity-10 p-3 rounded-circle me-3">
                            <i class="bi bi-briefcase text-primary fs-4"></i>
                        </div>
                        <div>
                            <h6 class="mb-0 text-muted">Total Jobs</h6>
                            <h2 class="mb-0"><?= number_format($stats['total_jobs'] ?? 0) ?></h2>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        
        <div class="col-md-3">
            <div class="card border-0 shadow-sm h-100">
                <div class="card-body">
                    <div class="d-flex align-items-center">
                        <div class="bg-warning bg-opacity-10 p-3 rounded-circle me-3">
                            <i class="bi bi-hourglass-split text-warning fs-4"></i>
                        </div>
                        <div>
                            <h6 class="mb-0 text-muted">Pending</h6>
                            <h2 class="mb-0"><?= number_format($stats['pending_jobs'] ?? 0) ?></h2>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        
        <div class="col-md-3">
            <div class="card border-0 shadow-sm h-100">
                <div class="card-body">
                    <div class="d-flex align-items-center">
                        <div class="bg-success bg-opacity-10 p-3 rounded-circle me-3">
                            <i class="bi bi-check-circle text-success fs-4"></i>
                        </div>
                        <div>
                            <h6 class="mb-0 text-muted">Completed</h6>
                            <h2 class="mb-0"><?= number_format($stats['completed_jobs'] ?? 0) ?></h2>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        
        <div class="col-md-3">
            <div class="card border-0 shadow-sm h-100">
                <div class="card-body">
                    <div class="d-flex align-items-center">
                        <div class="bg-info bg-opacity-10 p-3 rounded-circle me-3">
                            <i class="bi bi-cash-coin text-info fs-4"></i>
                        </div>
                        <div>
                            <h6 class="mb-0 text-muted">Total Revenue</h6>
                            <h2 class="mb-0">฿<?= number_format($stats['revenue'] ?? 0, 2) ?></h2>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Recent Jobs -->
    <div class="card border-0 shadow-sm">
        <div class="card-header bg-white border-0 py-3">
            <h5 class="mb-0">Recent Jobs</h5>
        </div>
        <div class="card-body p-0">
            <?php if (!empty($recentJobs)): ?>
                <div class="table-responsive">
                    <table class="table table-hover mb-0">
                        <thead class="table-light">
                            <tr>
                                <th>Job ID</th>
                                <th>Customer</th>
                                <th>Pickup</th>
                                <th>Drop-off</th>
                                <th>Status</th>
                                <th>Vendor Cost</th>
                                <th>Date</th>
                                <th>Action</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php foreach ($recentJobs as $job): ?>
                                <tr>
                                    <td>#<?= htmlspecialchars($job['id'] ?? '') ?></td>
                                    <td><?= htmlspecialchars($job['customer_name'] ?? 'N/A') ?></td>
                                    <td><?= htmlspecialchars($job['from_text'] ?? '') ?></td>
                                    <td><?= htmlspecialchars($job['to_text'] ?? '') ?></td>
                                    <td>
                                        <?php
                                          $st = strtolower((string)($job['status'] ?? 'pending'));
                                          $badge = 'warning';
                                          if ($st === 'confirmed' || $st === 'completed') { $badge = 'success'; }
                                          elseif ($st === 'cancelled') { $badge = 'secondary'; }
                                          elseif ($st === 'refunded') { $badge = 'warning'; }
                                          elseif ($st === 'failed') { $badge = 'danger'; }
                                        ?>
                                        <span class="badge bg-<?= $badge ?> text-dark"><?= ucfirst(htmlspecialchars($st)) ?></span>
                                    </td>
                                    <td>
                                      <?php
                                        $vamt = (float)($job['vendor_cost'] ?? 0);
                                        $vcur = (string)($job['vendor_currency'] ?? ($job['currency'] ?? 'THB'));
                                        echo number_format($vamt, 2).' '.htmlspecialchars($vcur);
                                      ?>
                                    </td>
                                    <td>
                                      <?php
                                        $d = (string)($job['trip_date'] ?? '');
                                        $t = trim((string)($job['pickup_time'] ?? ''));
                                        echo $d !== '' ? htmlspecialchars(date('M d, Y', strtotime($d))) : 'N/A';
                                        if ($t !== '') { echo ' <span class="text-muted">'.htmlspecialchars($t).'</span>'; }
                                      ?>
                                    </td>
                                    <td>
                                        <a href="/vendor/job/view?id=<?= $job['id'] ?>" class="btn btn-sm btn-outline-primary">
                                            View
                                        </a>
                                    </td>
                                </tr>
                            <?php endforeach; ?>
                        </tbody>
                    </table>
                </div>
            <?php else: ?>
                <div class="text-center py-5">
                    <div class="text-muted mb-3">
                        <i class="bi bi-inbox fs-1"></i>
                    </div>
                    <h5>No jobs found</h5>
                    <p class="text-muted">Your recent jobs will appear here</p>
                </div>
            <?php endif; ?>
        </div>
        <?php if (!empty($recentJobs)): ?>
            <div class="card-footer bg-white text-end">
                <a href="/vendor/jobs" class="btn btn-sm btn-outline-primary">View All Jobs</a>
            </div>
        <?php endif; ?>
    </div>
</div>
