<div class="d-flex align-items-center justify-content-between mb-3">
  <h1 class="h5 mb-0">Users</h1>
  <a href="/users/create" class="btn btn-sm btn-primary">Add User</a>
</div>
<div class="table-responsive">
  <table class="table table-hover align-middle">
    <thead><tr><th>ID</th><th>Name</th><th>Email</th><th>Role</th><th>Status</th><th></th></tr></thead>
    <tbody>
      <?php foreach ($users as $u): ?>
        <tr>
          <td><?= (int)$u['id'] ?></td>
          <td><?= App\Core\Security::sanitize($u['name']) ?></td>
          <td><?= App\Core\Security::sanitize($u['email']) ?></td>
          <td><span class="badge bg-secondary"><?= App\Core\Security::sanitize($u['role']) ?></span></td>
          <td><?= App\Core\Security::sanitize($u['status']) ?></td>
          <td class="text-end">
            <a class="btn btn-sm btn-outline-primary" href="/users/edit?id=<?= (int)$u['id'] ?>">Edit</a>
            <form action="/users/delete" method="post" class="d-inline ms-1" onsubmit="return confirm('Delete user?')">
              <input type="hidden" name="csrf" value="<?= App\Core\Security::csrfToken(); ?>">
              <input type="hidden" name="id" value="<?= (int)$u['id'] ?>">
              <button class="btn btn-sm btn-outline-danger">Delete</button>
            </form>
          </td>
        </tr>
      <?php endforeach; ?>
    </tbody>
  </table>
</div>
