<h1 class="h5 mb-3">Edit User</h1>
<form method="post" action="/users/update" class="row g-3">
  <input type="hidden" name="csrf" value="<?= App\Core\Security::csrfToken(); ?>">
  <input type="hidden" name="id" value="<?= (int)$user['id'] ?>">
  <div class="col-md-6">
    <label class="form-label">Name</label>
    <input class="form-control" name="name" value="<?= App\Core\Security::sanitize($user['name']) ?>" required>
  </div>
  <div class="col-md-6">
    <label class="form-label">Email</label>
    <input type="email" class="form-control" name="email" value="<?= App\Core\Security::sanitize($user['email']) ?>" required>
  </div>
  <div class="col-md-4">
    <label class="form-label">Role</label>
    <select class="form-select" name="role">
      <?php $roles=['Admin','Employee','Channel Partner','B2B Agent','Vendor']; foreach($roles as $r): ?>
        <option <?= $user['role']===$r?'selected':'' ?>><?= $r ?></option>
      <?php endforeach; ?>
    </select>
  </div>
  <div class="col-md-4">
    <label class="form-label">Status</label>
    <select class="form-select" name="status">
      <?php $st=['Active','Inactive']; foreach($st as $s): ?>
        <option <?= $user['status']===$s?'selected':'' ?>><?= $s ?></option>
      <?php endforeach; ?>
    </select>
  </div>
  <div class="col-12">
    <button class="btn btn-primary">Update</button>
    <a class="btn btn-light" href="/users">Cancel</a>
  </div>
</form>
