<?php
// app/Views/layouts/admin_header.php
// This file is included at the top of admin views for additional admin-specific header content

// Set admin page flag if not already set
$isAdminPage = $isAdminPage ?? true;
$showAdminSidebar = $showAdminSidebar ?? true;

// Add admin-specific styles
$adminStyles = <<<HTML
<style>
  .admin-container {
    min-height: calc(100vh - 200px);
  }
  .sidebar-sticky {
    position: -webkit-sticky;
    position: sticky;
    top: 1rem;
  }
</style>
HTML;

// Add admin-specific scripts
$adminScripts = <<<HTML
<script>
  // Admin-specific scripts can go here
  document.addEventListener('DOMContentLoaded', function() {
    // Initialize tooltips if needed
    if (typeof bootstrap !== 'undefined' && bootstrap.Tooltip) {
      var tooltipTriggerList = [].slice.call(document.querySelectorAll('[data-bs-toggle="tooltip"]'));
      tooltipTriggerList.map(function (tooltipTriggerEl) {
        return new bootstrap.Tooltip(tooltipTriggerEl);
      });
    }
  });
</script>
HTML;

// Add to existing head content if it exists
$headContent = $headContent ?? '';
$headContent .= $adminStyles;

// Add to existing scripts if they exist
$scripts = $scripts ?? '';
$scripts .= $adminScripts;

// Include the main layout
require __DIR__ . '/main.php';

// Prevent double inclusion
$adminHeaderIncluded = true;
?>
