<div class="d-flex align-items-center justify-content-between mb-3">
  <h1 class="h5 mb-0">Hotels</h1>
  <a href="/hotels/create" class="btn btn-sm btn-primary">Add Hotel</a>
</div>
<div class="row g-3">
  <?php foreach ($hotels as $h): ?>
    <div class="col-md-4">
      <div class="card h-100 shadow-sm">
        <div class="card-body">
          <div class="fw-semibold mb-1"><?php echo App\Core\Security::sanitize($h['name']); ?></div>
          <div class="text-muted small mb-2"><?php echo App\Core\Security::sanitize($h['city'] . ', ' . $h['country']); ?></div>
          <div class="fw-bold">$<?php echo number_format($h['base_price'], 2); ?></div>
        </div>
        <div class="card-footer bg-white text-end">
          <a class="btn btn-sm btn-outline-primary" href="/hotels/edit?id=<?= (int)$h['id'] ?>">Edit</a>
          <form action="/admin/hotels/delete" method="post" class="d-inline ms-1" onsubmit="return confirm('Delete hotel?')">
            <input type="hidden" name="csrf" value="<?= App\Core\Security::csrfToken(); ?>">
            <input type="hidden" name="id" value="<?= (int)$h['id'] ?>">
            <button class="btn btn-sm btn-outline-danger">Delete</button>
          </form>
        </div>
      </div>
    </div>
  <?php endforeach; ?>
</div>
