<?php
// Values are extracted by the View/renderer; support both new and legacy keys
$name = isset($name) ? $name : ($data['name'] ?? 'User');
$resetUrl = isset($resetLink) ? $resetLink : (($resetUrl ?? null) ?: ($data['resetUrl'] ?? '#'));

// Build a human-friendly expiry string
if (isset($expiresIn)) {
    $expiresText = $expiresIn;
} elseif (isset($expiresAt) && $expiresAt instanceof DateTimeInterface) {
    $expiresText = '1 hour';
} elseif (isset($data['expiresIn'])) {
    $expiresText = $data['expiresIn'];
} else {
    $expiresText = '1 hour';
}
?>
<!DOCTYPE html>
<html>
<head>
    <meta charset="UTF-8">
    <title>Reset Your Password - B2B Thai Hub</title>
    <style>
        body { font-family: Arial, sans-serif; line-height: 1.6; color: #333; max-width: 600px; margin: 0 auto; padding: 20px; }
        .button { 
            display: inline-block; 
            padding: 12px 24px; 
            background-color: #2563eb; 
            color: white; 
            text-decoration: none; 
            border-radius: 4px; 
            font-weight: bold;
            margin: 20px 0; 
        }
        .footer { 
            margin-top: 30px; 
            padding-top: 20px; 
            border-top: 1px solid #eee; 
            font-size: 12px; 
            color: #666; 
        }
        .container { max-width: 600px; margin: 0 auto; }
    </style>
</head>
<body>
    <div class="container">
        <h2>Reset Your Password</h2>
        <p>Hello <?= htmlspecialchars($name) ?>,</p>
        
        <p>We received a request to reset your password. Click the button below to set a new password:</p>
        
        <p>
            <a href="<?= htmlspecialchars($resetUrl) ?>" class="button">
                Reset Password
            </a>
        </p>
        
        <p>Or copy and paste this link into your browser:</p>
        <p><code><?= htmlspecialchars($resetUrl) ?></code></p>
        
        <p>This link will expire in <?= htmlspecialchars($expiresText) ?>. If you didn't request this, you can safely ignore this email.</p>
        
        <div class="footer">
            <p>If you're having trouble with the button above, copy and paste the URL below into your web browser.</p>
            <p>© <?= date('Y') ?> B2B Thai Hub. All rights reserved.</p>
        </div>
    </div>
</body>
</html>
