<script>
  function renderContact(order){
    const cName = document.getElementById('cName');
    const cMobile = document.getElementById('cMobile');
    const cEmail = document.getElementById('cEmail');
    const cWhatsapp = document.getElementById('cWhatsapp');
    const contactStatus = document.getElementById('contactStatus');
    if (cName) cName.value = order.customer_name || '';
    if (cMobile) cMobile.value = order.customer_mobile || '';
    if (cEmail) cEmail.value = order.customer_email || '';
    if (cWhatsapp) cWhatsapp.value = order.customer_whatsapp || '';
    if (contactStatus) contactStatus.textContent = '';
  }

  function isContactComplete(){
    const cName = document.getElementById('cName');
    const cMobile = document.getElementById('cMobile');
    return ((cName?.value||'').trim().length >= 2) && ((cMobile?.value||'').trim().length >= 6);
  }

  function updatePayButtonState(){
    const statusOk = (window.orderData?.order?.status === 'pending');
    const ready = statusOk && isContactComplete();
    try { const payBtn = document.getElementById('btnPayWallet'); if (payBtn) payBtn.disabled = !ready; } catch(_){}
    try {
      const walletBox = document.getElementById('walletBox');
      if (walletBox) walletBox.style.display = ready ? '' : 'none';
    } catch(_){ }
  }

  async function saveContact(){
    try{
      const btnSaveContact = document.getElementById('btnSaveContact');
      const contactStatus = document.getElementById('contactStatus');
      if (btnSaveContact) btnSaveContact.disabled = true;
      if (contactStatus) contactStatus.textContent = 'Saving…';
      const res = await fetch('/b2b/api/checkout/order-contact', {
        method: 'POST',
        headers: {
          'Content-Type': 'application/json',
          'Accept': 'application/json',
          'X-CSRF-Token': (window.CSRF_TOKEN||'')
        },
        body: JSON.stringify({
          order_id: window.orderId,
          customer_name: (document.getElementById('cName')?.value||'').trim(),
          customer_mobile: (document.getElementById('cMobile')?.value||'').trim(),
          customer_email: (document.getElementById('cEmail')?.value||'').trim(),
          customer_whatsapp: (document.getElementById('cWhatsapp')?.value||'').trim(),
        })
      });
      const json = await res.json();
      if(!res.ok || json.error){
        if (contactStatus) { contactStatus.textContent = json && json.error ? json.error : 'Failed to save'; contactStatus.classList.remove('text-muted'); contactStatus.classList.add('text-danger'); }
        if (btnSaveContact) btnSaveContact.disabled = false;
        return;
      }
      if (contactStatus) { contactStatus.textContent = 'Saved'; contactStatus.classList.remove('text-danger'); contactStatus.classList.add('text-success'); }
      // refresh order to reflect updated fields
      await loadOrder();
    }catch(e){
      const contactStatus = document.getElementById('contactStatus');
      if (contactStatus) { contactStatus.textContent = 'Error saving contact'; contactStatus.classList.remove('text-muted'); contactStatus.classList.add('text-danger'); }
    }finally{
      const btnSaveContact = document.getElementById('btnSaveContact');
      if (btnSaveContact) btnSaveContact.disabled = false;
      updatePayButtonState();
    }
  }
</script>
<?php
// app/Views/checkout/index.php
/** @var int $orderId */
$title = 'Checkout / Fill Customer Detail for Booking';
?>
<div class="row g-4">
  <div class="col-12 col-lg-8">
    <h1 class="h4 mb-1">Checkout / Fill Customer Detail for Booking</h1>
    <!-- Simple stepper -->
    <div class="mb-3">
      <ol class="list-unstyled d-flex gap-3 align-items-center small text-muted mb-0">
        <li class="d-flex align-items-center"><span class="badge rounded-pill bg-primary me-2">1</span> Fill customer details</li>
        <li class="text-muted">›</li>
        <li class="d-flex align-items-center"><span class="badge rounded-pill bg-secondary me-2">2</span> Review order</li>
        <li class="text-muted">›</li>
        <li class="d-flex align-items-center"><span class="badge rounded-pill bg-secondary me-2">3</span> Payment</li>
      </ol>
    </div>
    <!-- Contact first on the left for a more professional flow -->
    <div class="card mb-3">
      <div class="card-header bg-white fw-semibold">Customer Details:</div>
      <div class="card-body">
        <div class="row g-3">
          <div class="col-12">
            <label class="form-label">Customer Name <span class="text-danger">*</span></label>
            <input id="cName" type="text" class="form-control" placeholder="Full name" autofocus>
          </div>
          <div class="col-12 col-md-6">
            <label class="form-label">Mobile Number <span class="text-danger">*</span></label>
            <input id="cMobile" type="text" class="form-control" placeholder="Mobile number">
          </div>
          <div class="col-12 col-md-6">
            <label class="form-label">Email <span class="text-muted small">(optional)</span></label>
            <input id="cEmail" type="email" class="form-control" placeholder="name@example.com">
          </div>
          <div class="col-12 col-md-6">
            <label class="form-label">WhatsApp <span class="text-muted small">(optional)</span></label>
            <input id="cWhatsapp" type="text" class="form-control" placeholder="WhatsApp number">
          </div>
          <div class="col-12 d-flex align-items-center gap-2">
            <span id="contactStatus" class="small text-muted"></span>
          </div>
        </div>
      </div>
    </div>

    <!-- Order summary below contact -->
    <div id="orderSummary" class="card">
      <div class="card-body">
        <div class="d-flex justify-content-between align-items-center mb-2">
          <div class="fw-semibold">Order <span class="text-muted">#<?= (int)$orderId ?></span></div>
          <span id="orderStatusBadge" class="badge bg-warning text-dark" style="display:none">pending</span>
        </div>
        <div id="orderDetails" class="mb-3 text-muted">Loading order…</div>
        <!-- Step 3: Payment directly under review -->
        <div id="walletBox" style="display:none">
          <div class="d-flex justify-content-between align-items-center mb-2">
            <div class="fw-semibold">Payment</div>
            <div id="walletBalance" class="text-muted small">–</div>
          </div>
          <button id="btnPayWallet" class="btn btn-primary w-100" disabled>
            <span class="label">Make Payment</span>
          </button>
          <div class="small text-muted mt-2">Your wallet balance will be used for this order.</div>
        </div>
      </div>
    </div>
  </div>
  <div class="col-12 col-lg-4">
    <div class="position-sticky" style="top: 88px;">
      <div class="card">
        <div class="card-header bg-white fw-semibold">Summary</div>
        <div class="card-body">
          <div class="d-flex justify-content-between mb-1 small text-muted"><div>Order</div><div>#<?= (int)$orderId ?></div></div>
          <div id="summaryCustomer" class="small text-muted mb-2">Customer: <em>not set</em></div>
          <div class="d-flex justify-content-between small mb-1"><div>Subtotal</div><div id="summarySubtotal">–</div></div>
          <div class="d-flex justify-content-between"><div><strong>Total</strong></div><div id="summaryTotal"><strong>–</strong></div></div>
          <hr>
          <div class="small text-muted">
            <div class="mb-1">Secure checkout</div>
            <div>24x7 support • Instant confirmations</div>
          </div>
        </div>
      </div>
    </div>
  </div>
</div>

<script>
(function(){
  window.orderId = <?= (int)$orderId ?>;
  window.checkoutSig = '<?= htmlspecialchars($sig, ENT_QUOTES) ?>';
  const orderBox = document.getElementById('orderSummary');
  const orderDetails = document.getElementById('orderDetails');
  const payBtn = document.getElementById('btnPayWallet');
  const walletEl = document.getElementById('walletBalance');
  const cName = document.getElementById('cName');
  const cMobile = document.getElementById('cMobile');
  const cEmail = document.getElementById('cEmail');
  const cWhatsapp = document.getElementById('cWhatsapp');
  const btnSaveContact = document.getElementById('btnSaveContact');
  const contactStatus = document.getElementById('contactStatus');
  window.orderData = null;

  async function loadOrder(){
    try{
      const url = `/b2b/api/checkout/order?id=${encodeURIComponent(window.orderId)}`;
      const res = await fetch(url, { headers: { 'Accept': 'application/json' } });
      const json = await res.json();
      if(!res.ok || json.error){
        if (orderDetails) orderDetails.innerHTML = `<div class="text-danger">${json && json.error ? json.error : 'Failed to load order.'}</div>`;
        payBtn.disabled = true;
        return;
      }
      window.orderData = json;
      renderOrder(json);
      renderContact(json.order||{});
      // reflect current inputs on the customer line immediately
      try{ updateCustomerPreview(); }catch(_){}
      updatePayButtonState();
    }catch(e){
      if (orderDetails) orderDetails.innerHTML = '<div class="text-danger">Unexpected error loading order.</div>';
      payBtn.disabled = true;
    }
  }

  // --- Helpers for customer preview ---
  function escapeHtml(s){ return String(s||'').replace(/&/g,'&amp;').replace(/</g,'&lt;').replace(/>/g,'&gt;'); }
  function customerLineInner(name, mobile){
    const n = (name||'').trim();
    const m = (mobile||'').trim();
    if (!n && !m) return 'Customer: <em>not set</em>';
    const namePart = n ? `Customer: <strong>${escapeHtml(n)}</strong>` : 'Customer:';
    const mobilePart = m ? ` • ${escapeHtml(m)}` : '';
    return namePart + mobilePart;
  }
  function updateCustomerPreview(){
    const n = document.getElementById('cName')?.value || '';
    const m = document.getElementById('cMobile')?.value || '';
    const inner = customerLineInner(n, m);
    const orderCust = document.getElementById('orderCustomer');
    if (orderCust) { orderCust.innerHTML = inner; }
    const sCust = document.getElementById('summaryCustomer');
    if (sCust) { sCust.innerHTML = `<div class="small text-muted">${inner}</div>`; }
  }

  function renderOrder(data){
    const order = data.order || {};
    const items = data.items || [];
    const currency = order.currency || 'THB';
    const custInner = customerLineInner(order.customer_name, order.customer_mobile);
    const list = items.length ? items.map((it,i)=>{
      const title = [it.name, it.variant_name].filter(Boolean).join(' – ') || ('Item #' + (i+1));
      const unitStr = Number(it.unit_price||0).toFixed(2) + ' ' + (it.currency || currency);
      return `
      <div class="d-flex justify-content-between py-1 border-bottom">
        <div>
          <div>${title}</div>
          <div class="text-muted small">${unitStr} × ${it.qty}${it.pax_type? ' ('+it.pax_type+')':''}</div>
        </div>
        <div class="text-muted small">${Number(it.line_total||0).toFixed(2)} ${it.currency || currency}</div>
      </div>`;
    }).join('') : '<div class="text-muted">No items found.</div>';

    // update status badge in the static header
    const badge = document.getElementById('orderStatusBadge');
    if (badge){
      const paid = (order.status === 'paid');
      badge.textContent = order.status || 'pending';
      badge.className = 'badge ' + (paid ? 'bg-success' : 'bg-warning text-dark');
      badge.style.display = '';
    }

    // render review details inside #orderDetails
    const subtotal = Number(items.reduce((a,b)=>a + (parseFloat(b.line_total)||0),0)).toFixed(2) + ' ' + currency;
    const total = Number(order.total||order.total_amount||0).toFixed(2) + ' ' + currency;
    if (orderDetails){
      orderDetails.classList.remove('text-muted');
      orderDetails.innerHTML = `
        <div id="orderCustomer" class="small text-muted">${custInner}</div>
        <div class="border rounded p-2 mb-2 bg-white">${list}</div>
        <div class="d-flex justify-content-between small"><div>Subtotal</div><div>${subtotal}</div></div>
        <div class="d-flex justify-content-between"><div><strong>Total</strong></div><div><strong>${total}</strong></div></div>
      `;
    }
    // sync right summary
    const sCust = document.getElementById('summaryCustomer');
    const sSub = document.getElementById('summarySubtotal');
    const sTot = document.getElementById('summaryTotal');
    if (sCust) sCust.innerHTML = `<div class="small text-muted">${custInner}</div>`;
    if (sSub) sSub.textContent = subtotal;
    if (sTot) sTot.innerHTML = `<strong>${total}</strong>`;
  }

  async function loadWallet(){
    try{
      const res = await fetch('/b2b/api/wallet', { headers:{'Accept':'application/json'} });
      const json = await res.json();
      if(res.ok && !json.error){
        walletEl.textContent = `${Number(json.balance||0).toFixed(2)} ${json.currency||'THB'}`;
      }else{
        walletEl.textContent = '–';
      }
    }catch(e){ walletEl.textContent = '–'; }
  }

  // After validating and saving contact, go to dedicated payment page
  async function startPaymentFlow(){
    try{
      // 1) Validate contact locally
      if (!isContactComplete()){
        const contactStatus = document.getElementById('contactStatus');
        if (contactStatus){
          contactStatus.textContent = 'Please enter Customer Name and Mobile Number before payment.';
          contactStatus.classList.remove('text-muted');
          contactStatus.classList.add('text-danger');
        }
        document.getElementById('cName')?.focus();
        document.querySelector('.card .card-header')?.scrollIntoView({behavior:'smooth', block:'start'});
        return;
      }
      // 2) Auto-save contact to order
      payBtn.disabled = true;
      payBtn.querySelector('.label').textContent = 'Processing…';
      const saveRes = await fetch('/b2b/api/checkout/order-contact', {
        method: 'POST',
        headers: { 'Content-Type':'application/json','Accept':'application/json','X-CSRF-Token': (window.CSRF_TOKEN||'') },
        body: JSON.stringify({
          order_id: window.orderId,
          customer_name: (document.getElementById('cName')?.value||'').trim(),
          customer_mobile: (document.getElementById('cMobile')?.value||'').trim(),
          customer_email: (document.getElementById('cEmail')?.value||'').trim(),
          customer_whatsapp: (document.getElementById('cWhatsapp')?.value||'').trim(),
        })
      });
      const saveJson = await saveRes.json().catch(()=>({error:'Invalid response'}));
      if(!saveRes.ok || saveJson.error){
        alert(saveJson && saveJson.error ? saveJson.error : 'Failed to save contact');
        payBtn.disabled = false;
        payBtn.querySelector('.label').textContent = 'Make Payment';
        return;
      }
      // refresh top-of-order customer line after save (non-blocking)
      loadOrder();
      // Cache minimal contact so payment page can show it instantly
      try {
        const key = `checkout_contact_${window.orderId}`;
        const payload = {
          name: (document.getElementById('cName')?.value||'').trim(),
          mobile: (document.getElementById('cMobile')?.value||'').trim()
        };
        sessionStorage.setItem(key, JSON.stringify(payload));
      } catch(_){ }
      // 3) Redirect to payment selection page
      const url = `/b2b/checkout/pay?id=${encodeURIComponent(window.orderId)}&sig=${encodeURIComponent(window.checkoutSig||'')}`;
      window.location = url;
      
    }catch(e){
      alert('Unexpected error');
      payBtn.disabled = false;
      payBtn.querySelector('.label').textContent = 'Make Payment';
    }
  }

  cName.addEventListener('input', ()=>{ updatePayButtonState(); updateCustomerPreview(); });
  cMobile.addEventListener('input', ()=>{ updatePayButtonState(); updateCustomerPreview(); });
  payBtn.addEventListener('click', startPaymentFlow);
  loadOrder();
  loadWallet();
})();
</script>

