<?php
// app/Views/checkout/confirm.php
/** @var int $orderId */
/** @var string $sig */
$title = 'Booking Confirmed';
?>
<!-- Removed agent theme stylesheet -->
<div class="agent-hero">
  <div class="agent-container">
    <div class="hero-inner">
      <div class="hero-title">Payment Successful</div>
      <div class="hero-sub">Your booking is confirmed. Review details below.</div>
    </div>
  </div>
</div>

<div class="agent-container">
  <div class="pay-grid">
    <div>
    <!-- Hero -->
    <div class="ag-card mb-3">
      <div class="ag-card-body">
        <div class="flex items-center">
          <div style="width:48px;height:48px;border-radius:50%;background:#e8f7ea;display:flex;align-items:center;justify-content:center;color:#1e7e34;font-size:26px;margin-right:12px;">✓</div>
          <div class="flex-grow-1">
            <h1 class="h4 m-0">Payment Successful</h1>
            <div class="text-muted small mt-1">Your booking is confirmed. A confirmation has been recorded in your dashboard.</div>
            <?php $agent = $_SESSION['user'] ?? null; ?>
            <?php if (!empty($agent)):
              $agencyCompany = $agent['company'] ?? ($agent['company_name'] ?? null);
              $agentPerson = $agent['name'] ?? 'Your Agency';
            ?>
              <div class="small mt-1">Booked via <strong><?= htmlspecialchars($agencyCompany ?: $agentPerson) ?></strong></div>
            <?php endif; ?>
            <div class="flex items-center justify-between mt-2">
              <div class="flex items-center gap-2" style="flex-wrap:wrap;">
                <span class="ag-badge" style="background:#f7f7f9;border:1px solid #eee;color:#666;">Order #<?= (int)$orderId ?></span>
                <span id="orderStatusBadge" class="ag-badge success">Payment Success</span>
                <span class="ag-badge" style="background:#f7f7f9;border:1px solid #eee;color:#666;">Date: <span id="metaDate">—</span></span>
              </div>
              <div class="no-print">
                <button class="ag-btn-outline" onclick="window.print()">Print</button>
              </div>
            </div>
          </div>
        </div>
      </div>
    </div>

    <!-- Summary -->
    <div class="ag-card mb-3">
      <div class="ag-card-header">Booking Summary</div>
      <div class="ag-card-body">
        <div id="heroSummary" class="mb-3 text-muted">Loading details…</div>
        <div id="itemsList" class="list-card"></div>
        <div class="flex justify-between small mb-1"><div>Subtotal</div><div id="subtotal">–</div></div>
        <div class="flex justify-between"><div><strong>Total</strong></div><div id="total"><strong>–</strong></div></div>
      </div>
    </div>

    <!-- CTAs -->
    <div class="flex gap-2 no-print" style="flex-wrap:wrap;">
      <button class="ag-btn" onclick="window.print()">Print Ticket</button>
      <button class="ag-btn secondary" id="btnDownload">Download PDF</button>
      <button class="ag-btn-outline" id="btnShare">Share</button>
      <a class="back-link" href="/">Go to Dashboard</a>
    </div>
  </div>

  <aside>
    <div class="sticky-aside">
      <?php $agent = $_SESSION['user'] ?? null; ?>
      <?php if (!empty($agent)): ?>
      <?php 
        // Prefer company (Agent List), then company_name; fallback minimal
        $agencyCompany = $agent['company'] ?? ($agent['company_name'] ?? null);
        $agentPerson = $agent['name'] ?? 'Your Agent';
      ?>
      <div class="ag-card mb-3">
        <div class="ag-card-header">Your Agency</div>
        <div class="ag-card-body" style="display:flex;align-items:flex-start;gap:12px;">
          <div style="width:44px;height:44px;border-radius:50%;background:#f3f6ff;color:#3455d1;display:inline-flex;align-items:center;justify-content:center;font-weight:800;">🏢</div>
          <div>
            <div class="fw-semibold mb-1"><?= htmlspecialchars($agencyCompany ?: 'Your Agency') ?></div>
            <div class="small text-muted mb-1">Your booking agent: <?= htmlspecialchars($agentPerson) ?></div>
            <div class="small">Email: <?= htmlspecialchars($agent['email'] ?? '—') ?></div>
            <?php if (!empty($agent['mobile'] ?? null) || !empty($agent['phone'] ?? null)): ?>
              <div class="small">Phone: <?= htmlspecialchars(($agent['mobile'] ?? $agent['phone'])) ?></div>
            <?php endif; ?>
          </div>
        </div>
        <div class="ag-card-body small text-muted" style="border-top:1px solid var(--ag-border);">Booked via your trusted agency</div>
      </div>
      <?php endif; ?>
      <div class="ag-card">
        <div class="ag-card-header">Customer</div>
        <div class="ag-card-body" id="customerBox">
          <div class="text-muted small">Loading…</div>
        </div>
      </div>
      <div class="ag-card mt-3">
        <div class="ag-card-header">Need Help?</div>
        <div class="ag-card-body small text-muted">
          • 24x7 support<br>
          • Instant confirmations<br>
          • Secure payments
        </div>
      </div>
    </div>
  </aside>
  </div>
</div>

<!-- Hidden, clean PDF section (no invoice number) -->
<div id="invoiceDoc" style="display:none;">
  <div style="font-family:system-ui,-apple-system,Segoe UI,Roboto,Helvetica,Arial,sans-serif;color:#222;">
    <div style="border-bottom:2px solid #e9ecef;padding-bottom:8px;margin-bottom:16px;">
      <div style="font-size:20px;font-weight:700;">Payment Confirmation</div>
      <div style="font-size:12px;color:#666;">Order #<?= (int)$orderId ?> • <span id="pdfDate">—</span></div>
    </div>
    <?php $agent = $_SESSION['user'] ?? null; if (!empty($agent)):
      $agencyCompany = $agent['company'] ?? ($agent['company_name'] ?? null);
      $agentPerson = $agent['name'] ?? 'Your Agency';
    ?>
    <div style="margin-bottom:10px;font-size:12px;color:#444;">
      <span style="font-weight:600;">Booked via:</span>
      <span><?= htmlspecialchars($agencyCompany ?: $agentPerson) ?></span>
      <?php if (!empty($agent['email'])): ?> • <span><?= htmlspecialchars($agent['email']) ?></span><?php endif; ?>
      <?php if (!empty($agent['mobile'] ?? null) || !empty($agent['phone'] ?? null)): ?> • <span><?= htmlspecialchars(($agent['mobile'] ?? $agent['phone'])) ?></span><?php endif; ?>
    </div>
    <?php endif; ?>
    <div style="margin-bottom:12px;">
      <div style="font-weight:600;margin-bottom:4px;">Customer</div>
      <div id="pdfCustomer" style="font-size:12px;color:#444;">—</div>
    </div>
    <div style="margin:12px 0 6px;font-weight:600;">Items</div>
    <table style="width:100%;border-collapse:collapse;font-size:12px;">
      <thead>
        <tr>
          <th style="text-align:left;border-bottom:1px solid #eee;padding:6px 4px;">Description</th>
          <th style="text-align:right;border-bottom:1px solid #eee;padding:6px 4px;">Amount</th>
        </tr>
      </thead>
      <tbody id="pdfItems"></tbody>
      <tfoot>
        <tr>
          <td style="text-align:right;padding:6px 4px;border-top:1px solid #eee;">Subtotal</td>
          <td id="pdfSubtotal" style="text-align:right;padding:6px 4px;border-top:1px solid #eee;">—</td>
        </tr>
        <tr>
          <td style="text-align:right;padding:6px 4px;font-weight:700;">Total</td>
          <td id="pdfTotal" style="text-align:right;padding:6px 4px;font-weight:700;">—</td>
        </tr>
      </tfoot>
    </table>
    <div style="margin-top:16px;font-size:11px;color:#666;">This is a payment confirmation for your order. No invoice number is included.</div>
  </div>
  
</div>

<!-- html2pdf.js CDN -->
<script src="https://cdnjs.cloudflare.com/ajax/libs/html2pdf.js/0.10.1/html2pdf.bundle.min.js" integrity="sha512-YcsIPQv4eGXh8iP9SadrN5p3wlu7mJ9W3nGx0T+Rk7g2yE0T2bq9x6pE4s1m0d0YjA5b3Jg1y7wYx8lR0rQx0w==" crossorigin="anonymous" referrerpolicy="no-referrer"></script>

<script>
(function(){
  // Agent UI removed: no-op
  window.orderId = <?= (int)$orderId ?>;
  window.checkoutSig = '<?= htmlspecialchars($sig, ENT_QUOTES) ?>';
  const hero = document.getElementById('heroSummary');
  const itemsEl = document.getElementById('itemsList');
  const subEl = document.getElementById('subtotal');
  const totEl = document.getElementById('total');
  const custEl = document.getElementById('customerBox');
  const badge = document.getElementById('orderStatusBadge');
  const metaDate = document.getElementById('metaDate');
  const btnDownload = document.getElementById('btnDownload');
  const pdfRoot = document.getElementById('invoiceDoc');
  const pdfDate = document.getElementById('pdfDate');
  const pdfCustomer = document.getElementById('pdfCustomer');
  const pdfItems = document.getElementById('pdfItems');
  const pdfSubtotal = document.getElementById('pdfSubtotal');
  const pdfTotal = document.getElementById('pdfTotal');

  function escapeHtml(s){ return String(s||'').replace(/&/g,'&amp;').replace(/</g,'&lt;').replace(/>/g,'&gt;'); }
  function customerLineInner(name, mobile){
    const n = (name||'').trim();
    const m = (mobile||'').trim();
    if (!n && !m) return 'Customer: <em>not set</em>';
    const namePart = n ? `Customer: <strong>${escapeHtml(n)}</strong>` : 'Customer:';
    const mobilePart = m ? ` • ${escapeHtml(m)}` : '';
    return namePart + mobilePart;
  }

  // Format hotel details block for screen
  function hotelMetaHtml(it){
    try{
      if (!it || it.module !== 'hotel') return '';
      const h = it.details && it.details.hotel ? it.details.hotel : null;
      if (!h) return '';
      const hotelName = h.hotel_name ? `<div class="small">Hotel: <strong>${escapeHtml(h.hotel_name)}</strong></div>` : '';
      const dateLine = (h.check_in_date||h.check_out_date) ? `<div class="small text-muted">${escapeHtml(h.check_in_date||'')} → ${escapeHtml(h.check_out_date||'')}</div>` : '';
      const roomLine = h.room && h.room.name ? `<div class="small">Room: ${escapeHtml(h.room.name)}</div>` : '';
      const guests = h.guests ? `Adults: ${h.guests.adults??'—'}${typeof h.guests.children==='number'?`, Children: ${h.guests.children}`:''}` : '';
      const guestsLine = guests ? `<div class="small">${guests}</div>` : '';
      let namesHtml = '';
      try{
        const arr = Array.isArray(h.guest_names) ? h.guest_names : [];
        if (arr.length){
          const lines = arr.map(g=>{
            const ri = (typeof g.room_index!=='undefined')?`Room ${g.room_index}: `:'';
            const names = (g.guests||[]).map(escapeHtml).join(', ');
            return `<div class=\"small text-muted\">${ri}${names}</div>`;
          }).join('');
          namesHtml = `<div class=\"small\">Guests</div>${lines}`;
        }
      }catch(_){}
      const block = [hotelName, dateLine, roomLine, guestsLine, namesHtml].filter(Boolean).join('');
      return block ? `<div class="mt-1">${block}</div>` : '';
    }catch(_){ return ''; }
  }

  // Format hotel details for PDF (single cell HTML)
  function hotelMetaPdfHtml(it){
    try{
      if (!it || it.module !== 'hotel') return '';
      const h = it.details && it.details.hotel ? it.details.hotel : null;
      if (!h) return '';
      const parts = [];
      if (h.hotel_name) parts.push(`<div style=\"color:#111;\"><strong>${escapeHtml(h.hotel_name)}</strong></div>`);
      if (h.check_in_date || h.check_out_date) parts.push(`<div style=\"color:#666;\">${escapeHtml(h.check_in_date||'')} → ${escapeHtml(h.check_out_date||'')}</div>`);
      if (h.room && h.room.name) parts.push(`<div>Room: ${escapeHtml(h.room.name)}</div>`);
      if (h.guests){ parts.push(`<div>Adults: ${h.guests.adults??'—'}${typeof h.guests.children==='number'?`, Children: ${h.guests.children}`:''}</div>`); }
      try{
        const arr = Array.isArray(h.guest_names) ? h.guest_names : [];
        if (arr.length){
          const lines = arr.map(g=>{
            const ri = (typeof g.room_index!=='undefined')?`Room ${g.room_index}: `:'';
            const names = (g.guests||[]).map(escapeHtml).join(', ');
            return `<div style=\"color:#666;\">${ri}${names}</div>`;
          }).join('');
          parts.push(`<div>Guests</div>${lines}`);
        }
      }catch(_){ }
      return parts.join('');
    }catch(_){ return ''; }
  }

  async function loadOrder(){
    try{
      const BASE = (location.pathname.startsWith('/agent/')) ? '/agent' : '/b2b';
      const res = await fetch(`${BASE}/api/checkout/order?id=${encodeURIComponent(window.orderId)}`, { headers:{'Accept':'application/json'} });
      const data = await res.json();
      if(!res.ok || data.error){
        hero.innerHTML = `<span class="text-danger">${data && data.error ? data.error : 'Failed to load order.'}</span>`;
        return;
      }
      const order = data.order || {};
      const items = data.items || [];
      const currency = order.currency || 'THB';

      const list = items.length ? items.map((it,i)=>{
        const title = [it.name, it.variant_name].filter(Boolean).join(' – ') || ('Item #' + (i+1));
        const unitStr = Number(it.unit_price||0).toFixed(2) + ' ' + (it.currency || currency);
        const hotelHtml = hotelMetaHtml(it);
        return `
        <div class="row-line">
          <div class="flex justify-between">
            <div>
              <div>${title}</div>
              <div class="text-muted small">${unitStr} × ${it.qty}${it.pax_type? ' ('+it.pax_type+')':''}</div>
            </div>
            <div class="text-muted small">${Number(it.line_total||0).toFixed(2)} ${it.currency || currency}</div>
          </div>
          ${hotelHtml}
        </div>`;
      }).join('') : '<div class="text-muted">No items found.</div>';

      const subtotal = Number(items.reduce((a,b)=>a + (parseFloat(b.line_total)||0),0)).toFixed(2) + ' ' + currency;
      const total = Number(order.total||order.total_amount||0).toFixed(2) + ' ' + currency;

      const created = order.created_at ? new Date(order.created_at) : null;
      if (metaDate) metaDate.textContent = created ? created.toLocaleString() : '—';
      if (pdfDate) pdfDate.textContent = created ? created.toLocaleString() : '—';
      hero.innerHTML = `<div class=\"small text-muted\">${customerLineInner(order.customer_name, order.customer_mobile)}</div>`;
      itemsEl.innerHTML = list;
      subEl.textContent = subtotal;
      totEl.innerHTML = `<strong>${total}</strong>`;

      // Simple status badge
      const paid = (order.status === 'paid');
      const cancelled = ((order.status||'') === 'cancelled');
      const pending = !paid && !cancelled;
      if (badge){
        let text = 'Payment Pending';
        let cls = 'ag-badge warn';
        if (paid){ text = 'Payment Success'; cls = 'ag-badge success'; }
        else if (cancelled){ text = 'Payment Cancelled'; cls = 'ag-badge danger'; }
        badge.textContent = text;
        badge.setAttribute('class', cls);
      }

      custEl.innerHTML = `
        <div class=\"small text-muted\">${customerLineInner(order.customer_name, order.customer_mobile)}</div>
        ${order.customer_email ? `<div class=\"small\">${escapeHtml(order.customer_email)}</div>` : ''}
        ${order.customer_whatsapp ? `<div class=\"small\">WhatsApp: ${escapeHtml(order.customer_whatsapp)}</div>` : ''}
      `;
      

      // Build PDF content (no invoice number)
      if (pdfCustomer) {
        const name = escapeHtml(order.customer_name||'');
        const mobile = escapeHtml(order.customer_mobile||'');
        const email = escapeHtml(order.customer_email||'');
        const wa = escapeHtml(order.customer_whatsapp||'');
        pdfCustomer.innerHTML = `${name ? `<strong>${name}</strong>` : ''}${mobile? ` • ${mobile}`:''}${email? ` • ${email}`:''}${wa? ` • WhatsApp: ${wa}`:''}` || '—';
      }
      if (pdfItems){
        pdfItems.innerHTML = items.length ? items.map((it,i)=>{
          const title = [it.name, it.variant_name].filter(Boolean).join(' – ') || ('Item #' + (i+1));
          const qty = it.qty ? ` × ${it.qty}${it.pax_type? ' ('+it.pax_type+')':''}` : '';
          const amount = `${Number(it.line_total||0).toFixed(2)} ${it.currency || currency}`;
          const hotelPdf = hotelMetaPdfHtml(it);
          const descHtml = hotelPdf ? `${title}<span style=\"color:#6b7280;\">${qty}</span><div style=\"margin-top:2px;\">${hotelPdf}</div>` : `${title}<span style=\"color:#6b7280;\">${qty}</span>`;
          return `<tr><td style=\"padding:6px 4px;border-bottom:1px solid #f3f4f6;\">${descHtml}</td><td style=\"text-align:right;padding:6px 4px;border-bottom:1px solid #f3f4f6;\">${amount}</td></tr>`;
        }).join('') : `<tr><td colspan=\"2\" style=\"padding:6px 4px;\">No items</td></tr>`;
      }
      if (pdfSubtotal) pdfSubtotal.textContent = subtotal;
      if (pdfTotal) pdfTotal.textContent = total;
    }catch(e){
      hero.textContent = 'Failed to load order details';
      itemsEl.innerHTML = '';
    }
  }

  // Download PDF
  async function downloadPdf(){
    if (!window.html2pdf || !pdfRoot){ window.print(); return; }
    // Temporarily show node to render
    const prev = pdfRoot.style.display;
    pdfRoot.style.display = 'block';
    const opt = {
      margin:       8,
      filename:     `payment-confirmation-${window.orderId}.pdf`,
      image:        { type: 'jpeg', quality: 0.98 },
      html2canvas:  { scale: 2, useCORS: true },
      jsPDF:        { unit: 'pt', format: 'a4', orientation: 'portrait' }
    };
    try{
      await html2pdf().set(opt).from(pdfRoot).save();
    }finally{
      pdfRoot.style.display = prev;
    }
  }

  // Wire events
  if (btnDownload) btnDownload.addEventListener('click', downloadPdf);
  document.getElementById('btnShare').addEventListener('click', async function(){
    const BASE = (location.pathname.startsWith('/agent/')) ? '/agent' : '/b2b';
    const url = `${location.origin}${BASE}/checkout/confirm?id=${encodeURIComponent(window.orderId)}&sig=${encodeURIComponent(window.checkoutSig)}`;
    const title = 'Your Booking is Confirmed';
    const text = `Order #${window.orderId} confirmed`;
    try{
      if (navigator.share) { await navigator.share({ title, text, url }); }
      else { await navigator.clipboard.writeText(url); alert('Link copied'); }
    }catch(_){ /* ignore */ }
  });

  loadOrder();
})();
</script>
