<?php
// app/Views/agent/yacht_voucher.php
$title = $title ?? 'Yacht Voucher';
$booking = $booking ?? [];
$active = 'yachts';
require __DIR__ . '/partials/header.php';
?>

<div class="max-w-3xl mx-auto px-4 py-10">
  <div class="card bg-base-100 shadow-xl border">
    <div class="card-body p-6">
      <h1 class="text-2xl font-extrabold mb-2">Yacht Booking Voucher</h1>
      <div class="text-sm text-base-content/70 mb-4">Show this voucher to the operator. It contains your booking details and payment confirmation.</div>

      <div class="grid grid-cols-1 sm:grid-cols-2 gap-4">
        <div>
          <div class="text-sm text-base-content/60">Booking Code</div>
          <div class="font-semibold"><?= htmlspecialchars((string)($booking['booking_code'] ?? ('YCH-' . (int)($booking['id'] ?? 0)))) ?></div>
        </div>
        <div>
          <div class="text-sm text-base-content/60">Yacht</div>
          <div class="font-semibold"><?= htmlspecialchars((string)($booking['yacht_name'] ?? '—')) ?></div>
        </div>
        <div>
          <div class="text-sm text-base-content/60">Trip Date</div>
          <div class="font-semibold"><?= htmlspecialchars((string)($booking['trip_date'] ?? '—')) ?></div>
        </div>
        <div>
          <div class="text-sm text-base-content/60">Hours • Guests</div>
          <div class="font-semibold"><?= (int)($booking['hours'] ?? 0) ?>h • <?= (int)($booking['guests'] ?? 0) ?> guests</div>
        </div>
        <div>
          <div class="text-sm text-base-content/60">Amount</div>
          <div class="font-semibold"><?= number_format((float)($booking['amount_total'] ?? 0), 2) . ' ' . htmlspecialchars((string)($booking['currency'] ?? 'THB')) ?></div>
        </div>
        <div>
          <div class="text-sm text-base-content/60">Payment</div>
          <div class="font-semibold capitalize"><?= htmlspecialchars((string)($booking['payment_method'] ?? 'wallet')) ?> • <?= htmlspecialchars((string)($booking['payment_txn_id'] ?? '—')) ?></div>
        </div>
      </div>

      <div class="mt-6 flex gap-2">
        <a class="btn" href="/b2b/agent/yachts">Back to Yachts</a>
        <a class="btn btn-primary" href="/b2b/agent">Go to Dashboard</a>
      </div>
    </div>
  </div>
</div>

<?php require __DIR__ . '/partials/footer.php'; ?>
