<?php
// app/Views/agent/yacht.php
$title = $title ?? 'Yacht';
$yacht = $yacht ?? [];
$images = $images ?? [];
$csrf = $csrf ?? '';
$active = 'yachts';
require __DIR__ . '/partials/header.php';
?>

<div class="max-w-6xl mx-auto px-4 py-6">
  <nav class="mb-4 text-sm breadcrumbs text-base-content/70">
    <ul>
      <li><a href="/b2b/agent">Home</a></li>
      <li><a href="/b2b/agent/yachts">Yachts</a></li>
      <li><?= htmlspecialchars((string)($yacht['name'] ?? 'Yacht')) ?></li>
    </ul>
  </nav>

  <div class="grid grid-cols-1 lg:grid-cols-12 gap-6">
    <div class="lg:col-span-7">
      <?php if (!empty($images)): ?>
        <div class="grid grid-cols-2 gap-2">
          <?php foreach ($images as $idx => $im): $src = (string)($im['file_path'] ?? ''); if ($src==='') continue; ?>
            <img src="<?= htmlspecialchars($src) ?>" class="w-full h-48 object-cover rounded" alt="Yacht photo" loading="lazy">
          <?php endforeach; ?>
        </div>
      <?php else: ?>
        <img src="https://picsum.photos/seed/y<?= (int)($yacht['id'] ?? 0) ?>/960/540" class="w-full h-64 object-cover rounded" alt="Yacht" loading="lazy">
      <?php endif; ?>
      <div class="mt-4 prose prose-sm max-w-none">
        <h2 class="text-xl font-bold mb-2">About</h2>
        <p><?= nl2br(htmlspecialchars((string)($yacht['description'] ?? 'Experience this yacht with professional crew.'))) ?></p>
      </div>
    </div>

    <div class="lg:col-span-5 space-y-4 lg:sticky lg:top-24 self-start">
      <div class="card bg-base-100 shadow-xl border">
        <div class="card-body p-5">
          <h1 class="text-2xl font-extrabold mb-2 text-base-content">
            <?= htmlspecialchars((string)($yacht['name'] ?? 'Yacht')) ?>
          </h1>
          <div class="text-sm text-base-content/70 mb-3">
            <?= htmlspecialchars((string)($yacht['city'] ?? '-')) ?> • Capacity: <?= (int)($yacht['capacity'] ?? 0) ?> pax • Max Guests: <?= (int)($yacht['max_guests'] ?? 0) ?>
          </div>

          <?php $cur = (string)($yacht['currency'] ?? 'THB'); $from = (float)($yacht['from_price'] ?? 0); ?>
          <div class="mb-4">
            <div class="text-sm text-base-content/60">Base price (per hour)</div>
            <div class="text-xl font-bold"><?= number_format($from, 2) . ' ' . htmlspecialchars($cur) ?></div>
          </div>

          <form method="get" action="/b2b/agent/yacht/payment" class="space-y-3">
            <input type="hidden" name="csrf_token" value="<?= htmlspecialchars($csrf) ?>">
            <input type="hidden" name="yacht_id" value="<?= (int)($yacht['id'] ?? 0) ?>">

            <div>
              <label class="label"><span class="label-text font-semibold">Trip date</span></label>
              <input type="date" name="trip_date" class="input input-bordered w-full" required>
            </div>
            <div class="grid grid-cols-2 gap-3">
              <div>
                <label class="label"><span class="label-text font-semibold">Hours</span></label>
                <input type="number" name="hours" min="1" value="4" class="input input-bordered w-full" required>
              </div>
              <div>
                <label class="label"><span class="label-text font-semibold">Guests</span></label>
                <input type="number" name="guests" min="1" value="<?= max(1, (int)min(10, (int)($yacht['max_guests'] ?? 10))) ?>" class="input input-bordered w-full" required>
              </div>
            </div>

            <button type="submit" class="btn btn-primary btn-block mt-2">Continue to Payment</button>
          </form>
        </div>
      </div>
    </div>
  </div>
</div>

<?php require __DIR__ . '/partials/footer.php'; ?>
