<?php
$title = $title ?? 'Wallet History';
$transactions = $transactions ?? [];
$stats = $stats ?? [];
$filters = $filters ?? [];
$pager = $pager ?? [];
$categories = $categories ?? [];

$currentBalance = $stats['current_balance'] ?? 0;
$totalCredits = $stats['total_credits'] ?? 0;
$totalDebits = $stats['total_debits'] ?? 0;
$todaySpending = $stats['today_spending'] ?? 0;
$adminCredits = $stats['admin_credits'] ?? 0;
$totalRefunds = $stats['total_refunds'] ?? 0;
$thisMonthSpending = $stats['this_month_spending'] ?? 0;
$lastTransactionDate = $stats['last_transaction_date'] ?? null;
?>

<!DOCTYPE html>
<html lang="en" data-theme="light">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?= htmlspecialchars($title) ?> - Agent Portal</title>
    <script src="https://cdn.tailwindcss.com"></script>
    <link href="https://cdn.jsdelivr.net/npm/daisyui@4.12.10/dist/full.min.css" rel="stylesheet" type="text/css" />
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    <style>
        .card-hover { transition: all 0.3s ease; }
        .card-hover:hover { transform: translateY(-2px); box-shadow: 0 10px 25px rgba(0,0,0,0.1); }
        .animate-fade-in { animation: fadeIn 0.6s ease-in; }
        .animate-slide-up { animation: slideUp 0.8s ease-out; }
        .animate-pulse-slow { animation: pulse 3s cubic-bezier(0.4, 0, 0.6, 1) infinite; }
        @keyframes fadeIn { from { opacity: 0; transform: translateY(20px); } to { opacity: 1; transform: translateY(0); } }
        @keyframes slideUp { from { opacity: 0; transform: translateY(40px); } to { opacity: 1; transform: translateY(0); } }
        .gradient-bg { background: linear-gradient(135deg, #667eea 0%, #764ba2 100%); }
        .glass-effect { backdrop-filter: blur(10px); background: rgba(255, 255, 255, 0.9); }
        .transaction-row:hover { background: linear-gradient(90deg, rgba(59, 130, 246, 0.05) 0%, rgba(147, 51, 234, 0.05) 100%); }
    </style>
</head>
<body class="bg-gradient-to-br from-slate-50 via-blue-50 to-indigo-50 min-h-screen">
    <?php include __DIR__ . '/partials/header.php'; ?>

<!-- Modern Enterprise Header with Gradient Background -->
<div class="bg-gradient-to-br from-slate-50 via-purple-50 to-indigo-100 min-h-screen">
<div class="max-w-7xl mx-auto px-6 py-8">
    
    <!-- Premium Header Section -->
    <div class="bg-white rounded-2xl shadow-xl border border-slate-200/60 p-8 mb-8 animate-fade-in">
        <div class="flex flex-col lg:flex-row lg:items-center lg:justify-between gap-6">
            <div class="flex items-center space-x-4">
                <div class="w-16 h-16 bg-gradient-to-br from-purple-600 to-indigo-700 rounded-2xl flex items-center justify-center shadow-lg">
                    <i class="fas fa-wallet text-white text-2xl"></i>
                </div>
                <div>
                    <h1 class="text-4xl font-bold bg-gradient-to-r from-blue-600 to-purple-600 bg-clip-text text-transparent">
                        Wallet Management
                    </h1>
                    <p class="text-slate-600 mt-2 text-lg">Enterprise-grade wallet analytics and transaction history</p>
                    <?php if ($lastTransactionDate): ?>
                    <p class="text-sm text-slate-500 mt-1">
                        <i class="fas fa-clock mr-1"></i>Last activity: <?= date('M j, Y \a\t g:i A', strtotime($lastTransactionDate)) ?>
                    </p>
                    <?php endif; ?>
                </div>
            </div>
            <div class="flex gap-3 flex-wrap">
                <button class="btn btn-outline btn-primary glass-effect">
                    <i class="fas fa-download mr-2"></i>Export
                </button>
                <a href="/b2b/agent/taxi/bookings" class="btn btn-primary bg-gradient-to-r from-blue-500 to-purple-600 border-0">
                    <i class="fas fa-arrow-left mr-2"></i>Back to Bookings
                </a>
            </div>
        </div>
    </div>

    <!-- Enhanced Statistics Cards -->
    <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-4 gap-6 mb-8">
        <!-- Current Balance -->
        <div class="bg-white rounded-2xl shadow-xl border border-slate-200/60 p-6 card-hover animate-slide-up glass-effect">
            <div class="flex items-center justify-between">
                <div>
                    <p class="text-slate-600 text-sm font-semibold uppercase tracking-wide">Current Balance</p>
                    <p class="text-3xl font-bold text-slate-800 mt-2">฿<?= number_format($currentBalance, 2) ?></p>
                    <div class="flex items-center mt-2">
                        <div class="w-2 h-2 bg-green-500 rounded-full animate-pulse-slow mr-2"></div>
                        <span class="text-xs text-green-600 font-medium">Active</span>
                    </div>
                </div>
                <div class="w-14 h-14 bg-gradient-to-br from-blue-500 to-indigo-600 rounded-2xl flex items-center justify-center shadow-lg">
                    <i class="fas fa-wallet text-white text-xl"></i>
                </div>
            </div>
        </div>

        <!-- Admin Credits -->
        <div class="bg-white rounded-2xl shadow-xl border border-slate-200/60 p-6 card-hover animate-slide-up glass-effect">
            <div class="flex items-center justify-between">
                <div>
                    <p class="text-slate-600 text-sm font-semibold uppercase tracking-wide">Admin Credits</p>
                    <p class="text-3xl font-bold text-emerald-600 mt-2">฿<?= number_format($adminCredits, 2) ?></p>
                    <p class="text-xs text-slate-500 mt-1">Added by administrators</p>
                </div>
                <div class="w-14 h-14 bg-gradient-to-br from-emerald-500 to-green-600 rounded-2xl flex items-center justify-center shadow-lg">
                    <i class="fas fa-user-shield text-white text-xl"></i>
                </div>
            </div>
        </div>

        <!-- Total Credits -->
        <div class="bg-white rounded-2xl shadow-xl border border-slate-200/60 p-6 card-hover animate-slide-up glass-effect">
            <div class="flex items-center justify-between">
                <div>
                    <p class="text-slate-600 text-sm font-semibold uppercase tracking-wide">Total Credits</p>
                    <p class="text-3xl font-bold text-green-600 mt-2">฿<?= number_format($totalCredits, 2) ?></p>
                    <p class="text-xs text-slate-500 mt-1">All incoming funds</p>
                </div>
                <div class="w-14 h-14 bg-gradient-to-br from-green-500 to-emerald-600 rounded-2xl flex items-center justify-center shadow-lg">
                    <i class="fas fa-plus-circle text-white text-xl"></i>
                </div>
            </div>
        </div>

        <!-- Total Spending -->
        <div class="bg-white rounded-2xl shadow-xl border border-slate-200/60 p-6 card-hover animate-slide-up glass-effect">
            <div class="flex items-center justify-between">
                <div>
                    <p class="text-slate-600 text-sm font-semibold uppercase tracking-wide">Total Spending</p>
                    <p class="text-3xl font-bold text-red-600 mt-2">฿<?= number_format($totalDebits, 2) ?></p>
                    <p class="text-xs text-slate-500 mt-1">All outgoing payments</p>
                </div>
                <div class="w-14 h-14 bg-gradient-to-br from-red-500 to-pink-600 rounded-2xl flex items-center justify-center shadow-lg">
                    <i class="fas fa-minus-circle text-white text-xl"></i>
                </div>
            </div>
        </div>

        <!-- Today's Spending -->
        <div class="bg-white rounded-2xl shadow-xl border border-slate-200/60 p-6 card-hover animate-slide-up glass-effect">
            <div class="flex items-center justify-between">
                <div>
                    <p class="text-slate-600 text-sm font-semibold uppercase tracking-wide">Today's Spending</p>
                    <p class="text-3xl font-bold text-orange-600 mt-2">฿<?= number_format($todaySpending, 2) ?></p>
                    <p class="text-xs text-slate-500 mt-1"><?= date('M j, Y') ?></p>
                </div>
                <div class="w-14 h-14 bg-gradient-to-br from-amber-500 to-orange-600 rounded-2xl flex items-center justify-center shadow-lg">
                    <i class="fas fa-clock text-white text-xl"></i>
                </div>
            </div>
        </div>

        <!-- This Month -->
        <div class="bg-white rounded-2xl shadow-xl border border-slate-200/60 p-6 card-hover animate-slide-up glass-effect">
            <div class="flex items-center justify-between">
                <div>
                    <p class="text-slate-600 text-sm font-semibold uppercase tracking-wide">This Month</p>
                    <p class="text-3xl font-bold text-purple-600 mt-2">฿<?= number_format($thisMonthSpending, 2) ?></p>
                    <p class="text-xs text-slate-500 mt-1"><?= date('F Y') ?></p>
                </div>
                <div class="w-14 h-14 bg-gradient-to-br from-purple-500 to-indigo-600 rounded-2xl flex items-center justify-center shadow-lg">
                    <i class="fas fa-calendar-alt text-white text-xl"></i>
                </div>
            </div>
        </div>

        <!-- Total Refunds -->
        <div class="bg-white rounded-2xl shadow-xl border border-slate-200/60 p-6 card-hover animate-slide-up glass-effect">
            <div class="flex items-center justify-between">
                <div>
                    <p class="text-slate-600 text-sm font-semibold uppercase tracking-wide">Total Refunds</p>
                    <div class="text-3xl font-bold text-cyan-600 mt-2">฿<?= number_format($stats['total_refunds'] ?? 0, 2) ?></div>
                    <p class="text-xs text-slate-500 mt-1">Refunded amounts</p>
                </div>
                <div class="w-14 h-14 bg-gradient-to-br from-cyan-500 to-blue-600 rounded-2xl flex items-center justify-center shadow-lg">
                    <i class="fas fa-undo text-white text-xl"></i>
                </div>
            </div>
        </div>

        <!-- Wallet Health Score -->
        <div class="bg-gradient-to-br from-indigo-500 to-purple-600 rounded-2xl shadow-xl p-6 card-hover animate-slide-up text-white">
            <div class="flex items-center justify-between">
                <div>
                    <p class="text-indigo-100 text-sm font-semibold uppercase tracking-wide">Wallet Health</p>
                    <?php 
                    $healthScore = $currentBalance > 0 ? min(100, ($currentBalance / max(1, $totalDebits)) * 100) : 0;
                    $healthColor = $healthScore >= 70 ? 'text-green-300' : ($healthScore >= 40 ? 'text-yellow-300' : 'text-red-300');
                    ?>
                    <p class="text-3xl font-bold mt-2 <?= $healthColor ?>"><?= number_format($healthScore, 0) ?>%</p>
                    <p class="text-xs text-indigo-200 mt-1">Balance vs spending ratio</p>
                </div>
                <div class="w-14 h-14 bg-white/20 rounded-2xl flex items-center justify-center">
                    <i class="fas fa-heartbeat text-white text-xl"></i>
                </div>
            </div>
        </div>
    </div>

    <!-- Search and Filters -->
    <div class="bg-white rounded-xl shadow-lg border border-slate-200/60 p-6 mb-8 animate-fade-in">
        <form method="GET" class="space-y-4 lg:space-y-0 lg:flex lg:items-end lg:space-x-4">
            <div class="flex-1">
                <label class="block text-sm font-medium text-slate-700 mb-2">Search</label>
                <input type="text" name="q" value="<?= htmlspecialchars($filters['q'] ?? '') ?>" 
                       placeholder="Search by description, reference, or details..." 
                       class="w-full px-4 py-2 border border-slate-300 rounded-lg focus:ring-2 focus:ring-purple-500 focus:border-purple-500 transition-colors">
            </div>
            <div>
                <label class="block text-sm font-medium text-slate-700 mb-2">Transaction Type</label>
                <select name="type" class="px-4 py-2 border border-slate-300 rounded-lg focus:ring-2 focus:ring-purple-500 focus:border-purple-500 transition-colors">
                    <?php $selectedType = $filters['type'] ?? ''; ?>
                    <option value="" <?= $selectedType === '' ? 'selected' : '' ?>>All Types</option>
                    <option value="credit" <?= $selectedType === 'credit' ? 'selected' : '' ?>>Credits (+)</option>
                    <option value="debit" <?= $selectedType === 'debit' ? 'selected' : '' ?>>Debits (-)</option>
                </select>
            </div>
            <div>
                <label class="block text-sm font-medium text-slate-700 mb-2">From Date</label>
                <input type="date" name="from" value="<?= htmlspecialchars($filters['from'] ?? '') ?>" 
                       class="px-4 py-2 border border-slate-300 rounded-lg focus:ring-2 focus:ring-purple-500 focus:border-purple-500 transition-colors">
            </div>
            <div>
                <label class="block text-sm font-medium text-slate-700 mb-2">To Date</label>
                <input type="date" name="to" value="<?= htmlspecialchars($filters['to'] ?? '') ?>" 
                       class="px-4 py-2 border border-slate-300 rounded-lg focus:ring-2 focus:ring-purple-500 focus:border-purple-500 transition-colors">
            </div>
            <div>
                <label class="block text-sm font-medium text-slate-700 mb-2">Per Page</label>
                <select name="per_page" class="px-4 py-2 border border-slate-300 rounded-lg focus:ring-2 focus:ring-purple-500 focus:border-purple-500 transition-colors">
                    <?php $pp = (int)($filters['per_page'] ?? 10); ?>
                    <?php foreach ([10,20,50,100,200] as $opt): ?>
                        <option value="<?= $opt ?>" <?= $pp === $opt ? 'selected' : '' ?>><?= $opt ?></option>
                    <?php endforeach; ?>
                </select>
            </div>
            <div class="flex space-x-2">
                <button type="submit" class="px-6 py-2 bg-purple-600 hover:bg-purple-700 text-white font-medium rounded-lg transition-colors">
                    <svg class="w-4 h-4 inline mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M21 21l-6-6m2-5a7 7 0 11-14 0 7 7 0 0114 0z"></path>
                    </svg>
                    Search
                </button>
                <a href="/b2b/agent/wallet/history" class="px-4 py-2 bg-slate-100 hover:bg-slate-200 text-slate-700 font-medium rounded-lg transition-colors">
                    Reset
                </a>
            </div>
        </form>
    </div>

    <!-- Transactions Table -->
    <div class="bg-white rounded-xl shadow-lg border border-slate-200/60 overflow-hidden animate-fade-in">
        <div class="px-6 py-4 bg-gradient-to-r from-slate-50 to-slate-100 border-b border-slate-200">
            <h3 class="text-lg font-semibold text-slate-800 flex items-center">
                <svg class="w-5 h-5 mr-2 text-slate-600" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 5H7a2 2 0 00-2 2v10a2 2 0 002 2h8a2 2 0 002-2V7a2 2 0 00-2-2h-2M9 5a2 2 0 002 2h2a2 2 0 002-2M9 5a2 2 0 012-2h2a2 2 0 012 2"></path>
                </svg>
                Transaction History
            </h3>
        </div>
        
        <div class="overflow-x-auto">
            <table class="w-full">
                <thead class="bg-gradient-to-r from-slate-100 to-slate-50">
                    <tr class="border-b border-slate-200">
                        <th class="px-6 py-4 text-left text-xs font-semibold text-slate-600 uppercase tracking-wider">Date & Time</th>
                        <th class="px-6 py-4 text-left text-xs font-semibold text-slate-600 uppercase tracking-wider">Transaction Details</th>
                        <th class="px-6 py-4 text-left text-xs font-semibold text-slate-600 uppercase tracking-wider">Service Type</th>
                        <th class="px-6 py-4 text-left text-xs font-semibold text-slate-600 uppercase tracking-wider">Booking Reference</th>
                        <th class="px-6 py-4 text-left text-xs font-semibold text-slate-600 uppercase tracking-wider">Reference ID</th>
                        <th class="px-6 py-4 text-center text-xs font-semibold text-slate-600 uppercase tracking-wider">Category</th>
                        <th class="px-6 py-4 text-center text-xs font-semibold text-slate-600 uppercase tracking-wider">Status</th>
                        <th class="px-6 py-4 text-right text-xs font-semibold text-slate-600 uppercase tracking-wider">Amount</th>
                        <th class="px-6 py-4 text-right text-xs font-semibold text-slate-600 uppercase tracking-wider">Running Balance</th>
                    </tr>
                </thead>
                <tbody class="divide-y divide-slate-200">
                    <?php if (!empty($transactions)): ?>
                        <?php foreach ($transactions as $tx): 
                            $isCredit = (float)($tx['amount'] ?? 0) > 0;
                            $amount = (float)($tx['amount'] ?? 0);
                            $balance = (float)($tx['balance_after'] ?? 0);
                            $type = $tx['transaction_type'] ?? 'neutral';
                        ?>
                            <tr class="hover:bg-slate-50 transition-colors duration-200">
                                <td class="px-6 py-4">
                                    <div class="text-sm font-medium text-slate-900">
                                        <?= !empty($tx['created_at']) ? date('M j, Y', strtotime($tx['created_at'])) : '-' ?>
                                    </div>
                                    <div class="text-xs text-slate-500">
                                        <?= !empty($tx['created_at']) ? date('g:i A', strtotime($tx['created_at'])) : '-' ?>
                                    </div>
                                </td>
                                
                                <td class="px-6 py-4">
                                    <div class="text-sm font-medium text-slate-900">
                                        <?= htmlspecialchars($tx['description'] ?? 'Wallet Transaction') ?>
                                    </div>
                                </td>
                                
                                <!-- Service Type Column -->
                                <td class="px-6 py-4">
                                    <?php
                                    // Use service_type from controller if available, otherwise fallback to old logic
                                    if (!empty($tx['service_type'])) {
                                        $serviceType = $tx['service_type'];
                                        $serviceIcon = '💼';
                                        $serviceColor = 'bg-slate-100 text-slate-800';
                                        
                                        // Set appropriate icons and colors based on service type
                                        if (stripos($serviceType, 'taxi') !== false) {
                                            $serviceIcon = '🚖';
                                            $serviceColor = 'bg-blue-100 text-blue-800';
                                        } elseif (stripos($serviceType, 'order') !== false || stripos($serviceType, 'activity') !== false) {
                                            $serviceIcon = '🎯';
                                            $serviceColor = 'bg-purple-100 text-purple-800';
                                        } elseif (stripos($serviceType, 'admin') !== false) {
                                            $serviceIcon = '👨‍💼';
                                            $serviceColor = 'bg-emerald-100 text-emerald-800';
                                        } elseif (stripos($serviceType, 'treasury') !== false || stripos($serviceType, 'system') !== false) {
                                            $serviceIcon = '🏦';
                                            $serviceColor = 'bg-indigo-100 text-indigo-800';
                                        }
                                    } else {
                                        // Fallback to old logic
                                        $serviceType = 'General';
                                        $serviceIcon = '💼';
                                        $serviceColor = 'bg-slate-100 text-slate-800';
                                        
                                        if (!empty($tx['booking_details']['booking_code'])) {
                                            $serviceType = 'Taxi Service';
                                            $serviceIcon = '🚖';
                                            $serviceColor = 'bg-blue-100 text-blue-800';
                                        } elseif (!empty($tx['refund_details']['booking_code'])) {
                                            $serviceType = 'Taxi Service';
                                            $serviceIcon = '🚖';
                                            $serviceColor = 'bg-blue-100 text-blue-800';
                                        } elseif (!empty($tx['order_details'])) {
                                            $serviceType = 'Activity Booking';
                                            $serviceIcon = '🎯';
                                            $serviceColor = 'bg-purple-100 text-purple-800';
                                        } elseif (!empty($tx['booking_details']) || !empty($tx['refund_details'])) {
                                            $serviceType = 'Activity Booking';
                                            $serviceIcon = '🎯';
                                            $serviceColor = 'bg-purple-100 text-purple-800';
                                        } elseif (strpos($tx['description'] ?? '', 'Admin') !== false) {
                                            $serviceType = 'Admin Action';
                                            $serviceIcon = '👨‍💼';
                                            $serviceColor = 'bg-emerald-100 text-emerald-800';
                                        } elseif (strpos($tx['description'] ?? '', 'Treasury') !== false) {
                                            $serviceType = 'System Funding';
                                            $serviceIcon = '🏦';
                                            $serviceColor = 'bg-indigo-100 text-indigo-800';
                                        }
                                    }
                                    ?>
                                    <span class="inline-flex items-center px-2.5 py-0.5 rounded-full text-xs font-medium <?= $serviceColor ?>">
                                        <?= $serviceIcon ?> <?= $serviceType ?>
                                    </span>
                                </td>
                                
                                <!-- Booking Reference Column -->
                                <td class="px-6 py-4">
                                    <?php
                                    $bookingRef = '-';
                                    $bookingColor = 'text-slate-500';
                                    
                                    if (!empty($tx['booking_details']['booking_code'])) {
                                        $bookingRef = $tx['booking_details']['booking_code'];
                                        $bookingColor = 'text-blue-600 font-medium';
                                    } elseif (!empty($tx['refund_details']['booking_code'])) {
                                        $bookingRef = $tx['refund_details']['booking_code'];
                                        $bookingColor = 'text-blue-600 font-medium';
                                    } elseif (!empty($tx['order_details']['order_id'])) {
                                        $bookingRef = 'ORDER-' . $tx['order_details']['order_id'];
                                        $bookingColor = 'text-purple-600 font-medium';
                                    } elseif (!empty($tx['booking_details']['booking_id'])) {
                                        $bookingRef = 'BOOKING-' . $tx['booking_details']['booking_id'];
                                        $bookingColor = 'text-purple-600 font-medium';
                                    } elseif (!empty($tx['refund_details']['original_booking_id'])) {
                                        $bookingRef = 'BOOKING-' . $tx['refund_details']['original_booking_id'];
                                        $bookingColor = 'text-purple-600 font-medium';
                                    }
                                    ?>
                                    <div class="text-sm <?= $bookingColor ?>">
                                        <?= htmlspecialchars($bookingRef) ?>
                                    </div>
                                </td>
                                
                                <td class="px-6 py-4">
                                    <div class="text-sm font-mono text-slate-600 bg-slate-50 px-2 py-1 rounded">
                                        <?= htmlspecialchars($tx['reference'] ?? 'TXN-' . $tx['id']) ?>
                                    </div>
                                    <?php if ($tx['status'] === 'pending'): ?>
                                        <div class="text-xs text-amber-600 mt-1">
                                            <i class="fas fa-clock mr-1"></i>Pending
                                        </div>
                                    <?php elseif ($tx['status'] === 'approved'): ?>
                                        <div class="text-xs text-green-600 mt-1">
                                            <i class="fas fa-check-circle mr-1"></i>Approved
                                        </div>
                                    <?php endif; ?>
                                </td>
                                
                                <td class="px-6 py-4 text-center">
                                    <?php
                                    // Determine category based on transaction details
                                    $category = 'General';
                                    $categoryColor = 'bg-slate-100 text-slate-800';
                                    
                                    if (strpos($tx['description'] ?? '', 'Taxi') !== false) {
                                        $category = 'Taxi';
                                        $categoryColor = 'bg-blue-100 text-blue-800';
                                    } elseif (strpos($tx['description'] ?? '', 'Booking') !== false) {
                                        $category = 'Booking';
                                        $categoryColor = 'bg-purple-100 text-purple-800';
                                    } elseif (strpos($tx['description'] ?? '', 'Admin') !== false) {
                                        $category = 'Admin';
                                        $categoryColor = 'bg-emerald-100 text-emerald-800';
                                    } elseif (strpos($tx['description'] ?? '', 'Refund') !== false) {
                                        $category = 'Refund';
                                        $categoryColor = 'bg-green-100 text-green-800';
                                    } elseif (strpos($tx['description'] ?? '', 'Treasury') !== false) {
                                        $category = 'Treasury';
                                        $categoryColor = 'bg-indigo-100 text-indigo-800';
                                    }
                                    ?>
                                    <span class="inline-flex items-center px-2.5 py-0.5 rounded-full text-xs font-medium <?= $categoryColor ?>">
                                        <?= $category ?>
                                    </span>
                                </td>
                                
                                <td class="px-6 py-4 text-center">
                                    <?php if ($type === 'credit'): ?>
                                        <span class="inline-flex items-center px-2.5 py-0.5 rounded-full text-xs font-medium bg-emerald-100 text-emerald-800">
                                            <svg class="w-3 h-3 mr-1" fill="currentColor" viewBox="0 0 20 20">
                                                <path fill-rule="evenodd" d="M10 18a8 8 0 100-16 8 8 0 000 16zm3.707-9.293a1 1 0 00-1.414-1.414L9 10.586 7.707 9.293a1 1 0 00-1.414 1.414l2 2a1 1 0 001.414 0l4-4z" clip-rule="evenodd"></path>
                                            </svg>
                                            <?= ucfirst($tx['status'] ?? 'approved') ?>
                                        </span>
                                    <?php else: ?>
                                        <span class="inline-flex items-center px-2.5 py-0.5 rounded-full text-xs font-medium bg-red-100 text-red-800">
                                            <svg class="w-3 h-3 mr-1" fill="currentColor" viewBox="0 0 20 20">
                                                <path fill-rule="evenodd" d="M10 18a8 8 0 100-16 8 8 0 000 16zM8.707 7.293a1 1 0 00-1.414 1.414L8.586 10l-1.293 1.293a1 1 0 101.414 1.414L10 11.414l1.293 1.293a1 1 0 001.414-1.414L11.414 10l1.293-1.293a1 1 0 00-1.414-1.414L10 8.586 8.707 7.293z" clip-rule="evenodd"></path>
                                            </svg>
                                            <?= ucfirst($tx['status'] ?? 'approved') ?>
                                        </span>
                                    <?php endif; ?>
                                </td>
                                
                                <td class="px-6 py-4 text-right">
                                    <div class="text-sm font-semibold <?= $type === 'credit' ? 'text-emerald-600' : 'text-red-600' ?>">
                                        <?= $type === 'credit' ? '+' : '-' ?>฿<?= number_format(abs($tx['amount']), 2) ?>
                                    </div>
                                </td>
                                
                                <td class="px-6 py-4 text-right">
                                    <div class="text-sm font-bold text-slate-800 bg-slate-50 px-3 py-1 rounded-lg">
                                        ฿<?= number_format($tx['running_balance'] ?? 0, 2) ?>
                                    </div>
                                </td>
                                
                            </tr>
                        <?php endforeach; ?>
                    <?php else: ?>
                        <tr>
                            <td colspan="6" class="px-6 py-12 text-center">
                                <div class="flex flex-col items-center space-y-4">
                                    <div class="w-16 h-16 bg-slate-100 rounded-full flex items-center justify-center">
                                        <svg class="w-8 h-8 text-slate-400" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 5H7a2 2 0 00-2 2v10a2 2 0 002 2h8a2 2 0 002-2V7a2 2 0 00-2-2h-2M9 5a2 2 0 002 2h2a2 2 0 002-2M9 5a2 2 0 012-2h2a2 2 0 012 2"></path>
                                        </svg>
                                    </div>
                                    <div class="text-lg font-medium text-slate-900">No transactions found</div>
                                    <div class="text-sm text-slate-500">Try adjusting your search filters</div>
                                </div>
                            </td>
                        </tr>
                    <?php endif; ?>
                </tbody>
            </table>
        </div>

        <!-- Pagination -->
        <?php if ($pager['totalPages'] > 1): ?>
        <div class="px-6 py-4 border-t border-slate-200 flex items-center justify-between">
            <div class="text-sm text-slate-700">
                Showing <?= (($pager['currentPage'] - 1) * $pager['perPage']) + 1 ?> to 
                <?= min($pager['currentPage'] * $pager['perPage'], $pager['totalItems']) ?> of 
                <?= $pager['totalItems'] ?> results
            </div>
            <div class="flex items-center space-x-2">
                <?php $cp = (int)$pager['currentPage']; $tp = (int)$pager['totalPages']; ?>
                <?php if ($cp > 1): ?>
                    <a href="?<?= http_build_query(array_merge($filters, ['page' => 1])) ?>" class="px-3 py-2 bg-slate-100 hover:bg-slate-200 text-slate-700 text-sm rounded-lg">First</a>
                    <a href="?<?= http_build_query(array_merge($filters, ['page' => $cp - 1])) ?>" class="px-3 py-2 bg-slate-100 hover:bg-slate-200 text-slate-700 text-sm rounded-lg">Prev</a>
                <?php endif; ?>

                <?php
                    $pages = [];
                    if ($tp <= 7) {
                        $pages = range(1, $tp);
                    } else {
                        $pages = [1, 2];
                        $start = max(3, $cp - 1);
                        $end = min($tp - 2, $cp + 1);
                        if ($start > 3) echo '<span class="px-2 text-slate-400">…</span>';
                        for ($i = $start; $i <= $end; $i++) { $pages[] = $i; }
                        if ($end < $tp - 2) echo '<span class="px-2 text-slate-400">…</span>';
                        $pages[] = $tp - 1; $pages[] = $tp;
                    }
                ?>
                <?php foreach ($pages as $i): ?>
                    <a href="?<?= http_build_query(array_merge($filters, ['page' => $i])) ?>" 
                       class="px-3 py-2 <?= (int)$i === $cp ? 'bg-purple-600 text-white' : 'bg-slate-100 hover:bg-slate-200 text-slate-700' ?> text-sm rounded-lg transition-colors">
                        <?= $i ?>
                    </a>
                <?php endforeach; ?>

                <?php if ($cp < $tp): ?>
                    <a href="?<?= http_build_query(array_merge($filters, ['page' => $cp + 1])) ?>" class="px-3 py-2 bg-slate-100 hover:bg-slate-200 text-slate-700 text-sm rounded-lg">Next</a>
                    <a href="?<?= http_build_query(array_merge($filters, ['page' => $tp])) ?>" class="px-3 py-2 bg-slate-100 hover:bg-slate-200 text-slate-700 text-sm rounded-lg">Last</a>
                <?php endif; ?>
            </div>
        </div>
        <?php endif; ?>
    </div>

</div>
</div>

<style>
.card-hover {
    transition: all 0.3s ease;
}
.card-hover:hover {
    transform: translateY(-2px);
    box-shadow: 0 20px 25px -5px rgba(0, 0, 0, 0.1), 0 10px 10px -5px rgba(0, 0, 0, 0.04);
}
.animate-fade-in {
    animation: fadeIn 0.5s ease-in-out;
}
@keyframes fadeIn {
    from { opacity: 0; transform: translateY(10px); }
    to { opacity: 1; transform: translateY(0); }
}
</style>

<?php include __DIR__ . '/partials/footer.php'; ?>
