<?php
// app/Views/agent/ticket_view.php
$title = 'Ticket #' . ($ticket['id'] ?? '') . ' - Support Center';
$active = 'support';
$ticket = $ticket ?? [];
$replies = $replies ?? [];
$csrf = $csrf ?? '';

// Format dates
function formatDate($date) {
    if (empty($date)) return '';
    $dt = new DateTime($date);
    return $dt->format('M j, Y g:i A');
}

require __DIR__ . '/partials/header.php';
?>

<div class="bg-gradient-to-br from-slate-50 via-blue-50 to-indigo-100 min-h-screen">
  <div class="max-w-5xl mx-auto px-4 py-8">
    <?php 
    $ok = isset($_GET['ok']) ? (string)$_GET['ok'] : '';
    $err = isset($_GET['err']) ? (string)$_GET['err'] : '';
    ?>
    
    <?php if ($ok === 'reply'): ?>
      <div class="mb-4 rounded-xl border border-emerald-200 bg-emerald-50 text-emerald-800 px-4 py-3">Your reply has been submitted.</div>
    <?php elseif ($err === 'reply'): ?>
      <div class="mb-4 rounded-xl border border-rose-200 bg-rose-50 text-rose-800 px-4 py-3">Error submitting your reply. Please try again.</div>
    <?php endif; ?>

    <!-- Back to tickets -->
    <div class="mb-6">
      <a href="/b2b/agent/support" class="inline-flex items-center text-blue-600 hover:text-blue-800">
        <svg class="w-5 h-5 mr-1" fill="none" stroke="currentColor" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg">
          <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M10 19l-7-7m0 0l7-7m-7 7h18"></path>
        </svg>
        Back to My Tickets
      </a>
    </div>

    <!-- Ticket Header -->
    <div class="bg-white rounded-2xl shadow-lg border border-slate-200 overflow-hidden mb-6">
      <div class="px-6 py-4 bg-gradient-to-r from-slate-50 to-slate-100 border-b border-slate-200">
        <div class="flex flex-col md:flex-row md:items-center md:justify-between">
          <h1 class="text-2xl font-bold text-slate-800"><?= htmlspecialchars($ticket['subject'] ?? '') ?></h1>
          <div class="mt-2 md:mt-0">
            <?php
            $status = strtolower((string)($ticket['status'] ?? 'open'));
            $statusMap = [
              'open' => 'bg-blue-100 text-blue-800',
              'in_progress' => 'bg-amber-100 text-amber-800',
              'resolved' => 'bg-emerald-100 text-emerald-800',
              'closed' => 'bg-slate-100 text-slate-800',
            ];
            $statusClass = $statusMap[$status] ?? 'bg-slate-100 text-slate-800';
            ?>
            <span class="inline-flex items-center px-3 py-1 rounded-full text-sm font-medium <?= $statusClass ?> capitalize">
              <?= htmlspecialchars(str_replace('_', ' ', $status)) ?>
            </span>
          </div>
        </div>
        
        <div class="mt-2 flex flex-wrap gap-2 text-sm text-slate-600">
          <span class="inline-flex items-center">
            <svg class="w-4 h-4 mr-1" fill="none" stroke="currentColor" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg">
              <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M8 7V3m8 4V3m-9 8h10M5 21h14a2 2 0 002-2V7a2 2 0 00-2-2H5a2 2 0 00-2 2v12a2 2 0 002 2z"></path>
            </svg>
            <?= formatDate($ticket['created_at'] ?? '') ?>
          </span>
          <span class="hidden md:inline">•</span>
          <span class="inline-flex items-center">
            <svg class="w-4 h-4 mr-1" fill="none" stroke="currentColor" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg">
              <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M3 8l7.89 5.26a2 2 0 002.22 0L21 8M5 19h14a2 2 0 002-2V7a2 2 0 00-2-2H5a2 2 0 00-2 2v10a2 2 0 002 2z"></path>
            </svg>
            <?= htmlspecialchars(ucfirst($ticket['category'] ?? 'general')) ?>
          </span>
          <span class="hidden md:inline">•</span>
          <span class="inline-flex items-center">
            <svg class="w-4 h-4 mr-1" fill="none" stroke="currentColor" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg">
              <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 8v4l3 3m6-3a9 9 0 11-18 0 9 9 0 0118 0z"></path>
            </svg>
            Priority: <?= htmlspecialchars(ucfirst($ticket['priority'] ?? 'normal')) ?>
          </span>
          <?php if (!empty($ticket['ip_address'])): ?>
            <span class="hidden md:inline">•</span>
            <span class="inline-flex items-center">
              <svg class="w-4 h-4 mr-1" fill="none" stroke="currentColor" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg">
                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M21 12a9 9 0 01-9 9m9-9a9 9 0 00-9-9m9 9H3m9 9a9 9 0 01-9-9m9 9c1.657 0 3-4.03 3-9s-1.343-9-3-9m0 18c-1.657 0-3-4.03-3-9s1.343-9 3-9m-9 9a9 9 0 019-9"></path>
              </svg>
              <?= htmlspecialchars($ticket['ip_address']) ?>
            </span>
          <?php endif; ?>
        </div>
      </div>

      <!-- Ticket Message -->
      <div class="p-6">
        <div class="prose max-w-none">
          <?= nl2br(htmlspecialchars($ticket['message'] ?? '')) ?>
        </div>
      </div>
    </div>

    <!-- Replies -->
    <div class="space-y-4 mb-8">
      <h2 class="text-lg font-semibold text-slate-800 mb-4">
        <?= count($replies) ?> <?= count($replies) === 1 ? 'Reply' : 'Replies' ?>
      </h2>
      
      <?php if (empty($replies)): ?>
        <div class="bg-white rounded-2xl shadow border border-slate-200 p-6 text-center text-slate-500">
          No replies yet. Our support team will respond soon.
        </div>
      <?php else: ?>
        <?php foreach ($replies as $reply): ?>
          <div class="bg-white rounded-2xl shadow border border-slate-200 overflow-hidden">
            <div class="px-6 py-3 border-b border-slate-200 bg-slate-50 flex justify-between items-center">
              <div class="font-medium text-slate-700">
                <?php if ($reply['role'] === 'agent'): ?>
                  <span class="text-blue-600">Support Team</span>
                <?php else: ?>
                  <span class="text-slate-800">You</span>
                <?php endif; ?>
              </div>
              <div class="text-sm text-slate-500">
                <?= formatDate($reply['created_at'] ?? '') ?>
              </div>
            </div>
            <div class="p-6">
              <div class="prose max-w-none">
                <?= nl2br(htmlspecialchars($reply['message'] ?? '')) ?>
              </div>
            </div>
          </div>
        <?php endforeach; ?>
      <?php endif; ?>
    </div>

    <!-- Reply Form -->
    <div class="bg-white rounded-2xl shadow-lg border border-slate-200 p-6">
      <h3 class="text-lg font-semibold text-slate-800 mb-4">Add a Reply</h3>
      <form method="post" action="">
        <input type="hidden" name="csrf_token" value="<?= htmlspecialchars($csrf) ?>">
        <div class="mb-4">
          <label for="message" class="block text-sm font-medium text-slate-700 mb-1">Your Message</label>
          <textarea 
            id="message" 
            name="message" 
            rows="4" 
            class="w-full px-3 py-2 border border-slate-300 rounded-xl focus:ring-2 focus:ring-blue-500 focus:border-blue-500"
            placeholder="Type your reply here..."
            required
          ></textarea>
        </div>
        <div class="flex justify-end">
          <button 
            type="submit" 
            class="px-4 py-2 bg-gradient-to-r from-blue-600 to-indigo-600 hover:from-blue-700 hover:to-indigo-700 text-white font-semibold rounded-xl shadow-lg hover:shadow-xl transition-all"
          >
            Submit Reply
          </button>
        </div>
      </form>
    </div>
  </div>
</div>

<?php require __DIR__ . '/partials/footer.php'; ?>
