<?php
// app/Views/agent/taxi_verify.php
// This page is PUBLIC. Do not require login.
$title = $title ?? 'Official Booking Verification';
$code = (string)($code ?? '');
$result = $result ?? null; // array|null

$valid = is_array($result) && !empty($result['booking_code']);
$status = strtolower((string)($result['status'] ?? ''));
$paid = strtolower((string)($result['payment_status'] ?? '')) === 'paid';

// Basic app/company info for footer and issuer
$appName = trim($_ENV['COMPANY_NAME'] ?? 'BookMyThai', '"');
$companyName = trim($_ENV['COMPANY_NAME'] ?? 'So Simple Trip Co. Ltd', '"');
$tatLicense = trim($_ENV['TAT_LICENSE'] ?? ($_ENV['TAT_LICENSE_NO'] ?? '13/03289'), '"');
$supportEmail = trim($_ENV['SUPPORT_EMAIL'] ?? 'support@bookmythai.com', '"');
$supportPhone = trim($_ENV['SUPPORT_PHONE'] ?? '+66 123 4567', '"');

// Get service type and passenger name
$serviceType = '';
if ($valid) {
    if (!empty($result['from_text']) && !empty($result['to_text'])) {
        $fromText = (string)($result['from_text'] ?? '');
        $toText = (string)($result['to_text'] ?? '');
        
        // Check if airport transfer
        if (stripos($fromText, 'airport') !== false || stripos($toText, 'airport') !== false) {
            $serviceType = 'Airport Taxi Transfer';
        } else {
            $serviceType = 'Taxi Transfer';
        }
        
        // Add direction
        if (stripos($fromText, 'airport') !== false) {
            $serviceType .= ' (One Way)';
        } elseif (!empty($result['return_pickup']) && $result['return_pickup']) {
            $serviceType .= ' (Round Trip)';
        } else {
            $serviceType .= ' (One Way)';
        }
    } else {
        $serviceType = 'Taxi Transfer';
    }
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?= htmlspecialchars($title) ?></title>
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@300;400;500;600;700&display=swap" rel="stylesheet">
    <style>
        :root {
            --primary: #10B981;
            --primary-dark: #059669;
            --primary-light: #D1FAE5;
            --success: #10B981;
            --error: #EF4444;
            --warning: #F59E0B;
            --text-primary: #111827;
            --text-secondary: #4B5563;
            --text-muted: #6B7280;
            --border: #E5E7EB;
            --bg-light: #F9FAFB;
            --white: #FFFFFF;
        }
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }
        body {
            font-family: 'Inter', -apple-system, BlinkMacSystemFont, 'Segoe UI', Roboto, Oxygen, Ubuntu, Cantarell, 'Open Sans', 'Helvetica Neue', sans-serif;
            background-color: var(--bg-light);
            color: var(--text-primary);
            line-height: 1.5;
            padding: 20px;
        }
        .container {
            max-width: 600px;
            margin: 0 auto;
            background: var(--white);
            border-radius: 12px;
            overflow: hidden;
            box-shadow: 0 1px 3px rgba(0, 0, 0, 0.1);
        }
        .header {
            background: var(--primary);
            color: white;
            padding: 24px;
            text-align: center;
        }
        .logo {
            max-width: 180px;
            margin-bottom: 16px;
        }
        .title {
            font-size: 20px;
            font-weight: 600;
            margin-bottom: 8px;
        }
        .subtitle {
            font-size: 14px;
            opacity: 0.9;
            font-weight: 400;
        }
        .content {
            padding: 32px;
        }
        .verification-badge {
            text-align: center;
            margin-bottom: 32px;
        }
        .verification-icon {
            width: 80px;
            height: 80px;
            background: var(--primary-light);
            border-radius: 50%;
            display: flex;
            align-items: center;
            justify-content: center;
            margin: 0 auto 16px;
        }
        .verification-icon svg {
            width: 40px;
            height: 40px;
            color: var(--primary);
        }
        .verification-text {
            font-size: 20px;
            font-weight: 600;
            color: var(--text-primary);
            margin-bottom: 8px;
        }
        .verification-subtext {
            font-size: 14px;
            color: var(--text-secondary);
            margin-bottom: 24px;
        }
        .details-card {
            background: var(--bg-light);
            border-radius: 8px;
            padding: 20px;
            margin-bottom: 24px;
        }
        .detail-row {
            display: flex;
            justify-content: space-between;
            padding: 12px 0;
            border-bottom: 1px solid var(--border);
        }
        .detail-row:last-child {
            border-bottom: none;
        }
        .detail-label {
            color: var(--text-secondary);
            font-size: 14px;
        }
        .detail-value {
            font-weight: 500;
            text-align: right;
        }
        .qr-code {
            text-align: center;
            margin: 32px 0;
        }
        .qr-code img {
            max-width: 180px;
            border: 1px solid var(--border);
            border-radius: 8px;
            padding: 12px;
        }
        .footer {
            text-align: center;
            padding: 24px;
            color: var(--text-muted);
            font-size: 12px;
            border-top: 1px solid var(--border);
        }
        .footer p {
            margin-bottom: 4px;
        }
        .status-badge {
            display: inline-block;
            padding: 4px 12px;
            border-radius: 12px;
            font-size: 12px;
            font-weight: 500;
            background: var(--primary-light);
            color: var(--primary);
        }
        .status-badge.paid {
            background: #D1FAE5;
            color: #065F46;
        }
        .status-badge.cancelled {
            background: #FEE2E2;
            color: #991B1B;
        }
        @media (max-width: 480px) {
            .content {
                padding: 24px 16px;
            }
            .detail-row {
                flex-direction: column;
                gap: 4px;
            }
            .detail-value {
                text-align: left;
            }
        }
    </style>
</head>
<body>
    <div class="container">
        <div class="header">
            <img src="https://bookmythai.com/logo.png" alt="So Simple Trip" class="logo" onerror="this.src='data:image/svg+xml;base64,PHN2ZyB4bWxucz0iaHR0cDovL3d3dy53My5vcmcvMjAwMC9zdmciIHdpZHRoPSIxODAiIGhlaWdodD0iNDgiIHZpZXdCb3g9IjAgMCAxODAgNDgiIGZpbGw9Im5vbmUiPgogIDxyZWN0IHdpZHRoPSIxODAiIGhlaWdodD0iNDgiIHJ4PSI0IiBmaWxsPSIjMTA2NjRGIi8+CiAgPHRleHQgeD0iMjAiIHk9IjMyIiBmb250LWZhbWlseT0iQXJpYWwiIGZvbnQtc2l6ZT0iMTYiIGZvbnQtd2VpZ2h0PSI2MDAiIGZpbGw9IndoaXRlIj5Cb29rTXlUaGFpPC90ZXh0PgogIDx0ZXh0IHg9IjIwIiB5PSIxNiIgZm9udC1mYW1pbHk9IkFyaWFsIiBmb250LXNpemU9IjI0IiBmb250LXdlaWdodD0iYm9sZCIgZmlsbD0id2hpdGUiPlNpbXBsZVRyaXA8L3RleHQ+Cjwvc3ZnPg=='">
            <h1 class="title">Official Booking Verification</h1>
            <p class="subtitle">Verify your booking details below</p>
        </div>
        
        <div class="content">
            <?php if ($valid): ?>
                <div class="verification-badge">
                    <div class="verification-icon" <?= $status === 'cancelled' ? 'style="background: #FEE2E2;"' : '' ?>>
                        <?php if ($status === 'cancelled'): ?>
                            <svg xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24" stroke="#DC2626">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M6 18L18 6M6 6l12 12" />
                            </svg>
                        <?php else: ?>
                            <svg xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M5 13l4 4L19 7" />
                            </svg>
                        <?php endif; ?>
                    </div>
                    <h2 class="verification-text">
                        <?= $status === 'cancelled' ? 'Booking Cancelled' : 'Booking Verified' ?>
                    </h2>
                    <p class="verification-subtext">
                        Your booking has been successfully verified with our system
                    </p>
                </div>

                <div class="details-card">
                    <div class="detail-row">
                        <span class="detail-label">Voucher ID</span>
                        <span class="detail-value"><?= htmlspecialchars($code) ?></span>
                    </div>
                    <div class="detail-row">
                        <span class="detail-label">Service Type</span>
                        <span class="detail-value"><?= htmlspecialchars($serviceType) ?></span>
                    </div>
                    <div class="detail-row">
                        <span class="detail-label">Passenger Name</span>
                        <span class="detail-value"><?= htmlspecialchars((string)($result['customer_name'] ?? '—')) ?></span>
                    </div>
                    <div class="detail-row">
                        <span class="detail-label">Travel Date</span>
                        <span class="detail-value">
                            <?= htmlspecialchars($result['trip_date'] ? date('d M Y', strtotime((string)$result['trip_date'])) : '—') ?>
                        </span>
                    </div>
                    <?php if (!empty($result['pickup_time'])): ?>
                    <div class="detail-row">
                        <span class="detail-label">Pickup Time</span>
                        <span class="detail-value">
                            <?= htmlspecialchars(date('h:i A', strtotime((string)$result['pickup_time']))) ?>
                        </span>
                    </div>
                    <?php endif; ?>
                    <div class="detail-row">
                        <span class="detail-label">Pickup</span>
                        <span class="detail-value"><?= htmlspecialchars((string)($result['from_text'] ?? '—')) ?></span>
                    </div>
                    <div class="detail-row">
                        <span class="detail-label">Drop-off</span>
                        <span class="detail-value"><?= htmlspecialchars((string)($result['to_text'] ?? '—')) ?></span>
                    </div>
                    <div class="detail-row">
                        <span class="detail-label">Status</span>
                        <span class="detail-value">
                            <?php if ($paid): ?>
                                <span class="status-badge paid">Paid</span>
                            <?php else: ?>
                                <span class="status-badge <?= $status === 'cancelled' ? 'cancelled' : '' ?>">
                                <?= $status === 'cancelled' ? 'Cancelled' : htmlspecialchars(ucfirst($result['payment_status'] ?? 'Unpaid')) ?>
                            </span>
                            <?php endif; ?>
                        </span>
                    </div>
                </div>

            <?php else: ?>
                <div class="verification-badge">
                    <div class="verification-icon" style="background: #FEE2E2;">
                        <svg xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24" stroke="#EF4444">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M6 18L18 6M6 6l12 12" />
                        </svg>
                    </div>
                    <h2 class="verification-text">Booking Not Found</h2>
                    <p class="verification-subtext">
                        The booking code you entered is invalid or has expired
                    </p>
                </div>
                
                <div class="details-card" style="text-align: center;">
                    <p style="margin-bottom: 16px;">Please check the booking code and try again, or contact our support team for assistance.</p>
                    <p>Booking Code: <strong><?= htmlspecialchars($code) ?></strong></p>
                </div>
            <?php endif; ?>
        </div>
        
        <div class="footer">
            <p>Verified by <?= htmlspecialchars($companyName) ?></p>
            <p>TAT License No. <?= htmlspecialchars($tatLicense) ?></p>
            <p>Need Help? <?= htmlspecialchars($supportEmail) ?></p>
        </div>
    </div>
</body>
</html>
