<?php
/**
 * Taxi Refund History - Professional Enterprise-Grade View
 */
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?= htmlspecialchars($title ?? 'Taxi Refund History') ?> - BookMyThai Agent Portal</title>
    <script src="https://cdn.tailwindcss.com"></script>
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@300;400;500;600;700&display=swap" rel="stylesheet">
    <style>
        body { font-family: 'Inter', sans-serif; }
        .gradient-bg { background: linear-gradient(135deg, #667eea 0%, #764ba2 100%); }
        .card-hover { transition: all 0.3s cubic-bezier(0.4, 0, 0.2, 1); }
        .card-hover:hover { transform: translateY(-2px); box-shadow: 0 20px 25px -5px rgba(0, 0, 0, 0.1), 0 10px 10px -5px rgba(0, 0, 0, 0.04); }
        .animate-fade-in { animation: fadeIn 0.6s ease-out; }
        @keyframes fadeIn { from { opacity: 0; transform: translateY(20px); } to { opacity: 1; transform: translateY(0); } }
        .status-badge { @apply inline-flex items-center px-2.5 py-0.5 rounded-full text-xs font-medium; }
        .status-refunded { @apply bg-red-100 text-red-800; }
        .status-partial { @apply bg-yellow-100 text-yellow-800; }
    </style>
</head>
<body class="bg-gray-50 min-h-screen">

<?php include __DIR__ . '/partials/header.php'; ?>

<div class="max-w-7xl mx-auto px-6 py-8">
    
    <!-- Premium Header Section -->
    <div class="bg-white rounded-2xl shadow-xl border border-slate-200/60 p-8 mb-8 animate-fade-in">
        <div class="flex flex-col lg:flex-row lg:items-center lg:justify-between gap-6">
            <div class="flex items-center space-x-4">
                <div class="w-16 h-16 bg-gradient-to-br from-red-600 to-rose-700 rounded-2xl flex items-center justify-center shadow-lg">
                    <svg xmlns="http://www.w3.org/2000/svg" class="h-8 w-8 text-white" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12h6m-6 4h6m2 5H7a2 2 0 01-2-2V5a2 2 0 012-2h5.586a1 1 0 01.707.293l5.414 5.414a1 1 0 01.293.707V19a2 2 0 01-2 2z"></path>
                    </svg>
                </div>
                <div>
                    <h1 class="text-4xl font-bold bg-gradient-to-r from-slate-800 to-slate-600 bg-clip-text text-transparent">
                        Refund History
                    </h1>
                    <p class="text-slate-600 text-lg mt-1">Complete taxi refund tracking & analytics</p>
                    <div class="flex items-center space-x-4 mt-3">
                        <div class="flex items-center space-x-2 text-sm text-slate-500">
                            <div class="w-2 h-2 bg-red-500 rounded-full animate-pulse"></div>
                            <span>Real-time Data</span>
                        </div>
                        <div class="flex items-center space-x-2 text-sm text-slate-500">
                            <svg class="w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 8v4l3 3m6-3a9 9 0 11-18 0 9 9 0 0118 0z"></path>
                            </svg>
                            <span>Last updated: <?= date('M j, Y g:i A') ?></span>
                        </div>
                    </div>
                </div>
            </div>
            <div class="flex items-center space-x-3">
                <a href="/b2b/agent/taxi/bookings" class="inline-flex items-center px-4 py-2 bg-slate-100 hover:bg-slate-200 text-slate-700 text-sm font-medium rounded-lg transition-all duration-200">
                    <svg class="w-4 h-4 mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M10 19l-7-7m0 0l7-7m-7 7h18"></path>
                    </svg>
                    Back to Bookings
                </a>
            </div>
        </div>
    </div>

    <!-- Statistics Cards -->
    <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-4 gap-6 mb-8">
        <div class="bg-white rounded-xl shadow-lg border border-slate-200/60 p-6 card-hover animate-fade-in">
            <div class="flex items-center justify-between">
                <div>
                    <p class="text-slate-600 text-sm font-medium">Total Refunds</p>
                    <p class="text-2xl font-bold text-slate-800 mt-1">฿<?= number_format($stats['total_refunds'] ?? 0, 2) ?></p>
                </div>
                <div class="w-12 h-12 bg-gradient-to-br from-red-500 to-rose-600 rounded-xl flex items-center justify-center">
                    <svg class="w-6 h-6 text-white" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 8c-1.657 0-3 .895-3 2s1.343 2 3 2 3 .895 3 2-1.343 2-3 2m0-8c1.11 0 2.08.402 2.599 1M12 8V7m0 1v8m0 0v1m0-1c-1.11 0-2.08-.402-2.599-1"></path>
                    </svg>
                </div>
            </div>
        </div>

        <div class="bg-white rounded-xl shadow-lg border border-slate-200/60 p-6 card-hover animate-fade-in">
            <div class="flex items-center justify-between">
                <div>
                    <p class="text-slate-600 text-sm font-medium">Today</p>
                    <p class="text-2xl font-bold text-slate-800 mt-1">฿<?= number_format($stats['today'] ?? 0, 2) ?></p>
                </div>
                <div class="w-12 h-12 bg-gradient-to-br from-emerald-500 to-green-600 rounded-xl flex items-center justify-center">
                    <svg class="w-6 h-6 text-white" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M13 16h-1v-4h-1m1-4h.01M12 6a9 9 0 100 18 9 9 0 000-18z"></path>
                    </svg>
                </div>
            </div>
        </div>

        <div class="bg-white rounded-xl shadow-lg border border-slate-200/60 p-6 card-hover animate-fade-in">
            <div class="flex items-center justify-between">
                <div>
                    <p class="text-slate-600 text-sm font-medium">This Month</p>
                    <p class="text-2xl font-bold text-slate-800 mt-1">฿<?= number_format($stats['this_month'] ?? 0, 2) ?></p>
                </div>
                <div class="w-12 h-12 bg-gradient-to-br from-orange-500 to-red-600 rounded-xl flex items-center justify-center">
                    <svg class="w-6 h-6 text-white" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M8 7V3m8 4V3m-9 8h10M5 21h14a2 2 0 002-2V7a2 2 0 00-2-2H5a2 2 0 00-2 2v12a2 2 0 002 2z"></path>
                    </svg>
                </div>
            </div>
        </div>

        <div class="bg-white rounded-xl shadow-lg border border-slate-200/60 p-6 card-hover animate-fade-in">
            <div class="flex items-center justify-between">
                <div>
                    <p class="text-slate-600 text-sm font-medium">Last 30 Days</p>
                    <p class="text-2xl font-bold text-slate-800 mt-1">฿<?= number_format($stats['last_30_days'] ?? 0, 2) ?></p>
                </div>
                <div class="w-12 h-12 bg-gradient-to-br from-amber-500 to-orange-600 rounded-xl flex items-center justify-center">
                    <svg class="w-6 h-6 text-white" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M13 7h8m0 0v8m0-8l-8 8-4-4-6 6"></path>
                    </svg>
                </div>
            </div>
        </div>
    </div>

    <!-- Filters Section -->
    <div class="bg-white rounded-xl shadow-lg border border-slate-200/60 p-6 mb-8 animate-fade-in">
        <form method="GET" class="space-y-4 lg:space-y-0 lg:flex lg:items-end lg:space-x-4">
            <div class="flex-1">
                <label class="block text-sm font-medium text-slate-700 mb-2">Search</label>
                <input type="text" name="q" value="<?= htmlspecialchars($filters['q'] ?? '') ?>" 
                       placeholder="Search by booking code, route, or taxi name..." 
                       class="w-full px-4 py-2 border border-slate-300 rounded-lg focus:ring-2 focus:ring-red-500 focus:border-red-500 transition-colors">
            </div>
            <div>
                <label class="block text-sm font-medium text-slate-700 mb-2">From Date</label>
                <input type="date" name="from" value="<?= htmlspecialchars($filters['from'] ?? '') ?>" 
                       class="px-4 py-2 border border-slate-300 rounded-lg focus:ring-2 focus:ring-red-500 focus:border-red-500 transition-colors">
            </div>
            <div>
                <label class="block text-sm font-medium text-slate-700 mb-2">To Date</label>
                <input type="date" name="to" value="<?= htmlspecialchars($filters['to'] ?? '') ?>" 
                       class="px-4 py-2 border border-slate-300 rounded-lg focus:ring-2 focus:ring-red-500 focus:border-red-500 transition-colors">
            </div>
            <div>
                <label class="block text-sm font-medium text-slate-700 mb-2">Per Page</label>
                <select name="per_page" class="px-4 py-2 border border-slate-300 rounded-lg focus:ring-2 focus:ring-red-500 focus:border-red-500 transition-colors">
                    <?php $pp = (int)($filters['per_page'] ?? 10); ?>
                    <?php foreach ([10,20,50,100,200] as $opt): ?>
                        <option value="<?= $opt ?>" <?= $pp === $opt ? 'selected' : '' ?>><?= $opt ?></option>
                    <?php endforeach; ?>
                </select>
            </div>
            <div class="flex space-x-2">
                <button type="submit" class="px-6 py-2 bg-red-600 hover:bg-red-700 text-white font-medium rounded-lg transition-colors">
                    <svg class="w-4 h-4 inline mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M21 21l-6-6m2-5a7 7 0 11-14 0 7 7 0 0114 0z"></path>
                    </svg>
                    Search
                </button>
                <a href="/b2b/agent/taxi/refunds" class="px-4 py-2 bg-slate-100 hover:bg-slate-200 text-slate-700 font-medium rounded-lg transition-colors">
                    Reset
                </a>
            </div>
        </form>
    </div>

    <!-- Refunds Table -->
    <div class="bg-white rounded-xl shadow-lg border border-slate-200/60 overflow-hidden animate-fade-in">
        <div class="px-6 py-4 border-b border-slate-200">
            <h3 class="text-lg font-semibold text-slate-800">Refund Records</h3>
            <p class="text-sm text-slate-600 mt-1">Showing <?= count($refunds) ?> of <?= $pager['totalItems'] ?> refunds</p>
        </div>

        <?php if (empty($refunds)): ?>
        <div class="p-12 text-center">
            <div class="w-16 h-16 bg-slate-100 rounded-full flex items-center justify-center mx-auto mb-4">
                <svg class="w-8 h-8 text-slate-400" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12h6m-6 4h6m2 5H7a2 2 0 01-2-2V5a2 2 0 012-2h5.586a1 1 0 01.707.293l5.414 5.414a1 1 0 01.293.707V19a2 2 0 01-2 2z"></path>
                </svg>
            </div>
            <h3 class="text-lg font-medium text-slate-900 mb-2">No refunds found</h3>
            <p class="text-slate-600">No refund records match your current filters.</p>
        </div>
        <?php else: ?>
        <div class="overflow-x-auto">
            <table class="w-full">
                <thead class="bg-slate-50">
                    <tr>
                        <th class="px-6 py-3 text-left text-xs font-medium text-slate-500 uppercase tracking-wider">Booking</th>
                        <th class="px-6 py-3 text-left text-xs font-medium text-slate-500 uppercase tracking-wider">Route</th>
                        <th class="px-6 py-3 text-left text-xs font-medium text-slate-500 uppercase tracking-wider">Refund Amount</th>
                        <th class="px-6 py-3 text-left text-xs font-medium text-slate-500 uppercase tracking-wider">Refund Date</th>
                        <th class="px-6 py-3 text-left text-xs font-medium text-slate-500 uppercase tracking-wider">Status</th>
                        <th class="px-6 py-3 text-left text-xs font-medium text-slate-500 uppercase tracking-wider">Source</th>
                        <th class="px-6 py-3 text-left text-xs font-medium text-slate-500 uppercase tracking-wider">Reason</th>
                        <th class="px-6 py-3 text-right text-xs font-medium text-slate-500 uppercase tracking-wider">Actions</th>
                    </tr>
                </thead>
                <tbody class="bg-white divide-y divide-slate-200">
                    <?php foreach ($refunds as $refund): ?>
                    <tr class="hover:bg-slate-50 transition-colors">
                        <td class="px-6 py-4 whitespace-nowrap">
                            <div class="flex items-center">
                                <div class="w-10 h-10 bg-gradient-to-br from-red-500 to-rose-600 rounded-lg flex items-center justify-center mr-3">
                                    <svg class="w-5 h-5 text-white" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12l2 2 4-4M7.835 4.697a3.42 3.42 0 001.946-.806 3.42 3.42 0 014.438 0 3.42 3.42 0 001.946.806 3.42 3.42 0 013.138 3.138 3.42 3.42 0 00.806 1.946 3.42 3.42 0 010 4.438 3.42 3.42 0 00-.806 1.946 3.42 3.42 0 01-3.138 3.138 3.42 3.42 0 00-1.946.806 3.42 3.42 0 01-4.438 0 3.42 3.42 0 00-1.946-.806 3.42 3.42 0 01-3.138-3.138 3.42 3.42 0 00-.806-1.946 3.42 3.42 0 010-4.438 3.42 3.42 0 00.806-1.946 3.42 3.42 0 013.138-3.138z"></path>
                                    </svg>
                                </div>
                                <div>
                                    <div class="text-sm font-medium text-slate-900"><?= htmlspecialchars($refund['booking_code'] ?? 'N/A') ?></div>
                                    <div class="text-sm text-slate-500">ID: #<?= (int)$refund['id'] ?></div>
                                </div>
                            </div>
                        </td>
                        <td class="px-6 py-4">
                            <div class="text-sm text-slate-900"><?= htmlspecialchars($refund['from_text'] ?? 'N/A') ?></div>
                            <div class="text-sm text-slate-500">→ <?= htmlspecialchars($refund['to_text'] ?? 'N/A') ?></div>
                            <div class="text-xs text-slate-400 mt-1"><?= htmlspecialchars($refund['taxi_name'] ?? 'Unknown Taxi') ?></div>
                        </td>
                        <td class="px-6 py-4 whitespace-nowrap">
                            <div class="text-lg font-bold text-red-600">฿<?= number_format((float)($refund['refund_amount_calc'] ?? 0), 2) ?></div>
                            <div class="text-xs text-slate-500">Original: ฿<?= number_format((float)($refund['amount_total'] ?? 0), 2) ?></div>
                        </td>
                        <td class="px-6 py-4 whitespace-nowrap">
                            <div class="text-sm text-slate-900">
                                <?= date('M j, Y', strtotime($refund['refund_date_calc'] ?? 'now')) ?>
                            </div>
                            <div class="text-xs text-slate-500">
                                <?= date('g:i A', strtotime($refund['refund_date_calc'] ?? 'now')) ?>
                            </div>
                        </td>
                        <td class="px-6 py-4 whitespace-nowrap">
                            <?php
                            $status = $refund['status'] ?? 'unknown';
                            $paymentStatus = $refund['payment_status'] ?? 'unknown';
                            $badgeClass = 'status-refunded';
                            $statusText = 'Refunded';
                            
                            if ($paymentStatus === 'partial') {
                                $badgeClass = 'status-partial';
                                $statusText = 'Partial Refund';
                            }
                            ?>
                            <span class="status-badge <?= $badgeClass ?>"><?= $statusText ?></span>
                        </td>
                        <td class="px-6 py-4 whitespace-nowrap">
                            <?php 
                                $src = trim((string)($refund['refund_source'] ?? ''));
                                $method = trim((string)($refund['refund_method'] ?? ''));
                                $srcBadge = 'bg-slate-100 text-slate-700';
                                if ($src === 'Wallet Refund') { $srcBadge = 'bg-emerald-100 text-emerald-700'; }
                                elseif ($src === 'Gateway Refund') { $srcBadge = 'bg-indigo-100 text-indigo-700'; }
                            ?>
                            <span class="inline-flex items-center px-2 py-0.5 rounded text-xs font-semibold <?= $srcBadge ?>">
                                <?= htmlspecialchars($src !== '' ? $src : 'Unknown') ?>
                            </span>
                            <?php if ($method !== ''): ?>
                                <span class="ml-2 text-xs text-slate-500">(<?= htmlspecialchars($method) ?>)</span>
                            <?php endif; ?>
                        </td>
                        <td class="px-6 py-4">
                            <div class="text-sm text-slate-900">
                                <?php 
                                    $reason = trim((string)($refund['refund_reason_calc'] ?? ''));
                                    if ($reason === '' && isset($refund['cancel_reason'])) { $reason = (string)$refund['cancel_reason']; }
                                    echo htmlspecialchars($reason !== '' ? $reason : 'No reason provided');
                                ?>
                            </div>
                        </td>
                        <td class="px-6 py-4 whitespace-nowrap text-right text-sm font-medium">
                            <a href="/b2b/agent/taxi/voucher?id=<?= (int)$refund['id'] ?>" 
                               class="inline-flex items-center px-3 py-1.5 bg-slate-100 hover:bg-slate-200 text-slate-700 text-xs font-medium rounded-lg transition-colors">
                                <svg class="w-3 h-3 mr-1" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M15 12a3 3 0 11-6 0 3 3 0 016 0z"></path>
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M2.458 12C3.732 7.943 7.523 5 12 5c4.478 0 8.268 2.943 9.542 7-1.274 4.057-5.064 7-9.542 7-4.477 0-8.268-2.943-9.542-7z"></path>
                                </svg>
                                View Details
                            </a>
                        </td>
                    </tr>
                    <?php endforeach; ?>
                </tbody>
            </table>
        </div>

        <!-- Pagination -->
        <?php if ($pager['totalPages'] > 1): ?>
        <div class="px-6 py-4 border-t border-slate-200 flex items-center justify-between">
            <div class="text-sm text-slate-700">
                Showing <?= (($pager['currentPage'] - 1) * $pager['perPage']) + 1 ?> to 
                <?= min($pager['currentPage'] * $pager['perPage'], $pager['totalItems']) ?> of 
                <?= $pager['totalItems'] ?> results
            </div>
            <div class="flex items-center space-x-2">
                <?php $cp = (int)$pager['currentPage']; $tp = (int)$pager['totalPages']; ?>
                <?php if ($cp > 1): ?>
                    <a href="?<?= http_build_query(array_merge($filters, ['page' => 1])) ?>" class="px-3 py-2 bg-slate-100 hover:bg-slate-200 text-slate-700 text-sm rounded-lg">First</a>
                    <a href="?<?= http_build_query(array_merge($filters, ['page' => $cp - 1])) ?>" class="px-3 py-2 bg-slate-100 hover:bg-slate-200 text-slate-700 text-sm rounded-lg">Prev</a>
                <?php endif; ?>

                <?php
                    $pages = [];
                    if ($tp <= 7) {
                        $pages = range(1, $tp);
                    } else {
                        $pages = [1, 2];
                        $start = max(3, $cp - 1);
                        $end = min($tp - 2, $cp + 1);
                        if ($start > 3) echo '<span class="px-2 text-slate-400">…</span>';
                        for ($i = $start; $i <= $end; $i++) { $pages[] = $i; }
                        if ($end < $tp - 2) echo '<span class="px-2 text-slate-400">…</span>';
                        $pages[] = $tp - 1; $pages[] = $tp;
                    }
                ?>
                <?php foreach ($pages as $i): ?>
                    <a href="?<?= http_build_query(array_merge($filters, ['page' => $i])) ?>" 
                       class="px-3 py-2 <?= (int)$i === $cp ? 'bg-red-600 text-white' : 'bg-slate-100 hover:bg-slate-200 text-slate-700' ?> text-sm rounded-lg transition-colors">
                        <?= $i ?>
                    </a>
                <?php endforeach; ?>

                <?php if ($cp < $tp): ?>
                    <a href="?<?= http_build_query(array_merge($filters, ['page' => $cp + 1])) ?>" class="px-3 py-2 bg-slate-100 hover:bg-slate-200 text-slate-700 text-sm rounded-lg">Next</a>
                    <a href="?<?= http_build_query(array_merge($filters, ['page' => $tp])) ?>" class="px-3 py-2 bg-slate-100 hover:bg-slate-200 text-slate-700 text-sm rounded-lg">Last</a>
                <?php endif; ?>
            </div>
        </div>
        <?php endif; ?>
        <?php endif; ?>
    </div>
</div>

<?php include __DIR__ . '/partials/footer.php'; ?>

</body>
</html>
