<?php
// app/Views/agent/support_view.php
$title = $title ?? 'Support Ticket';
$ticket = $ticket ?? null;
$replies = $replies ?? [];
$csrf = $csrf ?? '';
$error = $_GET['err'] ?? '';
$success = isset($_GET['ok']);

// Format timestamp with relative time
$fmt = function($ts) { 
    if(!$ts) return '—'; 
    $tm = strtotime((string)$ts); 
    if(!$tm) return '—';
    $now = time();
    $diff = $now - $tm;
    
    // Relative time for recent items
    if($diff < 3600) {
        $mins = floor($diff / 60);
        return $mins <= 1 ? 'just now' : $mins . ' minutes ago';
    } elseif($diff < 86400) {
        $hours = floor($diff / 3600);
        return $hours . ' hour' . ($hours > 1 ? 's' : '') . ' ago';
    } elseif($diff < 604800) {
        $days = floor($diff / 86400);
        return $days . ' day' . ($days > 1 ? 's' : '') . ' ago';
    }
    
    // Full date for older items
    return date('d M Y, H:i', $tm);
};

// Get status badge class
$statusBadge = [
    'open' => 'bg-blue-100 text-blue-800',
    'in_progress' => 'bg-amber-100 text-amber-800',
    'resolved' => 'bg-emerald-100 text-emerald-800',
    'closed' => 'bg-slate-100 text-slate-800'
];

// Get priority badge class
$priorityBadge = [
    'low' => 'bg-slate-100 text-slate-800',
    'normal' => 'bg-blue-100 text-blue-800',
    'high' => 'bg-amber-100 text-amber-800',
    'urgent' => 'bg-red-100 text-red-800'
];
require __DIR__ . '/partials/header.php';
?>

<div class="min-h-screen bg-slate-50">
    <div class="max-w-6xl mx-auto px-4 py-8">
        <?php if (!$ticket): ?>
            <div class="bg-white rounded-xl p-6 border border-red-200">
                <div class="text-red-600 font-medium">Ticket not found or you don't have permission to view it.</div>
                <a href="/b2b/agent/support" class="mt-4 inline-block text-blue-600 hover:underline">&larr; Back to tickets</a>
            </div>
        <?php else: ?>
            <?php if ($success): ?>
              <div class="mb-4 rounded-lg border border-emerald-200 bg-emerald-50 text-emerald-800 px-4 py-3">
                Reply sent successfully.
              </div>
            <?php endif; ?>
            <?php if ($error): ?>
              <div class="mb-4 rounded-lg border border-rose-200 bg-rose-50 text-rose-800 px-4 py-3">
                <?= htmlspecialchars($error) ?>
              </div>
            <?php endif; ?>
            <!-- Header -->
            <div class="flex flex-col md:flex-row md:items-center md:justify-between gap-4 mb-6 bg-white border border-slate-200 rounded-2xl shadow-sm px-5 py-4">
                <div>
                    <div class="flex items-center gap-2">
                      <svg class="w-6 h-6 text-blue-600" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M8 7V3m8 4V3m-9 8h10M5 21h14a2 2 0 002-2V7a2 2 0 00-2-2H5a2 2 0 00-2 2v12a2 2 0 002 2z" />
                      </svg>
                      <h1 class="text-2xl font-bold text-slate-800">Ticket #<?= $ticket['id'] ?></h1>
                    </div>
                    <div class="mt-1 text-sm text-slate-600 flex items-center gap-2">
                        <span class="inline-flex items-center px-2.5 py-0.5 rounded-full text-xs font-medium <?= $statusBadge[$ticket['status']] ?? 'bg-gray-100 text-gray-800' ?>">
                          <svg class="w-3.5 h-3.5 mr-1" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M5 13l4 4L19 7"/></svg>
                          <?= ucfirst(str_replace('_', ' ', $ticket['status'])) ?>
                        </span>
                        <span class="mx-1 text-slate-300">•</span>
                        <span class="inline-flex items-center text-slate-500">
                          <svg class="w-4 h-4 mr-1" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 8v4l3 3m6-3a9 9 0 11-18 0 9 9 0 0118 0z"/></svg>
                          <?= $fmt($ticket['created_at']) ?>
                        </span>
                    </div>
                </div>
                <div class="flex flex-wrap gap-2">
                    <a href="/b2b/agent/support" class="inline-flex items-center px-3 py-1.5 bg-white border border-slate-300 hover:bg-slate-100 text-slate-700 rounded-lg text-sm font-medium transition-colors">
                        <svg class="w-4 h-4 mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M15 19l-7-7 7-7"/></svg>
                        Back to Tickets
                    </a>
                </div>
            </div>

            <!-- Main Content -->
            <div class="grid grid-cols-1 lg:grid-cols-3 gap-6">
                <!-- Left Column (Ticket & Replies) -->
                <div class="lg:col-span-2 space-y-6">
                    <!-- Ticket Details -->
                    <div class="bg-white rounded-2xl shadow-sm border border-slate-200 overflow-hidden">
                        <div class="p-6 border-b border-slate-100">
                            <h2 class="text-xl font-semibold text-slate-800 mb-4 flex items-center gap-2">
                              <svg class="w-5 h-5 text-slate-400" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M7 8h10M7 12h8m-8 4h6"/></svg>
                              <?= htmlspecialchars($ticket['subject']) ?>
                            </h2>
                            
                            <div class="grid grid-cols-1 md:grid-cols-3 gap-4 text-sm text-slate-700 mb-4">
                                <div>
                                    <div class="text-xs text-slate-500 mb-1 inline-flex items-center">
                                      <svg class="w-3.5 h-3.5 mr-1" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M16.5 6v.75m0 3v.75m0 3v.75m0 3V18m-9-5.25h5.25M7.5 15h3M3.375 5.25c-.621 0-1.125.504-1.125 1.125v3.026a2.999 2.999 0 010 5.198v3.026c0 .621.504 1.125 1.125 1.125h17.25c.621 0 1.125-.504 1.125-1.125v-3.026a2.999 2.999 0 010-5.198V6.375c0-.621-.504-1.125-1.125-1.125H3.375z"/></svg>
                                      Category
                                    </div>
                                    <div class="font-medium"><?= ucfirst($ticket['category']) ?></div>
                                </div>
                                <div>
                                    <div class="text-xs text-slate-500 mb-1 inline-flex items-center">
                                      <svg class="w-3.5 h-3.5 mr-1" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 8v4l3 3M5 3h14a2 2 0 012 2v14a2 2 0 01-2 2H5a2 2 0 01-2-2V5a2 2 0 012-2z"/></svg>
                                      Priority
                                    </div>
                                    <div>
                                        <span class="inline-flex items-center px-2.5 py-0.5 rounded-full text-xs font-medium <?= $priorityBadge[strtolower($ticket['priority'])] ?? 'bg-gray-100 text-gray-800' ?>">
                                            <?= ucfirst($ticket['priority']) ?>
                                        </span>
                                    </div>
                                </div>
                                <div>
                                    <div class="text-xs text-slate-500 mb-1 inline-flex items-center">
                                      <svg class="w-3.5 h-3.5 mr-1" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M8 7V3m8 4V3m-9 8h10M5 21h14a2 2 0 002-2V7a2 2 0 00-2-2H5a2 2 0 00-2 2v12a2 2 0 002 2z"/></svg>
                                      Last Updated
                                    </div>
                                    <div class="font-medium"><?= $fmt($ticket['updated_at'] ?? $ticket['created_at']) ?></div>
                                </div>
                            </div>
                            
                            <div class="mt-4 pt-4 border-t border-slate-100">
                                <div class="prose max-w-none text-slate-700">
                                    <?= nl2br(htmlspecialchars($ticket['message'])) ?>
                                </div>
                            </div>
                        </div>
                    </div>

                    <!-- Conversation -->
                    <div class="bg-white rounded-xl shadow-sm border border-slate-200 overflow-hidden">
                        <div class="p-6 border-b border-slate-100">
                            <h3 class="text-lg font-medium text-slate-900 inline-flex items-center gap-2">
                              <svg class="w-5 h-5 text-slate-500" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M8 10h.01M12 10h.01M16 10h.01M9 16H5a2 2 0 01-2-2V6a2 2 0 012-2h14a2 2 0 012 2v8a2 2 0 01-2 2h-5l-5 5v-5z"/></svg>
                              Conversation
                            </h3>
                        </div>
                        
                        <div id="chatScroll" class="divide-y divide-slate-100 max-h-[520px] overflow-y-auto">
                            <?php if (empty($replies)): ?>
                                <div class="p-6 text-center text-slate-500">
                                    <svg class="mx-auto h-12 w-12 text-slate-300" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="1.5" d="M8 10h.01M12 10h.01M16 10h.01M9 16H5a2 2 0 01-2-2V6a2 2 0 012-2h14a2 2 0 012 2v8a2 2 0 01-2 2h-5l-5 5v-5z" />
                                    </svg>
                                    <p class="mt-2 text-sm">No replies yet. Be the first to respond.</p>
                                </div>
                            <?php else: ?>
                                <?php foreach ($replies as $reply): ?>
                                    <?php 
                                    $isAgent = $reply['role'] === 'agent';
                                    $isAdmin = $reply['role'] === 'admin';
                                    $isNote = $reply['role'] === 'note';
                                    $bgClass = $isAgent ? 'bg-blue-50' : ($isAdmin ? 'bg-slate-50' : 'bg-white');
                                    $borderClass = $isAgent ? 'border-l-4 border-blue-500' : ($isAdmin ? 'border-l-4 border-slate-500' : '');
                                    $title = $isAgent ? 'You' : ($isAdmin ? 'Support Team' : 'System');
                                    $icon = $isAgent ? 'user' : ($isAdmin ? 'shield' : 'info');
                                    ?>
                                    <div class="p-6 <?= $bgClass ?> <?= $borderClass ?> hover:bg-slate-50 transition-colors" id="reply-<?= $reply['id'] ?>">
                                        <div class="flex items-start gap-3">
                                            <div class="flex-shrink-0">
                                                <div class="h-10 w-10 rounded-full <?= $isAgent ? 'bg-blue-100 text-blue-600' : ($isAdmin ? 'bg-slate-200 text-slate-600' : 'bg-gray-200 text-gray-600') ?> flex items-center justify-center">
                                                    <?php if ($icon === 'user'): ?>
                                                        <svg class="h-5 w-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="1.5" d="M16 7a4 4 0 11-8 0 4 4 0 018 0zM12 14a7 7 0 00-7 7h14a7 7 0 00-7-7z" />
                                                        </svg>
                                                    <?php elseif ($icon === 'shield'): ?>
                                                        <svg class="h-5 w-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="1.5" d="M9 12l2 2 4-4m5.618-4.016A11.955 11.955 0 0112 2.944a11.955 11.955 0 01-8.618 3.04A12.02 12.02 0 003 9c0 5.591 3.824 10.29 9 11.622 5.176-1.332 9-6.03 9-11.622 0-1.042-.133-2.052-.382-3.016z" />
                                                        </svg>
                                                    <?php else: ?>
                                                        <svg class="h-5 w-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="1.5" d="M13 16h-1v-4h-1m1-4h.01M21 12a9 9 0 11-18 0 9 9 0 0118 0z" />
                                                        </svg>
                                                    <?php endif; ?>
                                                </div>
                                            </div>
                                            <div class="flex-1 min-w-0">
                                                <div class="flex items-center justify-between">
                                                    <div class="flex items-center gap-2">
                                                        <span class="text-sm font-medium text-slate-900"><?= $title ?></span>
                                                        <?php if ($isNote): ?>
                                                            <span class="inline-flex items-center px-2 py-0.5 rounded text-xs font-medium bg-purple-100 text-purple-800">
                                                                Note
                                                            </span>
                                                        <?php endif; ?>
                                                    </div>
                                                    <span class="text-xs text-slate-500"><?= $fmt($reply['created_at']) ?></span>
                                                </div>
                                                <div class="mt-1 text-sm text-slate-700 whitespace-pre-wrap">
                                                    <?= nl2br(htmlspecialchars($reply['message'])) ?>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                <?php endforeach; ?>
                                <div id="reply-latest"></div>
                            <?php endif; ?>
                        </div>
                        
                        <!-- Reply Form -->
                        <div class="p-4 border-t border-slate-100 bg-white">
                            <?php if ($ticket['status'] === 'closed'): ?>
                                <div class="text-center py-4 text-slate-500">
                                    This ticket is closed. You can no longer reply to it.
                                </div>
                            <?php else: ?>
                                <form method="post" action="/b2b/agent/support/reply" class="space-y-3" id="replyForm">
                                    <input type="hidden" name="csrf_token" value="<?= htmlspecialchars($csrf) ?>">
                                    <input type="hidden" name="ticket_id" value="<?= (int)$ticket['id'] ?>">
                                    
                                    <div>
                                        <label for="message" class="block text-sm font-medium text-slate-700 mb-1">Your Reply</label>
                                        <div class="mt-1">
                                            <textarea 
                                                id="message" 
                                                name="message" 
                                                rows="2" 
                                                required 
                                                class="block w-full rounded-lg border-slate-300 shadow-sm focus:border-blue-500 focus:ring-blue-500 sm:text-sm resize-none min-h-[44px] max-h-40"
                                                placeholder="Type your response here... (Ctrl+Enter to send)"
                                            ></textarea>
                                        </div>
                                    </div>
                                    <div class="flex items-center justify-end">
                                        <button 
                                            type="submit" 
                                            class="inline-flex items-center px-3 py-2 border border-transparent rounded-lg shadow-sm text-sm font-medium text-white bg-blue-600 hover:bg-blue-700 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-blue-500"
                                        >
                                            <svg class="-ml-1 mr-2 h-4 w-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 19l9 2-9-18-9 18 9-2zm0 0v-8" />
                                            </svg>
                                            Send Reply
                                        </button>
                                    </div>
                                </form>
                            <?php endif; ?>
                        </div>
                    </div>
                </div>
                
                <!-- Right Column (Ticket Info) -->
                <div class="space-y-6">
                  <!-- Ticket Status -->
                  <div class="bg-white rounded-2xl shadow-sm border border-slate-200 overflow-hidden">
                    <div class="px-4 py-3 bg-slate-50 border-b border-slate-200">
                      <h3 class="text-sm font-medium text-slate-900 inline-flex items-center gap-2">
                        <svg class="w-4 h-4 text-slate-500" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M5 13l4 4L19 7"/></svg>
                        Ticket Status
                      </h3>
                    </div>
                    <div class="p-4">
                      <div class="space-y-3">
                        <div>
                          <div class="text-xs text-slate-500 mb-1">Status</div>
                          <div class="text-sm font-medium">
                            <span class="inline-flex items-center px-2.5 py-0.5 rounded-full text-xs font-medium <?= $statusBadge[$ticket['status']] ?? 'bg-gray-100 text-gray-800' ?>">
                              <?= ucfirst(str_replace('_', ' ', $ticket['status'])) ?>
                            </span>
                          </div>
                        </div>
                        <div>
                          <div class="text-xs text-slate-500 mb-1">Created</div>
                          <div class="text-sm font-medium"><?= $fmt($ticket['created_at']) ?></div>
                        </div>
                        <div>
                          <div class="text-xs text-slate-500 mb-1">Last Updated</div>
                          <div class="text-sm font-medium"><?= $fmt($ticket['updated_at'] ?? $ticket['created_at']) ?></div>
                        </div>
                        <?php if ($ticket['last_replied_at']): ?>
                        <div>
                          <div class="text-xs text-slate-500 mb-1">Last Reply</div>
                          <div class="text-sm font-medium"><?= $fmt($ticket['last_replied_at']) ?></div>
                        </div>
                        <?php endif; ?>
                      </div>
                    </div>
                  </div>

                  <!-- Quick Actions -->
                  <?php if ($ticket['status'] !== 'closed'): ?>
                  <div class="bg-white rounded-2xl shadow-sm border border-slate-200 overflow-hidden">
                    <div class="px-4 py-3 bg-slate-50 border-b border-slate-200">
                      <h3 class="text-sm font-medium text-slate-900 inline-flex items-center gap-2">
                        <svg class="w-4 h-4 text-slate-500" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 8v4l3 3"/></svg>
                        Quick Actions
                      </h3>
                    </div>
                    <div class="p-2">
                      <form method="post" action="/b2b/agent/support/status" class="space-y-2">
                        <input type="hidden" name="csrf_token" value="<?= htmlspecialchars($csrf) ?>">
                        <input type="hidden" name="ticket_id" value="<?= (int)$ticket['id'] ?>">
                        <?php 
                          $st = (string)($ticket['status'] ?? 'open');
                          $canResolve = in_array($st, ['open','in_progress'], true);
                        ?>
                        <?php if ($canResolve): ?>
                        <button type="submit" name="status" value="resolved" class="w-full inline-flex items-center justify-center px-3 py-2 text-sm rounded-lg font-medium text-white bg-emerald-600 hover:bg-emerald-700 focus:outline-none focus:ring-2 focus:ring-emerald-500">
                          <svg class="mr-2 h-5 w-5 text-white" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M5 13l4 4L19 7" /></svg>
                          Mark as Resolved
                        </button>
                        <?php endif; ?>
                        <button type="submit" name="status" value="closed" class="w-full inline-flex items-center justify-center px-3 py-2 text-sm rounded-lg font-medium text-white bg-slate-700 hover:bg-slate-800 focus:outline-none focus:ring-2 focus:ring-slate-500" <?= $st==='closed' ? 'disabled' : '' ?>>
                          <svg class="mr-2 h-5 w-5 text-white" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M6 18L18 6M6 6l12 12" /></svg>
                          <?= $st==='closed' ? 'Closed' : 'Close Ticket' ?>
                        </button>
                      </form>
                    </div>
                  </div>
                  <?php endif; ?>

                  <!-- Properties -->
                  <div class="bg-white rounded-2xl shadow-sm border border-slate-200 overflow-hidden">
                    <div class="px-4 py-3 bg-slate-50 border-b border-slate-200">
                      <h3 class="text-sm font-medium text-slate-900 inline-flex items-center gap-2">
                        <svg class="w-4 h-4 text-slate-500" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M15 9h3.75M15 12h3.75M15 15h3.75M4.5 19.5h15a2.25 2.25 0 002.25-2.25V6.75A2.25 2.25 0 0019.5 4.5h-15a2.25 2.25 0 00-2.25 2.25v10.5A2.25 2.25 0 004.5 19.5zm6-10.125a1.875 1.875 0 11-3.75 0 1.875 1.875 0 013.75 0zm1.294 6.336a6.721 6.721 0 01-3.17.547 6.721 6.721 0 01-3.168-.547 3.375 3.375 0 013.17-5.916 3.375 3.375 0 013.168 5.916z"/></svg>
                        Properties
                      </h3>
                    </div>
                    <div class="p-4 space-y-3">
                      <div>
                        <div class="text-xs text-slate-500">Ticket ID</div>
                        <div class="text-sm font-medium">#<?= (int)$ticket['id'] ?></div>
                      </div>
                      <div>
                        <div class="text-xs text-slate-500">Agent ID</div>
                        <div class="text-sm font-medium"><?= (int)($ticket['user_id'] ?? 0) ?></div>
                      </div>
                      <?php if (!empty($ticket['user_email'])): ?>
                      <div>
                        <div class="text-xs text-slate-500">Email</div>
                        <div class="text-sm font-medium break-all"><?= htmlspecialchars((string)$ticket['user_email']) ?></div>
                      </div>
                      <?php endif; ?>
                    </div>
                  </div>
                </div>
            </div>
        <?php endif; ?>
    </div>
</div>

<!-- Add some JavaScript for better UX -->
<script>
document.addEventListener('DOMContentLoaded', function() {
    // Scroll to the bottom of the conversation
    const latestReply = document.getElementById('reply-latest');
    if (latestReply) {
        latestReply.scrollIntoView({ behavior: 'smooth' });
    }
    
    // Auto-resize textarea
    const textarea = document.getElementById('message');
    const form = document.getElementById('replyForm');
    if (textarea) {
        textarea.addEventListener('input', function() {
            this.style.height = 'auto';
            this.style.height = (this.scrollHeight) + 'px';
        });
        // Enter to send, Shift+Enter for newline
        textarea.addEventListener('keydown', function(e) {
            if (e.key === 'Enter' && !e.shiftKey) {
                e.preventDefault();
                if (form && this.value.trim() !== '') {
                    form.dispatchEvent(new Event('submit', {cancelable:true}));
                }
            }
        });
    }
    // AJAX submit to avoid full page reload
    if (form) {
        form.addEventListener('submit', async function(e){
            e.preventDefault();
            if (!textarea || textarea.value.trim() === '') return;
            const stickToBottom = () => {
                const chat = document.getElementById('chatScroll');
                if (chat) chat.scrollTop = chat.scrollHeight;
            };
            const fd = new FormData(form);
            try{
                const res = await fetch('/b2b/agent/support/reply', {method:'POST', body: fd, headers:{'Accept':'application/json','X-Requested-With':'XMLHttpRequest'}});
                if (!res.ok) throw new Error('network');
                const data = await res.json();
                if (data && data.reply && data.reply.id) {
                    // Append immediately
                    const chat = document.getElementById('chatScroll');
                    const anchor = document.getElementById('reply-latest');
                    const r = data.reply;
                    const html = `\n<div class="p-6 bg-blue-50 border-l-4 border-blue-500" id="reply-${r.id}">\n  <div class=\"flex items-start gap-3\">\n    <div class=\"flex-shrink-0\">\n      <div class=\"h-10 w-10 rounded-full bg-blue-100 text-blue-600 flex items-center justify-center\">\n        <svg class=\"h-5 w-5\" fill=\"none\" stroke=\"currentColor\" viewBox=\"0 0 24 24\"><path stroke-linecap=\"round\" stroke-linejoin=\"round\" stroke-width=\"1.5\" d=\"M16 7a4 4 0 11-8 0 4 4 0 018 0zM12 14a7 7 0 00-7 7h14a7 7 0 00-7-7z\" /></svg>\n      </div>\n    </div>\n    <div class=\"flex-1 min-w-0\">\n      <div class=\"flex items-center justify-between\">\n        <div class=\"flex items-center gap-2\"><span class=\"text-sm font-medium text-slate-900\">You</span></div>\n        <span class=\"text-xs text-slate-500\">just now</span>\n      </div>\n      <div class=\"mt-1 text-sm text-slate-700 whitespace-pre-wrap\">${textarea.value.replace(/&/g,'&amp;').replace(/</g,'&lt;').replace(/>/g,'&gt;')}</div>\n    </div>\n  </div>\n</div>`;
                    if (anchor) { anchor.insertAdjacentHTML('beforebegin', html); } else if (chat) { chat.insertAdjacentHTML('beforeend', html); }
                    window.agentSinceId = r.id; // hint to poller
                    textarea.value=''; textarea.style.height='auto';
                    stickToBottom();
                }
            }catch(err){ /* optionally show toast */ }
        });
    }
    
    // Live polling for new replies
    (function setupLivePolling(){
        const ticketInput = document.querySelector('#replyForm input[name="ticket_id"]');
        const chat = document.getElementById('chatScroll');
        if (!ticketInput || !chat) return;
        // Scroll to bottom on load
        chat.scrollTop = chat.scrollHeight;
        const ticketId = parseInt(ticketInput.value || '0', 10);
        let sinceId = (function(){
            // Try to read the highest id from existing replies
            let maxId = 0;
            chat.querySelectorAll('[id^="reply-"]').forEach(el=>{
                const n = parseInt((el.id||'').replace('reply-',''), 10);
                if (!isNaN(n) && n > maxId) maxId = n;
            });
            return maxId;
        })();
        // allow external updates (after own send)
        if (window.agentSinceId && window.agentSinceId > sinceId) sinceId = window.agentSinceId;
        function escapeHtml(s){
            return (s||'').replace(/[&<>"']/g, function(c){
                return ({'&':'&amp;','<':'&lt;','>':'&gt;','\"':'&quot;','\'':'&#39;'}[c] || c);
            });
        }
        function nearBottom(){
            return (chat.scrollHeight - chat.scrollTop - chat.clientHeight) < 80;
        }
        function renderReply(r){
            const role = (r.role||'').toLowerCase();
            const isAgent = role === 'agent';
            const isAdmin = role === 'admin';
            const isNote = role === 'note';
            const bgClass = isAgent ? 'bg-blue-50' : (isAdmin ? 'bg-slate-50' : 'bg-white');
            const borderClass = isAgent ? 'border-l-4 border-blue-500' : (isAdmin ? 'border-l-4 border-slate-500' : '');
            const title = isAgent ? 'You' : (isAdmin ? 'Support Team' : 'System');
            const message = escapeHtml(r.message||'');
            return `
            <div class="p-6 ${bgClass} ${borderClass}" id="reply-${r.id}">
              <div class="flex items-start gap-3">
                <div class="flex-shrink-0">
                  <div class="h-10 w-10 rounded-full ${isAgent ? 'bg-blue-100 text-blue-600' : (isAdmin ? 'bg-slate-200 text-slate-600' : 'bg-gray-200 text-gray-600')} flex items-center justify-center">
                    <svg class="h-5 w-5" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="1.5" d="M16 7a4 4 0 11-8 0 4 4 0 018 0zM12 14a7 7 0 00-7 7h14a7 7 0 00-7-7z" /></svg>
                  </div>
                </div>
                <div class="flex-1 min-w-0">
                  <div class="flex items-center justify-between">
                    <div class="flex items-center gap-2">
                      <span class="text-sm font-medium text-slate-900">${title}</span>
                      ${isNote ? '<span class="inline-flex items-center px-2 py-0.5 rounded text-xs font-medium bg-purple-100 text-purple-800">Note</span>' : ''}
                    </div>
                    <span class="text-xs text-slate-500">just now</span>
                  </div>
                  <div class="mt-1 text-sm text-slate-700 whitespace-pre-wrap">${message}</div>
                </div>
              </div>
            </div>`;
        }
        async function poll(){
            try {
                const sid = (window.agentSinceId && window.agentSinceId > sinceId) ? window.agentSinceId : sinceId;
                const res = await fetch(`/b2b/agent/support/replies?ticket_id=${ticketId}&since_id=${sid}`, {credentials:'same-origin'});
                if (!res.ok) return;
                const data = await res.json();
                if (!data || !data.replies || !data.replies.length) return;
                const stick = nearBottom();
                const anchor = document.getElementById('reply-latest');
                data.replies.forEach(r=>{
                    if (r.id && r.id > sinceId) sinceId = r.id;
                    const html = renderReply(r);
                    if (anchor) {
                        anchor.insertAdjacentHTML('beforebegin', html);
                    } else {
                        chat.insertAdjacentHTML('beforeend', html);
                    }
                });
                if (stick) {
                    chat.scrollTop = chat.scrollHeight;
                }
            } catch(e) { /* ignore */ }
        }
        setInterval(poll, 2000);
    })();

    // Handle error messages
    const urlParams = new URLSearchParams(window.location.search);
    if (urlParams.has('err')) {
        const error = urlParams.get('err');
        let message = 'An error occurred';
        
        switch(error) {
            case 'invalid_input':
                message = 'Please enter a valid message';
                break;
            case 'not_found':
                message = 'Ticket not found';
                break;
            case 'reply_failed':
                message = 'Failed to send reply. Please try again.';
                break;
        }
        
        if (message) {
            alert(message);
        }
    }
});
</script>
<?php require __DIR__ . '/partials/footer.php'; ?>
