<?php
// app/Views/agent/partials/sidebar.php
$active = $active ?? '';
function item($href, $label, $icon, $key, $active){
  $cls = 'sidebar-link'.($active===$key?' sidebar-link-active':'');
  echo '<a class="'.$cls.'" href="'.$href.'">'.$icon.'<span>'.$label.'</span></a>';
}
?>
<nav class="p-4 space-y-1">
  <div class="text-xs text-base-content/60 px-4 pb-1">Dashboard</div>
  <?php item('/b2b/agent', 'Overview', '📊', 'dashboard', $active); ?>
  <div class="text-xs text-base-content/60 px-4 pt-4 pb-1">Products</div>
  <?php item('/b2b/agent/hotels', 'Hotels', '🏨', 'hotels', $active); ?>
  <?php item('/b2b/agent/activities', 'Activities', '🎟️', 'activities', $active); ?>
  <?php item('/b2b/agent/taxi', 'Taxi', '🚕', 'taxi', $active); ?>
  <?php item('/b2b/agent/yachts', 'Yachts', '🛥️', 'yachts', $active); ?>
  <div class="text-xs text-base-content/60 px-4 pt-4 pb-1">Management</div>
  <?php item('/b2b/agent/bookings', 'Booking History (All)', '📒', 'bookings', $active); ?>
  <?php item('/b2b/agent/refunds', 'Refund History (All)', '💳', 'refunds', $active); ?>
  <div class="text-xs text-base-content/60 px-4 pt-4 pb-1">Bookings by Module</div>
  <?php item('/b2b/agent/activities/bookings', 'Activities • Bookings', '🎟️', 'act_bookings', $active); ?>
  <?php item('/b2b/agent/activities/refunds', 'Activities • Refunds', '🎟️', 'act_refunds', $active); ?>
  <?php item('/b2b/agent/hotels/bookings', 'Hotels • Bookings', '🏨', 'hot_bookings', $active); ?>
  <?php item('/b2b/agent/hotels/refunds', 'Hotels • Refunds', '🏨', 'hot_refunds', $active); ?>
  <?php item('/b2b/agent/taxi/bookings', 'Taxi • Bookings', '🚕', 'tax_bookings', $active); ?>
  <?php item('/b2b/agent/taxi/refunds', 'Taxi • Refunds', '🚕', 'tax_refunds', $active); ?>
  <?php item('/b2b/agent/yachts/bookings', 'Yachts • Bookings', '🛥️', 'yht_bookings', $active); ?>
  <?php item('/b2b/agent/yachts/refunds', 'Yachts • Refunds', '🛥️', 'yht_refunds', $active); ?>
  <?php item('/b2b/agent/wallet', 'Wallet', '👛', 'wallet', $active); ?>
  <?php item('/b2b/agent/profile', 'Profile', '👤', 'profile', $active); ?>
</nav>
