<?php
// app/Views/agent/packages.php
$title = $title ?? 'Packages';
$packages = $packages ?? [];
$partner = $partner ?? ['fixed_markup'=>null];
$active = 'packages';
require __DIR__ . '/partials/header.php';
?>

<!-- Filters -->
<form method="get" class="mb-4 grid gap-3 sm:grid-cols-2 lg:grid-cols-4">
  <input class="input input-bordered" name="q" placeholder="Package name" value="<?= htmlspecialchars($_GET['q'] ?? '') ?>" />
  <input class="input input-bordered" name="city" placeholder="Location" value="<?= htmlspecialchars($_GET['city'] ?? '') ?>" />
  <input class="input input-bordered" name="price_min" placeholder="Min price" value="<?= htmlspecialchars($_GET['price_min'] ?? '') ?>" />
  <input class="input input-bordered" name="price_max" placeholder="Max price" value="<?= htmlspecialchars($_GET['price_max'] ?? '') ?>" />
  <div class="sm:col-span-2 lg:col-span-4"><button class="btn btn-primary">Search</button></div>
</form>

<!-- Grid -->
<div class="grid-cards">
  <?php if (!$packages): ?>
    <div class="col-span-full text-base-content/60">No packages found</div>
  <?php else: foreach ($packages as $p):
    $base = (float)($p['base_price'] ?? 0);
    $markup = (float)($partner['fixed_markup'] ?? 0);
    $agentPrice = $base + ($markup ?: 0);
  ?>
    <div class="card bg-base-100 shadow card-hover">
      <div class="card-body">
        <div class="flex items-start justify-between">
          <div>
            <h2 class="card-title mb-1"><?= htmlspecialchars($p['name'] ?? 'Package') ?></h2>
            <div class="text-sm text-base-content/70">
              <?= htmlspecialchars($p['city'] ?? '-') ?><?php if (!empty($p['duration'])): ?> • <?= htmlspecialchars($p['duration']) ?><?php endif; ?>
            </div>
          </div>
        </div>
        <div class="mt-3">
          <div class="text-sm text-base-content/60">Admin Price</div>
          <div class="font-semibold"><?= number_format($base, 2) ?> THB</div>
        </div>
        <div class="mt-2">
          <div class="text-sm text-base-content/60">Agent Price</div>
          <div class="font-semibold"><?= number_format($agentPrice, 2) ?> THB</div>
          <?php if ($markup): ?>
            <div class="text-xs text-success">Includes fixed markup of <?= number_format($markup, 2) ?> THB</div>
          <?php endif; ?>
        </div>
        <div class="card-actions justify-end mt-4">
          <a href="#" class="btn btn-primary">Book Now</a>
        </div>
      </div>
    </div>
  <?php endforeach; endif; ?>
</div>

<?php require __DIR__ . '/partials/footer.php'; ?>
