<?php // app/Views/agent/kyc/index.php ?>
<?php require __DIR__ . '/../partials/header.php'; ?>

<div class="min-h-screen bg-base-200">
  <div class="max-w-5xl mx-auto px-4 py-8">
    <div class="bg-white rounded-2xl shadow-xl border border-slate-200 overflow-hidden">
      <div class="px-6 py-4 bg-gradient-to-r from-indigo-600 to-blue-600 text-white flex items-center justify-between">
        <div class="flex items-center gap-3">
          <div class="w-9 h-9 rounded-xl bg-white/20 flex items-center justify-center">
            <svg class="w-5 h-5" fill="currentColor" viewBox="0 0 24 24"><path d="M12 2a10 10 0 100 20 10 10 0 000-20Zm-1 5h2v6h-2V7Zm1 10a1.5 1.5 0 110-3 1.5 1.5 0 010 3Z"/></svg>
          </div>
          <div>
            <h2 class="text-xl font-bold leading-tight">KYC Verification</h2>
            <p class="text-white/80 text-sm">Securely upload your identity documents to unlock bookings and wallet features</p>
          </div>
        </div>
        <div class="flex items-center gap-2">
          <a href="/b2b/agent" class="btn btn-sm">Dashboard</a>
          <a href="/b2b/agent/kyc/status" class="btn btn-sm">KYC Status</a>
        </div>
      </div>
      <div class="p-6">
        <?php // Compute business type label for display near tip
          $__btMap = [ 'freelancer' => 'Freelancer', 'sole_proprietor' => 'Sole Proprietor', 'partnership' => 'Partnership / LLP', 'company' => 'Company' ];
          $__btLabel = $__btMap[strtolower((string)($business_type ?? 'freelancer'))] ?? 'Freelancer';
        ?>
        <div class="alert alert-info mb-2">
          <div>
            <span class="font-semibold">Tip:</span> Use clear, well-lit photos. Accepts JPG, PNG, or WEBP up to 5 MB each. You can submit back side later.
          </div>
        </div>
        <div class="mb-5">
          <span class="inline-flex items-center px-3 py-1 rounded-full bg-brand-50 text-brand-700 text-sm border border-brand-200">
            <svg xmlns="http://www.w3.org/2000/svg" class="h-4 w-4 mr-1.5" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2"><path d="M20 21v-2a4 4 0 0 0-4-4H8a4 4 0 0 0-4 4v2"/><circle cx="12" cy="7" r="4"/></svg>
            Business Type: <span class="font-semibold ml-1"><?= htmlspecialchars($__btLabel) ?></span>
          </span>
        </div>

        <?php 
          $btLabelMap = [ 'freelancer' => 'Freelancer', 'sole_proprietor' => 'Sole Proprietor', 'partnership' => 'Partnership / LLP', 'company' => 'Company' ];
          $btLabel = $btLabelMap[strtolower((string)($business_type ?? 'freelancer'))] ?? 'Freelancer';
          $kf = $kyc_flags ?? [];
        ?>
        <div class="mb-6 rounded-xl border border-slate-200 bg-slate-50 p-4 hidden">
          <div class="flex flex-col sm:flex-row sm:items-center sm:justify-between gap-3">
            <div class="text-sm">
              <div class="font-semibold text-slate-800">KYC applies to: <span class="text-brand-700"><?= htmlspecialchars($btLabel) ?></span></div>
              <div class="text-slate-600 mt-1">Below are the requirements for your business type.</div>
            </div>
            <div class="flex flex-wrap gap-2 text-xs">
              <span class="badge">ID Type<?= !empty($kf['id_type_require']) ? ': Required' : ': Optional' ?></span>
              <span class="badge">ID Number<?= !empty($kf['id_number_require']) ? ': Required' : ': Optional' ?></span>
              <span class="badge">Front<?= !empty($kf['id_front_require']) ? ': Required' : ': Optional' ?></span>
              <span class="badge">Back<?= !empty($kf['id_back_enable']) ? (!empty($kf['id_back_require']) ? ': Enabled • Required' : ': Enabled') : ': Disabled' ?></span>
              <span class="badge <?= !empty($kf['selfie_enable']) ? 'badge-success' : '' ?>">Selfie: <?= !empty($kf['selfie_enable']) ? 'Yes' : 'No' ?><?= !empty($kf['selfie_require']) ? ' • Required' : '' ?></span>
              <span class="badge <?= !empty($kf['address_enable']) ? 'badge-success' : '' ?>">Address Proof: <?= !empty($kf['address_enable']) ? 'Yes' : 'No' ?><?= !empty($kf['address_require']) ? ' • Required' : '' ?></span>
              <?php if (!empty($kf['iata_enable'])): ?>
                <span class="badge">IATA: Yes<?= !empty($kf['iata_require_code']) ? ' • Code on Yes' : '' ?></span>
              <?php else: ?>
                <span class="badge">IATA: No</span>
              <?php endif; ?>
              <?php if (!empty($kf['gst_number_enable'])): ?>
                <span class="badge">GST Number: Yes<?= !empty($kf['gst_number_require']) ? ' • Required' : '' ?></span>
              <?php else: ?>
                <span class="badge">GST Number: No</span>
              <?php endif; ?>
              <?php if (!empty($kf['gst_company_enable'])): ?>
                <span class="badge">GST Company: Yes<?= !empty($kf['gst_company_require']) ? ' • Required' : '' ?></span>
              <?php else: ?>
                <span class="badge">GST Company: No</span>
              <?php endif; ?>
            </div>
          </div>
        </div>

        <?php if (!empty($_SESSION['errors'])): ?>
          <div class="alert alert-error">
            <ul class="list-disc ml-6">
              <?php foreach ((array)$_SESSION['errors'] as $e): ?>
                <li><?= htmlspecialchars($e) ?></li>
              <?php endforeach; unset($_SESSION['errors']); ?>
            </ul>
          </div>
        <?php endif; ?>
        <?php if (!empty($_SESSION['flash'])): ?>
          <div class="alert alert-info mb-3"><?= htmlspecialchars($_SESSION['flash']); unset($_SESSION['flash']); ?></div>
        <?php endif; ?>

        <form method="post" action="/b2b/agent/kyc/submit" enctype="multipart/form-data" class="grid grid-cols-1 gap-6">
          <input type="hidden" name="csrf" value="<?= htmlspecialchars($csrf ?? '') ?>">
          <?php 
            // Ensure business-type flags are available before any conditional blocks below
            $bt = strtolower((string)($business_type ?? 'freelancer'));
            $isSP = $bt === 'sole_proprietor';
            $isLLP = $bt === 'partnership';
            $isCO = $bt === 'company';
          ?>
          <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
            <div>
              <label class="label"><span class="label-text font-semibold">ID Type <?php if(!empty($kf['id_type_require'])): ?><span class="badge badge-error badge-sm ml-2">required</span><?php endif; ?></span></label>
              <?php $curType = $kyc['id_type'] ?? 'passport'; ?>
              <select name="id_type" class="select select-bordered w-full" <?php if(!empty($kf['id_type_require'])) echo 'required'; ?>>
                <option value="passport" <?= $curType==='passport'?'selected':''; ?>>Passport</option>
                <option value="national_id" <?= $curType==='national_id'?'selected':''; ?>>National ID</option>
                <option value="driving_license" <?= $curType==='driving_license'?'selected':''; ?>>Driving License</option>
                <option value="other" <?= $curType==='other'?'selected':''; ?>>Other</option>
              </select>
              <p class="mt-1 text-xs text-slate-500">Choose the document type you will upload</p>
            </div>
            <div>
              <label class="label"><span class="label-text font-semibold">Registration Certificate (SP)
                <span class="ml-2 tooltip" title="Upload your sole proprietor registration certificate">ℹ️</span>
              </span></label>
              <input type="file" id="doc_registration_certificate" name="doc_registration_certificate" class="file-input file-input-bordered w-full" accept="image/*,application/pdf">
              <div class="mt-2 flex items-center gap-2">
                <button type="button" class="btn btn-sm capture-btn" data-target="doc_registration_certificate">
                  <svg xmlns="http://www.w3.org/2000/svg" class="h-4 w-4" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2"><path d="M23 19V5a2 2 0 0 0-2-2H3a2 2 0 0 0-2 2v14"/><polyline points="7 14 12 9 17 14"/><line x1="12" y1="9" x2="12" y2="22"/></svg>
                  <span class="ml-1">Take Photo</span>
                </button>
              </div>
              <img id="prev_doc_registration_certificate" class="mt-2 hidden max-h-24 rounded border" alt="preview registration certificate" />
              <div id="meta_doc_registration_certificate" class="text-xs text-slate-500 mt-1"></div>
              <progress id="prog_doc_registration_certificate" class="progress progress-primary w-full hidden" value="0" max="100"></progress>
            </div>
            <?php if ($isLLP): ?>
            <div>
              <label class="label"><span class="label-text font-semibold">Partnership Deed (LLP)
                <span class="ml-2 tooltip" title="Upload your partnership deed (LLP)">ℹ️</span>
              </span></label>
              <input type="file" id="doc_partnership_deed" name="doc_partnership_deed" class="file-input file-input-bordered w-full" accept="image/*,application/pdf">
              <div class="mt-2 flex items-center gap-2">
                <button type="button" class="btn btn-sm capture-btn" data-target="doc_partnership_deed">
                  <svg xmlns="http://www.w3.org/2000/svg" class="h-4 w-4" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2"><path d="M23 19V5a2 2 0 0 0-2-2H3a2 2 0 0 0-2 2v14"/><polyline points="7 14 12 9 17 14"/><line x1="12" y1="9" x2="12" y2="22"/></svg>
                  <span class="ml-1">Take Photo</span>
                </button>
              </div>
              <img id="prev_doc_partnership_deed" class="mt-2 hidden max-h-24 rounded border" alt="preview partnership deed" />
              <div id="meta_doc_partnership_deed" class="text-xs text-slate-500 mt-1"></div>
              <progress id="prog_doc_partnership_deed" class="progress progress-primary w-full hidden" value="0" max="100"></progress>
            </div>
            <?php endif; ?>
            <?php if ($isCO): ?>
            <div>
              <label class="label"><span class="label-text font-semibold">Incorporation Certificate (Company)
                <span class="ml-2 tooltip" title="Upload your company incorporation certificate">ℹ️</span>
              </span></label>
              <input type="file" id="doc_incorporation_certificate" name="doc_incorporation_certificate" class="file-input file-input-bordered w-full" accept="image/*,application/pdf">
              <div class="mt-2 flex items-center gap-2">
                <button type="button" class="btn btn-sm capture-btn" data-target="doc_incorporation_certificate">
                  <svg xmlns="http://www.w3.org/2000/svg" class="h-4 w-4" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2"><path d="M23 19V5a2 2 0 0 0-2-2H3a2 2 0 0 0-2 2v14"/><polyline points="7 14 12 9 17 14"/><line x1="12" y1="9" x2="12" y2="22"/></svg>
                  <span class="ml-1">Take Photo</span>
                </button>
              </div>
              <img id="prev_doc_incorporation_certificate" class="mt-2 hidden max-h-24 rounded border" alt="preview incorporation cert" />
              <div id="meta_doc_incorporation_certificate" class="text-xs text-slate-500 mt-1"></div>
              <progress id="prog_doc_incorporation_certificate" class="progress progress-primary w-full hidden" value="0" max="100"></progress>
            </div>
            <?php endif; ?>
          </div>

          <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
            <div>
              <label class="label"><span class="label-text font-semibold">ID Number <?php if(!empty($kf['id_number_require'])): ?><span class="badge badge-error badge-sm ml-2">required</span><?php endif; ?></span></label>
              <input type="text" name="id_number" class="input input-bordered w-full" value="<?= htmlspecialchars($kyc['id_number'] ?? '') ?>" placeholder="Enter document number" <?php if(!empty($kf['id_number_require'])) echo 'required'; ?>>
              <p class="mt-1 text-xs text-slate-500">We use this only for verification purposes</p>
            </div>
            <div>
              <label class="label"><span class="label-text font-semibold">Government ID (Front)
                <?php if(!empty($kf['id_front_require'])): ?><span class="badge badge-error badge-sm ml-2">required</span><?php endif; ?>
                <span class="ml-2 tooltip" title="Upload a clear photo of the front side showing name and number">ℹ️</span>
              </span></label>
              <input type="file" id="doc_front" name="doc_front" class="file-input file-input-bordered w-full" accept="image/jpeg,image/png,image/webp;capture=camera" <?php if(!empty($kf['id_front_require'])) echo 'required'; ?>>
              <div class="mt-2 flex items-center gap-2">
                <button type="button" class="btn btn-sm capture-btn" data-target="doc_front">
                  <svg xmlns="http://www.w3.org/2000/svg" class="h-4 w-4" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2"><path d="M23 19V5a2 2 0 0 0-2-2H3a2 2 0 0 0-2 2v14"/><polyline points="7 14 12 9 17 14"/><line x1="12" y1="9" x2="12" y2="22"/></svg>
                  <span class="ml-1">Take Photo</span>
                </button>
              </div>
              <p class="mt-1 text-xs text-slate-500">Clear photo showing name and number</p>
              <img id="prev_doc_front" class="mt-2 hidden max-h-24 rounded border" alt="preview front" />
              <div id="meta_doc_front" class="text-xs text-slate-500 mt-1"></div>
              <progress id="prog_doc_front" class="progress progress-primary w-full hidden" value="0" max="100"></progress>
              <?php if (!empty($kyc['doc_front_path']) && !empty($kyc['id'])): ?>
                <div class="mt-2 text-xs"><a class="link" href="/b2b/agent/kyc/file?id=<?= (int)$kyc['id'] ?>&side=front" target="_blank">View previously uploaded</a></div>
              <?php endif; ?>
            </div>
            <?php if (!empty($kf['id_back_enable'])): ?>
            <div>
              <label class="label"><span class="label-text font-semibold">Government ID (Back)
                <?php if(!empty($kf['id_back_require'])): ?><span class="badge badge-error badge-sm ml-2">required</span><?php endif; ?>
                <span class="ml-2 tooltip" title="Back side of the same document (optional)">ℹ️</span>
              </span></label>
              <input type="file" id="doc_back" name="doc_back" class="file-input file-input-bordered w-full" accept="image/jpeg,image/png,image/webp;capture=camera" <?php if(!empty($kf['id_back_require'])) echo 'required'; ?>>
              <div class="mt-2 flex items-center gap-2">
                <button type="button" class="btn btn-sm capture-btn" data-target="doc_back">
                  <svg xmlns="http://www.w3.org/2000/svg" class="h-4 w-4" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2"><path d="M23 19V5a2 2 0 0 0-2-2H3a2 2 0 0 0-2 2v14"/><polyline points="7 14 12 9 17 14"/><line x1="12" y1="9" x2="12" y2="22"/></svg>
                  <span class="ml-1">Take Photo</span>
                </button>
              </div>
              <p class="mt-1 text-xs text-slate-500">Optional for some IDs</p>
              <img id="prev_doc_back" class="mt-2 hidden max-h-24 rounded border" alt="preview back" />
              <div id="meta_doc_back" class="text-xs text-slate-500 mt-1"></div>
              <progress id="prog_doc_back" class="progress progress-primary w-full hidden" value="0" max="100"></progress>
              <?php if (!empty($kyc['doc_back_path']) && !empty($kyc['id'])): ?>
                <div class="mt-2 text-xs"><a class="link" href="/b2b/agent/kyc/file?id=<?= (int)$kyc['id'] ?>&side=back" target="_blank">View previously uploaded</a></div>
              <?php endif; ?>
            </div>
            <?php endif; ?>
          </div>

          <?php $kf = $kyc_flags ?? ['selfie_enable'=>false,'selfie_require'=>false,'address_enable'=>false,'address_require'=>false]; ?>
          <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
            <?php if (!empty($kf['selfie_enable'])): ?>
            <div>
              <label class="label"><span class="label-text font-semibold">Selfie <?php if (!empty($kf['selfie_require'])): ?><span class="badge badge-error badge-sm ml-2">required</span><?php endif; ?>
                <span class="ml-2 tooltip" title="Take a clear headshot with good lighting">ℹ️</span>
              </span></label>
              <input type="file" id="doc_selfie" name="doc_selfie" class="file-input file-input-bordered w-full" accept="image/jpeg,image/png,image/webp;capture=user" style="display:none;" <?php if(!empty($kf['selfie_require'])) echo 'required'; ?>>
              <input type="hidden" name="liveness_motion" id="liveness_motion" value="">
              <input type="hidden" name="liveness_blink" id="liveness_blink" value="">
              <p class="mt-1 text-xs text-slate-500">Face must be visible and unobstructed. We will verify quick head-turn and a blink.</p>
              <div class="mt-2 flex items-center gap-2">
                <button type="button" class="btn btn-sm capture-btn" data-target="doc_selfie">
                  <svg xmlns="http://www.w3.org/2000/svg" class="h-4 w-4" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2"><path d="M23 19V5a2 2 0 0 0-2-2H3a2 2 0 0 0-2 2v14"/><polyline points="7 14 12 9 17 14"/><line x1="12" y1="9" x2="12" y2="22"/></svg>
                  <span class="ml-1">Take Selfie</span>
                </button>
                <span class="text-xs text-slate-500">Use your camera to capture a selfie</span>
              </div>
              <img id="prev_doc_selfie" class="mt-2 hidden max-h-24 rounded border" alt="preview selfie" />
              <div id="meta_doc_selfie" class="text-xs text-slate-500 mt-1"></div>
              <progress id="prog_doc_selfie" class="progress progress-primary w-full hidden" value="0" max="100"></progress>
            </div>
            <?php endif; ?>
            <?php if (!empty($kf['address_enable'])): ?>
            <div>
              <label class="label"><span class="label-text font-semibold">Address Proof <?php if (!empty($kf['address_require'])): ?><span class="badge badge-error badge-sm ml-2">required</span><?php endif; ?>
                <span class="ml-2 tooltip" title="Utility bill, bank statement, or similar">ℹ️</span>
              </span></label>
              <input type="file" id="doc_address" name="doc_address" class="file-input file-input-bordered w-full" accept="image/jpeg,image/png,image/webp" <?php if(!empty($kf['address_require'])) echo 'required'; ?>>
              <div class="mt-2 flex items-center gap-2">
                <button type="button" class="btn btn-sm capture-btn" data-target="doc_address">
                  <svg xmlns="http://www.w3.org/2000/svg" class="h-4 w-4" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2"><path d="M23 19V5a2 2 0 0 0-2-2H3a2 2 0 0 0-2 2v14"/><polyline points="7 14 12 9 17 14"/><line x1="12" y1="9" x2="12" y2="22"/></svg>
                  <span class="ml-1">Take Photo</span>
                </button>
              </div>
              <p class="mt-1 text-xs text-slate-500">Utility bill, bank statement, or similar <?php if (empty($kf['address_require'])): ?> (optional) <?php endif; ?></p>
              <img id="prev_doc_address" class="mt-2 hidden max-h-24 rounded border" alt="preview address" />
              <div id="meta_doc_address" class="text-xs text-slate-500 mt-1"></div>
              <progress id="prog_doc_address" class="progress progress-primary w-full hidden" value="0" max="100"></progress>
            </div>
            <?php endif; ?>
          </div>

          <?php 
            $bt = strtolower((string)($business_type ?? 'freelancer'));
            $isSP = $bt === 'sole_proprietor';
            $isLLP = $bt === 'partnership';
            $isCO = $bt === 'company';
          ?>

          <?php if ($isSP || $isLLP || $isCO): ?>
          <div class="divider">Business Info</div>
          <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
            <div>
              <label class="label"><span class="label-text font-semibold">Company / Agency Name <span class="badge badge-error badge-sm ml-2">required</span>
                <span class="ml-2 tooltip" title="Your legal business / agency name as it should appear on invoices and communication">ℹ️</span>
              </span></label>
              <input type="text" name="company" class="input input-bordered w-full" placeholder="e.g., Stellar Travels Pvt Ltd" value="<?= htmlspecialchars((string)($profile['company'] ?? '')) ?>" required>
            </div>
          </div>
          <?php endif; ?>

          <!-- Address Section -->
          <div class="divider">Address</div>
          <?php 
            // Do not auto-fill country; let user choose from full list (same as register page)
            $countrySaved = '';
            $stateSaved = (string)($profile['state'] ?? '');
            $citySaved = (string)($profile['city'] ?? '');
            $pinSaved = (string)($profile['pincode'] ?? '');
            $addrSaved = (string)($profile['address'] ?? '');
          ?>
          <div class="grid grid-cols-1 md:grid-cols-4 gap-4">
            <div>
              <label class="label"><span class="label-text font-semibold">Country</span></label>
              <select name="country" class="select select-bordered w-full" <?php if(!empty($kf['address_require'])) echo 'required'; ?>>
                <option value="">Select your country</option>
                <option value="AF">Afghanistan</option>
                <option value="AL">Albania</option>
                <option value="DZ">Algeria</option>
                <option value="AS">American Samoa</option>
                <option value="AD">Andorra</option>
                <option value="AO">Angola</option>
                <option value="AI">Anguilla</option>
                <option value="AR">Argentina</option>
                <option value="AM">Armenia</option>
                <option value="AW">Aruba</option>
                <option value="AU">Australia</option>
                <option value="AT">Austria</option>
                <option value="AZ">Azerbaijan</option>
                <option value="BS">Bahamas</option>
                <option value="BH">Bahrain</option>
                <option value="BD">Bangladesh</option>
                <option value="BB">Barbados</option>
                <option value="BY">Belarus</option>
                <option value="BE">Belgium</option>
                <option value="BZ">Belize</option>
                <option value="BJ">Benin</option>
                <option value="BM">Bermuda</option>
                <option value="BT">Bhutan</option>
                <option value="BO">Bolivia</option>
                <option value="BA">Bosnia and Herzegovina</option>
                <option value="BW">Botswana</option>
                <option value="BR">Brazil</option>
                <option value="BN">Brunei</option>
                <option value="BG">Bulgaria</option>
                <option value="BF">Burkina Faso</option>
                <option value="BI">Burundi</option>
                <option value="KH">Cambodia</option>
                <option value="CM">Cameroon</option>
                <option value="CA">Canada</option>
                <option value="CV">Cape Verde</option>
                <option value="KY">Cayman Islands</option>
                <option value="CF">Central African Republic</option>
                <option value="TD">Chad</option>
                <option value="CL">Chile</option>
                <option value="CN">China</option>
                <option value="CO">Colombia</option>
                <option value="KM">Comoros</option>
                <option value="CG">Congo</option>
                <option value="CR">Costa Rica</option>
                <option value="CI">Côte d’Ivoire</option>
                <option value="HR">Croatia</option>
                <option value="CU">Cuba</option>
                <option value="CY">Cyprus</option>
                <option value="CZ">Czech Republic</option>
                <option value="DK">Denmark</option>
                <option value="DJ">Djibouti</option>
                <option value="DM">Dominica</option>
                <option value="DO">Dominican Republic</option>
                <option value="EC">Ecuador</option>
                <option value="EG">Egypt</option>
                <option value="SV">El Salvador</option>
                <option value="GQ">Equatorial Guinea</option>
                <option value="ER">Eritrea</option>
                <option value="EE">Estonia</option>
                <option value="SZ">Eswatini</option>
                <option value="ET">Ethiopia</option>
                <option value="FJ">Fiji</option>
                <option value="FI">Finland</option>
                <option value="FR">France</option>
                <option value="GA">Gabon</option>
                <option value="GM">Gambia</option>
                <option value="GE">Georgia</option>
                <option value="DE">Germany</option>
                <option value="GH">Ghana</option>
                <option value="GR">Greece</option>
                <option value="GD">Grenada</option>
                <option value="GU">Guam</option>
                <option value="GT">Guatemala</option>
                <option value="GN">Guinea</option>
                <option value="GW">Guinea-Bissau</option>
                <option value="GY">Guyana</option>
                <option value="HT">Haiti</option>
                <option value="HN">Honduras</option>
                <option value="HK">Hong Kong</option>
                <option value="HU">Hungary</option>
                <option value="IS">Iceland</option>
                <option value="IN">India</option>
                <option value="ID">Indonesia</option>
                <option value="IR">Iran</option>
                <option value="IQ">Iraq</option>
                <option value="IE">Ireland</option>
                <option value="IL">Israel</option>
                <option value="IT">Italy</option>
                <option value="JM">Jamaica</option>
                <option value="JP">Japan</option>
                <option value="JO">Jordan</option>
                <option value="KZ">Kazakhstan</option>
                <option value="KE">Kenya</option>
                <option value="KI">Kiribati</option>
                <option value="KP">Korea (North)</option>
                <option value="KR">Korea (South)</option>
                <option value="KW">Kuwait</option>
                <option value="KG">Kyrgyzstan</option>
                <option value="LA">Laos</option>
                <option value="LV">Latvia</option>
                <option value="LB">Lebanon</option>
                <option value="LS">Lesotho</option>
                <option value="LR">Liberia</option>
                <option value="LY">Libya</option>
                <option value="LI">Liechtenstein</option>
                <option value="LT">Lithuania</option>
                <option value="LU">Luxembourg</option>
                <option value="MO">Macau</option>
                <option value="MK">North Macedonia</option>
                <option value="MG">Madagascar</option>
                <option value="MW">Malawi</option>
                <option value="MY">Malaysia</option>
                <option value="MV">Maldives</option>
                <option value="ML">Mali</option>
                <option value="MT">Malta</option>
                <option value="MH">Marshall Islands</option>
                <option value="MQ">Martinique</option>
                <option value="MR">Mauritania</option>
                <option value="MU">Mauritius</option>
                <option value="MX">Mexico</option>
                <option value="FM">Micronesia</option>
                <option value="MD">Moldova</option>
                <option value="MC">Monaco</option>
                <option value="MN">Mongolia</option>
                <option value="ME">Montenegro</option>
                <option value="MA">Morocco</option>
                <option value="MZ">Mozambique</option>
                <option value="MM">Myanmar</option>
                <option value="NA">Namibia</option>
                <option value="NR">Nauru</option>
                <option value="NP">Nepal</option>
                <option value="NL">Netherlands</option>
                <option value="NC">New Caledonia</option>
                <option value="NZ">New Zealand</option>
                <option value="NI">Nicaragua</option>
                <option value="NE">Niger</option>
                <option value="NG">Nigeria</option>
                <option value="NO">Norway</option>
                <option value="OM">Oman</option>
                <option value="PK">Pakistan</option>
                <option value="PW">Palau</option>
                <option value="PS">Palestine</option>
                <option value="PA">Panama</option>
                <option value="PG">Papua New Guinea</option>
                <option value="PY">Paraguay</option>
                <option value="PE">Peru</option>
                <option value="PH">Philippines</option>
                <option value="PL">Poland</option>
                <option value="PT">Portugal</option>
                <option value="PR">Puerto Rico</option>
                <option value="QA">Qatar</option>
                <option value="RE">Réunion</option>
                <option value="RO">Romania</option>
                <option value="RU">Russia</option>
                <option value="RW">Rwanda</option>
                <option value="KN">Saint Kitts and Nevis</option>
                <option value="LC">Saint Lucia</option>
                <option value="VC">Saint Vincent and the Grenadines</option>
                <option value="WS">Samoa</option>
                <option value="SM">San Marino</option>
                <option value="ST">São Tomé and Príncipe</option>
                <option value="SA">Saudi Arabia</option>
                <option value="SN">Senegal</option>
                <option value="RS">Serbia</option>
                <option value="SC">Seychelles</option>
                <option value="SL">Sierra Leone</option>
                <option value="SG">Singapore</option>
                <option value="SK">Slovakia</option>
                <option value="SI">Slovenia</option>
                <option value="SB">Solomon Islands</option>
                <option value="SO">Somalia</option>
                <option value="ZA">South Africa</option>
                <option value="ES">Spain</option>
                <option value="LK">Sri Lanka</option>
                <option value="SD">Sudan</option>
                <option value="SR">Suriname</option>
                <option value="SE">Sweden</option>
                <option value="CH">Switzerland</option>
                <option value="SY">Syria</option>
                <option value="TW">Taiwan</option>
                <option value="TJ">Tajikistan</option>
                <option value="TZ">Tanzania</option>
                <option value="TH">Thailand</option>
                <option value="TL">Timor-Leste</option>
                <option value="TG">Togo</option>
                <option value="TO">Tonga</option>
                <option value="TT">Trinidad and Tobago</option>
                <option value="TN">Tunisia</option>
                <option value="TR">Turkey</option>
                <option value="TM">Turkmenistan</option>
                <option value="UG">Uganda</option>
                <option value="UA">Ukraine</option>
                <option value="AE">United Arab Emirates</option>
                <option value="GB">United Kingdom</option>
                <option value="US">United States</option>
                <option value="UY">Uruguay</option>
                <option value="UZ">Uzbekistan</option>
                <option value="VU">Vanuatu</option>
                <option value="VE">Venezuela</option>
                <option value="VN">Vietnam</option>
                <option value="YE">Yemen</option>
                <option value="ZM">Zambia</option>
                <option value="ZW">Zimbabwe</option>
              </select>
            </div>
            <div>
              <label class="label"><span class="label-text font-semibold">State</span></label>
              <input type="text" name="state" class="input input-bordered w-full" placeholder="Type state/province" value="<?= htmlspecialchars($stateSaved) ?>" <?php if(!empty($kf['address_require'])) echo 'required'; ?>>
            </div>
            <div>
              <label class="label"><span class="label-text font-semibold">City</span></label>
              <input type="text" name="city" class="input input-bordered w-full" value="<?= htmlspecialchars($citySaved) ?>" <?php if(!empty($kf['address_require'])) echo 'required'; ?>>
            </div>
            <div>
              <label class="label"><span class="label-text font-semibold">Pincode</span></label>
              <input type="text" name="pincode" class="input input-bordered w-full" value="<?= htmlspecialchars($pinSaved) ?>" <?php if(!empty($kf['address_require'])) echo 'required'; ?>>
            </div>
          </div>
          <div class="mt-4">
            <label class="label"><span class="label-text font-semibold">Address</span></label>
            <input type="text" name="address" class="input input-bordered w-full" value="<?= htmlspecialchars($addrSaved) ?>" placeholder="House / Street / Area" <?php if(!empty($kf['address_require'])) echo 'required'; ?>>
          </div>

          <?php if (!empty($kf['iata_enable']) || !empty($kf['gst_number_enable']) || !empty($kf['gst_company_enable'])): ?>
          <div class="divider">Business Registration</div>
          <div class="grid grid-cols-1 md:grid-cols-3 gap-6">
            <?php if (!empty($kf['iata_enable'])): ?>
            <div>
              <label class="label"><span class="label-text font-semibold">IATA Registered
                <span class="ml-2 tooltip" title="Select Yes if your agency is IATA registered">ℹ️</span>
              </span></label>
              <?php $oldIata = (string)($_POST['iata_registered'] ?? '0'); ?>
              <select id="iata_registered" name="iata_registered" class="select select-bordered w-full">
                <option value="0" <?= $oldIata==='0'?'selected':''; ?>>No</option>
                <option value="1" <?= $oldIata==='1'?'selected':''; ?>>Yes</option>
              </select>
            </div>
            <div>
              <label class="label"><span class="label-text font-semibold">IATA Code <?php if (!empty($kf['iata_require_code'])): ?><span class="badge badge-error badge-sm ml-2">required on Yes</span><?php endif; ?>
                <span class="ml-2 tooltip" title="Enter your official IATA numeric code">ℹ️</span>
              </span></label>
              <input type="text" id="iata_code" name="iata_code" class="input input-bordered w-full" placeholder="Enter IATA code if applicable" disabled>
            </div>
            <?php endif; ?>

            <?php if (!empty($kf['gst_number_enable'])): ?>
            <div>
              <label class="label"><span class="label-text font-semibold">GST/VAT Number <?php if (!empty($kf['gst_number_require'])): ?><span class="badge badge-error badge-sm ml-2">required</span><?php endif; ?>
                <span class="ml-2 tooltip" title="Provide your GST number if enabled for your business type">ℹ️</span>
              </span></label>
              <input type="text" name="gst_number" class="input input-bordered w-full" placeholder="Enter GST/VAT number" <?php if(!empty($kf['gst_number_require'])) echo 'required'; ?>>
            </div>
            <?php endif; ?>

            <?php if (!empty($kf['gst_company_enable'])): ?>
            <div>
              <label class="label"><span class="label-text font-semibold">GST/VAT Company <?php if (!empty($kf['gst_company_require'])): ?><span class="badge badge-error badge-sm ml-2">required</span><?php endif; ?>
                <span class="ml-2 tooltip" title="Registered GST company name (if applicable)">ℹ️</span>
              </span></label>
              <input type="text" name="gst_company" class="input input-bordered w-full" placeholder="Enter GST/VAT registered company" <?php if(!empty($kf['gst_company_require'])) echo 'required'; ?>>
            </div>
            <?php endif; ?>
          </div>
          <?php endif; ?>

          <div class="flex flex-col md:flex-row items-center justify-between gap-3 mt-2">
            <div class="text-xs text-slate-500">By submitting, you agree that your documents will be securely stored and used only for verification.</div>
            <div class="flex gap-3">
              <a href="/b2b/agent/kyc/status" class="btn btn-ghost">View Status</a>
              <button type="submit" class="btn btn-primary">Submit KYC</button>
            </div>
          </div>
        </form>

        <?php if (!empty($docs)): ?>
          <div class="divider">Uploaded Documents</div>
          <div class="grid grid-cols-1 md:grid-cols-2 gap-4">
            <?php foreach ($docs as $d): ?>
              <div class="p-3 rounded-xl border border-slate-200 bg-slate-50">
                <div class="text-sm font-semibold mb-1">Type: <?= htmlspecialchars(ucwords(str_replace('_',' ',$d['doc_type']))) ?></div>
                <a class="link" target="_blank" href="/<?= htmlspecialchars($d['file_path']) ?>">View file</a>
              </div>
            <?php endforeach; ?>
          </div>
        <?php endif; ?>
      </div>
    </div>
  </div>
</div>

<?php require __DIR__ . '/../partials/footer.php'; ?>
<?php // Admin-like reusable camera overlay and logic
include __DIR__ . '/../partials/camera_admin_like.php'; ?>

<script>
  // Client-side helpers
  (function(){
    const MAX = 5 * 1024 * 1024; // 5MB
    const ACCEPT = ['image/jpeg','image/png','image/webp'];
    function qs(id){ return document.getElementById(id); }
    function humanSize(n){ const u=['B','KB','MB','GB']; let i=0; while(n>1024 && i<u.length-1){ n/=1024; i++; } return n.toFixed( (i>0)?1:0 )+' '+u[i]; }
    function bindPreview(inputId){
      const inp = qs(inputId); if (!inp) return;
      const prev = qs('prev_'+inputId);
      const meta = qs('meta_'+inputId);
      const prog = qs('prog_'+inputId);
      inp.addEventListener('change', function(){
        const f = this.files && this.files[0];
        if (!f) { if(prev) prev.classList.add('hidden'); if(meta) meta.textContent=''; return; }
        if (f.size > MAX) { alert('File too large (max 5MB).'); this.value=''; if(prev) prev.classList.add('hidden'); if(meta) meta.textContent=''; return; }
        if (ACCEPT.indexOf(f.type) === -1 && !inputId.includes('certificate') && !inputId.includes('deed')) {
          alert('Invalid image type. Allowed: JPEG, PNG, WEBP'); this.value=''; if(prev) prev.classList.add('hidden'); if(meta) meta.textContent=''; return; }
        // Local preview with progress via FileReader
        if (prev && f.type.startsWith('image/')) {
          const reader = new FileReader();
          if (prog) { prog.classList.remove('hidden'); prog.value = 0; }
          reader.onprogress = (e)=>{ if (e.lengthComputable && prog) { prog.value = Math.round((e.loaded/e.total)*100); } };
          reader.onload = (e)=>{ prev.src = e.target.result; prev.classList.remove('hidden'); if (prog) prog.classList.add('hidden'); };
          reader.readAsDataURL(f);
        }
        if (meta) { meta.textContent = f.name + ' • ' + (f.type||'') + ' • ' + humanSize(f.size); }
      });
    }
    ['doc_front','doc_back','doc_selfie','doc_address','doc_registration_certificate','doc_partnership_deed','doc_incorporation_certificate'].forEach(bindPreview);

    // IATA code required toggle (on Yes)
    const sel = qs('iata_registered');
    const code = qs('iata_code');
    const requireOnYes = <?php echo !empty($kyc_flags['iata_require_code']) ? 'true':'false'; ?>;
    function toggleIata(){
      if(!sel||!code) return;
      const yes = sel.value==='1';
      code.disabled = !yes;
      code.required = !!(requireOnYes && yes);
      if (!yes) { code.value=''; }
    }
    if (sel) { sel.addEventListener('change', toggleIata); toggleIata(); }

    // Drag & Drop support for file inputs
    function bindDnD(inputId){
      const inp = qs(inputId); if (!inp) return;
      const box = inp.closest('div'); if (!box) return;
      ['dragenter','dragover','dragleave','drop'].forEach(ev=>{
        box.addEventListener(ev, (e)=>{ e.preventDefault(); e.stopPropagation(); });
      });
      ['dragenter','dragover'].forEach(ev=>{
        box.addEventListener(ev, ()=> box.classList.add('ring','ring-primary','ring-offset-2'));
      });
      ['dragleave','drop'].forEach(ev=>{
        box.addEventListener(ev, ()=> box.classList.remove('ring','ring-primary','ring-offset-2'));
      });
      box.addEventListener('drop', (e)=>{
        const files = e.dataTransfer?.files; if (!files || !files.length) return;
        const dt = new DataTransfer(); dt.items.add(files[0]);
        inp.files = dt.files; inp.dispatchEvent(new Event('change'));
      });
    }
    ['doc_front','doc_back','doc_selfie','doc_address','doc_registration_certificate','doc_partnership_deed','doc_incorporation_certificate'].forEach(bindDnD);

    // Styled tooltips for elements with class 'tooltip' (using title attr)
    let tipEl = null;
    function showTip(target){
      const text = target.getAttribute('title'); if (!text) return;
      target.setAttribute('data-title', text); target.removeAttribute('title');
      tipEl = document.createElement('div'); tipEl.className = 'bt-tooltip'; tipEl.textContent = text;
      document.body.appendChild(tipEl);
      const r = target.getBoundingClientRect();
      const tw = tipEl.offsetWidth, th = tipEl.offsetHeight;
      let left = r.left + (r.width/2) - (tw/2); let top = r.top - th - 8 + window.scrollY;
      if (left < 8) left = 8; if (left + tw > window.innerWidth - 8) left = window.innerWidth - tw - 8;
      if (top < 8) top = r.bottom + 8 + window.scrollY;
      tipEl.style.left = left + 'px'; tipEl.style.top = top + 'px';
      requestAnimationFrame(()=> tipEl.classList.add('bt-tooltip-show'));
    }
    function hideTip(target){
      const text = target.getAttribute('data-title'); if (text && !target.getAttribute('title')) { target.setAttribute('title', text); }
      if (tipEl) { tipEl.remove(); tipEl = null; }
    }
    document.addEventListener('mouseover', (e)=>{ const t = e.target; if (t && t.classList && t.classList.contains('tooltip')) showTip(t); });
    document.addEventListener('mouseout', (e)=>{ const t = e.target; if (t && t.classList && t.classList.contains('tooltip')) hideTip(t); });
  })();
</script>

<style>
  /* Styled tooltip bubble */
  .bt-tooltip { position: absolute; z-index: 50; background: rgba(15,23,42,0.96); color: #fff; font-size: 12px; line-height: 1.25; padding: 6px 8px; border-radius: 6px; box-shadow: 0 8px 24px rgba(0,0,0,.25); opacity: 0; transform: translateY(-4px); transition: opacity .12s ease, transform .12s ease; max-width: 280px; }
  .bt-tooltip-show { opacity: 1; transform: translateY(0); }
</style>
