<?php
// app/Views/agent/hotel_detail.php
$title = $title ?? 'Hotel';
$hotel = $hotel ?? [];
$search = $search ?? ['checkin'=>date('Y-m-d', strtotime('+1 day')), 'checkout'=>date('Y-m-d', strtotime('+2 day')), 'rooms'=>1, 'nights'=>1];
$rate_plans = $rate_plans ?? [];
$room_offers = $room_offers ?? [];
$active = 'hotels';
require __DIR__ . '/partials/header.php';
?>

<div class="max-w-6xl mx-auto px-4 py-6">
  <a href="/b2b/agent/hotels" class="link link-primary">← Back to results</a>

  <div class="mt-4 grid grid-cols-1 md:grid-cols-12 gap-6">
    <div class="md:col-span-8 space-y-4">
      <div class="rounded-xl overflow-hidden border bg-white/80">
        <?php $thumb = trim((string)($hotel['thumbnail_url'] ?? '')); ?>
        <img src="<?= $thumb !== '' ? htmlspecialchars($thumb) : ('https://picsum.photos/seed/'.urlencode((string)($hotel['id'] ?? rand(1,9999))).'/1200/600') ?>"
             alt="Hotel photo" class="w-full h-64 md:h-80 object-cover" loading="lazy">
      </div>

      <div class="rounded-xl border bg-white/80 p-4 md:p-6">
        <div class="flex items-start gap-3">
          <h1 class="text-2xl font-bold flex-1">
            <?= htmlspecialchars($hotel['name'] ?? 'Hotel') ?>
          </h1>
          <?php $stars = (int)($hotel['stars'] ?? 0); if ($stars>0): ?>
            <div class="rating rating-sm">
              <?php for($i=1;$i<=5;$i++): ?>
                <input type="radio" class="mask mask-star-2 bg-amber-400" <?= $i==$stars?'checked':'' ?> />
              <?php endfor; ?>
            </div>
          <?php endif; ?>
        </div>
        <div class="text-sm text-base-content/70 mt-1">
          <?= htmlspecialchars(trim((string)($hotel['city'] ?? ''))) ?>
          <?php if (!empty($hotel['country'])): ?>, <?= htmlspecialchars($hotel['country']) ?><?php endif; ?>
        </div>

        <div class="mt-4 prose max-w-none">
          <p>Base price: <strong><?= number_format((float)($hotel['base_price'] ?? 0), 0) ?> THB</strong></p>
          <?php if (!empty($hotel['description'])): ?>
            <p><?= nl2br(htmlspecialchars($hotel['description'])) ?></p>
          <?php else: ?>
            <p>Contact us for more details about this property.</p>
          <?php endif; ?>
        </div>
      </div>

      <div class="rounded-xl border bg-white/80 p-4 md:p-6">
        <h2 class="text-xl font-semibold mb-3">Rooms & Availability</h2>
        <form method="get" action="/b2b/agent/hotel" class="grid grid-cols-1 md:grid-cols-6 gap-3 mb-4">
          <input type="hidden" name="id" value="<?= htmlspecialchars((string)($hotel['id'] ?? '')) ?>">
          <div class="form-control md:col-span-2">
            <label class="label"><span class="label-text">Check-in</span></label>
            <input type="date" name="checkin" value="<?= htmlspecialchars($search['checkin'] ?? '') ?>" class="input input-bordered">
          </div>
          <div class="form-control md:col-span-2">
            <label class="label"><span class="label-text">Check-out</span></label>
            <input type="date" name="checkout" value="<?= htmlspecialchars($search['checkout'] ?? '') ?>" class="input input-bordered">
          </div>
          <div class="form-control">
            <label class="label"><span class="label-text">Rooms</span></label>
            <input type="number" min="1" name="rooms" value="<?= (int)($search['rooms'] ?? 1) ?>" class="input input-bordered">
          </div>
          <div class="form-control flex justify-end md:col-span-1">
            <label class="label">&nbsp;</label>
            <button type="submit" class="btn btn-primary">Update</button>
          </div>
        </form>

        <?php if (empty($room_offers)): ?>
          <div class="alert">
            <div>No rooms configured for this property yet.</div>
          </div>
        <?php else: ?>
          <div class="text-sm text-base-content/70 mb-3">
            Stay: <strong><?= htmlspecialchars($search['checkin']) ?></strong> → <strong><?= htmlspecialchars($search['checkout']) ?></strong>
            • Nights: <strong><?= (int)($search['nights'] ?? 1) ?></strong>
            • Rooms: <strong><?= (int)($search['rooms'] ?? 1) ?></strong>
          </div>

          <form method="post" action="/b2b/agent/hotel/precheck" class="space-y-3">
            <?php $csrf_multi = \App\Middleware\AgentGuard::generateCsrfToken('hotel_precheck'); ?>
            <input type="hidden" name="csrf_token" value="<?= htmlspecialchars($csrf_multi) ?>">
            <input type="hidden" name="hotel_id" value="<?= (int)($hotel['id'] ?? 0) ?>">
            <input type="hidden" name="checkin" value="<?= htmlspecialchars($search['checkin'] ?? '') ?>">
            <input type="hidden" name="checkout" value="<?= htmlspecialchars($search['checkout'] ?? '') ?>">
            <input type="hidden" name="rooms_qty" value="<?= (int)($search['rooms'] ?? 1) ?>">
            <?php foreach ($room_offers as $offer): $r = $offer['room'] ?? []; $plans=$offer['plans'] ?? []; ?>
              <div class="border rounded-lg p-3 bg-base-100">
                <div class="flex items-start gap-3">
                  <div class="flex-1">
                    <div class="font-semibold"><?= htmlspecialchars($r['name'] ?? ('Room #' . (string)($r['id'] ?? ''))) ?></div>
                    <div class="text-xs text-base-content/70">
                      Max: <?= (int)($r['occupancy_adults'] ?? $r['capacity'] ?? 2) ?> adults
                      <?php if (!empty($r['bed_info'])): ?> • Bed: <?= htmlspecialchars($r['bed_info']) ?><?php endif; ?>
                    </div>
                  </div>

                  <div class="text-right min-w-[160px]">
                    <?php if (!empty($offer['available'])): ?>
                      <div class="text-success text-sm font-medium">Available</div>
                    <?php else: ?>
                      <div class="text-error text-sm font-medium">Sold out / Closed</div>
                    <?php endif; ?>
                    <div class="text-xs text-base-content/70">
                      for <?= (int)($search['rooms'] ?? 1) ?> room(s), <?= (int)($offer['nights'] ?? 1) ?> night(s)
                    </div>
                  </div>
                </div>

                <?php if (empty($plans)): ?>
                  <div class="mt-3 alert">
                    <div>No active rate plans configured.</div>
                  </div>
                <?php else: ?>
                  <div class="mt-3 grid grid-cols-1 md:grid-cols-1 gap-2">
                    <?php foreach ($plans as $pl): $rp = $pl['rate_plan'] ?? []; ?>
                      <div class="border rounded p-3 flex items-center justify-between bg-white/70">
                        <div>
                          <?php
                            $abbr = strtoupper(trim((string)($rp['meal_plan'] ?? '')));
                            $mealMap = [
                              'RO' => 'Room Only',
                              'BB' => 'Bed & Breakfast',
                              'HB' => 'Half Board',
                              'FB' => 'Full Board',
                              'AI' => 'All Inclusive',
                              'CP' => 'Continental Plan',
                            ];
                            $mealLabel = $mealMap[$abbr] ?? $abbr;
                          ?>
                          <div class="text-sm font-medium"><?= htmlspecialchars($rp['name'] ?? 'Plan') ?> <span class="badge ml-1"><?= htmlspecialchars($mealLabel) ?></span></div>
                          <div class="text-xs text-base-content/70">Refundable: <?= isset($rp['refundable']) && (int)$rp['refundable']===1 ? 'Yes' : 'No' ?></div>
                        </div>
                        <div class="text-right">
                          <div class="text-lg font-bold"><?= number_format((float)($pl['total_price'] ?? 0), 0) ?> THB</div>
                          <div class="mt-1 text-xs text-base-content/70">Qty</div>
                          <input type="number" class="input input-bordered input-sm w-20" name="selections[<?= (int)($r['id'] ?? 0) ?>][<?= (int)($rp['id'] ?? 0) ?>]" min="0" value="0" <?= empty($offer['available']) ? 'disabled' : '' ?> />
                        </div>
                      </div>
                    <?php endforeach; ?>
                  </div>
                <?php endif; ?>
              </div>
            <?php endforeach; ?>
            <div class="flex justify-end">
              <button class="btn btn-primary">Proceed</button>
            </div>
          </form>
        <?php endif; ?>
      </div>
    </div>

    <aside class="md:col-span-4 space-y-4">
      <div class="rounded-xl border bg-white/80 p-4 md:p-6">
        <h3 class="font-semibold mb-2">On the map</h3>
        <?php $lat = $hotel['latitude'] ?? null; $lng = $hotel['longitude'] ?? null; ?>
        <?php if ($lat && $lng): ?>
          <iframe
            class="w-full h-64 rounded-lg border"
            src="https://www.openstreetmap.org/export/embed.html?bbox=<?= urlencode((float)$lng-0.01) ?>%2C<?= urlencode((float)$lat-0.01) ?>%2C<?= urlencode((float)$lng+0.01) ?>%2C<?= urlencode((float)$lat+0.01) ?>&layer=mapnik&marker=<?= urlencode((float)$lat) ?>%2C<?= urlencode((float)$lng) ?>"
            style="border:0" loading="lazy"></iframe>
          <div class="text-xs text-base-content/70 mt-1">Lat: <?= htmlspecialchars($lat) ?>, Lng: <?= htmlspecialchars($lng) ?></div>
        <?php else: ?>
          <div class="text-sm text-base-content/70">Coordinates not available.</div>
        <?php endif; ?>
      </div>

      <div class="rounded-xl border bg-white/80 p-4 md:p-6">
        <h3 class="font-semibold mb-2">Contact</h3>
        <div class="text-sm text-base-content/70">Please reach out to our support to request a quote or confirm availability.</div>
        <a href="/b2b/agent/bookings/review" class="btn btn-primary btn-block mt-3">Proceed to Booking</a>
      </div>
    </aside>
  </div>
</div>

<?php require __DIR__ . '/partials/footer.php'; ?>
