<?php 
require __DIR__ . '/partials/header.php'; 
?>

<!-- CLEAN AGENT HOME PAGE -->
<div class="min-h-screen bg-gradient-to-br from-slate-50 via-white to-blue-50/30">

  <!-- Search Interface -->
  <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8 pt-8">
    <div class="bg-white rounded-2xl shadow-xl border border-slate-200 overflow-hidden relative z-10 transition-all duration-300 hover:shadow-2xl">
        
        <!-- Compact Search Header -->
        <div class="bg-gradient-to-r from-brand-600 to-blue-600 px-6 py-5 rounded-t-2xl">
          <div class="flex items-center justify-between">
            <div>
              <h2 class="text-xl font-bold text-white">Quick Search</h2>
              <p class="text-brand-100 mt-1 text-sm">Find and book instantly with live rates</p>
            </div>
            <div class="flex items-center space-x-6 text-white">
              <!-- Status Indicator -->
              <div class="flex items-center space-x-2">
                <div class="w-2 h-2 bg-emerald-400 rounded-full animate-pulse"></div>
                <span class="text-xs font-semibold text-emerald-100">Online</span>
              </div>
              
              <!-- Highlighted Wallet Balance -->
              <div class="bg-gradient-to-r from-emerald-400/20 to-green-400/20 backdrop-blur-sm px-4 py-2 rounded-xl border-2 border-emerald-300/40 shadow-lg ring-2 ring-emerald-300/20">
                <div class="text-xs text-emerald-100 font-semibold">Wallet Balance</div>
                <div class="text-lg font-black text-white">฿<?= number_format($wallet_balance ?? 0, 2) ?></div>
              </div>
              
              <!-- Live Rates & Instant Confirm -->
              <div class="flex items-center space-x-4">
                <div class="flex items-center space-x-2">
                  <div class="w-2 h-2 bg-emerald-400 rounded-full animate-pulse"></div>
                  <span class="text-sm font-semibold">Live Rates</span>
                </div>
                <div class="flex items-center space-x-2">
                  <svg class="w-4 h-4" fill="currentColor" viewBox="0 0 24 24">
                    <path d="M9 12l2 2 4-4m6 2a9 9 0 11-18 0 9 9 0 0118 0z"/>
                  </svg>
                  <span class="text-sm font-semibold">Instant Confirm</span>
                </div>
              </div>
            </div>
          </div>
        </div>

        <!-- Tab Navigation -->
        <div class="bg-slate-50 px-6 py-3 border-b border-slate-200">
          <nav class="flex space-x-1" role="tablist">
            <button role="tab" data-tab="hotels" aria-selected="true" class="tab-active px-4 py-2 rounded-lg font-semibold text-sm transition-all duration-200 flex items-center space-x-2 bg-white text-slate-800 shadow-sm border border-slate-200">
              <svg class="w-4 h-4 text-purple-600" fill="currentColor" viewBox="0 0 24 24">
                <path d="M4 3h10a2 2 0 012 2v14h3v2H3v-2h1V5a2 2 0 012-2Z"/>
              </svg>
              <span>Hotels</span>
            </button>
            <button role="tab" data-tab="activities" class="px-4 py-2 rounded-lg font-semibold text-sm transition-all duration-200 flex items-center space-x-2 text-slate-600 hover:text-slate-800 hover:bg-white/50">
              <svg class="w-4 h-4 text-emerald-600" fill="currentColor" viewBox="0 0 24 24">
                <path d="M12 3a9 9 0 100 18 9 9 0 000-18Zm0 4.5a1.5 1.5 0 110 3 1.5 1.5 0 010-3Zm-3.75 9.75a4.5 4.5 0 017.5 0H8.25Z"/>
              </svg>
              <span>Activities</span>
            </button>
            <button role="tab" data-tab="transfers" class="px-4 py-2 rounded-lg font-semibold text-sm transition-all duration-200 flex items-center space-x-2 text-slate-600 hover:text-slate-800 hover:bg-white/50">
              <svg class="w-4 h-4 text-blue-600" fill="currentColor" viewBox="0 0 24 24">
                <path d="M5 11l1.5-4.5A2 2 0 018.4 5h7.2a2 2 0 011.9 1.5L19 11v6a1 1 0 01-1 1h-1a1 1 0 01-1-1v-1H8v1a1 1 0 01-1 1H6a1 1 0 01-1-1v-6h0Z"/>
              </svg>
              <span>Transfers</span>
            </button>
            <button role="tab" data-tab="yachts" class="px-4 py-2 rounded-lg font-semibold text-sm transition-all duration-200 flex items-center space-x-2 text-slate-600 hover:text-slate-800 hover:bg-white/50">
              <svg class="w-4 h-4 text-cyan-600" fill="currentColor" viewBox="0 0 24 24">
                <path d="M3 18s2 3 9 3 9-3 9-3l-3-6h-6l-3 6Zm9-15l5 9h-5V3Z"/>
              </svg>
              <span>Yachts</span>
            </button>
            <button role="tab" data-tab="packages" class="px-4 py-2 rounded-lg font-semibold text-sm transition-all duration-200 flex items-center space-x-2 text-slate-600 hover:text-slate-800 hover:bg-white/50">
              <svg class="w-4 h-4 text-orange-600" fill="currentColor" viewBox="0 0 24 24">
                <path d="M3 7l9-4 9 4-9 4L3 7Zm0 3l9 4 9-4v7l-9 4-9-4v-7Z"/>
              </svg>
              <span>Packages</span>
            </button>
          </nav>
        </div>

      <!-- Enterprise Search Content -->
      <div class="p-8 md:p-10">
        <!-- Hotels Search Panel (Active) -->
        <div id="panel-hotels" role="tabpanel" class="space-y-8">
          <!-- Primary Search Row -->
          <div class="grid grid-cols-1 lg:grid-cols-12 gap-6 items-end">
            <!-- Destination -->
            <div class="lg:col-span-4">
              <label class="block text-xs font-bold text-slate-700 uppercase tracking-wide mb-3">Destination</label>
              <div class="relative">
                <input type="text" placeholder="Bangkok, Phuket, Pattaya..." 
                       class="w-full px-5 py-4 bg-white border border-slate-300 rounded-lg focus:border-blue-500 focus:ring-2 focus:ring-blue-100 transition-all duration-200 text-slate-900 font-medium placeholder-slate-500 shadow-sm">
                <svg class="absolute right-4 top-4 w-5 h-5 text-slate-400" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                  <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M17.657 16.657L13.414 20.9a1.998 1.998 0 01-2.827 0l-4.244-4.243a8 8 0 1111.314 0z"/>
                </svg>
              </div>
            </div>
            
            <!-- Check-in -->
            <div class="lg:col-span-2">
              <label class="block text-xs font-bold text-slate-700 uppercase tracking-wide mb-3">Check-in</label>
              <input type="date" class="w-full px-5 py-4 bg-white border border-slate-300 rounded-lg focus:border-blue-500 focus:ring-2 focus:ring-blue-100 transition-all duration-200 text-slate-900 font-medium shadow-sm">
            </div>
            
            <!-- Check-out -->
            <div class="lg:col-span-2">
              <label class="block text-xs font-bold text-slate-700 uppercase tracking-wide mb-3">Check-out</label>
              <input type="date" class="w-full px-5 py-4 bg-white border border-slate-300 rounded-lg focus:border-blue-500 focus:ring-2 focus:ring-blue-100 transition-all duration-200 text-slate-900 font-medium shadow-sm">
            </div>
            
            <!-- Guests & Rooms -->
            <div class="lg:col-span-2">
              <label class="block text-xs font-bold text-slate-700 uppercase tracking-wide mb-3">Guests & Rooms</label>
              <div class="grid grid-cols-2 gap-2">
                <select class="px-3 py-4 bg-white border border-slate-300 rounded-lg focus:border-blue-500 focus:ring-2 focus:ring-blue-100 transition-all duration-200 text-slate-900 font-medium shadow-sm text-sm">
                  <option>1</option>
                  <option>2</option>
                  <option>3</option>
                  <option>4+</option>
                </select>
                <select class="px-3 py-4 bg-white border border-slate-300 rounded-lg focus:border-blue-500 focus:ring-2 focus:ring-blue-100 transition-all duration-200 text-slate-900 font-medium shadow-sm text-sm">
                  <option>1</option>
                  <option>2</option>
                  <option>3</option>
                  <option>4+</option>
                </select>
              </div>
            </div>
            
            <!-- Search Button -->
            <div class="lg:col-span-2">
              <button class="w-full px-6 py-4 bg-blue-600 hover:bg-blue-700 text-white font-bold rounded-lg shadow-lg hover:shadow-xl transition-all duration-200 flex items-center justify-center space-x-2">
                <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                  <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M21 21l-6-6m2-5a7 7 0 11-14 0 7 7 0 0114 0z"/>
                </svg>
                <span>Search</span>
              </button>
            </div>
          </div>

          <!-- Advanced Filters -->
          <div class="border-t border-slate-200 pt-6 mt-6">
            <div class="grid grid-cols-2 lg:grid-cols-6 gap-4">
              <div>
                <label class="block text-xs font-semibold text-slate-600 mb-2">Star Rating</label>
                <select class="w-full px-3 py-2 bg-white border border-slate-300 rounded-md focus:border-blue-500 focus:ring-1 focus:ring-blue-100 text-sm">
                  <option>Any</option>
                  <option>5 Star</option>
                  <option>4 Star</option>
                  <option>3 Star</option>
                </select>
              </div>
              <div>
                <label class="block text-xs font-semibold text-slate-600 mb-2">Price Range</label>
                <select class="w-full px-3 py-2 bg-white border border-slate-300 rounded-md focus:border-blue-500 focus:ring-1 focus:ring-blue-100 text-sm">
                  <option>Any Budget</option>
                  <option>Under ฿2,000</option>
                  <option>฿2,000 - ฿5,000</option>
                  <option>฿5,000+</option>
                </select>
              </div>
              <div>
                <label class="block text-xs font-semibold text-slate-600 mb-2">Property Type</label>
                <select class="w-full px-3 py-2 bg-white border border-slate-300 rounded-md focus:border-blue-500 focus:ring-1 focus:ring-blue-100 text-sm">
                  <option>All Types</option>
                  <option>Hotel</option>
                  <option>Resort</option>
                  <option>Villa</option>
                </select>
              </div>
              <div>
                <label class="block text-xs font-semibold text-slate-600 mb-2">Amenities</label>
                <select class="w-full px-3 py-2 bg-white border border-slate-300 rounded-md focus:border-blue-500 focus:ring-1 focus:ring-blue-100 text-sm">
                  <option>Any</option>
                  <option>Pool</option>
                  <option>Spa</option>
                  <option>Beach Access</option>
                </select>
              </div>
              <div>
                <label class="block text-xs font-semibold text-slate-600 mb-2">Meal Plan</label>
                <select class="w-full px-3 py-2 bg-white border border-slate-300 rounded-md focus:border-blue-500 focus:ring-1 focus:ring-blue-100 text-sm">
                  <option>Room Only</option>
                  <option>Breakfast</option>
                  <option>Half Board</option>
                  <option>Full Board</option>
                </select>
              </div>
              <div class="flex items-end">
                <button class="w-full px-4 py-2 bg-slate-100 hover:bg-slate-200 text-slate-700 font-semibold rounded-md transition-colors text-sm">
                  Reset Filters
                </button>
              </div>
            </div>
          </div>
        </div>

        <!-- Other tab panels (hidden by default) -->
        <div id="panel-activities" role="tabpanel" class="hidden">
          <div class="text-center py-12 px-4">
            <div class="text-emerald-600 mb-4">
              <svg class="w-16 h-16 mx-auto" fill="currentColor" viewBox="0 0 24 24">
                <path d="M12 3a9 9 0 100 18 9 9 0 000-18Z"/>
              </svg>
            </div>
            <h3 class="text-2xl font-bold text-slate-800 mb-2">Activities & Tours</h3>
            <p class="text-slate-600">Search form coming soon...</p>
          </div>
        </div>

        <div id="panel-transfers" role="tabpanel" class="hidden">
          <div class="text-center py-12">
            <h3 class="text-2xl font-bold text-slate-800 mb-2">Transfers</h3>
            <p class="text-slate-600">Search form coming soon...</p>
          </div>
        </div>

        <div id="panel-yachts" role="tabpanel" class="hidden">
          <div class="text-center py-12">
            <h3 class="text-2xl font-bold text-slate-800 mb-2">Yachts</h3>
            <p class="text-slate-600">Search form coming soon...</p>
          </div>
        </div>

        <div id="panel-packages" role="tabpanel" class="hidden">
          <div class="text-center py-12">
            <h3 class="text-2xl font-bold text-slate-800 mb-2">Packages</h3>
            <p class="text-slate-600">Search form coming soon...</p>
          </div>
        </div>
      </div>
    </div>
    
    <!-- Generate Itinerary Section -->
    <div class="mt-10 px-4 sm:px-6 lg:px-8">
      <div class="max-w-4xl mx-auto bg-gradient-to-br from-blue-50 to-indigo-50 rounded-2xl p-6 shadow-sm border border-blue-100">
        <div class="flex flex-col md:flex-row items-center justify-between">
          <div class="text-center md:text-left mb-4 md:mb-0">
            <h3 class="text-lg font-bold text-slate-800">Ready to Plan Your Perfect Trip?</h3>
            <p class="text-slate-600 text-sm mt-1">Let our AI create a personalized itinerary based on your preferences</p>
          </div>
          <button class="group relative overflow-hidden bg-gradient-to-r from-blue-600 to-indigo-600 hover:from-blue-500 hover:to-indigo-500 text-white font-semibold py-3 px-6 rounded-xl shadow-lg hover:shadow-xl transition-all duration-300 transform hover:-translate-y-0.5 flex items-center space-x-2">
            <span class="absolute inset-0 w-full h-full bg-white opacity-10 group-hover:opacity-0 transition-opacity duration-300"></span>
            <svg class="w-5 h-5 text-white" fill="none" stroke="currentColor" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg">
              <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 5H7a2 2 0 00-2 2v12a2 2 0 002 2h10a2 2 0 002-2V7a2 2 0 00-2-2h-2M9 5a2 2 0 002 2h2a2 2 0 002-2M9 5a2 2 0 012-2h2a2 2 0 012 2m-3 7h3m-3 4h3m-6-4h.01M9 16h.01"></path>
            </svg>
            <span class="relative z-10">Generate Itinerary</span>
            <svg class="w-4 h-4 ml-1 transform group-hover:translate-x-1 transition-transform duration-200" fill="none" stroke="currentColor" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg">
              <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M14 5l7 7m0 0l-7 7m7-7H3"></path>
            </svg>
          </button>
        </div>
      </div>
    </div>
  </div>

</div>

<script>
// F11-style Fullscreen API with cross-browser support
function toggleF11Fullscreen() {
  console.log('Fullscreen button clicked!'); // Debug log
  
  const elem = document.documentElement;
  
  if (!document.fullscreenElement && !document.webkitFullscreenElement && !document.mozFullScreenElement && !document.msFullscreenElement) {
    // Enter fullscreen with cross-browser support
    console.log('Entering fullscreen...');
    
    if (elem.requestFullscreen) {
      elem.requestFullscreen();
    } else if (elem.webkitRequestFullscreen) { // Safari
      elem.webkitRequestFullscreen();
    } else if (elem.mozRequestFullScreen) { // Firefox
      elem.mozRequestFullScreen();
    } else if (elem.msRequestFullscreen) { // IE/Edge
      elem.msRequestFullscreen();
    } else {
      console.error('Fullscreen API not supported');
      alert('Your browser does not support fullscreen mode');
      return;
    }
    
    // Update button text
    setTimeout(() => {
      const btnText = document.getElementById('fullscreen-btn-text');
      if (btnText) {
        btnText.textContent = 'Exit Fullscreen';
      }
    }, 100);
    
  } else {
    // Exit fullscreen with cross-browser support
    console.log('Exiting fullscreen...');
    
    if (document.exitFullscreen) {
      document.exitFullscreen();
    } else if (document.webkitExitFullscreen) { // Safari
      document.webkitExitFullscreen();
    } else if (document.mozCancelFullScreen) { // Firefox
      document.mozCancelFullScreen();
    } else if (document.msExitFullscreen) { // IE/Edge
      document.msExitFullscreen();
    }
    
    // Update button text
    setTimeout(() => {
      const btnText = document.getElementById('fullscreen-btn-text');
      if (btnText) {
        btnText.textContent = 'Fullscreen Mode';
      }
    }, 100);
  }
}

// Listen for fullscreen changes (cross-browser)
document.addEventListener('fullscreenchange', updateFullscreenButton);
document.addEventListener('webkitfullscreenchange', updateFullscreenButton);
document.addEventListener('mozfullscreenchange', updateFullscreenButton);
document.addEventListener('MSFullscreenChange', updateFullscreenButton);

function updateFullscreenButton() {
  console.log('Fullscreen state changed');
  const btnText = document.getElementById('fullscreen-btn-text');
  if (btnText) {
    const isFullscreen = document.fullscreenElement || document.webkitFullscreenElement || 
                        document.mozFullScreenElement || document.msFullscreenElement;
    if (isFullscreen) {
      btnText.textContent = 'Exit Fullscreen';
      console.log('Now in fullscreen mode');
    } else {
      btnText.textContent = 'Fullscreen Mode';
      document.body.style.cursor = 'default';
      console.log('Exited fullscreen mode');
    }
  }
}

// Keyboard shortcut: F11 or Ctrl+F
document.addEventListener('keydown', (e) => {
  console.log('Key pressed:', e.key, 'Ctrl:', e.ctrlKey); // Debug key presses
  if (e.key === 'F11') {
    e.preventDefault();
    console.log('F11 key detected, calling fullscreen');
    toggleF11Fullscreen();
  }
  if (e.ctrlKey && e.key.toLowerCase() === 'f') {
    e.preventDefault();
    console.log('Ctrl+F detected, calling fullscreen');
    toggleF11Fullscreen();
  }
  // ESC to exit fullscreen
  if (e.key === 'Escape' && document.fullscreenElement) {
    console.log('ESC pressed, exiting fullscreen');
    document.exitFullscreen();
  }
});

// Test function to check if fullscreen API is available
function checkFullscreenSupport() {
  const elem = document.documentElement;
  if (elem.requestFullscreen || elem.webkitRequestFullscreen || elem.mozRequestFullScreen || elem.msRequestFullscreen) {
    console.log('Fullscreen API supported');
  } else {
    console.log('Fullscreen API not supported');
    alert('Your browser does not support fullscreen mode');
  }
}

// Alternative simple fullscreen function for testing
function simpleFullscreen() {
  console.log('Simple fullscreen test');
  try {
    if (document.documentElement.requestFullscreen) {
      document.documentElement.requestFullscreen();
      console.log('Standard fullscreen called');
    } else {
      console.log('Standard fullscreen not available');
    }
  } catch (error) {
    console.error('Fullscreen error:', error);
  }
}

// Check support when page loads
document.addEventListener('DOMContentLoaded', function() {
  checkFullscreenSupport();
  
  // Test button click handler
  const btn = document.querySelector('button[onclick="toggleF11Fullscreen()"]');
  if (btn) {
    console.log('Fullscreen button found');
    btn.addEventListener('click', function(e) {
      console.log('Button click event fired');
      e.preventDefault();
      simpleFullscreen();
    });
  } else {
    console.log('Fullscreen button NOT found');
  }
});
</script>

<!-- Tab Switching Script -->
<script>
document.addEventListener('DOMContentLoaded', function() {
  const tabs = document.querySelectorAll('[role="tab"]');
  const panels = document.querySelectorAll('[role="tabpanel"]');
  
  function activateTab(tab) {
    const targetPanel = tab.dataset.tab;
    
    // Update tabs
    tabs.forEach(t => {
      const isActive = t === tab;
      t.classList.toggle('tab-active', isActive);
      t.setAttribute('aria-selected', isActive ? 'true' : 'false');
      
      if (isActive) {
        t.classList.remove('text-slate-600', 'hover:text-slate-800', 'hover:bg-white/50');
        t.classList.add('bg-white', 'text-slate-800', 'shadow-sm', 'border', 'border-slate-200');
      } else {
        t.classList.remove('bg-white', 'text-slate-800', 'shadow-sm', 'border', 'border-slate-200');
        t.classList.add('text-slate-600', 'hover:text-slate-800', 'hover:bg-white/50');
      }
    });
    
    // Update panels
    panels.forEach(panel => {
      const isActive = panel.id === `panel-${targetPanel}`;
      panel.classList.toggle('hidden', !isActive);
    });
  }
  
  tabs.forEach(tab => {
    tab.addEventListener('click', () => activateTab(tab));
  });
});
</script>

<?php require __DIR__ . '/partials/footer.php'; ?>
