<?php
// app/Views/agent/dashboard.php
$title = $title ?? 'Agent Dashboard';
$metrics = $metrics ?? ['total_bookings'=>0,'revenue'=>0,'wallet_balance'=>0];
$notifications = $notifications ?? [];
$recent_bookings = $recent_bookings ?? [];
$active = 'dashboard';
require __DIR__ . '/partials/header.php';
?>

<!-- WORLD-CLASS ENTERPRISE HERO SECTION -->
<section class="relative overflow-hidden bg-gradient-to-br from-slate-50 via-white to-blue-50/30">
  <!-- Premium Background Elements -->
  <div class="absolute inset-0 bg-gradient-to-br from-brand-50/20 via-blue-50/10 to-indigo-50/20"></div>
  <div class="absolute inset-0 bg-[url('data:image/svg+xml,%3Csvg width="100" height="100" viewBox="0 0 100 100" xmlns="http://www.w3.org/2000/svg"%3E%3Cg fill="none" fill-rule="evenodd"%3E%3Cg fill="%23e0f2fe" fill-opacity="0.15"%3E%3Ccircle cx="50" cy="50" r="1.5"/%3E%3C/g%3E%3C/g%3E%3C/svg%3E')] opacity-60"></div>
  
  <!-- Trust Indicators Strip -->
  <div class="relative bg-gradient-to-r from-emerald-600 via-green-600 to-teal-600 text-white py-2">
    <div class="max-w-7xl mx-auto px-4 flex items-center justify-center space-x-8 text-sm">
      <div class="flex items-center space-x-2">
        <svg class="w-4 h-4 text-emerald-200" fill="currentColor" viewBox="0 0 24 24">
          <path d="M12 1L3 5v6c0 5.55 3.84 10.74 9 12 5.16-1.26 9-6.45 9-12V5l-9-4z"/>
        </svg>
        <span class="font-semibold">SSL Secured</span>
      </div>
      <div class="flex items-center space-x-2">
        <svg class="w-4 h-4 text-emerald-200" fill="currentColor" viewBox="0 0 24 24">
          <path d="M9 12l2 2 4-4m6 2a9 9 0 11-18 0 9 9 0 0118 0z"/>
        </svg>
        <span class="font-semibold">TAT Licensed</span>
      </div>
      <div class="flex items-center space-x-2">
        <div class="w-2 h-2 bg-emerald-300 rounded-full animate-pulse"></div>
        <span class="font-semibold">99.9% Uptime</span>
      </div>
    </div>
  </div>
  
  <div class="relative max-w-7xl mx-auto px-4 sm:px-6 lg:px-8 py-12 lg:py-20">
    <!-- Enterprise Header with Trust Signals -->
    <div class="text-center mb-12">
      <!-- Premium Status Badge -->
      <div class="inline-flex items-center gap-3 bg-white/95 backdrop-blur-xl rounded-2xl px-6 py-3 mb-6 shadow-xl border border-slate-200/50">
        <div class="flex items-center space-x-2">
          <div class="w-3 h-3 rounded-full bg-emerald-500 animate-pulse shadow-lg shadow-emerald-500/50"></div>
          <span class="text-sm font-bold text-slate-800">LIVE SYSTEM</span>
        </div>
        <div class="w-px h-4 bg-slate-300"></div>
        <div class="flex items-center space-x-2">
          <svg class="w-4 h-4 text-brand-600" fill="currentColor" viewBox="0 0 24 24">
            <path d="M12 2l3.09 6.26L22 9.27l-5 4.87 1.18 6.88L12 17.77l-6.18 3.25L7 14.14 2 9.27l6.91-1.01L12 2z"/>
          </svg>
          <span class="text-sm font-bold text-brand-700">PREMIUM PARTNER</span>
        </div>
        <div class="w-px h-4 bg-slate-300"></div>
        <span class="text-sm font-semibold text-slate-600">Real-time API</span>
      </div>
      
      <!-- World-Class Headlines -->
      <h1 class="text-4xl sm:text-5xl lg:text-6xl font-black mb-4">
        <span class="bg-gradient-to-r from-slate-900 via-slate-800 to-slate-700 bg-clip-text text-transparent">Thailand's</span>
        <br>
        <span class="bg-gradient-to-r from-brand-600 via-blue-600 to-indigo-600 bg-clip-text text-transparent">#1 B2B Platform</span>
      </h1>
      
      <h2 class="text-xl sm:text-2xl lg:text-3xl font-bold text-slate-700 mb-6 max-w-4xl mx-auto leading-tight">
        Compete with Booking.com, Agoda & MakeMyTrip
        <span class="block text-brand-600 mt-2">Premium Agent Portal</span>
      </h2>
      
      <p class="text-lg text-slate-600 max-w-3xl mx-auto mb-8 leading-relaxed">
        Enterprise-grade platform trusted by 10,000+ travel agents worldwide. Access premium inventory, 
        competitive rates, and instant confirmations for hotels, activities, transfers, and luxury yachts.
      </p>
      
      <!-- Trust Metrics -->
      <div class="flex flex-wrap justify-center items-center gap-8 mb-8">
        <div class="text-center">
          <div class="text-3xl font-black text-brand-600">10K+</div>
          <div class="text-sm font-semibold text-slate-600">Active Agents</div>
        </div>
        <div class="text-center">
          <div class="text-3xl font-black text-brand-600">50K+</div>
          <div class="text-sm font-semibold text-slate-600">Monthly Bookings</div>
        </div>
        <div class="text-center">
          <div class="text-3xl font-black text-brand-600">99.9%</div>
          <div class="text-sm font-semibold text-slate-600">Success Rate</div>
        </div>
        <div class="text-center">
          <div class="text-3xl font-black text-brand-600">24/7</div>
          <div class="text-sm font-semibold text-slate-600">Support</div>
        </div>
      </div>
      
      <!-- Premium CTA -->
      <div class="flex flex-col sm:flex-row items-center justify-center gap-4 mb-8">
        <button class="px-8 py-4 bg-gradient-to-r from-brand-600 to-blue-600 hover:from-brand-700 hover:to-blue-700 text-white font-bold rounded-2xl shadow-2xl hover:shadow-3xl transition-all duration-300 transform hover:scale-105 flex items-center space-x-2">
          <svg class="w-5 h-5" fill="currentColor" viewBox="0 0 24 24">
            <path d="M13 10V3L4 14h7v7l9-11h-7z"/>
          </svg>
          <span>Start Booking Now</span>
        </button>
        <button class="px-8 py-4 bg-white hover:bg-slate-50 text-slate-800 font-bold rounded-2xl shadow-xl hover:shadow-2xl transition-all duration-300 border-2 border-slate-200 hover:border-brand-300 flex items-center space-x-2">
          <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M15 10l4.553-2.276A1 1 0 0121 8.618v6.764a1 1 0 01-1.447.894L15 14M5 18h8a2 2 0 002-2V8a2 2 0 00-2-2H5a2 2 0 00-2 2v8a2 2 0 002 2z"/>
          </svg>
          <span>Watch Demo</span>
        </button>
      </div>
      
      <!-- Enterprise Badges -->
      <div class="flex flex-wrap justify-center items-center gap-6 opacity-70">
        <div class="flex items-center space-x-2 bg-white/80 px-4 py-2 rounded-xl shadow-sm">
          <svg class="w-5 h-5 text-green-600" fill="currentColor" viewBox="0 0 24 24">
            <path d="M12 1L3 5v6c0 5.55 3.84 10.74 9 12 5.16-1.26 9-6.45 9-12V5l-9-4z"/>
          </svg>
          <span class="text-sm font-semibold text-slate-700">ISO 27001</span>
        </div>
        <div class="flex items-center space-x-2 bg-white/80 px-4 py-2 rounded-xl shadow-sm">
          <svg class="w-5 h-5 text-blue-600" fill="currentColor" viewBox="0 0 24 24">
            <path d="M9 12l2 2 4-4m6 2a9 9 0 11-18 0 9 9 0 0118 0z"/>
          </svg>
          <span class="text-sm font-semibold text-slate-700">PCI DSS</span>
        </div>
        <div class="flex items-center space-x-2 bg-white/80 px-4 py-2 rounded-xl shadow-sm">
          <svg class="w-5 h-5 text-purple-600" fill="currentColor" viewBox="0 0 24 24">
            <path d="M12 2l3.09 6.26L22 9.27l-5 4.87 1.18 6.88L12 17.77l-6.18 3.25L7 14.14 2 9.27l6.91-1.01L12 2z"/>
          </svg>
          <span class="text-sm font-semibold text-slate-700">TAT Licensed</span>
        </div>
      </div>
    </div>

    <!-- WORLD-CLASS SEARCH INTERFACE -->
    <div class="mx-auto" style="animation-delay: 0.2s;">
      <div class="relative max-w-7xl mx-auto">
        <!-- Premium Search Card -->
        <div class="bg-white/95 backdrop-blur-xl rounded-3xl shadow-2xl border border-slate-200/50 overflow-hidden">
          <!-- Premium Header -->
          <div class="bg-gradient-to-r from-slate-50 via-white to-slate-50 border-b border-slate-200/60 px-8 py-6">
            <div class="flex items-center justify-between mb-4">
              <div>
                <h3 class="text-2xl font-bold text-slate-900">Search & Book Instantly</h3>
                <p class="text-slate-600">Access 50,000+ premium inventory with real-time availability</p>
              </div>
              <div class="flex items-center space-x-3">
                <div class="flex items-center space-x-2 bg-emerald-50 px-3 py-1.5 rounded-full">
                  <div class="w-2 h-2 bg-emerald-500 rounded-full animate-pulse"></div>
                  <span class="text-sm font-semibold text-emerald-700">Live Rates</span>
                </div>
                <div class="flex items-center space-x-2 bg-blue-50 px-3 py-1.5 rounded-full">
                  <svg class="w-3 h-3 text-blue-600" fill="currentColor" viewBox="0 0 24 24">
                    <path d="M13 10V3L4 14h7v7l9-11h-7z"/>
                  </svg>
                  <span class="text-sm font-semibold text-blue-700">Instant Confirm</span>
                </div>
              </div>
            </div>
            
            <!-- Premium Tab Navigation -->
            <nav class="flex space-x-2 bg-slate-100/80 rounded-2xl p-2" id="searchTabs" role="tablist">
              
              <button id="tab-hotels" role="tab" 
                class="tab-button flex items-center space-x-3 px-6 py-4 rounded-xl font-bold text-sm transition-all duration-300 bg-gradient-to-r from-purple-500 to-pink-500 text-white shadow-lg hover:shadow-xl transform hover:scale-105" 
                aria-selected="true" 
                aria-controls="panel-hotels" 
                tabindex="0" 
                data-tab="hotels">
                <div class="w-8 h-8 bg-white/20 rounded-lg flex items-center justify-center">
                  <svg class="w-4 h-4" fill="currentColor" viewBox="0 0 24 24">
                    <path d="M19 21V5a2 2 0 00-2-2H7a2 2 0 00-2 2v16m14 0h2m-2 0h-5m-9 0H3m2 0h5M9 7h1m-1 4h1m4-4h1m-1 4h1"/>
                  </svg>
                </div>
                <div class="text-left">
                  <div class="font-bold">Hotels & Resorts</div>
                  <div class="text-xs opacity-90">50,000+ properties</div>
                </div>
              </button>
              
              <button id="tab-activities" role="tab" 
                class="tab-button flex items-center space-x-3 px-6 py-4 rounded-xl font-semibold text-sm transition-all duration-300 text-slate-600 hover:text-slate-800 hover:bg-white/80 hover:shadow-lg" 
                aria-selected="false" 
                aria-controls="panel-activities" 
                tabindex="-1" 
                data-tab="activities">
                <div class="w-8 h-8 bg-emerald-100 rounded-lg flex items-center justify-center">
                  <svg class="w-4 h-4 text-emerald-600" fill="currentColor" viewBox="0 0 24 24">
                    <path d="M13 10V3L4 14h7v7l9-11h-7z"/>
                  </svg>
                </div>
                <div class="text-left">
                  <div class="font-semibold">Activities & Tours</div>
                  <div class="text-xs text-slate-500">15,000+ experiences</div>
                </div>
              </button>
              
              <button id="tab-transfers" role="tab" 
                class="tab-button flex items-center space-x-3 px-6 py-4 rounded-xl font-semibold text-sm transition-all duration-300 text-slate-600 hover:text-slate-800 hover:bg-white/80 hover:shadow-lg" 
                aria-selected="false" 
                aria-controls="panel-transfers" 
                tabindex="-1" 
                data-tab="transfers">
                <div class="w-8 h-8 bg-blue-100 rounded-lg flex items-center justify-center">
                  <svg class="w-4 h-4 text-blue-600" fill="currentColor" viewBox="0 0 24 24">
                    <path d="M8 7h12m0 0l-4-4m4 4l-4 4m0 6H4m0 0l4 4m-4-4l4-4"/>
                  </svg>
                </div>
                <div class="text-left">
                  <div class="font-semibold">Premium Transfers</div>
                  <div class="text-xs text-slate-500">Professional drivers</div>
                </div>
              </button>
              
              <button id="tab-yachts" role="tab" 
                class="tab-button flex items-center space-x-3 px-6 py-4 rounded-xl font-semibold text-sm transition-all duration-300 text-slate-600 hover:text-slate-800 hover:bg-white/80 hover:shadow-lg" 
                aria-selected="false" 
                aria-controls="panel-yachts" 
                tabindex="-1" 
                data-tab="yachts">
                <div class="w-8 h-8 bg-cyan-100 rounded-lg flex items-center justify-center">
                  <svg class="w-4 h-4 text-cyan-600" fill="currentColor" viewBox="0 0 24 24">
                    <path d="M3 18s2 3 9 3 9-3 9-3l-3-6h-6l-3 6Zm9-15l5 9h-5V3Z"/>
                  </svg>
                </div>
                <div class="text-left">
                  <div class="font-semibold">Luxury Yachts</div>
                  <div class="text-xs text-slate-500">Exclusive charters</div>
                </div>
              </button>
            </nav>
          </div>
          
          <!-- Premium Search Content -->
          <div class="p-8">
            <!-- Premium Hotel Search Panel -->
            <div id="panel-hotels" role="tabpanel" aria-labelledby="tab-hotels" data-panel="hotels" class="bg-gradient-to-br from-purple-50 via-pink-50 to-purple-50 rounded-2xl p-8 border border-purple-200/50">
              <div class="grid grid-cols-1 lg:grid-cols-3 gap-8">
                <!-- Search Form -->
                <div class="lg:col-span-2">
                  <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-6">
                    <!-- Destination -->
                    <div class="md:col-span-2 lg:col-span-1">
                      <label class="block text-sm font-bold text-slate-800 mb-3">Destination</label>
                      <div class="relative">
                        <input type="text" placeholder="Bangkok, Phuket, Pattaya..." 
                               class="w-full px-4 py-4 bg-white border-2 border-slate-200 rounded-xl focus:border-purple-500 focus:ring-4 focus:ring-purple-100 transition-all duration-200 text-slate-800 font-semibold placeholder-slate-400">
                        <svg class="absolute right-4 top-4 w-5 h-5 text-slate-400" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                          <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M17.657 16.657L13.414 20.9a1.998 1.998 0 01-2.827 0l-4.244-4.243a8 8 0 1111.314 0z"/>
                          <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M15 11a3 3 0 11-6 0 3 3 0 016 0z"/>
                        </svg>
                      </div>
                    </div>
                    
                    <!-- Check-in -->
                    <div>
                      <label class="block text-sm font-bold text-slate-800 mb-3">Check-in</label>
                      <input type="date" 
                             class="w-full px-4 py-4 bg-white border-2 border-slate-200 rounded-xl focus:border-purple-500 focus:ring-4 focus:ring-purple-100 transition-all duration-200 text-slate-800 font-semibold">
                    </div>
                    
                    <!-- Check-out -->
                    <div>
                      <label class="block text-sm font-bold text-slate-800 mb-3">Check-out</label>
                      <input type="date" 
                             class="w-full px-4 py-4 bg-white border-2 border-slate-200 rounded-xl focus:border-purple-500 focus:ring-4 focus:ring-purple-100 transition-all duration-200 text-slate-800 font-semibold">
                    </div>
                    
                    <!-- Guests -->
                    <div>
                      <label class="block text-sm font-bold text-slate-800 mb-3">Guests</label>
                      <select class="w-full px-4 py-4 bg-white border-2 border-slate-200 rounded-xl focus:border-purple-500 focus:ring-4 focus:ring-purple-100 transition-all duration-200 text-slate-800 font-semibold">
                        <option>1 Guest</option>
                        <option>2 Guests</option>
                        <option>3 Guests</option>
                        <option>4+ Guests</option>
                      </select>
                    </div>
                    
                    <!-- Rooms -->
                    <div>
                      <label class="block text-sm font-bold text-slate-800 mb-3">Rooms</label>
                      <select class="w-full px-4 py-4 bg-white border-2 border-slate-200 rounded-xl focus:border-purple-500 focus:ring-4 focus:ring-purple-100 transition-all duration-200 text-slate-800 font-semibold">
                        <option>1 Room</option>
                        <option>2 Rooms</option>
                        <option>3 Rooms</option>
                        <option>4+ Rooms</option>
                      </select>
                    </div>
                    
                    <!-- Search Button -->
                    <div class="flex items-end">
                      <button class="w-full px-6 py-4 bg-gradient-to-r from-purple-600 to-pink-600 hover:from-purple-700 hover:to-pink-700 text-white font-bold rounded-xl shadow-xl hover:shadow-2xl transition-all duration-300 transform hover:scale-105 flex items-center justify-center space-x-2">
                        <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                          <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M21 21l-6-6m2-5a7 7 0 11-14 0 7 7 0 0114 0z"/>
                        </svg>
                        <span>Search Hotels</span>
                      </button>
                    </div>
                  </div>
                </div>
                
                <!-- Premium Features -->
                <div class="bg-white/80 backdrop-blur-sm rounded-2xl p-6 border border-white/50">
                  <h4 class="text-lg font-bold text-slate-800 mb-4 flex items-center">
                    <svg class="w-5 h-5 text-purple-600 mr-2" fill="currentColor" viewBox="0 0 24 24">
                      <path d="M12 2l3.09 6.26L22 9.27l-5 4.87 1.18 6.88L12 17.77l-6.18 3.25L7 14.14 2 9.27l6.91-1.01L12 2z"/>
                    </svg>
                    Premium Benefits
                  </h4>
                  <div class="space-y-4">
                    <div class="flex items-center space-x-3">
                      <div class="w-8 h-8 bg-emerald-100 rounded-lg flex items-center justify-center">
                        <svg class="w-4 h-4 text-emerald-600" fill="currentColor" viewBox="0 0 24 24">
                          <path d="M9 12l2 2 4-4m6 2a9 9 0 11-18 0 9 9 0 0118 0z"/>
                        </svg>
                      </div>
                      <div>
                        <div class="font-semibold text-slate-800">Best Rate Guarantee</div>
                        <div class="text-xs text-slate-600">Lowest prices guaranteed</div>
                      </div>
                    </div>
                    <div class="flex items-center space-x-3">
                      <div class="w-8 h-8 bg-blue-100 rounded-lg flex items-center justify-center">
                        <svg class="w-4 h-4 text-blue-600" fill="currentColor" viewBox="0 0 24 24">
                          <path d="M13 10V3L4 14h7v7l9-11h-7z"/>
                        </svg>
                      </div>
                      <div>
                        <div class="font-semibold text-slate-800">Instant Confirmation</div>
                        <div class="text-xs text-slate-600">Real-time booking</div>
                      </div>
                    </div>
                    <div class="flex items-center space-x-3">
                      <div class="w-8 h-8 bg-purple-100 rounded-lg flex items-center justify-center">
                        <svg class="w-4 h-4 text-purple-600" fill="currentColor" viewBox="0 0 24 24">
                          <path d="M18.364 5.636l-3.536 3.536m0 5.656l3.536 3.536M9.172 9.172L5.636 5.636m3.536 9.192l-3.536 3.536M21 12a9 9 0 11-18 0 9 9 0 0118 0z"/>
                        </svg>
                      </div>
                      <div>
                        <div class="font-semibold text-slate-800">24/7 Support</div>
                        <div class="text-xs text-slate-600">Always available</div>
                      </div>
                    </div>
                  </div>
                </div>
              </div>
            </div>
            
            <!-- Hidden panels for other tabs -->
            <div id="panel-activities" role="tabpanel" aria-labelledby="tab-activities" data-panel="activities" class="hidden">
              <div class="text-center py-12">
                <div class="text-emerald-600 mb-4">
                  <svg class="w-16 h-16 mx-auto" fill="currentColor" viewBox="0 0 24 24">
                    <path d="M13 10V3L4 14h7v7l9-11h-7z"/>
                  </svg>
                </div>
                <h3 class="text-2xl font-bold text-slate-800 mb-2">Activities & Tours</h3>
                <p class="text-slate-600 mb-6">15,000+ curated experiences across Thailand</p>
                <button class="px-8 py-3 bg-emerald-600 text-white font-bold rounded-xl hover:bg-emerald-700 transition-colors">
                  Coming Soon
                </button>
              </div>
            </div>
            
            <div id="panel-transfers" role="tabpanel" aria-labelledby="tab-transfers" data-panel="transfers" class="hidden">
              <div class="text-center py-12">
                <div class="text-blue-600 mb-4">
                  <svg class="w-16 h-16 mx-auto" fill="currentColor" viewBox="0 0 24 24">
                    <path d="M8 7h12m0 0l-4-4m4 4l-4 4m0 6H4m0 0l4 4m-4-4l4-4"/>
                  </svg>
                </div>
                <h3 class="text-2xl font-bold text-slate-800 mb-2">Premium Transfers</h3>
                <p class="text-slate-600 mb-6">Professional drivers and luxury vehicles</p>
                <button class="px-8 py-3 bg-blue-600 text-white font-bold rounded-xl hover:bg-blue-700 transition-colors">
                  Coming Soon
                </button>
              </div>
            </div>
            
            <div id="panel-yachts" role="tabpanel" aria-labelledby="tab-yachts" data-panel="yachts" class="hidden">
              <div class="text-center py-12">
                <div class="text-cyan-600 mb-4">
                  <svg class="w-16 h-16 mx-auto" fill="currentColor" viewBox="0 0 24 24">
                    <path d="M3 18s2 3 9 3 9-3 9-3l-3-6h-6l-3 6Zm9-15l5 9h-5V3Z"/>
                  </svg>
                </div>
                <h3 class="text-2xl font-bold text-slate-800 mb-2">Luxury Yachts</h3>
                <p class="text-slate-600 mb-6">Exclusive yacht charters and marine experiences</p>
                <button class="px-8 py-3 bg-cyan-600 text-white font-bold rounded-xl hover:bg-cyan-700 transition-colors">
                  Coming Soon
                </button>
              </div>
            </div>
              <div id="panel-hotel" role="tabpanel" aria-labelledby="tab-hotel" data-panel="hotel" class="hidden bg-gradient-to-r from-purple-50 to-pink-50 rounded-xl p-4 border border-purple-200">
                <div class="flex items-center gap-3">
                  <div class="w-8 h-8 rounded-lg bg-purple-500 flex items-center justify-center text-white">
                    <svg class="w-4 h-4" fill="currentColor" viewBox="0 0 24 24"><path d="M4 3h10a2 2 0 012 2v14h3v2H3v-2h1V5a2 2 0 012-2Z"/></svg>
                  </div>
                  <div>
                    <h4 class="font-semibold text-slate-900">Hotels & Accommodations</h4>
                    <p class="text-sm text-slate-600">Search live hotel rates and availability with best price guarantee.</p>
                  </div>
                </div>
              </div>
              <div id="panel-yachts" role="tabpanel" aria-labelledby="tab-yachts" data-panel="yachts" class="hidden bg-gradient-to-r from-cyan-50 to-blue-50 rounded-xl p-4 border border-cyan-200">
                <div class="flex items-center gap-3">
                  <div class="w-8 h-8 rounded-lg bg-cyan-500 flex items-center justify-center text-white">
                    <svg class="w-4 h-4" fill="currentColor" viewBox="0 0 24 24"><path d="M12 6V4m0 2a2 2 0 100 4m0-4a2 2 0 110 4m-6 8a2 2 0 100-4m0 4a2 2 0 100 4m0-4v2m0-6V4m6 6v10m6-2a2 2 0 100-4m0 4a2 2 0 100 4m0-4v2m0-6V4"/></svg>
                  </div>
                  <div>
                    <h4 class="font-semibold text-slate-900">Yachts & Private Charters</h4>
                    <p class="text-sm text-slate-600">Charter luxury yachts and private cruises for exclusive experiences.</p>
                  </div>
                </div>
              </div>
              <div id="panel-packages" role="tabpanel" aria-labelledby="tab-packages" data-panel="packages" class="hidden bg-gradient-to-r from-orange-50 to-red-50 rounded-xl p-4 border border-orange-200">
                <div class="flex items-center gap-3">
                  <div class="w-8 h-8 rounded-lg bg-orange-500 flex items-center justify-center text-white">
                    <svg class="w-4 h-4" fill="currentColor" viewBox="0 0 24 24"><path d="M3 7l9-4 9 4-9 4L3 7Zm0 3l9 4 9-4v7l-9 4-9-4v-7Z"/></svg>
                  </div>
                  <div>
                    <h4 class="font-semibold text-slate-900">Travel Packages</h4>
                    <p class="text-sm text-slate-600">Build and quote comprehensive multi-day travel packages with ease.</p>
                  </div>
                </div>
              </div>
            </div>

            <!-- Mobile-Optimized Search Forms -->
            <div id="tabForms" class="space-y-4 md:space-y-6">
              <!-- Activities form -->
              <div data-form="activities" class="grid grid-cols-1 sm:grid-cols-2 md:grid-cols-5 gap-3 md:gap-4">
                <div class="sm:col-span-2 md:col-span-2 space-y-2">
                  <label class="text-sm font-semibold text-slate-700">Activity / City</label>
                  <div class="relative">
                  </div>
                  <div>
                    <label class="text-sm font-semibold text-slate-700 mb-2 block">From Date</label>
                    <input data-field="from" type="date" class="w-full px-4 py-3.5 rounded-xl border-2 border-slate-200 focus:border-brand-400 focus:ring-2 focus:ring-brand-100 transition-all duration-200 text-base bg-white" />
                  </div>
                  <div>
                    <label class="text-sm font-semibold text-slate-700 mb-2 block">To Date</label>
                    <input data-field="to" type="date" class="w-full px-4 py-3.5 rounded-xl border-2 border-slate-200 focus:border-brand-400 focus:ring-2 focus:ring-brand-100 transition-all duration-200 text-base bg-white" />
                  </div>
                </div>
                <div class="grid grid-cols-2 gap-3">
                  <div>
                    <label class="text-sm font-semibold text-slate-700 mb-2 block">Guests</label>
                    <input data-field="pax" type="number" placeholder="2" min="1" class="w-full px-4 py-3.5 rounded-xl border-2 border-slate-200 focus:border-brand-400 focus:ring-2 focus:ring-brand-100 transition-all duration-200 text-base bg-white" />
                  </div>
                  <div class="flex items-end">
                    <div class="w-full bg-slate-50 rounded-xl px-4 py-3.5 flex items-center justify-center">
                      <span class="text-xs text-slate-500 font-medium flex items-center gap-1">
                        <div class="w-2 h-2 bg-green-500 rounded-full animate-pulse"></div>
                        Instant confirmation
                      </span>
                    </div>
                  </div>
                </div>
              </div>

              <!-- Mobile-Optimized Taxi Form -->
              <div data-form="taxi" class="space-y-4 hidden">
                <div class="space-y-3">
                  <div>
                    <label class="text-sm font-semibold text-slate-700 mb-2 block">Pickup Location</label>
                    <input data-field="pickup" required type="text" placeholder="Airport / Hotel" class="w-full px-4 py-3.5 rounded-xl border-2 border-slate-200 focus:border-brand-400 focus:ring-2 focus:ring-brand-100 transition-all duration-200 text-base bg-white" aria-label="Pickup" />
                  </div>
                  <div>
                    <label class="text-sm font-semibold text-slate-700 mb-2 block">Dropoff Location</label>
                    <input data-field="dropoff" required type="text" placeholder="Destination" class="w-full px-4 py-3.5 rounded-xl border-2 border-slate-200 focus:border-brand-400 focus:ring-2 focus:ring-brand-100 transition-all duration-200 text-base bg-white" aria-label="Dropoff" />
                  </div>
                </div>
                <div class="grid grid-cols-2 gap-3">
                  <div>
                    <label class="text-sm font-semibold text-slate-700 mb-2 block">Date</label>
                    <input data-field="date" required type="date" class="w-full px-4 py-3.5 rounded-xl border-2 border-slate-200 focus:border-brand-400 focus:ring-2 focus:ring-brand-100 transition-all duration-200 text-base bg-white" aria-label="Date" />
                  </div>
                  <div class="flex items-end">
                    <div class="w-full bg-slate-50 rounded-xl px-4 py-3.5 flex items-center justify-center">
                      <span class="text-xs text-slate-500 font-medium flex items-center gap-1">
                        <svg class="w-3 h-3" fill="currentColor" viewBox="0 0 24 24"><path d="M12 2l3.09 6.26L22 9.27l-5 4.87 1.18 6.88L12 17.77l-6.18 3.25L7 14.14 2 9.27l6.91-1.01L12 2z"/></svg>
                        Professional drivers
                      </span>
                    </div>
                  </div>
                </div>
              </div>

              <!-- Mobile-Optimized Hotel Form -->
              <div data-form="hotel" class="space-y-4 hidden">
                <div>
                  <label class="text-sm font-semibold text-slate-700 mb-2 block">Destination / Hotel</label>
                  <input data-field="destination" required type="text" placeholder="e.g., Bangkok" class="w-full px-4 py-3.5 rounded-xl border-2 border-slate-200 focus:border-brand-400 focus:ring-2 focus:ring-brand-100 transition-all duration-200 text-base bg-white" aria-label="Destination" />
                </div>
                <div class="grid grid-cols-2 gap-3">
                  <div>
                    <label class="text-sm font-semibold text-slate-700 mb-2 block">Check-in</label>
                    <input data-field="checkin" required type="date" class="w-full px-4 py-3.5 rounded-xl border-2 border-slate-200 focus:border-brand-400 focus:ring-2 focus:ring-brand-100 transition-all duration-200 text-base bg-white" aria-label="Check-in" />
                  </div>
                  <div>
                    <label class="text-sm font-semibold text-slate-700 mb-2 block">Check-out</label>
                    <input data-field="checkout" required type="date" class="w-full px-4 py-3.5 rounded-xl border-2 border-slate-200 focus:border-brand-400 focus:ring-2 focus:ring-brand-100 transition-all duration-200 text-base bg-white" aria-label="Check-out" />
                  </div>
                </div>
                <div class="grid grid-cols-3 gap-3">
                  <div>
                    <label class="text-sm font-semibold text-slate-700 mb-2 block">Rooms</label>
                    <input data-field="rooms" required type="number" inputmode="numeric" pattern="[0-9]*" class="w-full px-4 py-3.5 rounded-xl border-2 border-slate-200 focus:border-brand-400 focus:ring-2 focus:ring-brand-100 transition-all duration-200 text-base bg-white" placeholder="1" min="1" aria-label="Rooms" />
                  </div>
                  <div class="col-span-2 flex items-end">
                    <div class="w-full bg-slate-50 rounded-xl px-4 py-3.5 flex items-center justify-center">
                      <span class="text-xs text-slate-500 font-medium flex items-center gap-1">
                        <svg class="w-3 h-3" fill="currentColor" viewBox="0 0 24 24"><path d="M9 12l2 2 4-4m6 2a9 9 0 11-18 0 9 9 0 0118 0z"/></svg>
                        Best price guarantee
                      </span>
                    </div>
                  </div>
                </div>
              </div>

              <!-- Yachts form -->
              <div data-form="yachts" class="grid md:grid-cols-5 gap-3 hidden">
                <label class="form-control md:col-span-2">
                  <div class="label"><span class="label-text">Port / Area</span></div>
                  <input data-field="area" required type="text" placeholder="e.g., Phuket" class="input input-bordered focus:outline-none focus:ring-2 focus:ring-brand-300" aria-label="Port or area" />
                </label>
                <label class="form-control">
                  <div class="label"><span class="label-text">Date</span></div>
                  <input data-field="date" required type="date" class="input input-bordered focus:outline-none focus:ring-2 focus:ring-brand-300" aria-label="Date" />
                </label>
                <label class="form-control">
                  <div class="label"><span class="label-text">Guests</span></div>
                  <input data-field="guests" required type="number" inputmode="numeric" pattern="[0-9]*" class="input input-bordered focus:outline-none focus:ring-2 focus:ring-brand-300" placeholder="4" min="1" aria-label="Guests" />
                </label>
              </div>

              <!-- Packages form -->
              <div data-form="packages" class="grid md:grid-cols-5 gap-3 hidden">
                <label class="form-control md:col-span-2">
                  <div class="label"><span class="label-text">Destination</span></div>
                  <input data-field="destination" required type="text" placeholder="e.g., Bangkok, Krabi" class="input input-bordered focus:outline-none focus:ring-2 focus:ring-brand-300" aria-label="Destination" />
                </label>
                <label class="form-control">
                  <div class="label"><span class="label-text">Start</span></div>
                  <input data-field="start" required type="date" class="input input-bordered focus:outline-none focus:ring-2 focus:ring-brand-300" aria-label="Start date" />
                </label>
                <label class="form-control">
                  <div class="label"><span class="label-text">Nights</span></div>
                  <input data-field="nights" required type="number" inputmode="numeric" pattern="[0-9]*" class="input input-bordered focus:outline-none focus:ring-2 focus:ring-brand-300" placeholder="3" min="1" aria-label="Nights" />
                </label>
                <label class="form-control">
                  <div class="label"><span class="label-text">Pax</span></div>
                  <input data-field="pax" required type="number" inputmode="numeric" pattern="[0-9]*" class="input input-bordered focus:outline-none focus:ring-2 focus:ring-brand-300" placeholder="2" min="1" aria-label="Passengers" />
                </label>
              </div>
            </div>

            <p id="liveRegion" class="sr-only" aria-live="polite"></p>
            <!-- Mobile-First Search Button -->
            <div class="mt-6 flex justify-center">
              <button id="searchBtn" class="w-full sm:w-auto px-6 py-3.5 bg-gradient-to-r from-brand-600 via-blue-600 to-indigo-600 hover:from-brand-700 hover:via-blue-700 hover:to-indigo-700 text-white font-semibold rounded-xl sm:rounded-lg focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-brand-500 focus:ring-offset-white transition-all duration-200 transform hover:scale-105 active:scale-95 flex items-center justify-center space-x-2">
                <svg class="w-5 h-5 text-white" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                  <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M21 21l-6-6m2-5a7 7 0 11-14 0 7 7 0 0114 0z"/>
                </svg>
                <span>Search</span>
              </button>
            </div>
            
          </div>
        </div>
      </div>
    </div>
  </div>
</section>

<!-- Mobile App-Style Bottom Navigation -->
<nav class="mobile-tabbar md:hidden fixed bottom-0 left-0 right-0 z-50 bg-white/95 backdrop-blur-lg border-t border-slate-200 shadow-2xl">
  <div class="max-w-7xl mx-auto px-2">
    <ul class="grid grid-cols-5 h-16">
      <li>
        <button class="group w-full h-full flex flex-col items-center justify-center gap-1 text-xs transition-all duration-300 hover:bg-brand-50 active:scale-95" data-mobile-tab="activities" aria-label="Activities">
          <div class="w-8 h-8 rounded-lg bg-slate-100 group-hover:bg-brand-100 group-active:bg-brand-200 flex items-center justify-center transition-all duration-300">
            <svg class="w-4 h-4 text-slate-600 group-hover:text-brand-600 transition-colors" viewBox="0 0 24 24" fill="currentColor"><path d="M12 3a9 9 0 100 18 9 9 0 000-18Zm0 4.5a1.5 1.5 0 110 3 1.5 1.5 0 010-3Zm-3.75 9.75a4.5 4.5 0 017.5 0H8.25Z"/></svg>
          </div>
          <span class="text-slate-600 group-hover:text-brand-600 font-medium transition-colors">Activities</span>
        </button>
      </li>
      <li>
        <button class="group w-full h-full flex flex-col items-center justify-center gap-1 text-xs transition-all duration-300 hover:bg-blue-50 active:scale-95" data-mobile-tab="taxi" aria-label="Taxi">
          <div class="w-8 h-8 rounded-lg bg-slate-100 group-hover:bg-blue-100 group-active:bg-blue-200 flex items-center justify-center transition-all duration-300">
            <svg class="w-4 h-4 text-slate-600 group-hover:text-blue-600 transition-colors" viewBox="0 0 24 24" fill="currentColor"><path d="M5 11l1.5-4.5A2 2 0 018.4 5h7.2a2 2 0 011.9 1.5L19 11v6a1 1 0 01-1 1h-1a1 1 0 01-1-1v-1H8v1a1 1 0 01-1 1H6a1 1 0 01-1-1v-6h0Zm3-2h8l-.7-2.1a1 1 0 00-.95-.7H9.65a1 1 0 00-.95.7L8 9Zm-.5 4a1.5 1.5 0 110-3 1.5 1.5 0 010 3Zm9 0a1.5 1.5 0 110-3 1.5 1.5 0 010 3Z"/></svg>
          </div>
          <span class="text-slate-600 group-hover:text-blue-600 font-medium transition-colors">Transfers</span>
        </button>
      </li>
      <li>
        <button class="group w-full h-full flex flex-col items-center justify-center gap-1 text-xs transition-all duration-300 hover:bg-emerald-50 active:scale-95" data-mobile-tab="hotel" aria-label="Hotel">
          <div class="w-8 h-8 rounded-lg bg-slate-100 group-hover:bg-emerald-100 group-active:bg-emerald-200 flex items-center justify-center transition-all duration-300">
            <svg class="w-4 h-4 text-slate-600 group-hover:text-emerald-600 transition-colors" viewBox="0 0 24 24" fill="currentColor"><path d="M4 3h10a2 2 0 012 2v14h3v2H3v-2h1V5a2 2 0 012-2Zm1 2v14h9V5H5Zm2 2h2v2H7V7Zm4 0h2v2h-2V7Z"/></svg>
          </div>
          <span class="text-slate-600 group-hover:text-emerald-600 font-medium transition-colors">Hotels</span>
        </button>
      </li>
      <li>
        <button class="group w-full h-full flex flex-col items-center justify-center gap-1 text-xs transition-all duration-300 hover:bg-teal-50 active:scale-95" data-mobile-tab="yachts" aria-label="Yachts">
          <div class="w-8 h-8 rounded-lg bg-slate-100 group-hover:bg-teal-100 group-active:bg-teal-200 flex items-center justify-center transition-all duration-300">
            <svg class="w-4 h-4 text-slate-600 group-hover:text-teal-600 transition-colors" viewBox="0 0 24 24" fill="currentColor"><path d="M3 18s2 3 9 3 9-3 9-3l-3-6h-6l-3 6Zm9-15l5 9h-5V3Z"/></svg>
          </div>
          <span class="text-slate-600 group-hover:text-teal-600 font-medium transition-colors">Yachts</span>
        </button>
      </li>
      <li>
        <button class="group w-full h-full flex flex-col items-center justify-center gap-1 text-xs transition-all duration-300 hover:bg-purple-50 active:scale-95" data-mobile-tab="packages" aria-label="Packages">
          <div class="w-8 h-8 rounded-lg bg-slate-100 group-hover:bg-purple-100 group-active:bg-purple-200 flex items-center justify-center transition-all duration-300">
            <svg class="w-4 h-4 text-slate-600 group-hover:text-purple-600 transition-colors" viewBox="0 0 24 24" fill="currentColor"><path d="M3 7l9-4 9 4-9 4L3 7Zm0 3l9 4 9-4v7l-9 4-9-4v-7Z"/></svg>
          </div>
          <span class="text-slate-600 group-hover:text-purple-600 font-medium transition-colors">Packages</span>
        </button>
      </li>
    </ul>
  </div>
</nav>

<!-- Mobile App-Style Floating Action Button -->
<div class="mobile-fab md:hidden fixed bottom-20 right-4 z-40">
  <button id="mobileSearchBtn" class="group relative w-14 h-14 bg-gradient-to-r from-brand-600 via-blue-600 to-indigo-600 text-white rounded-full shadow-2xl hover:shadow-3xl transition-all duration-300 hover-lift active:scale-95 overflow-hidden">
    <div class="absolute inset-0 bg-gradient-to-r from-brand-700 via-blue-700 to-indigo-700 opacity-0 group-hover:opacity-100 transition-opacity duration-300"></div>
    <span class="relative inline-flex items-center justify-center">
      <svg class="w-6 h-6 group-hover:scale-110 transition-transform" fill="currentColor" viewBox="0 0 24 24">
        <path d="M10 4a6 6 0 104.47 10.03l3.25 3.25 1.41-1.41-3.25-3.25A6 6 0 0010 4z"/>
      </svg>
    </span>
  </button>
</div>

<!-- Interaction script (ported from design) -->
<script>
  (function () {
    const html = document.documentElement;
    html.setAttribute('data-theme', 'light');

    const ua = navigator.userAgent || navigator.vendor || '';
    if (/iPhone|iPad|iPod/i.test(ua)) {
      html.classList.add('platform-ios');
    } else if (/Android/i.test(ua)) {
      html.classList.add('platform-android');
    }

    const tabs = document.querySelectorAll('[role="tab"]');
    const panels = document.querySelectorAll('[role="tabpanel"]');
    const forms = document.querySelectorAll('#tabForms [data-form]');
    const liveRegion = document.getElementById('liveRegion');

    const today = new Date();
    today.setHours(0,0,0,0);
    const pad = (n) => String(n).padStart(2, '0');
    const todayStr = `${today.getFullYear()}-${pad(today.getMonth()+1)}-${pad(today.getDate())}`;
    const dateInputs = document.querySelectorAll('#tabForms input[type="date"]');
    dateInputs.forEach(el => { el.min = todayStr; });
    const actFrom = document.querySelector('[data-form="activities"] input[data-field="from"]');
    const actTo = document.querySelector('[data-form="activities"] input[data-field="to"]');
    if (actFrom && actTo) { actFrom.addEventListener('change', () => { if (actFrom.value) actTo.min = actFrom.value; }); }
    const ci = document.querySelector('[data-form="hotel"] input[data-field="checkin"]');
    const co = document.querySelector('[data-form="hotel"] input[data-field="checkout"]');
    if (ci && co) { ci.addEventListener('change', () => { if (ci.value) co.min = ci.value; }); }

    function activateTab(tab) {
      const name = tab.dataset.tab;
      tabs.forEach(t => {
        const isActive = t === tab;
        t.classList.toggle('tab-active', isActive);
        t.setAttribute('aria-selected', isActive ? 'true' : 'false');
        t.setAttribute('tabindex', isActive ? '0' : '-1');
        
        // Update corporate tab styling
        if (isActive) {
          t.classList.remove('text-slate-600', 'hover:text-slate-800', 'hover:bg-white/50');
          t.classList.add('bg-white', 'text-slate-800', 'shadow-sm', 'border', 'border-slate-200');
        } else {
          t.classList.remove('bg-white', 'text-slate-800', 'shadow-sm', 'border', 'border-slate-200');
          t.classList.add('text-slate-600', 'hover:text-slate-800', 'hover:bg-white/50');
        }
      });
      panels.forEach(p => { p.classList.toggle('hidden', p.dataset.panel !== name); });
      forms.forEach(f => { f.classList.toggle('hidden', f.dataset.form !== name); });
      const mobileTabBtns = document.querySelectorAll('.mobile-tabbar [data-mobile-tab]');
      mobileTabBtns.forEach(btn => {
        const isActive = btn.getAttribute('data-mobile-tab') === name;
        btn.classList.toggle('active', isActive);
        btn.setAttribute('aria-current', isActive ? 'page' : 'false');
      });
      if (liveRegion) liveRegion.textContent = `${tab.textContent?.trim() || name} tab selected`;
      const firstInput = document.querySelector(`#tabForms [data-form="${name}"] input`);
      if (firstInput) firstInput.focus({ preventScroll: true });
    }

    tabs.forEach(t => t.addEventListener('click', (e) => { 
      e.preventDefault(); 
      e.stopPropagation();
      activateTab(t); 
    }));

    const mobileTabs = document.querySelectorAll('[data-mobile-tab]');
    mobileTabs.forEach(btn => btn.addEventListener('click', () => {
      const name = btn.getAttribute('data-mobile-tab');
      const target = document.querySelector(`[role="tab"][data-tab="${name}"]`);
      if (target) activateTab(target);
    }));

    const active = document.querySelector('[role="tab"].tab-active') || tabs[0];
    if (active) activateTab(active);

    function handleSearchClick() {
      const activeTab = document.querySelector('[role="tab"].tab-active');
      const name = activeTab ? activeTab.dataset.tab : 'activities';
      const form = document.querySelector(`#tabForms [data-form="${name}"]`);
      let valid = true;
      const get = (sel) => form ? form.querySelector(sel) : null;
      const setInvalid = (el, msg) => { if (el && el.setCustomValidity) { el.setCustomValidity(msg || ''); el.reportValidity(); valid = false; } };
      const clearInvalid = (el) => { if (el && el.setCustomValidity) el.setCustomValidity(''); };
      let target = '/b2b/agent/search/activities';
      const params = new URLSearchParams();
      if (name === 'activities') {
        const q = get('input[data-field="q"]');
        const from = get('input[data-field="from"]');
        const to = get('input[data-field="to"]');
        [q, from, to].forEach(clearInvalid);
        if (q && !q.value.trim()) setInvalid(q, 'Please enter an activity or city');
        if (from && to && from.value && to.value && new Date(from.value) > new Date(to.value)) setInvalid(to, 'End date should be after start date');
        target = '/b2b/agent/search/activities';
        if (q?.value) params.set('q', q.value.trim());
        if (from?.value) params.set('from', from.value);
        if (to?.value) params.set('to', to.value);
        const pax = get('input[data-field="pax"]'); if (pax?.value) params.set('pax', pax.value);
      } else if (name === 'taxi') {
        const pickup = get('input[data-field="pickup"]');
        const dropoff = get('input[data-field="dropoff"]');
        const date = get('input[data-field="date"]');
        [pickup, dropoff, date].forEach(clearInvalid);
        if (pickup && !pickup.value.trim()) setInvalid(pickup, 'Pickup is required');
        if (dropoff && !dropoff.value.trim()) setInvalid(dropoff, 'Dropoff is required');
        if (date && !date.value) setInvalid(date, 'Date is required');
        target = '/b2b/agent/search/taxi';
        if (pickup?.value) params.set('pickup', pickup.value.trim());
        if (dropoff?.value) params.set('dropoff', dropoff.value.trim());
        if (date?.value) params.set('date', date.value);
      } else if (name === 'hotel') {
        const dest = get('input[data-field="destination"]');
        const ci = get('input[data-field="checkin"]');
        const co = get('input[data-field="checkout"]');
        const rooms = get('input[data-field="rooms"]');
        [dest, ci, co, rooms].forEach(clearInvalid);
        if (dest && !dest.value.trim()) setInvalid(dest, 'Destination is required');
        if (ci && !ci.value) setInvalid(ci, 'Check-in required');
        if (co && !co.value) setInvalid(co, 'Check-out required');
        if (ci && co && ci.value && co.value && new Date(ci.value) > new Date(co.value)) setInvalid(co, 'Check-out after check-in');
        if (rooms && Number(rooms.value || 0) < 1) setInvalid(rooms, 'Minimum 1 room');
        target = '/b2b/agent/search/hotels';
        if (dest?.value) params.set('destination', dest.value.trim());
        if (ci?.value) params.set('checkin', ci.value);
        if (co?.value) params.set('checkout', co.value);
        if (rooms?.value) params.set('rooms', rooms.value);
      } else if (name === 'yachts') {
        const area = get('input[data-field="area"]');
        const date = get('input[data-field="date"]');
        const guests = get('input[data-field="guests"]');
        [area, date, guests].forEach(clearInvalid);
        if (area && !area.value.trim()) setInvalid(area, 'Area is required');
        if (date && !date.value) setInvalid(date, 'Date is required');
        if (guests && Number(guests.value || 0) < 1) setInvalid(guests, 'Minimum 1 guest');
        target = '/b2b/agent/search/yachts';
        if (area?.value) params.set('area', area.value.trim());
        if (date?.value) params.set('date', date.value);
        if (guests?.value) params.set('guests', guests.value);
      } else if (name === 'packages') {
        const dest = get('input[data-field="destination"]');
        const start = get('input[data-field="start"]');
        const nights = get('input[data-field="nights"]');
        const pax = get('input[data-field="pax"]');
        [dest, start, nights, pax].forEach(clearInvalid);
        if (dest && !dest.value.trim()) setInvalid(dest, 'Destination is required');
        if (start && !start.value) setInvalid(start, 'Start date is required');
        if (nights && Number(nights.value || 0) < 1) setInvalid(nights, 'Minimum 1 night');
        if (pax && Number(pax.value || 0) < 1) setInvalid(pax, 'Minimum 1 pax');
        target = '/b2b/agent/search/packages';
        if (dest?.value) params.set('destination', dest.value.trim());
        if (start?.value) params.set('start', start.value);
        if (nights?.value) params.set('nights', nights.value);
        if (pax?.value) params.set('pax', pax.value);
      }
      if (!valid) return;
      const qs = params.toString();
      window.location.href = qs ? `${target}?${qs}` : target;
    }

    const searchBtn = document.getElementById('searchBtn');
    if (searchBtn) searchBtn.addEventListener('click', handleSearchClick);
    const mobileSearchBtn = document.getElementById('mobileSearchBtn');
    if (mobileSearchBtn) mobileSearchBtn.addEventListener('click', handleSearchClick);
  })();
</script>

<!-- Include Social Proof Section -->
<?php include 'partials/social_proof.php'; ?>

<!-- Include Premium Pricing Section -->
<?php include 'partials/premium_pricing.php'; ?>

<?php require __DIR__ . '/partials/footer.php'; ?>
