<?php /** @var array $voucher */ ?>
<?php include __DIR__ . '/partials/header.php'; ?>
<style>
  @media print {
    .no-print { display: none; }
    body { background: #fff; }
    .voucher-card { box-shadow: none; border: 1px solid #e5e7eb; }
    .agent-only { display: none !important; }
    .print-only { display: inline !important; }
  }
  @media screen { .print-only { display: none !important; } }
  .voucher-card { box-shadow: 0 10px 30px rgba(2,6,23,0.06); border: 1px solid #e5e7eb; }
  .brand-bar { background: linear-gradient(90deg,#0ea5e9,#6366f1); height: 6px; border-radius: 6px 6px 0 0; margin: -24px -24px 20px -24px; }
  .section-title { font-weight: 600; color: #111827; border-left: 3px solid #0ea5e9; padding-left: 10px; margin-bottom: 10px; }
  .kv-grid { display: grid; grid-template-columns: 1fr 1fr; gap: 16px; }
  .kv-row { display: flex; align-items: baseline; gap: 10px; }
  .kv-label { color: #6b7280; font-size: 12px; min-width: 90px; }
  .kv-value { color: #111827; font-weight: 500; }
  .status-badge { display: inline-block; padding: 2px 8px; border-radius: 9999px; font-size: 12px; font-weight: 600; }
  .status-confirmed { background: #ecfdf5; color: #047857; border: 1px solid #a7f3d0; }
  .status-pending { background: #fffbeb; color: #92400e; border: 1px solid #fde68a; }
  .status-cancelled { background: #fef2f2; color: #991b1b; border: 1px solid #fecaca; }
  .muted { color: #6b7280; }
  .money { font-weight: 700; }
  .badge-agent { display:inline-flex; align-items:center; gap:6px; background:#eef2ff; color:#3730a3; border:1px solid #c7d2fe; padding:4px 10px; border-radius:9999px; font-size:12px; font-weight:600; }
  .qr-tile { display:inline-flex; flex-direction:column; align-items:center; gap:6px; background:#f9fafb; border:1px solid #e5e7eb; border-radius:12px; padding:10px; }
  .qr-label { font-size:11px; color:#6b7280; letter-spacing:.02em; text-transform:uppercase; }
  .verify-row { display:grid; grid-template-columns:auto 1fr; gap:16px; align-items:start; }
  .verify-right { display:flex; flex-direction:column; gap:6px; }
  .link-truncate { max-width: 100%; overflow:hidden; text-overflow:ellipsis; white-space:nowrap; display:inline-block; vertical-align:bottom; }
  .verify-url { font-family: ui-monospace, SFMono-Regular, Menlo, Monaco, Consolas, "Liberation Mono", "Courier New", monospace; font-size:12px; }
  .voucher-card { position: relative; overflow: hidden; }
  .brand-bar { height: 5px; background: linear-gradient(90deg, #1e3a8a 0%, #4f46e5 50%, #7c3aed 100%); border-radius: 8px 8px 0 0; }
  .watermark { position:absolute; inset:0; display:flex; align-items:center; justify-content:center; font-weight:800; letter-spacing:.2em; color:#111827; opacity:.04; font-size:64px; pointer-events:none; user-select:none; }
</style>
<div class="container mx-auto max-w-3xl py-8">
  <div class="no-print mb-4 flex flex-wrap gap-2 items-center">
    <a class="btn" href="/b2b/agent/bookings">Back to Bookings</a>
    <button class="btn btn-primary" onclick="window.print()">Print Voucher</button>
    <?php $csrfResend = \App\Middleware\AgentGuard::generateCsrfToken('booking_resend_email'); ?>
    <form method="post" action="/b2b/agent/bookings/resend-email" onsubmit="this.querySelector('button[type=submit]').disabled=true" class="inline">
      <input type="hidden" name="csrf_token" value="<?php echo htmlspecialchars($csrfResend); ?>">
      <input type="hidden" name="hotel_booking_id" value="<?php echo (int)($voucher['id'] ?? 0); ?>">
      <button type="submit" class="btn btn-outline">Resend confirmation email</button>
    </form>
  </div>

  <div class="voucher-card bg-white border rounded-2xl p-6 shadow-xl">
    <div class="brand-bar"></div>
    <div class="watermark">B2B THAIHUB</div>
    <div class="flex items-start justify-between mb-4">
      <div>
        <h1 class="text-xl font-semibold">Hotel Booking Voucher</h1>
        <div class="mt-2"><span class="badge-agent" title="This voucher was issued by a travel agent"> 
          <svg xmlns="http://www.w3.org/2000/svg" width="14" height="14" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"><path d="M20 21v-2a4 4 0 0 0-3-3.87"/><path d="M4 21v-2a4 4 0 0 1 3-3.87"/><circle cx="12" cy="7" r="4"/></svg>
          Issued by Agent
        </span></div>
        <div class="text-gray-700 mt-1">
          <div class="font-semibold">
            <?php echo htmlspecialchars((string)($voucher['hotel_name'] ?? '')); ?>
            <?php if (!empty($voucher['hotel_stars'])): ?>
              <span class="text-amber-500 text-sm ml-1">(<?php echo (int)$voucher['hotel_stars']; ?>★)</span>
            <?php endif; ?>
          </div>
          <div class="text-sm text-gray-500">
            <?php
              $loc = trim(((string)($voucher['hotel_city'] ?? '')) . ', ' . ((string)($voucher['hotel_country'] ?? '')));
              echo htmlspecialchars($loc !== ', ' ? $loc : '');
            ?>
          </div>
        </div>
      </div>
      <div class="text-right">
        <div class="text-sm text-gray-500">Created</div>
        <div><?php echo htmlspecialchars((string)($voucher['created_at'] ?? '')); ?></div>
        <div class="mt-2">
          <?php
            $status = strtolower((string)($voucher['status'] ?? 'pending'));
            $badgeClass = 'status-pending';
            if ($status === 'confirmed') $badgeClass = 'status-confirmed';
            if ($status === 'cancelled') $badgeClass = 'status-cancelled';
          ?>
          <span class="status-badge <?php echo $badgeClass; ?>">
            <?php echo htmlspecialchars((string)$voucher['status']); ?>
            <?php if (!empty($voucher['payment_status'])): ?>
              (<?php echo htmlspecialchars((string)$voucher['payment_status']); ?>)
            <?php endif; ?>
          </span>
        </div>
      </div>
    </div>
    <?php if (!empty($verify_url)): ?>
    <div class="mb-4 verify-row">
      <div class="qr-tile">
        <div class="qr-label">Verify</div>
        <?php if (!empty($verify_qr_data)): ?>
          <img src="<?php echo htmlspecialchars($verify_qr_data); ?>" alt="Verify QR" style="width:168px; height:168px; display:block; border-radius:8px;" />
        <?php elseif (!empty($voucher['booking_code']) && !empty($voucher['verify_token'])): ?>
          <img src="/booking/qr?code=<?php echo urlencode((string)$voucher['booking_code']); ?>&t=<?php echo urlencode((string)$voucher['verify_token']); ?>" alt="Verify QR" style="width:168px; height:168px; display:block; border-radius:8px;" />
        <?php else: ?>
          <div style="width:168px;height:168px;border-radius:8px;background:#f3f4f6;border:1px solid #e5e7eb;display:flex;align-items:center;justify-content:center;color:#9ca3af;font-size:12px;">QR unavailable</div>
        <?php endif; ?>
      </div>
      <div class="verify-right">
        <div class="section-title" style="margin-bottom:2px;">Public Verification</div>
        <div class="text-sm text-gray-700">Scan QR for verify booking.</div>
      </div>
    </div>
    <?php endif; ?>
    <div class="mb-4">
      <div class="section-title">Reservation Summary</div>
      <div class="kv-grid">
        <div>
          <div class="kv-row"><div class="kv-label">Booking Code</div><div class="kv-value font-mono"><?php echo htmlspecialchars((string)$voucher['booking_code']); ?></div></div>
          <div class="kv-row"><div class="kv-label">Check-in</div><div class="kv-value"><?php echo htmlspecialchars((string)$voucher['checkin']); ?></div></div>
          <div class="kv-row"><div class="kv-label">Nights</div><div class="kv-value"><?php echo (int)$voucher['nights']; ?></div></div>
          <div class="kv-row"><div class="kv-label">Room Type</div><div class="kv-value">
            <?php echo htmlspecialchars((string)($voucher['room_name'] ?? '')); ?>
            <?php if (!empty($voucher['room_beds'])): ?> <span class="muted">•</span> <?php echo htmlspecialchars((string)$voucher['room_beds']); ?><?php endif; ?>
            <?php if (!empty($voucher['room_capacity'])): ?> <span class="muted">•</span> Max <?php echo (int)$voucher['room_capacity']; ?> pax<?php endif; ?>
          </div></div>
          <div class="kv-row"><div class="kv-label">Rate Plan</div><div class="kv-value">
            <?php echo htmlspecialchars((string)($voucher['rate_plan_name'] ?? '')); ?>
            <?php if (!empty($voucher['rate_meal_plan'])): ?> <span class="muted">(<?php echo htmlspecialchars((string)$voucher['rate_meal_plan']); ?>)</span><?php endif; ?>
          </div></div>
        </div>
        <div>
          <div class="kv-row"><div class="kv-label">Status</div><div class="kv-value text-gray-900"><?php echo htmlspecialchars((string)$voucher['status']); ?><?php if (!empty($voucher['payment_status'])): ?> <span class="muted">(<?php echo htmlspecialchars((string)$voucher['payment_status']); ?>)</span><?php endif; ?></div></div>
          <div class="kv-row"><div class="kv-label">Check-out</div><div class="kv-value"><?php echo htmlspecialchars((string)$voucher['checkout']); ?></div></div>
          <div class="kv-row"><div class="kv-label">Rooms</div><div class="kv-value"><?php echo (int)$voucher['rooms_qty']; ?></div></div>
          <div class="kv-row"><div class="kv-label">Refundability</div><div class="kv-value">
            <?php if (isset($voucher['rate_refundable'])): ?>
              <?php echo ((int)$voucher['rate_refundable'] === 1) ? 'Refundable' : 'Non-refundable'; ?>
              <?php if (!empty($voucher['rate_refund_window_days']) && ((int)$voucher['rate_refundable'] === 1)): ?>
                <span class="muted">• Free cancel up to <?php echo (int)$voucher['rate_refund_window_days']; ?> days</span>
              <?php endif; ?>
            <?php endif; ?>
          </div></div>
          <div class="kv-row"><div class="kv-label">Total</div><div class="kv-value money">
            <?php if (!empty($hide_prices)): ?>
              Paid
            <?php else: ?>
              <span class="agent-only"><?php echo number_format((float)$voucher['total_price'], 2); ?> <?php echo htmlspecialchars((string)$voucher['currency']); ?></span>
              <span class="print-only">Paid</span>
            <?php endif; ?>
          </div></div>
        </div>
      </div>
    </div>

    <?php if (!empty($agent['name']) || !empty($agent['company']) || !empty($agent['agency_name']) || !empty($agent['phone']) || !empty($agent['email'])): ?>
    <div class="mb-4">
      <div class="section-title">Agent & Company</div>
      <div class="kv-grid">
        <div>
          <div class="kv-row"><div class="kv-label">Company</div><div class="kv-value">
            <?php echo htmlspecialchars((string)($agent['company'] ?? ($agent['agency_name'] ?? ''))); ?>
          </div></div>
          <?php if (!empty($agent['city']) || !empty($agent['country'])): ?>
          <div class="kv-row"><div class="kv-label">Location</div><div class="kv-value">
            <?php echo htmlspecialchars(trim(((string)($agent['city'] ?? '') . ', ' . (string)($agent['country'] ?? '')), ' ,')); ?>
          </div></div>
          <?php endif; ?>
        </div>
        <div>
          <div class="kv-row"><div class="kv-label">Agent</div><div class="kv-value">
            <?php echo htmlspecialchars((string)($agent['name'] ?? '')); ?>
          </div></div>
          <?php if (!empty($agent['email'])): ?>
          <div class="kv-row"><div class="kv-label">Email</div><div class="kv-value">
            <?php echo htmlspecialchars((string)$agent['email']); ?>
          </div></div>
          <?php endif; ?>
          <?php if (!empty($agent['phone'])): ?>
          <div class="kv-row"><div class="kv-label">Phone</div><div class="kv-value">
            <?php echo htmlspecialchars((string)$agent['phone']); ?>
          </div></div>
          <?php endif; ?>
        </div>
      </div>
    </div>
    <?php endif; ?>

    <div class="mb-4">
      <div class="section-title">Guest & Contact</div>
      <div class="kv-grid">
        <div>
          <div class="kv-row"><div class="kv-label">Customer</div><div class="kv-value"><?php echo htmlspecialchars((string)($voucher['customer_name'] ?? '')); ?></div></div>
        </div>
        <div>
          <div class="kv-row"><div class="kv-label">Email</div><div class="kv-value"><?php echo htmlspecialchars((string)($voucher['customer_email'] ?? '')); ?></div></div>
        </div>
      </div>
    </div>

    <?php if (!empty($voucher['guests_json'])): ?>
      <hr class="my-6" />
      <div>
        <div class="section-title">Guests</div>
        <?php $gj = json_decode((string)$voucher['guests_json'], true); ?>
        <?php if (is_array($gj)): ?>
          <div class="text-sm">
            <?php if (!empty($gj['lead_guest']['name'])): ?>
              <div><span class="text-gray-500">Lead guest:</span> <?php echo htmlspecialchars((string)$gj['lead_guest']['name']); ?></div>
            <?php endif; ?>
            <?php if (!empty($gj['rooms']) && is_array($gj['rooms'])): ?>
              <div class="mt-2">
                <?php foreach ($gj['rooms'] as $idx => $r): ?>
                  <div class="mb-1"><span class="text-gray-500">Room <?php echo (int)$idx + 1; ?>:</span>
                    Adults: <?php echo (int)($r['adults'] ?? 1); ?>,
                    Children: <?php echo (int)($r['children'] ?? 0); ?>
                  </div>
                <?php endforeach; ?>
              </div>
            <?php endif; ?>
          </div>
        <?php endif; ?>
      </div>
    <?php endif; ?>

    <?php if (!empty($voucher['policy_checkin_time']) || !empty($voucher['policy_checkout_time']) || !empty($voucher['policy_terms_html'])): ?>
      <hr class="my-6" />
      <div>
        <div class="section-title">Hotel Policies</div>
        <div class="text-sm text-gray-700 space-y-1">
          <?php if (!empty($voucher['policy_checkin_time'])): ?>
            <div>Check-in: <?php echo htmlspecialchars((string)$voucher['policy_checkin_time']); ?></div>
          <?php endif; ?>
          <?php if (!empty($voucher['policy_checkout_time'])): ?>
            <div>Check-out: <?php echo htmlspecialchars((string)$voucher['policy_checkout_time']); ?></div>
          <?php endif; ?>
          <?php if (!empty($voucher['policy_terms_html'])): ?>
            <div class="prose max-w-none">
              <?php // Terms are admin-controlled; render as-is but inside container. ?>
              <?php echo $voucher['policy_terms_html']; ?>
            </div>
          <?php endif; ?>
        </div>
      </div>
    <?php endif; ?>

    <hr class="my-6" />
    <div class="text-xs text-gray-500 mb-4">
      Please present this voucher at hotel check-in. Contact support for any changes.
    </div>

    <?php
      $qCancel = (string)($_GET['cancel'] ?? '');
      $qErr = (string)($_GET['err'] ?? '');
      $qMail = (string)($_GET['mail'] ?? '');
      if ($qCancel === 'success') {
        echo '<div class="alert alert-success mb-4">Cancellation request submitted successfully. Our team will review it shortly.</div>';
      } elseif ($qErr === 'already_requested') {
        echo '<div class="alert alert-warning mb-4">A cancellation request for this booking is already pending.</div>';
      } elseif ($qErr === 'already_cancelled') {
        echo '<div class="alert alert-info mb-4">This booking is already cancelled.</div>';
      } elseif ($qErr === 'reason') {
        echo '<div class="alert alert-error mb-4">Please provide a reason (at least 5 characters).</div>';
      } elseif ($qErr === 'db') {
        echo '<div class="alert alert-error mb-4">Could not submit your request due to a server error. Please try again.</div>';
      } elseif ($qMail === 'sent') {
        echo '<div class="alert alert-success mb-4">Confirmation email has been re-sent.</div>';
      } elseif ($qMail === 'err') {
        echo '<div class="alert alert-warning mb-4">Could not send the email right now. Please verify the customer email or try again later.</div>';
      }
    ?>

    <?php
      $isCancelled = strtolower((string)($voucher['status'] ?? '')) === 'cancelled';
      if (!$isCancelled) {
        // Generate CSRF token for this form
        $csrf = \App\Middleware\AgentGuard::generateCsrfToken('booking_cancel_request');
    ?>
      <div id="cancel" class="mt-4 p-4 rounded border bg-gray-50">
        <div class="section-title">Request Cancellation</div>
        <form action="/b2b/agent/bookings/cancel-request" method="post" class="space-y-3">
          <input type="hidden" name="csrf_token" value="<?php echo htmlspecialchars($csrf); ?>" />
          <input type="hidden" name="hotel_booking_id" value="<?php echo (int)($voucher['id'] ?? 0); ?>" />
          <label class="form-control w-full">
            <div class="label"><span class="label-text">Reason for cancellation</span></div>
            <textarea name="reason" class="textarea textarea-bordered w-full" rows="3" placeholder="Briefly explain why you need to cancel" required></textarea>
          </label>
          <div class="flex items-center gap-2">
            <button type="submit" class="btn btn-error">Submit Cancellation Request</button>
            <span class="text-xs text-gray-500">Submitting this request does not immediately cancel the booking. Our team will confirm eligibility and refunds per policy.</span>
          </div>
        </form>
      </div>
    <?php } ?>
  </div>
</div>
<?php include __DIR__ . '/partials/footer.php'; ?>
