<?php
// app/Views/agent/booking_pay.php
$title = $title ?? 'Select Payment Method';
$active = 'bookings';
$total = $total ?? 0.0;
$currency = $currency ?? 'THB';
$gateways = $gateways ?? ['wallet'=>false,'stripe'=>false,'paypal'=>false];
$wallet = $wallet ?? ['balance'=>0.0,'locked'=>false,'locked_until'=>null,'attempts'=>0];
require __DIR__ . '/partials/header.php';
?>

<div class="mb-4">
  <ul class="steps w-full">
    <li class="step step-primary">Select rooms</li>
    <li class="step step-primary">Guest details</li>
    <li class="step step-primary">Payment</li>
  </ul>
</div>

<?php
  $err = $_GET['err'] ?? '';
  $left = isset($_GET['left']) ? (int)$_GET['left'] : null;
  if ($err) {
      $msg = 'An error occurred.';
      if ($err === 'csrf') $msg = 'Your session expired. Please try again.';
      elseif ($err === 'invalid_pin') $msg = 'Please enter a valid PIN (4–6 digits).';
      elseif ($err === 'pin_check') $msg = 'Unable to verify PIN at the moment.';
      elseif ($err === 'wallet_locked') $msg = 'Your wallet PIN is locked. Please wait and try later or contact support.';
      elseif ($err === 'pin_locked') $msg = 'Too many failed attempts. Your PIN has been locked for 24 hours.';
      elseif ($err === 'pin_not_set') $msg = 'A wallet PIN is required but not set for your account. Please set your transaction PIN in Profile > Security and try again.';
      elseif ($err === 'pin_invalid') $msg = 'Incorrect PIN.' . ($left !== null ? (' Attempts left: ' . $left) : '');
      elseif ($err === 'insufficient_balance') $msg = 'Insufficient wallet balance. Please top up or choose another payment method.';
      elseif ($err === 'vendor_missing') $msg = 'This hotel is not linked to any vendor. Please contact admin to assign a vendor to this hotel.';
      echo '<div class="alert alert-error mb-4">' . htmlspecialchars($msg) . '</div>';
      // If debug mode and a detailed error exists in session, show it as well
      $appCfg = [];
      $cfgPath = dirname(__DIR__, 3) . '/config/app.php'; // go to project root/config
      if (is_file($cfgPath)) { $appCfg = require $cfgPath; }
      if (!empty($appCfg['debug']) && $err === 'wallet_error' && !empty($_SESSION['debug_wallet_error'])) {
          echo '<div class="alert alert-warning mb-4"><div class="font-semibold mb-1">Debug details</div><pre class="whitespace-pre-wrap text-xs">' . htmlspecialchars((string)$_SESSION['debug_wallet_error']) . '</pre></div>';
          unset($_SESSION['debug_wallet_error']);
      }
  }
?>

<div class="grid grid-cols-1 lg:grid-cols-3 gap-6">
  <div class="lg:col-span-2 space-y-4">
    <div class="card bg-base-100 shadow-sm border">
      <div class="card-body">
        <h2 class="card-title mb-1">Choose a payment method</h2>
        <div class="text-sm text-base-content/70">Amount due: <span class="font-semibold"><?= number_format((float)$total, 2) ?> <?= htmlspecialchars($currency) ?></span></div>

        <div class="divider my-4">Gateways</div>

        <div class="grid grid-cols-1 md:grid-cols-2 gap-4">
          <?php if (!empty($gateways['wallet'])): ?>
            <div class="card bg-white border">
              <div class="card-body">
                <div class="flex items-center justify-between">
                  <div>
                    <div class="font-semibold">Wallet</div>
                    <div class="text-sm opacity-70">Balance: <?= number_format((float)($wallet['balance'] ?? 0), 2) ?> <?= htmlspecialchars($currency) ?></div>
                    <?php if (!empty($wallet['locked'])): ?>
                      <div class="text-xs text-error mt-1">PIN locked<?= !empty($wallet['locked_until']) ? (', until ' . htmlspecialchars((string)$wallet['locked_until'])) : '' ?></div>
                    <?php endif; ?>
                    <?php $walletInsufficient = ((float)($wallet['balance'] ?? 0)) < ((float)$total); ?>
                    <?php if ($walletInsufficient): ?>
                      <div class="text-xs mt-1">Shortfall: <span class="font-medium text-error"><?= number_format(max(0, ((float)$total - (float)($wallet['balance'] ?? 0))), 2) ?></span> <?= htmlspecialchars($currency) ?></div>
                    <?php endif; ?>
                  </div>
                  <button class="btn btn-primary btn-sm" <?= (!empty($wallet['locked']) || (!empty($walletInsufficient))) ? 'disabled' : '' ?> onclick="document.getElementById('walletPinModal').showModal()">Pay with Wallet</button>
                </div>
              </div>
            </div>
          <?php endif; ?>

          <?php if (!empty($gateways['stripe'])): ?>
            <div class="card bg-white border opacity-90">
              <div class="card-body">
                <div class="flex items-center justify-between">
                  <div>
                    <div class="font-semibold">Card (Stripe)</div>
                    <div class="text-sm opacity-70">Pay securely with credit/debit card.</div>
                  </div>
                  <form method="post" action="/b2b/agent/bookings/pay/stripe">
                    <input type="hidden" name="csrf_token" value="<?= htmlspecialchars(\App\Middleware\AgentGuard::generateCsrfToken('booking_pay_stripe')) ?>">
                    <button type="submit" class="btn btn-outline btn-sm">Continue</button>
                  </form>
                </div>
              </div>
            </div>
          <?php endif; ?>

          <?php if (!empty($gateways['paypal'])): ?>
            <div class="card bg-white border opacity-90">
              <div class="card-body">
                <div class="flex items-center justify-between">
                  <div>
                    <div class="font-semibold">PayPal</div>
                    <div class="text-sm opacity-70">Checkout using PayPal.</div>
                  </div>
                  <button class="btn btn-outline btn-sm" disabled>Continue (soon)</button>
                </div>
              </div>
            </div>
          <?php endif; ?>
        </div>

        <div class="mt-6 flex items-center gap-2">
          <a href="/b2b/agent/bookings/review" class="btn btn-ghost">Back</a>
        </div>
      </div>
    </div>
  </div>

  <div class="space-y-4">
    <div class="card bg-base-100 border shadow-sm">
      <div class="card-body">
        <div class="font-semibold">Order summary</div>
        <div class="mt-2 flex justify-between text-sm">
          <div>Total</div>
          <div class="font-semibold"><?= number_format((float)$total, 2) ?> <?= htmlspecialchars($currency) ?></div>
        </div>
      </div>
    </div>
  </div>
</div>

<!-- Wallet PIN Modal -->
<dialog id="walletPinModal" class="modal">
  <div class="modal-box">
    <h3 class="font-bold text-lg">Confirm Wallet Payment</h3>
    <p class="py-2 text-sm opacity-70">Enter your wallet PIN to confirm payment of <span class="font-semibold"><?= number_format((float)$total, 2) ?> <?= htmlspecialchars($currency) ?></span>.</p>
    <form id="walletPayForm" method="post" action="/b2b/agent/pay/wallet" class="space-y-3" onsubmit="return showProcessingOverlay()">
      <input type="hidden" name="csrf_token" value="<?= htmlspecialchars(\App\Middleware\AgentGuard::generateCsrfToken('booking_pay_wallet')) ?>" />
      <label class="form-control w-full">
        <div class="label"><span class="label-text">PIN</span></div>
        <input type="password" name="tx_pin" inputmode="numeric" pattern="[0-9]{4,6}" maxlength="6" minlength="4" class="input input-bordered w-full" placeholder="••••" required />
      </label>
      <div class="modal-action">
        <button type="button" class="btn" onclick="document.getElementById('walletPinModal').close()">Cancel</button>
        <button type="submit" class="btn btn-primary">Pay Now</button>
      </div>
    </form>
  </div>
  <form method="dialog" class="modal-backdrop">
    <button>close</button>
  </form>
</dialog>

<!-- Processing overlay -->
<div id="processingOverlay" class="fixed inset-0 hidden items-center justify-center bg-base-100/80 backdrop-blur-sm z-[1000]">
  <div class="p-6 rounded-xl border bg-base-100 shadow-xl flex items-center gap-4">
    <svg class="animate-spin h-6 w-6 text-primary" xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24"><circle class="opacity-25" cx="12" cy="12" r="10" stroke="currentColor" stroke-width="4"></circle><path class="opacity-75" fill="currentColor" d="M4 12a8 8 0 018-8v4a4 4 0 00-4 4H4z"></path></svg>
    <div>
      <div class="font-semibold">We are confirming your booking…</div>
      <div class="text-sm opacity-70">Please wait while we process your payment and send the confirmation email.</div>
    </div>
  </div>
  <style>
    #processingOverlay.hidden { display: none; }
    #processingOverlay { display: flex; }
  </style>
</div>

<script>
  function showProcessingOverlay(){
    try{ document.getElementById('processingOverlay').classList.remove('hidden'); }catch(e){}
    return true;
  }
</script>

<?php require __DIR__ . '/partials/footer.php'; ?>
