<?php /** @var array $pi */ /** @var string $status */ /** @var array $result */ /** @var string $booking_code */ /** @var int $hotel_booking_id */ ?>
<?php include __DIR__ . '/partials/header.php'; ?>
<div class="container mx-auto max-w-3xl py-8">
  <h1 class="text-2xl font-semibold mb-4">Payment Confirmation</h1>

  <?php if ($status === 'succeeded'): ?>
    <div class="p-4 mb-6 rounded bg-green-50 border border-green-200 text-green-800">
      <p class="mb-1">Your payment was successful.</p>
      <?php if (!empty($booking_code)): ?>
        <p class="font-medium">Booking Code: <span class="font-mono"><?php echo htmlspecialchars($booking_code); ?></span></p>
      <?php endif; ?>
    </div>

    <div class="flex gap-3">
      <?php if (!empty($booking_code)): ?>
        <a class="btn btn-primary" href="/b2b/agent/bookings/voucher?code=<?php echo urlencode($booking_code); ?>">View Voucher</a>
      <?php elseif (!empty($hotel_booking_id)): ?>
        <a class="btn btn-primary" href="/b2b/agent/bookings/voucher?id=<?php echo (int)$hotel_booking_id; ?>">View Voucher</a>
      <?php endif; ?>
      <a class="btn" href="/b2b/agent/bookings?paid=1">Go to My Bookings</a>
    </div>
  <?php elseif ($status === 'created' || $status === 'processing'): ?>
    <div class="p-6 mb-6 rounded bg-yellow-50 border border-yellow-200 text-yellow-800 flex items-center gap-4">
      <svg class="animate-spin h-6 w-6 text-yellow-700" xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24"><circle class="opacity-25" cx="12" cy="12" r="10" stroke="currentColor" stroke-width="4"></circle><path class="opacity-75" fill="currentColor" d="M4 12a8 8 0 018-8v4a4 4 0 00-4 4H4z"></path></svg>
      <div>
        <p class="font-medium">We are confirming your booking…</p>
        <p class="text-sm opacity-80">Please wait a moment while we finalize your payment.</p>
      </div>
    </div>
    <div class="text-sm text-base-content/70 mb-3">This page will refresh automatically.</div>
    <a class="btn" href="/b2b/agent/bookings/confirmation?pi_id=<?php echo (int)($_GET['pi_id'] ?? 0); ?>">Refresh now</a>
  <?php else: ?>
    <div class="p-4 mb-6 rounded bg-red-50 border border-red-200 text-red-800">
      <p>Payment was not successful or has not been processed.</p>
    </div>
    <a class="btn" href="/b2b/agent/bookings/pay">Try Again</a>
  <?php endif; ?>
</div>
<script>
  (function(){
    const status = <?php echo json_encode($status); ?>;
    const piId = <?php echo (int)($_GET['pi_id'] ?? 0); ?>;
    const code = <?php echo json_encode($booking_code ?? ''); ?>;
    const bookingId = <?php echo (int)($hotel_booking_id ?? 0); ?>;
    if (status === 'created' || status === 'processing') {
      setTimeout(function(){ window.location.reload(); }, 3000);
    }
    if (status === 'succeeded') {
      let url = '';
      if (code) url = '/b2b/agent/bookings/voucher?code=' + encodeURIComponent(code);
      else if (bookingId) url = '/b2b/agent/bookings/voucher?id=' + bookingId;
      if (url) { setTimeout(function(){ window.location.href = url; }, 2500); }
    }
  })();
</script>
<?php include __DIR__ . '/partials/footer.php'; ?>
