<?php
// app/Views/agent/auth/verify_email.php
$title = $title ?? 'Verify Email';
?>
<!DOCTYPE html>
<html lang="en" class="h-full">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0, viewport-fit=cover">
    <!-- Mobile App-like meta -->
    <meta name="theme-color" content="#0d79c7">
    <meta name="apple-mobile-web-app-capable" content="yes">
    <meta name="apple-mobile-web-app-status-bar-style" content="black-translucent">
    <meta name="apple-mobile-web-app-title" content="B2B Thai Hub">
    <meta name="application-name" content="B2B Thai Hub">
    <meta name="format-detection" content="telephone=no,email=no,address=no">
    <title><?= htmlspecialchars($title) ?> - B2B Agent Portal</title>
    
    <!-- Tailwind CSS -->
    <script src="https://cdn.tailwindcss.com"></script>
    
    <!-- Font Awesome -->
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    
    <!-- Manifest for PWA -->
    <link rel="manifest" href="/manifest.webmanifest">
    <!-- Google Fonts -->
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@300;400;500;600;700;800&family=JetBrains+Mono:wght@400;500&display=swap" rel="stylesheet">
    
    <!-- Enterprise Styles -->
    <style>
        :root {
            --primary-50: #e6f4ff;
            --primary-100: #cce9ff;
            --primary-200: #99d3ff;
            --primary-300: #66beff;
            --primary-400: #33a8ff;
            --primary-500: #008cff; /* MakeMyTrip-like blue */
            --primary-600: #0077e6;
            --primary-700: #0063c7;
            --primary-800: #004f9e;
            --primary-900: #103b73;
            
            --gray-50: #f8fafc;
            --gray-100: #f1f5f9;
            --gray-200: #e2e8f0;
            --gray-300: #cbd5e1;
            --gray-400: #94a3b8;
            --gray-500: #64748b;
            --gray-600: #475569;
            --gray-700: #334155;
            --gray-800: #1e293b;
            --gray-900: #0f172a;
            
            --success-500: #10b981;
            --warning-500: #f59e0b;
            --danger-500: #ef4444;
            --info-500: #3b82f6;
        }
        
        * { box-sizing: border-box; }
        body { 
            font-family: 'Inter', -apple-system, BlinkMacSystemFont, 'Segoe UI', Roboto, Oxygen, Ubuntu, Cantarell, sans-serif;
            background-color: #f8fafc;
            color: #1e293b;
            line-height: 1.5;
            margin: 0;
            padding: 0;
            min-height: 100vh;
            display: flex;
            flex-direction: column;
        }
        
        /* Main container */
        .main-container {
            flex: 1;
            display: flex;
            align-items: center;
            justify-content: center;
            padding: 2rem 1rem;
            background-color: #f8fafc;
        }
        
        /* Login card */
        .login-card {
            background: white;
            border-radius: 1rem;
            box-shadow: 0 4px 20px rgba(0, 0, 0, 0.08);
            width: 100%;
            max-width: 28rem;
            overflow: hidden;
            border: 1px solid var(--gray-200);
        }
        
        /* Form container */
        .form-container {
            padding: 2.5rem;
        }
        
        /* Form elements */
        .form-group {
            margin-bottom: 1.5rem;
        }
        
        .form-label {
            display: block;
            font-size: 0.875rem;
            font-weight: 500;
            color: var(--gray-700);
            margin-bottom: 0.5rem;
        }
        
        .form-input {
            width: 100%;
            padding: 0.75rem 1rem;
            font-size: 0.9375rem;
            border: 1px solid var(--gray-300);
            border-radius: 0.5rem;
            background-color: white;
            transition: border-color 0.15s, box-shadow 0.15s;
        }
        
        .form-input:focus {
            outline: none;
            border-color: var(--primary-500);
            box-shadow: 0 0 0 3px rgba(0, 140, 255, 0.1);
        }
        
        .btn {
            display: inline-flex;
            align-items: center;
            justify-content: center;
            padding: 0.75rem 1.5rem;
            font-size: 0.9375rem;
            font-weight: 500;
            border-radius: 0.5rem;
            cursor: pointer;
            transition: all 0.2s;
            text-decoration: none;
            border: none;
        }
        
        .btn-primary {
            background-color: var(--primary-600);
            color: white;
        }
        
        .btn-primary:hover {
            background-color: var(--primary-700);
        }
        
        .btn-block {
            display: block;
            width: 100%;
        }
        
        /* Header */
        .page-header {
            background: linear-gradient(135deg, var(--primary-500), var(--primary-700));
            color: white;
            padding: 1.5rem 2rem;
            text-align: center;
        }
        
        .page-title {
            font-size: 1.5rem;
            font-weight: 700;
            margin: 0 0 0.5rem;
        }
        
        .page-subtitle {
            font-size: 0.9375rem;
            opacity: 0.9;
            margin: 0;
        }
        
        /* Footer */
        .footer {
            text-align: center;
            padding: 1.5rem;
            color: var(--gray-500);
            font-size: 0.875rem;
            border-top: 1px solid var(--gray-200);
            background-color: white;
        }
        
        /* Alerts */
        .alert {
            padding: 1rem;
            border-radius: 0.5rem;
            margin-bottom: 1.5rem;
            font-size: 0.9375rem;
        }
        
        .alert-error {
            background-color: #fef2f2;
            color: #b91c1c;
            border-left: 4px solid #dc2626;
        }
        
        .alert-info {
            background-color: #eff6ff;
            color: #1e40af;
            border-left: 4px solid #3b82f6;
        }
        
        /* OTP input */
        .otp-input {
            width: 100%;
            padding: 0.75rem 1rem;
            font-size: 1.25rem;
            font-weight: 600;
            letter-spacing: 0.2em;
            text-align: center;
            border: 1px solid var(--gray-300);
            border-radius: 0.5rem;
            background-color: white;
        }
        
        .otp-input:focus {
            outline: none;
            border-color: var(--primary-500);
            box-shadow: 0 0 0 3px rgba(0, 140, 255, 0.1);
        }
        
        /* Responsive */
        @media (max-width: 640px) {
            .main-container {
                padding: 1rem;
            }
            
            .form-container {
                padding: 1.5rem;
            }
            
            .page-header {
                padding: 1.25rem 1.5rem;
            }
        }
        
        /* Mobile app bar */
        .mobile-app-bar {
            display: none;
            background: linear-gradient(135deg, var(--primary-500), var(--primary-700));
            color: white;
            padding: 0.75rem 1rem;
            position: sticky;
            top: 0;
            z-index: 50;
            box-shadow: 0 2px 10px rgba(0, 0, 0, 0.1);
        }
        
        .app-row {
            display: flex;
            align-items: center;
            justify-content: space-between;
            max-width: 90rem;
            margin: 0 auto;
            width: 100%;
        }
        
        .app-badge {
            width: 32px;
            height: 32px;
            border-radius: 8px;
            background: rgba(255, 255, 255, 0.2);
            display: flex;
            align-items: center;
            justify-content: center;
        }
        
        .app-title {
            font-weight: 700;
            letter-spacing: 0.2px;
        }
        
        @media (max-width: 640px) {
            .mobile-app-bar {
                display: block;
            }
        }
    </style>
</head>
<body>
    <!-- App-like top bar for mobile -->
    <div class="mobile-app-bar">
        <div class="app-row">
            <div class="app-badge"><i class="fas fa-compass"></i></div>
            <div class="app-title">B2B Agent Portal</div>
            <div style="width: 32px;"></div> <!-- Spacer for alignment -->
        </div>
    </div>
    
    <div class="main-container">
        <div class="login-card">
            <!-- Header -->
            <div class="page-header">
                <h1 class="page-title">Verify Your Email</h1>
                <p class="page-subtitle">Enter the 6-digit code sent to your email</p>
                <?php if (!empty($sent_at) || !empty($expires_at)): ?>
                    <p class="text-white/80 text-xs mt-2">
                        <?php if (!empty($sent_at)): ?>Sent at: <strong><?= htmlspecialchars($sent_at) ?></strong><?php endif; ?>
                        <?php if (!empty($expires_at)): ?> · Expires at: <strong><?= htmlspecialchars($expires_at) ?></strong><?php endif; ?>
                    </p>
                <?php endif; ?>
            </div>
            
            <!-- Form Container -->
            <div class="form-container">
                <?php if (!empty($_SESSION['errors'])): ?>
                    <div class="alert alert-error">
                        <ul class="list-disc ml-6">
                            <?php foreach ((array)$_SESSION['errors'] as $e): ?>
                                <li><?= htmlspecialchars($e) ?></li>
                            <?php endforeach; unset($_SESSION['errors']); ?>
                        </ul>
                    </div>
                <?php endif; ?>
                
                <?php if (!empty($_SESSION['flash'])): ?>
                    <div class="alert alert-info"><?= htmlspecialchars($_SESSION['flash']); unset($_SESSION['flash']); ?></div>
                <?php endif; ?>
                
                <form method="post" action="/agent/verify-email" class="grid grid-cols-1 gap-4 mb-4" id="otp-verify-form">
                    <input type="hidden" name="csrf" value="<?= htmlspecialchars($csrf ?? '') ?>">
                    <div class="form-group">
                        <label class="form-label">6-digit verification code</label>
                        <input type="text" 
                               name="otp" 
                               class="otp-input" 
                               placeholder="000000" 
                               minlength="6" 
                               maxlength="6" 
                               pattern="^[0-9]{6}$" 
                               inputmode="numeric" 
                               autocomplete="one-time-code" 
                               required 
                               autofocus>
                        <p class="text-xs text-gray-500 mt-1">Check your email for the 6-digit code</p>
                    </div>
                    
                    <div class="form-group">
                        <button type="submit" class="btn btn-primary btn-block">Verify Email</button>
                    </div>
                </form>
                
                <div class="text-center">
                    <form method="post" action="/agent/resend-otp" class="inline-block" id="resend-form">
                        <input type="hidden" name="csrf" value="<?= htmlspecialchars($csrf ?? '') ?>">
                        <button type="submit" class="text-sm text-primary-600 hover:text-primary-800 font-medium" id="resend-btn">
                            Didn't receive a code? <span id="resend-text">Resend code</span>
                        </button>
                    </form>
                    <div id="cooldown-msg" class="text-xs text-gray-500 mt-1"></div>
                </div>
                
                <div class="mt-6 pt-4 border-t border-gray-200 text-center">
                    <a href="/b2b/agent/login" class="text-sm font-medium text-primary-600 hover:text-primary-800">
                        &larr; Back to Login
                    </a>
                </div>
            </div>
        </div>
    </div>
    
    <!-- Footer -->
    <div class="footer">
        <div class="container mx-auto">
            <p>&copy; <?= date('Y') ?> B2B Thai Hub. All rights reserved.</p>
        </div>
    </div>
    <script>
        (function(){
            const RESEND_KEY = 'agent_otp_resend_last';
            const COOLDOWN = 60; // seconds
            const btn = document.getElementById('resend-btn');
            const resendText = document.getElementById('resend-text');
            const cooldownMsg = document.getElementById('cooldown-msg');
            const form = document.getElementById('resend-form');
            
            // Check if we're in cooldown
            const lastResend = localStorage.getItem(RESEND_KEY);
            const now = Math.floor(Date.now() / 1000);
            
            if (lastResend) {
                const diff = now - parseInt(lastResend, 10);
                if (diff < COOLDOWN) {
                    startCooldown(COOLDOWN - diff);
                } else {
                    cooldownMsg.textContent = '';
                }
            }
            
            // Handle form submission
            form.addEventListener('submit', function(e) {
                localStorage.setItem(RESEND_KEY, now.toString());
                startCooldown(COOLDOWN);
            });
            
            function startCooldown(seconds) {
                let remaining = seconds;
                btn.disabled = true;
                
                function update() {
                    if (remaining <= 0) {
                        cooldownMsg.textContent = '';
                        resendText.textContent = 'Resend code';
                        btn.disabled = false;
                        return;
                    }
                    
                    const mins = Math.floor(remaining / 60);
                    const secs = remaining % 60;
                    cooldownMsg.textContent = `Please wait ${mins}:${secs < 10 ? '0' : ''}${secs} before requesting a new code`;
                    resendText.textContent = 'Resend code';
                    remaining--;
                    setTimeout(update, 1000);
                }
                
                update();
            }
            
            // Auto-submit OTP field when 6 digits are entered
            const otpInput = document.querySelector('input[name="otp"]');
            if (otpInput) {
                otpInput.addEventListener('input', function() {
                    if (this.value.length === 6) {
                        document.getElementById('otp-verify-form').submit();
                    }
                });
            }

            // Handle window unload to clean up any intervals
            window.addEventListener('beforeunload', function() {
                // Clean up any intervals if needed
                if (window.expiryInterval) {
                    clearInterval(window.expiryInterval);
                }
            });

            // Show expiry countdown if expiry time is provided
            <?php if (!empty($expires_at)): ?>
            (function() {
                const expiryBanner = document.createElement('div');
                expiryBanner.className = 'bg-yellow-50 border-l-4 border-yellow-400 p-4 mb-4';
                
                const expiryContainer = document.createElement('div');
                expiryContainer.className = 'flex items-center';
                
                const expiryText = document.createElement('div');
                expiryText.className = 'flex-1';
                
                const expiryTitle = document.createElement('h3');
                expiryTitle.className = 'text-sm font-medium text-yellow-800';
                
                const expiryMessage = document.createElement('p');
                expiryMessage.className = 'text-sm text-yellow-700';
                
                expiryContainer.appendChild(expiryText);
                expiryText.appendChild(expiryTitle);
                expiryText.appendChild(expiryMessage);
                
                // Insert the banner before the form
                const form = document.querySelector('form');
                form.parentNode.insertBefore(expiryBanner, form);
                expiryBanner.appendChild(expiryContainer);

                const expiresAt = new Date('<?= str_replace(' ', 'T', $expires_at) ?>').getTime();
                
                function updateExpiryTimer() {
                    const now = new Date().getTime();
                    const distance = expiresAt - now;
                    
                    if (distance < 0) {
                        expiryTitle.textContent = 'Code Expired';
                        expiryMessage.textContent = 'The verification code has expired. Please request a new one.';
                        clearInterval(window.expiryInterval);
                        return;
                    }
                    
                    // Calculate time remaining
                    const minutes = Math.floor((distance % (1000 * 60 * 60)) / (1000 * 60));
                    const seconds = Math.floor((distance % (1000 * 60)) / 1000);
                    
                    expiryTitle.textContent = 'Verification Code Expires In';
                    expiryMessage.textContent = `${minutes.toString().padStart(2, '0')}:${seconds.toString().padStart(2, '0')}`;
                }
                
                // Update the countdown every second
                window.expiryInterval = setInterval(updateExpiryTimer, 1000);
                updateExpiryTimer(); // Initial call
            })();
            <?php endif; ?>
        })();
    </script>
</body>
</html>
