<?php
// Title is passed from the controller
$page_title = $title ?? 'Agent Registration';
?>

<!DOCTYPE html>
<html lang="en" class="h-full">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0, viewport-fit=cover">
    <meta name="theme-color" content="#0d79c7">
    <meta name="apple-mobile-web-app-capable" content="yes">
    <meta name="apple-mobile-web-app-status-bar-style" content="black-translucent">
    <meta name="apple-mobile-web-app-title" content="B2B Thai Hub">
    <meta name="application-name" content="B2B Thai Hub">
    <meta name="format-detection" content="telephone=no,email=no,address=no">
    <title><?= htmlspecialchars($page_title ?? '', ENT_QUOTES, 'UTF-8') ?></title>
    
    <!-- Tailwind CSS -->
    <script src="https://cdn.tailwindcss.com"></script>
    
    <!-- Font Awesome -->
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    
    <!-- PWA Manifest -->
    <link rel="manifest" href="/manifest.webmanifest">

    <!-- Google Fonts -->
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@300;400;500;600;700;800&family=JetBrains+Mono:wght@400;500&display=swap" rel="stylesheet">
    
    <!-- Custom Enterprise Styles -->
    <style>
        :root {
            --primary-50: #f0f9ff;
            --primary-100: #e0f2fe;
            --primary-200: #bae6fd;
            --primary-300: #8fd3ff;
            --primary-400: #43b5ff;
            --primary-500: #008cff; /* MakeMyTrip-like blue */
            --primary-600: #0077e6;
            --primary-700: #0063c7;
            --primary-800: #004f9e;
            --primary-900: #103b73;
            
            --gray-50: #f8fafc;
            --gray-100: #f1f5f9;
            --gray-200: #e2e8f0;
            --gray-300: #cbd5e1;
            --gray-400: #94a3b8;
            --gray-500: #64748b;
            --gray-600: #475569;
            --gray-700: #334155;
            --gray-800: #1e293b;
            --gray-900: #0f172a;
            
            --success-50: #f0fdf4;
            --success-500: #22c55e;
            --success-600: #16a34a;
            
            --error-50: #fef2f2;
            --error-500: #ef4444;
            --error-600: #dc2626;
            
            --warning-50: #fffbeb;
            --warning-500: #f59e0b;
            --warning-600: #d97706;
        }
        
        :root {
            --primary: #008cff;
            --primary-hover: #0077e6;
            --success: #10b981;
            --error: #ef4444;
            --warning: #ff6d00;
            --gray-100: #f6f8fb;
            --gray-200: #e8eef6;
            --gray-700: #334155;
            --gray-900: #0f172a;
        }
        
        body {
            font-family: 'Inter', system-ui, -apple-system, sans-serif;
            @apply antialiased text-gray-800 bg-gray-50;
            -webkit-tap-highlight-color: transparent;
            touch-action: manipulation;
        }
        
        .form-input, .form-select {
            @apply w-full px-4 py-2.5 text-sm border border-gray-300 rounded-lg focus:ring-2 focus:ring-blue-100 focus:border-blue-500 transition-all duration-200;
        }
        
        .form-input:disabled, .form-select:disabled {
            @apply bg-gray-100 cursor-not-allowed;
        }
        
        .btn {
            @apply inline-flex items-center justify-center px-6 py-3 rounded-lg font-medium text-sm transition-all duration-200 focus:outline-none focus:ring-2 focus:ring-offset-2 disabled:opacity-70 disabled:cursor-not-allowed;
        }
        
        .btn-primary {
            @apply bg-blue-600 text-white hover:bg-blue-700 focus:ring-blue-200;
        }
        
        .btn-outline {
            @apply border border-gray-300 bg-white text-gray-700 hover:bg-gray-50 focus:ring-gray-200;
        }
        
        /* Animations */
        @keyframes fadeIn {
            from { opacity: 0; transform: translateY(5px); }
            to { opacity: 1; transform: translateY(0); }
        }
        
        @keyframes shake {
            0%, 100% { transform: translateX(0); }
            25% { transform: translateX(-5px); }
            75% { transform: translateX(5px); }
        }
        
        .animate-fade-in {
            animation: fadeIn 0.3s ease-out forwards;
        }
        
        .animate-shake {
            animation: shake 0.3s ease-in-out;
        }
        
        /* Password strength meter */
        .password-strength {
            @apply h-1.5 bg-gray-200 rounded-full overflow-hidden mt-2;
        }
        
        .password-strength-bar {
            @apply h-full transition-all duration-300;
        }
        
        .strength-0 { width: 20%; background-color: #ef4444; }
        .strength-1 { width: 40%; background-color: #f59e0b; }
        .strength-2 { width: 60%; background-color: #3b82f6; }
        .strength-3 { width: 80%; background-color: #10b981; }
        .strength-4 { width: 100%; background-color: #10b981; }
        
        /* Stepper */
        .stepper {
            @apply flex items-center justify-between mb-8 relative;
        }
        
        .stepper::before {
            content: '';
            @apply absolute top-1/2 left-0 right-0 h-0.5 bg-gray-200 -z-10;
        }
        
        .step {
            @apply flex flex-col items-center relative;
        }
        
        .step-number {
            @apply w-8 h-8 flex items-center justify-center rounded-full border-2 border-gray-300 bg-white text-sm font-medium mb-1.5;
        }
        
        .step.active .step-number {
            @apply border-blue-600 bg-blue-600 text-white;
        }
        
        .step.completed .step-number {
            @apply border-green-500 bg-green-500 text-white;
        }
        
        .step-label {
            @apply text-xs font-medium text-gray-500;
        }
        
        .step.active .step-label {
            @apply text-blue-600 font-semibold;
        }
        
        .step.completed .step-label {
            @apply text-green-500;
        }
        
        /* Form error */
        .form-error {
            @apply mt-1 text-xs text-red-600 flex items-start animate-fade-in;
        }
        
        .form-error svg {
            @apply flex-shrink-0 mt-0.5 mr-1.5;
        }
        
        .input-error {
            @apply border-red-500 focus:border-red-500 focus:ring-red-200 animate-shake;
        }
        
        /* Responsive adjustments */
        @media (max-width: 640px) {
            .container {
                @apply px-4;
            }
            
            .card {
                @apply border-0 shadow-none px-0;
            }
            
            .form-input, .form-select {
                @apply py-3 text-base;
            }
            
            .btn {
                @apply py-3.5 text-base;
            }
            
            .stepper {
                @apply mb-6;
            }
            
            .step-label {
                @apply text-[10px];
            }
        }
        
        * {
            box-sizing: border-box;
        }
        
        body {
            font-family: 'Inter', -apple-system, BlinkMacSystemFont, 'Segoe UI', Roboto, sans-serif;
            background: linear-gradient(135deg, var(--primary-600) 0%, var(--primary-800) 50%, var(--primary-950) 100%);
            min-height: 100vh;
            margin: 0;
            padding: 0;
            overflow-x: hidden;
            position: relative;
        }
        
        body::before {
            content: '';
            position: fixed;
            top: 0;
            left: 0;
            right: 0;
            bottom: 0;
            background: 
                radial-gradient(circle at 20% 80%, rgba(120, 119, 198, 0.3) 0%, transparent 50%),
                radial-gradient(circle at 80% 20%, rgba(255, 255, 255, 0.1) 0%, transparent 50%),
                radial-gradient(circle at 40% 40%, rgba(120, 119, 198, 0.2) 0%, transparent 50%);
            pointer-events: none;
            z-index: 0;
        }
        
        .main-container {
            position: relative;
            z-index: 1;
            min-height: 100vh;
            background: linear-gradient(180deg, #f8fbff 0%, #eef6ff 100%);
            padding: calc(2rem + env(safe-area-inset-top)) 1rem calc(2rem + env(safe-area-inset-bottom));
            display: flex;
            align-items: center;
            justify-content: center;
        }
        
        .registration-card {
            background: white;
            border-radius: 1.5rem;
            box-shadow: 0 20px 25px -5px rgba(0, 0, 0, 0.1), 0 10px 10px -5px rgba(0, 0, 0, 0.04);
            width: 100%;
            max-width: 32rem;
            overflow: hidden;
            border: 1px solid rgba(203, 213, 225, 0.3);
            backdrop-filter: blur(10px);
        }
        
        .brand-header {
            background: linear-gradient(135deg, var(--primary-600) 0%, var(--primary-800) 100%);
            padding: 3rem 2rem;
            text-align: center;
            color: white;
            position: relative;
            overflow: hidden;
        }
        
        .brand-header::before {
            content: '';
            position: absolute;
            top: -50%;
            left: -50%;
            right: -50%;
            bottom: -50%;
            background: radial-gradient(circle, rgba(255,255,255,0.1) 0%, transparent 70%);
            transform: rotate(30deg);
        }
        
        .brand-logo {
            width: 5rem;
            height: 5rem;
            margin: 0 auto 1.25rem;
            background: rgba(255, 255, 255, 0.15);
            border-radius: 1.25rem;
            display: flex;
            align-items: center;
            justify-content: center;
            font-size: 2rem;
            position: relative;
            z-index: 1;
            backdrop-filter: blur(5px);
            border: 1px solid rgba(255, 255, 255, 0.2);
        }
        
        .brand-title {
            color: white;
            font-size: 1.75rem;
            font-weight: 700;
            margin: 0 0 0.5rem;
            letter-spacing: -0.025em;
        }
        
        .brand-subtitle {
            color: rgba(255, 255, 255, 0.9);
            font-size: 0.95rem;
            margin: 0;
            font-weight: 400;
        }
        
        .form-container {
            padding: 3rem 2.5rem 2.5rem;
        }
        
        .alert {
            border-radius: 12px;
            padding: 1rem 1.25rem;
            margin-bottom: 1.5rem;
            display: flex;
            align-items: flex-start;
            gap: 0.75rem;
            font-size: 0.875rem;
            line-height: 1.5;
            border: 1px solid;
        }
        
        .alert-success {
            background: var(--success-50);
            border-color: var(--success-200);
            color: var(--success-800);
        }
        
        .alert-error {
            background: var(--error-50);
            border-color: var(--error-200);
            color: var(--error-800);
        }
        
        .alert-icon {
            width: 20px;
            height: 20px;
            flex-shrink: 0;
        }
        
        .stepper {
            display: flex;
            align-items: center;
            justify-content: space-between;
            margin-bottom: 2rem;
            position: relative;
        }
        
        .stepper::before {
            content: '';
            position: absolute;
            top: 20px;
            left: 20px;
            right: 20px;
            height: 2px;
            background: var(--gray-200);
            z-index: 0;
        }
        
        .step {
            display: flex;
            flex-direction: column;
            align-items: center;
            flex: 1;
            position: relative;
            z-index: 1;
        }
        
        .step-number {
            width: 40px;
            height: 40px;
            border-radius: 50%;
            background: white;
            border: 3px solid var(--gray-200);
            display: flex;
            align-items: center;
            justify-content: center;
            font-weight: 600;
            font-size: 0.875rem;
            color: var(--gray-400);
            transition: all 0.3s cubic-bezier(0.4, 0, 0.2, 1);
            position: relative;
        }
        
        .step.active .step-number {
            background: var(--primary-600);
            border-color: var(--primary-600);
            color: white;
            transform: scale(1.1);
            box-shadow: 0 4px 12px rgba(37, 99, 235, 0.4);
        }
        
        .step.completed .step-number {
            background: var(--success-500);
            border-color: var(--success-500);
            color: white;
        }
        
        .step-label {
            margin-top: 0.5rem;
            font-size: 0.75rem;
            font-weight: 500;
            color: var(--gray-500);
            text-align: center;
            transition: color 0.3s ease;
        }
        
        .step.active .step-label {
            color: var(--primary-600);
            font-weight: 600;
        }
        
        .step.completed .step-label {
            color: var(--success-600);
        }
        
        .progress-bar {
            width: 100%;
            height: 6px;
            background: var(--gray-100);
            border-radius: 3px;
            overflow: hidden;
            margin-bottom: 2rem;
        }
        
        .progress-fill {
            height: 100%;
            background: linear-gradient(90deg, var(--primary-500), var(--primary-600));
            border-radius: 3px;
            transition: width 0.5s cubic-bezier(0.4, 0, 0.2, 1);
            position: relative;
        }
        
        .progress-fill::after {
            content: '';
            position: absolute;
            top: 0;
            left: 0;
            right: 0;
            bottom: 0;
            background: linear-gradient(90deg, transparent, rgba(255, 255, 255, 0.3), transparent);
            animation: progress-shine 2s infinite;
        }
        
        @keyframes progress-shine {
            0% { transform: translateX(-100%); }
            100% { transform: translateX(100%); }
        }
        
        .form-group {
            margin-bottom: 1.75rem;
            position: relative;
        }
        
        .form-group label {
            display: block;
            margin-bottom: 0.5rem;
            font-weight: 500;
            color: var(--gray-700);
            font-size: 0.9375rem;
            transition: all 0.2s ease;
        }
        
        .form-group:focus-within label {
            color: var(--primary-600);
        }
        
        .required-asterisk {
            color: var(--error-500);
            margin-left: 2px;
        }
        
        .form-input {
            width: 100%;
            padding: 0.875rem 1.25rem;
            border: 1px solid var(--gray-200);
            border-radius: 0.75rem;
            font-size: 1rem;
            line-height: 1.5;
            color: var(--gray-800);
            background-color: var(--gray-50);
            transition: all 0.3s cubic-bezier(0.4, 0, 0.2, 1);
            box-shadow: 0 1px 2px 0 rgba(0, 0, 0, 0.05);
        }
        
        .form-input:focus {
            outline: none;
            border-color: var(--primary-400);
            box-shadow: 0 0 0 3px rgba(14, 165, 233, 0.15);
            background-color: white;
        }
        
        .form-input::placeholder {
            color: var(--gray-400);
            opacity: 1;
        }
        
        .form-input.error {
            border-color: var(--error-500);
            box-shadow: 0 0 0 3px rgba(239, 68, 68, 0.1);
        }
        
        .btn {
            display: block;
            width: 100%;
            padding: 1rem 1.5rem;
            background: linear-gradient(135deg, var(--primary-500) 0%, var(--primary-700) 100%);
            color: white;
            font-weight: 600;
            letter-spacing: 0.025em;
            border: none;
            border-radius: 0.75rem;
            font-size: 1rem;
            cursor: pointer;
            transition: all 0.3s cubic-bezier(0.4, 0, 0.2, 1);
            text-align: center;
            position: relative;
            overflow: hidden;
            box-shadow: 0 4px 6px -1px rgba(0, 0, 0, 0.1), 0 2px 4px -1px rgba(0, 0, 0, 0.06);
        }
        
        .btn:hover {
            background: linear-gradient(135deg, var(--primary-600) 0%, var(--primary-800) 100%);
            transform: translateY(-2px);
            box-shadow: 0 10px 15px -3px rgba(0, 0, 0, 0.1), 0 4px 6px -2px rgba(0, 0, 0, 0.05);
        }
        
        .btn:active {
            transform: translateY(0);
        }
        
        .btn::before {
            content: '';
            position: absolute;
            top: 0;
            left: 0;
            right: 0;
            bottom: 0;
            background: linear-gradient(135deg, rgba(255,255,255,0.2) 0%, transparent 100%);
            opacity: 0;
            transition: opacity 0.3s ease;
        }
        
        .btn:hover::before {
            opacity: 1;
        }
        
        .footer-links {
            padding: 1.5rem 2.5rem;
            text-align: center;
            border-top: 1px solid var(--gray-200);
            background-color: var(--gray-50);
        }
        
        .footer-text {
            font-size: 0.875rem;
            color: var(--gray-500);
            margin: 0;
            line-height: 1.5;
        }
        
        .footer-links a {
            color: var(--primary-600);
            font-weight: 500;
            text-decoration: none;
            transition: color 0.2s ease;
        }
        
        .footer-links a:hover {
            color: var(--primary-700);
            text-decoration: underline;
        }
        
        /* Responsive Design */
        @media (max-width: 640px) {
            .main-container {
                padding: calc(1rem + env(safe-area-inset-top)) 1rem calc(1rem + env(safe-area-inset-bottom));
            }
            
            .registration-card {
                border-radius: 1rem;
            }
            
            .form-container {
                padding: 2rem 1.5rem;
            }
            
            .brand-header {
                padding: 2rem 1.5rem;
            }
            
            .brand-logo {
                width: 4rem;
                height: 4rem;
                font-size: 1.75rem;
                grid-template-columns: 1fr;
            }
            
            .requirements-list {
                grid-template-columns: 1fr;
            }
            
            .button-group {
                flex-direction: column;
            }
            
            .btn-flex {
                width: 100%;
            }
            
            .step-label {
                font-size: 0.65rem;
            }
        }
        
        /* Dark mode support */
        @media (prefers-color-scheme: dark) {
            .registration-card {
                background: rgba(30, 41, 59, 0.95);
                border-color: rgba(255, 255, 255, 0.1);
            }
            
            .form-container {
                color: white;
            }
            
            .form-input, .form-select {
                background: rgba(51, 65, 85, 0.8);
                border-color: rgba(148, 163, 184, 0.3);
                color: white;
            }
            
            .form-label {
                color: rgba(248, 250, 252, 0.9);
            }
        }
        
        /* Accessibility */
        @media (prefers-reduced-motion: reduce) {
            *, *::before, *::after {
                animation-duration: 0.01ms !important;
                animation-iteration-count: 1 !important;
                transition-duration: 0.01ms !important;
            }
        }
        
        /* Focus styles for keyboard navigation */
        .btn:focus-visible,
        .form-input:focus-visible,
        .form-select:focus-visible,
        .business-type-option:focus-visible {
            outline: 2px solid var(--primary-500);
            outline-offset: 2px;
        }
        /* App-mode install banner */
        .app-install-banner {
            position: fixed;
            left: 0; right: 0; bottom: 0;
            padding: calc(0.75rem + env(safe-area-inset-bottom)) 1rem 1rem;
            background: rgba(15, 23, 42, 0.95);
            color: white;
            display: none;
            z-index: 50;
            backdrop-filter: saturate(180%) blur(10px);
        }
        .app-install-banner.show { display: block; }
        .app-install-banner .btn-install {
            background: #0d79c7; color: white; border: 0;
            padding: 0.75rem 1rem; border-radius: 0.75rem; font-weight: 600;
        }
        .app-install-banner .btn-install:active { opacity: 0.9; }
    </style>
    
    <script>
        tailwind.config = {
            theme: {
                extend: {
                    colors: {
                        primary: {
                            50: '#e6f4ff',
                            100: '#cce9ff',
                            200: '#99d3ff',
                            300: '#66beff',
                            400: '#33a8ff',
                            500: '#008cff',
                            600: '#0077e6',
                            700: '#0063c7',
                            800: '#004f9e',
                            900: '#103b73',
                            950: '#0c2c56'
                        },
                        brand: { 50:'#eef8ff',100:'#d8efff',200:'#b2e0ff',300:'#84ccff',400:'#46b3ff',500:'#1b97f0',600:'#0d79c7',700:'#0c62a1',800:'#0c4f82',900:'#0c426c' }
                    },
                    fontFamily: {
                        sans: ['Inter', 'system-ui', 'sans-serif'],
                        mono: ['JetBrains Mono', 'monospace']
                    }
                }
            }
        }
    </script>
</head>
<body>
    <!-- App-mode detection banner (Install PWA) -->
    <?php include __DIR__ . '/../partials/pwa_install_banner.php'; ?>
    <?php include __DIR__ . '/../partials/public_header.php'; ?>
    <div class="main-container">
        <div class="container-2col mx-auto w-full max-w-6xl grid grid-cols-1 lg:grid-cols-2 gap-6 items-start">
            <!-- Left: Credibility / Brand Panel -->
            <aside class="hidden lg:block">
                <div class="rounded-2xl border border-gray-200 bg-white shadow-sm overflow-hidden sticky top-6">
                    <div class="px-6 py-5 bg-gradient-to-r from-primary-500 to-primary-600 text-white flex items-center gap-4">
                        <div class="h-10 w-10 rounded-xl bg-white/20 flex items-center justify-center">
                            <i class="fas fa-briefcase text-white"></i>
                        </div>
                        <div>
                            <div class="text-base font-semibold tracking-wide">B2B Thai Hub — Empowering Travel Businesses Since 2015</div>
                            <div class="text-xs opacity-90">Trusted partner for agencies, OTAs, and travel entrepreneurs</div>
                        </div>
                    </div>
                    <div class="p-6">
                        <div class="grid grid-cols-1 sm:grid-cols-2 gap-4 text-sm">
                            <div class="flex items-start gap-3">
                                <i class="fas fa-shield-alt text-primary-600 mt-0.5"></i>
                                <div>
                                    <div class="font-medium text-gray-800">Secure 256‑bit SSL</div>
                                    <div class="text-gray-500">Bank‑grade encryption</div>
                                </div>
                            </div>
                            <div class="flex items-start gap-3">
                                <i class="fas fa-users text-primary-600 mt-0.5"></i>
                                <div>
                                    <div class="font-medium text-gray-800">500+ partner agencies</div>
                                    <div class="text-gray-500">Across APAC and MEA</div>
                                </div>
                            </div>
                            <div class="flex items-start gap-3">
                                <i class="fas fa-medal text-primary-600 mt-0.5"></i>
                                <div>
                                    <div class="font-medium text-gray-800">10+ years of reliability</div>
                                    <div class="text-gray-500">Enterprise‑grade uptime</div>
                                </div>
                            </div>
                            <div class="flex items-start gap-3">
                                <i class="fas fa-headset text-primary-600 mt-0.5"></i>
                                <div>
                                    <div class="font-medium text-gray-800">Priority onboarding</div>
                                    <div class="text-gray-500">Dedicated support team</div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </aside>

            <!-- Right: Registration Card -->
            <div class="registration-card">
                <!-- Form Container -->
                <div class="form-container">
                <?php
                $errors = $_SESSION['errors'] ?? [];
                if (isset($_SESSION['errors'])) unset($_SESSION['errors']);
                $flash = $_SESSION['flash'] ?? '';
                if (isset($_SESSION['flash'])) unset($_SESSION['flash']);
                ?>
                
                <!-- Flash Messages -->
                <?php if ($flash): ?>
                    <div class="alert alert-success">
                        <i class="fas fa-check-circle alert-icon"></i>
                        <span><?= htmlspecialchars($flash, ENT_QUOTES, 'UTF-8') ?></span>
                    </div>
                <?php endif; ?>
                
                <!-- Error Messages -->
                <?php if (!empty($errors)): ?>
                    <div class="alert alert-error">
                        <i class="fas fa-exclamation-triangle alert-icon"></i>
                        <div>
                            <div class="font-medium">Registration failed</div>
                            <ul class="mt-1 space-y-1">
                                <?php foreach ($errors as $error): ?>
                                    <li><?= htmlspecialchars($error, ENT_QUOTES, 'UTF-8') ?></li>
                                <?php endforeach; ?>
                            </ul>
                        </div>
                    </div>
                <?php endif; ?>

                <!-- Stepper -->
                <div class="stepper mb-8">
                    <div class="step active" id="step1-indicator">
                        <div class="step-number">1</div>
                        <div class="step-label">Account Info</div>
                    </div>
                    <div class="step" id="step2-indicator">
                        <div class="step-number">2</div>
                        <div class="step-label">Business Info</div>
                    </div>
                    <div class="step" id="step3-indicator">
                        <div class="step-number">3</div>
                        <div class="step-label">Complete</div>
                    </div>
                </div>
                
                <!-- Progress Bar -->
                <div class="w-full bg-gray-200 rounded-full h-1.5 mb-8">
                    <div id="progress-bar" class="bg-blue-600 h-1.5 rounded-full transition-all duration-300" style="width: 33.33%"></div>
                </div>
                
                <form id="registration-form" action="/agent/register" method="POST" class="space-y-5" autocomplete="on">
                    <input type="hidden" name="csrf" value="<?= htmlspecialchars($csrf ?? '', ENT_QUOTES, 'UTF-8') ?>">
                    <input type="hidden" name="step" value="1">
                    
                    <!-- Step 1: Account Information -->
                    <div id="step-1" class="step-content">
                        <div class="space-y-5">
                            <!-- Country -->
                            <div class="form-group">
                                <label for="country" class="block text-sm font-medium text-gray-700 mb-1.5">
                                    Country <span class="text-red-500">*</span>
                                </label>
                                <select id="country" name="country" required
                                    class="form-input w-full">
                                    <option value="">Select your country</option>
                                    <option value="AF">Afghanistan</option>
                                    <option value="AL">Albania</option>
                                    <option value="DZ">Algeria</option>
                                    <option value="AS">American Samoa</option>
                                    <option value="AD">Andorra</option>
                                    <option value="AO">Angola</option>
                                    <option value="AI">Anguilla</option>
                                    <option value="AR">Argentina</option>
                                    <option value="AM">Armenia</option>
                                    <option value="AW">Aruba</option>
                                    <option value="AU">Australia</option>
                                    <option value="AT">Austria</option>
                                    <option value="AZ">Azerbaijan</option>
                                    <option value="BS">Bahamas</option>
                                    <option value="BH">Bahrain</option>
                                    <option value="BD">Bangladesh</option>
                                    <option value="BB">Barbados</option>
                                    <option value="BY">Belarus</option>
                                    <option value="BE">Belgium</option>
                                    <option value="BZ">Belize</option>
                                    <option value="BJ">Benin</option>
                                    <option value="BM">Bermuda</option>
                                    <option value="BT">Bhutan</option>
                                    <option value="BO">Bolivia</option>
                                    <option value="BA">Bosnia and Herzegovina</option>
                                    <option value="BW">Botswana</option>
                                    <option value="BR">Brazil</option>
                                    <option value="BN">Brunei</option>
                                    <option value="BG">Bulgaria</option>
                                    <option value="BF">Burkina Faso</option>
                                    <option value="BI">Burundi</option>
                                    <option value="KH">Cambodia</option>
                                    <option value="CM">Cameroon</option>
                                    <option value="CA">Canada</option>
                                    <option value="CV">Cape Verde</option>
                                    <option value="KY">Cayman Islands</option>
                                    <option value="CF">Central African Republic</option>
                                    <option value="TD">Chad</option>
                                    <option value="CL">Chile</option>
                                    <option value="CN">China</option>
                                    <option value="CO">Colombia</option>
                                    <option value="KM">Comoros</option>
                                    <option value="CG">Congo</option>
                                    <option value="CD">Congo (DRC)</option>
                                    <option value="CR">Costa Rica</option>
                                    <option value="CI">Côte d'Ivoire</option>
                                    <option value="HR">Croatia</option>
                                    <option value="CU">Cuba</option>
                                    <option value="CY">Cyprus</option>
                                    <option value="CZ">Czech Republic</option>
                                    <option value="DK">Denmark</option>
                                    <option value="DJ">Djibouti</option>
                                    <option value="DM">Dominica</option>
                                    <option value="DO">Dominican Republic</option>
                                    <option value="EC">Ecuador</option>
                                    <option value="EG">Egypt</option>
                                    <option value="SV">El Salvador</option>
                                    <option value="GQ">Equatorial Guinea</option>
                                    <option value="ER">Eritrea</option>
                                    <option value="EE">Estonia</option>
                                    <option value="ET">Ethiopia</option>
                                    <option value="FJ">Fiji</option>
                                    <option value="FI">Finland</option>
                                    <option value="FR">France</option>
                                    <option value="GA">Gabon</option>
                                    <option value="GM">Gambia</option>
                                    <option value="GE">Georgia</option>
                                    <option value="DE">Germany</option>
                                    <option value="GH">Ghana</option>
                                    <option value="GR">Greece</option>
                                    <option value="GD">Grenada</option>
                                    <option value="GT">Guatemala</option>
                                    <option value="GN">Guinea</option>
                                    <option value="GW">Guinea-Bissau</option>
                                    <option value="GY">Guyana</option>
                                    <option value="HT">Haiti</option>
                                    <option value="HN">Honduras</option>
                                    <option value="HK">Hong Kong</option>
                                    <option value="HU">Hungary</option>
                                    <option value="IS">Iceland</option>
                                    <option value="IN">India</option>
                                    <option value="ID">Indonesia</option>
                                    <option value="IR">Iran</option>
                                    <option value="IQ">Iraq</option>
                                    <option value="IE">Ireland</option>
                                    <option value="IL">Israel</option>
                                    <option value="IT">Italy</option>
                                    <option value="JM">Jamaica</option>
                                    <option value="JP">Japan</option>
                                    <option value="JO">Jordan</option>
                                    <option value="KZ">Kazakhstan</option>
                                    <option value="KE">Kenya</option>
                                    <option value="KI">Kiribati</option>
                                    <option value="KR">Korea, South</option>
                                    <option value="KW">Kuwait</option>
                                    <option value="KG">Kyrgyzstan</option>
                                    <option value="LA">Laos</option>
                                    <option value="LV">Latvia</option>
                                    <option value="LB">Lebanon</option>
                                    <option value="LS">Lesotho</option>
                                    <option value="LR">Liberia</option>
                                    <option value="LY">Libya</option>
                                    <option value="LI">Liechtenstein</option>
                                    <option value="LT">Lithuania</option>
                                    <option value="LU">Luxembourg</option>
                                    <option value="MG">Madagascar</option>
                                    <option value="MW">Malawi</option>
                                    <option value="MY">Malaysia</option>
                                    <option value="MV">Maldives</option>
                                    <option value="ML">Mali</option>
                                    <option value="MT">Malta</option>
                                    <option value="MH">Marshall Islands</option>
                                    <option value="MR">Mauritania</option>
                                    <option value="MU">Mauritius</option>
                                    <option value="MX">Mexico</option>
                                    <option value="FM">Micronesia</option>
                                    <option value="MD">Moldova</option>
                                    <option value="MC">Monaco</option>
                                    <option value="MN">Mongolia</option>
                                    <option value="ME">Montenegro</option>
                                    <option value="MA">Morocco</option>
                                    <option value="MZ">Mozambique</option>
                                    <option value="MM">Myanmar</option>
                                    <option value="NA">Namibia</option>
                                    <option value="NR">Nauru</option>
                                    <option value="NP">Nepal</option>
                                    <option value="NL">Netherlands</option>
                                    <option value="NZ">New Zealand</option>
                                    <option value="NI">Nicaragua</option>
                                    <option value="NE">Niger</option>
                                    <option value="NG">Nigeria</option>
                                    <option value="MK">North Macedonia</option>
                                    <option value="NO">Norway</option>
                                    <option value="OM">Oman</option>
                                    <option value="PK">Pakistan</option>
                                    <option value="PW">Palau</option>
                                    <option value="PA">Panama</option>
                                    <option value="PG">Papua New Guinea</option>
                                    <option value="PY">Paraguay</option>
                                    <option value="PE">Peru</option>
                                    <option value="PH">Philippines</option>
                                    <option value="PL">Poland</option>
                                    <option value="PT">Portugal</option>
                                    <option value="QA">Qatar</option>
                                    <option value="RO">Romania</option>
                                    <option value="RU">Russia</option>
                                    <option value="RW">Rwanda</option>
                                    <option value="KN">Saint Kitts and Nevis</option>
                                    <option value="LC">Saint Lucia</option>
                                    <option value="WS">Samoa</option>
                                    <option value="SM">San Marino</option>
                                    <option value="ST">Sao Tome and Principe</option>
                                    <option value="SA">Saudi Arabia</option>
                                    <option value="SN">Senegal</option>
                                    <option value="RS">Serbia</option>
                                    <option value="SC">Seychelles</option>
                                    <option value="SL">Sierra Leone</option>
                                    <option value="SG">Singapore</option>
                                    <option value="SK">Slovakia</option>
                                    <option value="SI">Slovenia</option>
                                    <option value="SB">Solomon Islands</option>
                                    <option value="SO">Somalia</option>
                                    <option value="ZA">South Africa</option>
                                    <option value="SS">South Sudan</option>
                                    <option value="ES">Spain</option>
                                    <option value="LK">Sri Lanka</option>
                                    <option value="SD">Sudan</option>
                                    <option value="SR">Suriname</option>
                                    <option value="SE">Sweden</option>
                                    <option value="CH">Switzerland</option>
                                    <option value="TW">Taiwan</option>
                                    <option value="TJ">Tajikistan</option>
                                    <option value="TZ">Tanzania</option>
                                    <option value="TH" selected>Thailand</option>
                                    <option value="TL">Timor-Leste</option>
                                    <option value="TG">Togo</option>
                                    <option value="TO">Tonga</option>
                                    <option value="TT">Trinidad and Tobago</option>
                                    <option value="TN">Tunisia</option>
                                    <option value="TR">Turkey</option>
                                    <option value="TM">Turkmenistan</option>
                                    <option value="TV">Tuvalu</option>
                                    <option value="UG">Uganda</option>
                                    <option value="UA">Ukraine</option>
                                    <option value="AE">United Arab Emirates</option>
                                    <option value="GB">United Kingdom</option>
                                    <option value="US">United States</option>
                                    <option value="UY">Uruguay</option>
                                    <option value="UZ">Uzbekistan</option>
                                    <option value="VU">Vanuatu</option>
                                    <option value="VA">Vatican City</option>
                                    <option value="VE">Venezuela</option>
                                    <option value="VN">Vietnam</option>
                                    <option value="YE">Yemen</option>
                                    <option value="ZM">Zambia</option>
                                    <option value="ZW">Zimbabwe</option>
                                </select>
                            </div>

                            <!-- Full Name -->
                            <div class="form-group">
                                <label for="name" class="block text-sm font-medium text-gray-700 mb-1.5">
                                    Full Name <span class="text-red-500">*</span>
                                </label>
                                <input type="text" id="name" name="name" required
                                    class="form-input"
                                    placeholder="John Doe"
                                    autocomplete="name"
                                    autofocus>
                                <div id="name-error" class="form-error hidden">
                                    <svg class="h-4 w-4" fill="currentColor" viewBox="0 0 20 20">
                                        <path fill-rule="evenodd" d="M18 10a8 8 0 11-16 0 8 8 0 0116 0zm-7 4a1 1 0 11-2 0 1 1 0 012 0zm-1-9a1 1 0 00-1 1v4a1 1 0 102 0V6a1 1 0 00-1-1z" clip-rule="evenodd" />
                                    </svg>
                                    <span>Please enter your full name</span>
                                </div>
                            </div>
                            
                            <!-- Email -->
                            <div class="form-group">
                                <label for="email" class="block text-sm font-medium text-gray-700 mb-1.5">
                                    Email <span class="text-red-500">*</span>
                                </label>
                                <input type="email" id="email" name="email" required
                                    class="form-input"
                                    placeholder="you@example.com"
                                    autocomplete="email">
                                <div id="email-error" class="form-error hidden">
                                    <svg class="h-4 w-4" fill="currentColor" viewBox="0 0 20 20">
                                        <path fill-rule="evenodd" d="M18 10a8 8 0 11-16 0 8 8 0 0116 0zm-7 4a1 1 0 11-2 0 1 1 0 012 0zm-1-9a1 1 0 00-1 1v4a1 1 0 102 0V6a1 1 0 00-1-1z" clip-rule="evenodd" />
                                    </svg>
                                    <span>Please enter a valid email address</span>
                                </div>
                            </div>
                            
                            <!-- Password -->
                            <div class="form-group">
                                <label for="password" class="block text-sm font-medium text-gray-700 mb-1.5">
                                    Password <span class="text-red-500">*</span>
                                    <span id="password-strength-text" class="float-right text-xs font-normal"></span>
                                </label>
                                <div class="relative">
                                    <input type="password" id="password" name="password" required
                                        class="form-input pr-10"
                                        placeholder="••••••••"
                                        autocomplete="new-password"
                                        minlength="8">
                                    <button type="button" 
                                        class="absolute inset-y-0 right-0 pr-3 flex items-center text-gray-400 hover:text-gray-600"
                                        onclick="togglePasswordVisibility('password')"
                                        aria-label="Toggle password visibility">
                                        <i id="password-toggle-icon" class="fas fa-eye"></i>
                                    </button>
                                </div>
                                
                                <!-- Password strength meter -->
                                <div class="password-strength mt-2">
                                    <div id="password-strength-bar" class="password-strength-bar"></div>
                                </div>
                                
                                <!-- Password requirements -->
                                <div class="mt-3 space-y-1.5">
                                    <p class="text-xs text-gray-500">Password must contain:</p>
                                    <ul class="text-xs space-y-1">
                                        <li id="req-length" class="text-gray-500 flex items-center">
                                            <i id="req-length-icon" class="fas fa-circle text-[6px] mr-2"></i>
                                            <span>At least 8 characters</span>
                                        </li>
                                        <li id="req-uppercase" class="text-gray-500 flex items-center">
                                            <i id="req-uppercase-icon" class="fas fa-circle text-[6px] mr-2"></i>
                                            <span>At least 1 uppercase letter</span>
                                        </li>
                                        <li id="req-number" class="text-gray-500 flex items-center">
                                            <i id="req-number-icon" class="fas fa-circle text-[6px] mr-2"></i>
                                            <span>At least 1 number</span>
                                        </li>
                                        <li id="req-special" class="text-gray-500 flex items-center">
                                            <i id="req-special-icon" class="fas fa-circle text-[6px] mr-2"></i>
                                            <span>At least 1 special character</span>
                                        </li>
                                    </ul>
                                </div>
                                
                                <div id="password-error" class="form-error hidden">
                                    <svg class="h-4 w-4" fill="currentColor" viewBox="0 0 20 20">
                                        <path fill-rule="evenodd" d="M18 10a8 8 0 11-16 0 8 8 0 0116 0zm-7 4a1 1 0 11-2 0 1 1 0 012 0zm-1-9a1 1 0 00-1 1v4a1 1 0 102 0V6a1 1 0 00-1-1z" clip-rule="evenodd" />
                                    </svg>
                                    <span>Password must be at least 8 characters long</span>
                                </div>
                            </div>
                            
                            <!-- Confirm Password -->
                            <div class="form-group">
                                <label for="confirm-password" class="block text-sm font-medium text-gray-700 mb-1.5">
                                    Confirm Password <span class="text-red-500">*</span>
                                </label>
                                <div class="relative">
                                    <input type="password" id="confirm-password" name="password_confirm" required
                                        class="form-input pr-10"
                                        placeholder="••••••••"
                                        autocomplete="new-password">
                                    <button type="button" 
                                        class="absolute inset-y-0 right-0 pr-3 flex items-center text-gray-400 hover:text-gray-600"
                                        onclick="togglePasswordVisibility('confirm-password')"
                                        aria-label="Toggle password visibility">
                                        <i id="confirm-password-toggle-icon" class="fas fa-eye"></i>
                                    </button>
                                </div>
                                <div id="confirm-password-error" class="form-error hidden">
                                    <svg class="h-4 w-4" fill="currentColor" viewBox="0 0 20 20">
                                        <path fill-rule="evenodd" d="M18 10a8 8 0 11-16 0 8 8 0 0116 0zm-7 4a1 1 0 11-2 0 1 1 0 012 0zm-1-9a1 1 0 00-1 1v4a1 1 0 102 0V6a1 1 0 00-1-1z" clip-rule="evenodd" />
                                    </svg>
                                    <span>Passwords do not match</span>
                                </div>
                            </div>
                            
                            <!-- Terms and Conditions -->
                            <div class="flex items-start mt-4">
                                <div class="flex items-center h-5">
                                    <input id="terms" name="terms" type="checkbox" required
                                        class="h-4 w-4 text-blue-600 focus:ring-blue-500 border-gray-300 rounded">
                                </div>
                                <div class="ml-3 text-sm">
                                    <label for="terms" class="font-medium text-gray-700">
                                        I agree to the <a href="/terms" class="text-blue-600 hover:text-blue-500">Terms of Service</a> and 
                                        <a href="/privacy" class="text-blue-600 hover:text-blue-500">Privacy Policy</a>
                                    </label>
                                    <div id="terms-error" class="form-error hidden mt-1">
                                        <svg class="h-4 w-4" fill="currentColor" viewBox="0 0 20 20">
                                            <path fill-rule="evenodd" d="M18 10a8 8 0 11-16 0 8 8 0 0116 0zm-7 4a1 1 0 11-2 0 1 1 0 012 0zm-1-9a1 1 0 00-1 1v4a1 1 0 102 0V6a1 1 0 00-1-1z" clip-rule="evenodd" />
                                        </svg>
                                        <span>You must accept the terms and conditions</span>
                                    </div>
                                </div>
                            </div>
                            
                            <!-- Next Button -->
                            <div class="pt-2">
                                <button type="button" id="next-btn" 
                                    class="w-full flex justify-center items-center py-3 px-4 border border-transparent rounded-md shadow-sm text-sm font-medium text-white bg-blue-600 hover:bg-blue-700 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-blue-500">
                                    <span class="btn-text">Continue to Business Info</span>
                                    <svg id="next-btn-spinner" class="animate-spin -mr-1 ml-2 h-5 w-5 text-white hidden" xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24">
                                        <circle class="opacity-25" cx="12" cy="12" r="10" stroke="currentColor" stroke-width="4"></circle>
                                        <path class="opacity-75" fill="currentColor" d="M4 12a8 8 0 018-8V0C5.373 0 0 5.373 0 12h4zm2 5.291A7.962 7.962 0 014 12H0c0 3.042 1.135 5.824 3 7.938l3-2.647z"></path>
                                    </svg>
                                </button>
                            </div>
                        </div>
                    </div>
                    
                    <!-- Step 2: Business Information (initially hidden) -->
                    <div id="step-2" class="step-content hidden">
                        <div class="space-y-5">
                            <!-- Business Type -->
                            <div class="form-group">
                                <label class="block text-sm font-medium text-gray-700 mb-2">
                                    Business Type <span class="text-red-500">*</span>
                                </label>
                                <div class="grid grid-cols-2 gap-3">
                                    <div>
                                        <input type="radio" id="business-type-freelancer" name="business_type" value="freelancer" class="sr-only" required>
                                        <label for="business-type-freelancer" class="business-type-option">
                                            <i class="fas fa-user text-blue-500 text-xl mb-2"></i>
                                            <span>Freelancer</span>
                                        </label>
                                    </div>
                                    <div>
                                        <input type="radio" id="business-type-sole" name="business_type" value="sole_proprietor" class="sr-only">
                                        <label for="business-type-sole" class="business-type-option">
                                            <i class="fas fa-id-card text-blue-500 text-xl mb-2"></i>
                                            <span>Sole Proprietor</span>
                                        </label>
                                    </div>
                                    <div>
                                        <input type="radio" id="business-type-partnership" name="business_type" value="partnership" class="sr-only">
                                        <label for="business-type-partnership" class="business-type-option">
                                            <i class="fas fa-people-arrows text-blue-500 text-xl mb-2"></i>
                                            <span>Partnership/LLP</span>
                                        </label>
                                    </div>
                                    <div>
                                        <input type="radio" id="business-type-company" name="business_type" value="company" class="sr-only">
                                        <label for="business-type-company" class="business-type-option">
                                            <i class="fas fa-building text-blue-500 text-xl mb-2"></i>
                                            <span>Company</span>
                                        </label>
                                    </div>
                                </div>
                                <div id="business-type-error" class="form-error hidden mt-1">
                                    <svg class="h-4 w-4" fill="currentColor" viewBox="0 0 20 20">
                                        <path fill-rule="evenodd" d="M18 10a8 8 0 11-16 0 8 8 0 0116 0zm-7 4a1 1 0 11-2 0 1 1 0 012 0zm-1-9a1 1 0 00-1 1v4a1 1 0 102 0V6a1 1 0 00-1-1z" clip-rule="evenodd" />
                                    </svg>
                                    <span>Please select a business type</span>
                                </div>
                                <!-- Business Type Description -->
                                <div id="business-type-description" class="mt-3 p-3 bg-blue-50 border border-blue-100 rounded-md text-sm text-gray-700 hidden">
                                    <p>You selected: <span id="selected-business-type" class="font-medium"></span></p>
                                    <p class="mt-1 text-xs text-blue-600">Note: KYC verification will be required after email verification</p>
                                </div>
                            </div>
                            
                            <!-- Company/Agency (Conditional when not freelancer) -->
                            <div id="business-name-group" class="form-group hidden">
                                <label for="business-name" class="block text-sm font-medium text-gray-700 mb-1.5">
                                    Company / Agency Name <span class="text-red-500">*</span>
                                </label>
                                <input type="text" id="business-name" name="agent_company"
                                    class="form-input"
                                    placeholder="Your company or agency">
                                <div id="business-name-error" class="form-error hidden">
                                    <svg class="h-4 w-4" fill="currentColor" viewBox="0 0 20 20">
                                        <path fill-rule="evenodd" d="M18 10a8 8 0 11-16 0 8 8 0 0116 0zm-7 4a1 1 0 11-2 0 1 1 0 012 0zm-1-9a1 1 0 00-1 1v4a1 1 0 102 0V6a1 1 0 00-1-1z" clip-rule="evenodd" />
                                    </svg>
                                    <span>Please enter your company/agency</span>
                                </div>
                            </div>
                            
                            <!-- WhatsApp Number -->
                            <div class="form-group">
                                <label for="phone" class="block text-sm font-medium text-gray-700 mb-1.5">
                                    WhatsApp Number <span class="text-red-500">*</span>
                                </label>
                                <div class="flex gap-2">
                                    <select id="phone-country" class="form-select w-32" aria-label="Country code">
                                        <?php 
                                        $countryNames = [
                                            'AF' => 'Afghanistan', 'AL' => 'Albania', 'DZ' => 'Algeria', 'AS' => 'American Samoa', 'AD' => 'Andorra',
                                            'AO' => 'Angola', 'AI' => 'Anguilla', 'AQ' => 'Antarctica', 'AG' => 'Antigua and Barbuda', 'AR' => 'Argentina',
                                            'AM' => 'Armenia', 'AW' => 'Aruba', 'AU' => 'Australia', 'AT' => 'Austria', 'AZ' => 'Azerbaijan',
                                            'BS' => 'Bahamas', 'BH' => 'Bahrain', 'BD' => 'Bangladesh', 'BB' => 'Barbados', 'BY' => 'Belarus',
                                            'BE' => 'Belgium', 'BZ' => 'Belize', 'BJ' => 'Benin', 'BM' => 'Bermuda', 'BT' => 'Bhutan',
                                            'BO' => 'Bolivia', 'BA' => 'Bosnia and Herzegovina', 'BW' => 'Botswana', 'BR' => 'Brazil', 'IO' => 'British Indian Ocean Territory',
                                            'BN' => 'Brunei Darussalam', 'BG' => 'Bulgaria', 'BF' => 'Burkina Faso', 'BI' => 'Burundi', 'KH' => 'Cambodia',
                                            'CM' => 'Cameroon', 'CA' => 'Canada', 'CV' => 'Cape Verde', 'KY' => 'Cayman Islands', 'CF' => 'Central African Republic',
                                            'TD' => 'Chad', 'CL' => 'Chile', 'CN' => 'China', 'CX' => 'Christmas Island', 'CC' => 'Cocos (Keeling) Islands',
                                            'CO' => 'Colombia', 'KM' => 'Comoros', 'CD' => 'Congo, Democratic Republic of the', 'CG' => 'Congo, Republic of the', 'CK' => 'Cook Islands',
                                            'CR' => 'Costa Rica', 'CI' => "Côte d'Ivoire", 'HR' => 'Croatia', 'CU' => 'Cuba', 'CY' => 'Cyprus',
                                            'CZ' => 'Czech Republic', 'DK' => 'Denmark', 'DJ' => 'Djibouti', 'DM' => 'Dominica', 'DO' => 'Dominican Republic',
                                            'EC' => 'Ecuador', 'EG' => 'Egypt', 'SV' => 'El Salvador', 'GQ' => 'Equatorial Guinea', 'ER' => 'Eritrea',
                                            'EE' => 'Estonia', 'ET' => 'Ethiopia', 'FK' => 'Falkland Islands (Malvinas)', 'FO' => 'Faroe Islands', 'FJ' => 'Fiji',
                                            'FI' => 'Finland', 'FR' => 'France', 'GF' => 'French Guiana', 'PF' => 'French Polynesia', 'GA' => 'Gabon',
                                            'GM' => 'Gambia', 'GE' => 'Georgia', 'DE' => 'Germany', 'GH' => 'Ghana', 'GI' => 'Gibraltar',
                                            'GR' => 'Greece', 'GL' => 'Greenland', 'GD' => 'Grenada', 'GP' => 'Guadeloupe', 'GU' => 'Guam',
                                            'GT' => 'Guatemala', 'GG' => 'Guernsey', 'GN' => 'Guinea', 'GW' => 'Guinea-Bissau', 'GY' => 'Guyana',
                                            'HT' => 'Haiti', 'VA' => 'Holy See (Vatican City State)', 'HN' => 'Honduras', 'HK' => 'Hong Kong', 'HU' => 'Hungary',
                                            'IS' => 'Iceland', 'IN' => 'India', 'ID' => 'Indonesia', 'IR' => 'Iran, Islamic Republic of', 'IQ' => 'Iraq',
                                            'IE' => 'Ireland', 'IM' => 'Isle of Man', 'IL' => 'Israel', 'IT' => 'Italy', 'JM' => 'Jamaica',
                                            'JP' => 'Japan', 'JE' => 'Jersey', 'JO' => 'Jordan', 'KZ' => 'Kazakhstan', 'KE' => 'Kenya',
                                            'KI' => 'Kiribati', 'KP' => "Korea, Democratic People's Republic of", 'KR' => 'Korea, Republic of', 'KW' => 'Kuwait', 'KG' => 'Kyrgyzstan',
                                            'LA' => "Lao People's Democratic Republic", 'LV' => 'Latvia', 'LB' => 'Lebanon', 'LS' => 'Lesotho', 'LR' => 'Liberia',
                                            'LY' => 'Libya', 'LI' => 'Liechtenstein', 'LT' => 'Lithuania', 'LU' => 'Luxembourg', 'MO' => 'Macao',
                                            'MK' => 'North Macedonia', 'MG' => 'Madagascar', 'MW' => 'Malawi', 'MY' => 'Malaysia', 'MV' => 'Maldives',
                                            'ML' => 'Mali', 'MT' => 'Malta', 'MH' => 'Marshall Islands', 'MQ' => 'Martinique', 'MR' => 'Mauritania',
                                            'MU' => 'Mauritius', 'YT' => 'Mayotte', 'MX' => 'Mexico', 'FM' => 'Micronesia, Federated States of', 'MD' => 'Moldova, Republic of',
                                            'MC' => 'Monaco', 'MN' => 'Mongolia', 'ME' => 'Montenegro', 'MS' => 'Montserrat', 'MA' => 'Morocco',
                                            'MZ' => 'Mozambique', 'MM' => 'Myanmar', 'NA' => 'Namibia', 'NR' => 'Nauru', 'NP' => 'Nepal',
                                            'NL' => 'Netherlands', 'NC' => 'New Caledonia', 'NZ' => 'New Zealand', 'NI' => 'Nicaragua', 'NE' => 'Niger',
                                            'NG' => 'Nigeria', 'NU' => 'Niue', 'NF' => 'Norfolk Island', 'MP' => 'Northern Mariana Islands', 'NO' => 'Norway',
                                            'OM' => 'Oman', 'PK' => 'Pakistan', 'PW' => 'Palau', 'PS' => 'Palestine, State of', 'PA' => 'Panama',
                                            'PG' => 'Papua New Guinea', 'PY' => 'Paraguay', 'PE' => 'Peru', 'PH' => 'Philippines', 'PN' => 'Pitcairn',
                                            'PL' => 'Poland', 'PT' => 'Portugal', 'PR' => 'Puerto Rico', 'QA' => 'Qatar', 'RE' => 'Réunion',
                                            'RO' => 'Romania', 'RU' => 'Russian Federation', 'RW' => 'Rwanda', 'BL' => 'Saint Barthélemy', 'SH' => 'Saint Helena, Ascension and Tristan da Cunha',
                                            'KN' => 'Saint Kitts and Nevis', 'LC' => 'Saint Lucia', 'MF' => 'Saint Martin (French part)', 'PM' => 'Saint Pierre and Miquelon', 'VC' => 'Saint Vincent and the Grenadines',
                                            'WS' => 'Samoa', 'SM' => 'San Marino', 'ST' => 'Sao Tome and Principe', 'SA' => 'Saudi Arabia', 'SN' => 'Senegal',
                                            'RS' => 'Serbia', 'SC' => 'Seychelles', 'SL' => 'Sierra Leone', 'SG' => 'Singapore', 'SX' => 'Sint Maarten (Dutch part)',
                                            'SK' => 'Slovakia', 'SI' => 'Slovenia', 'SB' => 'Solomon Islands', 'SO' => 'Somalia', 'ZA' => 'South Africa',
                                            'SS' => 'South Sudan', 'ES' => 'Spain', 'LK' => 'Sri Lanka', 'SD' => 'Sudan', 'SR' => 'Suriname',
                                            'SJ' => 'Svalbard and Jan Mayen', 'SZ' => 'Eswatini', 'SE' => 'Sweden', 'CH' => 'Switzerland', 'SY' => 'Syrian Arab Republic',
                                            'TW' => 'Taiwan, Province of China', 'TJ' => 'Tajikistan', 'TZ' => 'Tanzania, United Republic of', 'TH' => 'Thailand', 'TL' => 'Timor-Leste',
                                            'TG' => 'Togo', 'TK' => 'Tokelau', 'TO' => 'Tonga', 'TT' => 'Trinidad and Tobago', 'TN' => 'Tunisia',
                                            'TR' => 'Turkey', 'TM' => 'Turkmenistan', 'TC' => 'Turks and Caicos Islands', 'TV' => 'Tuvalu', 'UG' => 'Uganda',
                                            'UA' => 'Ukraine', 'AE' => 'United Arab Emirates', 'GB' => 'United Kingdom', 'US' => 'United States', 'UY' => 'Uruguay',
                                            'UZ' => 'Uzbekistan', 'VU' => 'Vanuatu', 'VE' => 'Venezuela, Bolivarian Republic of', 'VN' => 'Viet Nam', 'VG' => 'Virgin Islands, British',
                                            'VI' => 'Virgin Islands, U.S.', 'WF' => 'Wallis and Futuna', 'EH' => 'Western Sahara', 'YE' => 'Yemen', 'ZM' => 'Zambia',
                                            'ZW' => 'Zimbabwe'
                                        ];
                                        
                                        $phoneCodes = [
                                            'AF' => '+93', 'AL' => '+355', 'DZ' => '+213', 'AS' => '+1684', 'AD' => '+376',
                                            'AO' => '+244', 'AI' => '+1264', 'AQ' => '+672', 'AG' => '+1268', 'AR' => '+54',
                                            'AM' => '+374', 'AW' => '+297', 'AU' => '+61', 'AT' => '+43', 'AZ' => '+994',
                                            'BS' => '+1242', 'BH' => '+973', 'BD' => '+880', 'BB' => '+1246', 'BY' => '+375',
                                            'BE' => '+32', 'BZ' => '+501', 'BJ' => '+229', 'BM' => '+1441', 'BT' => '+975',
                                            'BO' => '+591', 'BA' => '+387', 'BW' => '+267', 'BR' => '+55', 'IO' => '+246',
                                            'BN' => '+673', 'BG' => '+359', 'BF' => '+226', 'BI' => '+257', 'KH' => '+855',
                                            'CM' => '+237', 'CA' => '+1', 'CV' => '+238', 'KY' => '+1345', 'CF' => '+236',
                                            'TD' => '+235', 'CL' => '+56', 'CN' => '+86', 'CX' => '+61', 'CC' => '+61',
                                            'CO' => '+57', 'KM' => '+269', 'CD' => '+243', 'CG' => '+242', 'CK' => '+682',
                                            'CR' => '+506', 'CI' => '+225', 'HR' => '+385', 'CU' => '+53', 'CY' => '+357',
                                            'CZ' => '+420', 'DK' => '+45', 'DJ' => '+253', 'DM' => '+1767', 'DO' => '+1809',
                                            'EC' => '+593', 'EG' => '+20', 'SV' => '+503', 'GQ' => '+240', 'ER' => '+291',
                                            'EE' => '+372', 'ET' => '+251', 'FK' => '+500', 'FO' => '+298', 'FJ' => '+679',
                                            'FI' => '+358', 'FR' => '+33', 'GF' => '+594', 'PF' => '+689', 'GA' => '+241',
                                            'GM' => '+220', 'GE' => '+995', 'DE' => '+49', 'GH' => '+233', 'GI' => '+350',
                                            'GR' => '+30', 'GL' => '+299', 'GD' => '+1473', 'GP' => '+590', 'GU' => '+1671',
                                            'GT' => '+502', 'GG' => '+44', 'GN' => '+224', 'GW' => '+245', 'GY' => '+592',
                                            'HT' => '+509', 'VA' => '+379', 'HN' => '+504', 'HK' => '+852', 'HU' => '+36',
                                            'IS' => '+354', 'IN' => '+91', 'ID' => '+62', 'IR' => '+98', 'IQ' => '+964',
                                            'IE' => '+353', 'IM' => '+44', 'IL' => '+972', 'IT' => '+39', 'JM' => '+1876',
                                            'JP' => '+81', 'JE' => '+44', 'JO' => '+962', 'KZ' => '+7', 'KE' => '+254',
                                            'KI' => '+686', 'KP' => '+850', 'KR' => '+82', 'KW' => '+965', 'KG' => '+996',
                                            'LA' => '+856', 'LV' => '+371', 'LB' => '+961', 'LS' => '+266', 'LR' => '+231',
                                            'LY' => '+218', 'LI' => '+423', 'LT' => '+370', 'LU' => '+352', 'MO' => '+853',
                                            'MK' => '+389', 'MG' => '+261', 'MW' => '+265', 'MY' => '+60', 'MV' => '+960',
                                            'ML' => '+223', 'MT' => '+356', 'MH' => '+692', 'MQ' => '+596', 'MR' => '+222',
                                            'MU' => '+230', 'YT' => '+262', 'MX' => '+52', 'FM' => '+691', 'MD' => '+373',
                                            'MC' => '+377', 'MN' => '+976', 'ME' => '+382', 'MS' => '+1664', 'MA' => '+212',
                                            'MZ' => '+258', 'MM' => '+95', 'NA' => '+264', 'NR' => '+674', 'NP' => '+977',
                                            'NL' => '+31', 'NC' => '+687', 'NZ' => '+64', 'NI' => '+505', 'NE' => '+227',
                                            'NG' => '+234', 'NU' => '+683', 'NF' => '+672', 'MP' => '+1670', 'NO' => '+47',
                                            'OM' => '+968', 'PK' => '+92', 'PW' => '+680', 'PS' => '+970', 'PA' => '+507',
                                            'PG' => '+675', 'PY' => '+595', 'PE' => '+51', 'PH' => '+63', 'PN' => '+64',
                                            'PL' => '+48', 'PT' => '+351', 'PR' => '+1', 'QA' => '+974', 'RE' => '+262',
                                            'RO' => '+40', 'RU' => '+7', 'RW' => '+250', 'BL' => '+590', 'SH' => '+290',
                                            'KN' => '+1869', 'LC' => '+1758', 'MF' => '+590', 'PM' => '+508', 'VC' => '+1784',
                                            'WS' => '+685', 'SM' => '+378', 'ST' => '+239', 'SA' => '+966', 'SN' => '+221',
                                            'RS' => '+381', 'SC' => '+248', 'SL' => '+232', 'SG' => '+65', 'SX' => '+1721',
                                            'SK' => '+421', 'SI' => '+386', 'SB' => '+677', 'SO' => '+252', 'ZA' => '+27',
                                            'SS' => '+211', 'ES' => '+34', 'LK' => '+94', 'SD' => '+249', 'SR' => '+597',
                                            'SJ' => '+47', 'SZ' => '+268', 'SE' => '+46', 'CH' => '+41', 'SY' => '+963',
                                            'TW' => '+886', 'TJ' => '+992', 'TZ' => '+255', 'TH' => '+66', 'TL' => '+670',
                                            'TG' => '+228', 'TK' => '+690', 'TO' => '+676', 'TT' => '+1868', 'TN' => '+216',
                                            'TR' => '+90', 'TM' => '+993', 'TC' => '+1649', 'TV' => '+688', 'UG' => '+256',
                                            'UA' => '+380', 'AE' => '+971', 'GB' => '+44', 'US' => '+1', 'UY' => '+598',
                                            'UZ' => '+998', 'VU' => '+678', 'VE' => '+58', 'VN' => '+84', 'VG' => '+1284',
                                            'VI' => '+1340', 'WF' => '+681', 'EH' => '+212', 'YE' => '+967', 'ZM' => '+260',
                                            'ZW' => '+263'
                                        ];
                                        
                                        // Sort countries by name
                                        asort($countryNames);
                                        
                                        // Add options
                                        foreach ($countryNames as $code => $name) {
                                            if (isset($phoneCodes[$code])) {
                                                $phoneCode = $phoneCodes[$code];
                                                $selected = $code === 'TH' ? ' selected' : ''; // Default to Thailand
                                                echo "<option value='$phoneCode' data-country='$code'$selected>$name $phoneCode</option>\n";
                                            }
                                        }
                                        ?>
                                    </select>
                                    <input type="tel" id="phone" name="phone" required
                                        class="form-input flex-1"
                                        placeholder="WhatsApp number"
                                        inputmode="tel">
                                </div>
                                <div id="phone-error" class="form-error hidden">
                                    <svg class="h-4 w-4" fill="currentColor" viewBox="0 0 20 20">
                                        <path fill-rule="evenodd" d="M18 10a8 8 0 11-16 0 8 8 0 0116 0zm-7 4a1 1 0 11-2 0 1 1 0 012 0zm-1-9a1 1 0 00-1 1v4a1 1 0 102 0V6a1 1 0 00-1-1z" clip-rule="evenodd" />
                                    </svg>
                                    <span>Please enter a valid phone number</span>
                                </div>
                            </div>
                            
                            <!-- Country removed per requirements -->
                            
                            <!-- Address removed per requirements -->
                            
                            <!-- City/State/ZIP removed per requirements -->
                            
                            <!-- Tax ID removed per requirements -->
                            
                            <!-- Navigation Buttons -->
                            <div class="flex space-x-3 pt-2">
                                <button type="button" id="prev-btn"
                                    class="flex-1 inline-flex justify-center py-3 px-4 border border-gray-300 shadow-sm text-sm font-medium rounded-md text-gray-700 bg-white hover:bg-gray-50 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-blue-500">
                                    Back
                                </button>
                                <button type="submit" id="submit-btn"
                                    class="flex-1 inline-flex justify-center items-center py-3 px-4 border border-transparent shadow-sm text-sm font-medium rounded-md text-white bg-blue-600 hover:bg-blue-700 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-blue-500">
                                    <span class="btn-text">Complete Registration</span>
                                    <svg id="submit-spinner" class="animate-spin -mr-1 ml-2 h-5 w-5 text-white hidden" xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24">
                                        <circle class="opacity-25" cx="12" cy="12" r="10" stroke="currentColor" stroke-width="4"></circle>
                                        <path class="opacity-75" fill="currentColor" d="M4 12a8 8 0 018-8V0C5.373 0 0 5.373 0 12h4zm2 5.291A7.962 7.962 0 014 12H0c0 3.042 1.135 5.824 3 7.938l3-2.647z"></path>
                                    </svg>
                                </button>
                            </div>
                        </div>
                    </div>
                    
                    <!-- Step 3: Success Message (initially hidden) -->
                    <div id="step-3" class="step-content hidden">
                        <div class="text-center py-8">
                            <div class="mx-auto flex items-center justify-center h-12 w-12 rounded-full bg-green-100">
                                <svg class="h-6 w-6 text-green-600" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M5 13l4 4L19 7" />
                                </svg>
                            </div>
                            <h3 class="mt-3 text-lg font-medium text-gray-900">Registration Successful!</h3>
                            <div class="mt-2 text-sm text-gray-500">
                                <p>Thank you for registering. We've sent a verification email to <span id="registered-email" class="font-medium"></span>.</p>
                                <p class="mt-2">Please check your inbox and click the verification link to activate your account.</p>
                            </div>
                            <div class="mt-6">
                                <a href="/agent/login" class="inline-flex items-center px-4 py-2 border border-transparent text-sm font-medium rounded-md shadow-sm text-white bg-blue-600 hover:bg-blue-700 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-blue-500">
                                    Go to Login
                                </a>
                            </div>
                            <div class="mt-4 text-sm">
                                <p class="text-gray-500">Didn't receive the email? <button type="button" class="text-blue-600 hover:text-blue-500 font-medium">Resend verification</button></p>
                            </div>
                        </div>
                    </div>
                </form>
            </div>
            
            </div>
        </div>
    </div>
    <?php include __DIR__ . '/../partials/public_footer.php'; ?>
    
    <script>
        // Country to phone code mapping
        const countryPhoneCodes = {
            'AF': '+93',    // Afghanistan
            'AL': '+355',   // Albania
            'DZ': '+213',   // Algeria
            'AS': '+1684',  // American Samoa
            'AD': '+376',   // Andorra
            'AO': '+244',   // Angola
            'AI': '+1264',  // Anguilla
            'AQ': '+672',   // Antarctica
            'AG': '+1268',  // Antigua and Barbuda
            'AR': '+54',    // Argentina
            'AM': '+374',   // Armenia
            'AW': '+297',   // Aruba
            'AU': '+61',    // Australia
            'AT': '+43',    // Austria
            'AZ': '+994',   // Azerbaijan
            'BS': '+1242',  // Bahamas
            'BH': '+973',   // Bahrain
            'BD': '+880',   // Bangladesh
            'BB': '+1246',  // Barbados
            'BY': '+375',   // Belarus
            'BE': '+32',    // Belgium
            'BZ': '+501',   // Belize
            'BJ': '+229',   // Benin
            'BM': '+1441',  // Bermuda
            'BT': '+975',   // Bhutan
            'BO': '+591',   // Bolivia
            'BA': '+387',   // Bosnia and Herzegovina
            'BW': '+267',   // Botswana
            'BR': '+55',    // Brazil
            'IO': '+246',   // British Indian Ocean Territory
            'BN': '+673',   // Brunei Darussalam
            'BG': '+359',   // Bulgaria
            'BF': '+226',   // Burkina Faso
            'BI': '+257',   // Burundi
            'KH': '+855',   // Cambodia
            'CM': '+237',   // Cameroon
            'CA': '+1',     // Canada
            'CV': '+238',   // Cape Verde
            'KY': '+1345',  // Cayman Islands
            'CF': '+236',   // Central African Republic
            'TD': '+235',   // Chad
            'CL': '+56',    // Chile
            'CN': '+86',    // China
            'CX': '+61',    // Christmas Island
            'CC': '+61',    // Cocos (Keeling) Islands
            'CO': '+57',    // Colombia
            'KM': '+269',   // Comoros
            'CD': '+243',   // Congo, Democratic Republic of the
            'CG': '+242',   // Congo, Republic of the
            'CK': '+682',   // Cook Islands
            'CR': '+506',   // Costa Rica
            'CI': '+225',   // Cote d\'Ivoire
            'HR': '+385',   // Croatia
            'CU': '+53',    // Cuba
            'CY': '+357',   // Cyprus
            'CZ': '+420',   // Czech Republic
            'DK': '+45',    // Denmark
            'DJ': '+253',   // Djibouti
            'DM': '+1767',  // Dominica
            'DO': '+1809',  // Dominican Republic
            'EC': '+593',   // Ecuador
            'EG': '+20',    // Egypt
            'SV': '+503',   // El Salvador
            'GQ': '+240',   // Equatorial Guinea
            'ER': '+291',   // Eritrea
            'EE': '+372',   // Estonia
            'ET': '+251',   // Ethiopia
            'FK': '+500',   // Falkland Islands (Malvinas)
            'FO': '+298',   // Faroe Islands
            'FJ': '+679',   // Fiji
            'FI': '+358',   // Finland
            'FR': '+33',    // France
            'GF': '+594',   // French Guiana
            'PF': '+689',   // French Polynesia
            'GA': '+241',   // Gabon
            'GM': '+220',   // Gambia
            'GE': '+995',   // Georgia
            'DE': '+49',    // Germany
            'GH': '+233',   // Ghana
            'GI': '+350',   // Gibraltar
            'GR': '+30',    // Greece
            'GL': '+299',   // Greenland
            'GD': '+1473',  // Grenada
            'GP': '+590',   // Guadeloupe
            'GU': '+1671',  // Guam
            'GT': '+502',   // Guatemala
            'GG': '+44',    // Guernsey
            'GN': '+224',   // Guinea
            'GW': '+245',   // Guinea-Bissau
            'GY': '+592',   // Guyana
            'HT': '+509',   // Haiti
            'VA': '+379',   // Holy See (Vatican City State)
            'HN': '+504',   // Honduras
            'HK': '+852',   // Hong Kong
            'HU': '+36',    // Hungary
            'IS': '+354',   // Iceland
            'IN': '+91',    // India
            'ID': '+62',    // Indonesia
            'IR': '+98',    // Iran, Islamic Republic of
            'IQ': '+964',   // Iraq
            'IE': '+353',   // Ireland
            'IM': '+44',    // Isle of Man
            'IL': '+972',   // Israel
            'IT': '+39',    // Italy
            'JM': '+1876',  // Jamaica
            'JP': '+81',    // Japan
            'JE': '+44',    // Jersey
            'JO': '+962',   // Jordan
            'KZ': '+7',     // Kazakhstan
            'KE': '+254',   // Kenya
            'KI': '+686',   // Kiribati
            'KP': '+850',   // Korea, Democratic People\'s Republic of
            'KR': '+82',    // Korea, Republic of
            'KW': '+965',   // Kuwait
            'KG': '+996',   // Kyrgyzstan
            'LA': '+856',   // Lao People\'s Democratic Republic
            'LV': '+371',   // Latvia
            'LB': '+961',   // Lebanon
            'LS': '+266',   // Lesotho
            'LR': '+231',   // Liberia
            'LY': '+218',   // Libya
            'LI': '+423',   // Liechtenstein
            'LT': '+370',   // Lithuania
            'LU': '+352',   // Luxembourg
            'MO': '+853',   // Macao
            'MK': '+389',   // North Macedonia
            'MG': '+261',   // Madagascar
            'MW': '+265',   // Malawi
            'MY': '+60',    // Malaysia
            'MV': '+960',   // Maldives
            'ML': '+223',   // Mali
            'MT': '+356',   // Malta
            'MH': '+692',   // Marshall Islands
            'MQ': '+596',   // Martinique
            'MR': '+222',   // Mauritania
            'MU': '+230',   // Mauritius
            'YT': '+262',   // Mayotte
            'MX': '+52',    // Mexico
            'FM': '+691',   // Micronesia, Federated States of
            'MD': '+373',   // Moldova, Republic of
            'MC': '+377',   // Monaco
            'MN': '+976',   // Mongolia
            'ME': '+382',   // Montenegro
            'MS': '+1664',  // Montserrat
            'MA': '+212',   // Morocco
            'MZ': '+258',   // Mozambique
            'MM': '+95',    // Myanmar
            'NA': '+264',   // Namibia
            'NR': '+674',   // Nauru
            'NP': '+977',   // Nepal
            'NL': '+31',    // Netherlands
            'NC': '+687',   // New Caledonia
            'NZ': '+64',    // New Zealand
            'NI': '+505',   // Nicaragua
            'NE': '+227',   // Niger
            'NG': '+234',   // Nigeria
            'NU': '+683',   // Niue
            'NF': '+672',   // Norfolk Island
            'MP': '+1670',  // Northern Mariana Islands
            'NO': '+47',    // Norway
            'OM': '+968',   // Oman
            'PK': '+92',    // Pakistan
            'PW': '+680',   // Palau
            'PS': '+970',   // Palestine, State of
            'PA': '+507',   // Panama
            'PG': '+675',   // Papua New Guinea
            'PY': '+595',   // Paraguay
            'PE': '+51',    // Peru
            'PH': '+63',    // Philippines
            'PN': '+64',    // Pitcairn
            'PL': '+48',    // Poland
            'PT': '+351',   // Portugal
            'PR': '+1',     // Puerto Rico
            'QA': '+974',   // Qatar
            'RE': '+262',   // Réunion
            'RO': '+40',    // Romania
            'RU': '+7',     // Russian Federation
            'RW': '+250',   // Rwanda
            'BL': '+590',   // Saint Barthélemy
            'SH': '+290',   // Saint Helena, Ascension and Tristan da Cunha
            'KN': '+1869',  // Saint Kitts and Nevis
            'LC': '+1758',  // Saint Lucia
            'MF': '+590',   // Saint Martin (French part)
            'PM': '+508',   // Saint Pierre and Miquelon
            'VC': '+1784',  // Saint Vincent and the Grenadines
            'WS': '+685',   // Samoa
            'SM': '+378',   // San Marino
            'ST': '+239',   // Sao Tome and Principe
            'SA': '+966',   // Saudi Arabia
            'SN': '+221',   // Senegal
            'RS': '+381',   // Serbia
            'SC': '+248',   // Seychelles
            'SL': '+232',   // Sierra Leone
            'SG': '+65',    // Singapore
            'SX': '+1721',  // Sint Maarten (Dutch part)
            'SK': '+421',   // Slovakia
            'SI': '+386',   // Slovenia
            'SB': '+677',   // Solomon Islands
            'SO': '+252',   // Somalia
            'ZA': '+27',    // South Africa
            'SS': '+211',   // South Sudan
            'ES': '+34',    // Spain
            'LK': '+94',    // Sri Lanka
            'SD': '+249',   // Sudan
            'SR': '+597',   // Suriname
            'SJ': '+47',    // Svalbard and Jan Mayen
            'SZ': '+268',   // Eswatini
            'SE': '+46',    // Sweden
            'CH': '+41',    // Switzerland
            'SY': '+963',   // Syrian Arab Republic
            'TW': '+886',   // Taiwan, Province of China
            'TJ': '+992',   // Tajikistan
            'TZ': '+255',   // Tanzania, United Republic of
            'TH': '+66',    // Thailand
            'TL': '+670',   // Timor-Leste
            'TG': '+228',   // Togo
            'TK': '+690',   // Tokelau
            'TO': '+676',   // Tonga
            'TT': '+1868',  // Trinidad and Tobago
            'TN': '+216',   // Tunisia
            'TR': '+90',    // Turkey
            'TM': '+993',   // Turkmenistan
            'TC': '+1649',  // Turks and Caicos Islands
            'TV': '+688',   // Tuvalu
            'UG': '+256',   // Uganda
            'UA': '+380',   // Ukraine
            'AE': '+971',   // United Arab Emirates
            'GB': '+44',    // United Kingdom
            'US': '+1',     // United States
            'UY': '+598',   // Uruguay
            'UZ': '+998',   // Uzbekistan
            'VU': '+678',   // Vanuatu
            'VE': '+58',    // Venezuela, Bolivarian Republic of
            'VN': '+84',    // Viet Nam
            'VG': '+1284',  // Virgin Islands, British
            'VI': '+1340',  // Virgin Islands, U.S.
            'WF': '+681',   // Wallis and Futuna
            'EH': '+212',   // Western Sahara
            'YE': '+967',   // Yemen
            'ZM': '+260',   // Zambia
            'ZW': '+263'    // Zimbabwe
        };

        // Form state
        let currentStep = 1;
        const totalSteps = 3;
        
        // Update phone country code based on selected country
        function updatePhoneCountryCode() {
            const countrySelect = document.getElementById('country');
            const phoneCountrySelect = document.getElementById('phone-country');
            
            if (!countrySelect || !phoneCountrySelect) return;
            
            const countryCode = countrySelect.value;
            if (countryCode && countryPhoneCodes[countryCode]) {
                const phoneCode = countryPhoneCodes[countryCode];
                // Find and select the matching option
                for (let i = 0; i < phoneCountrySelect.options.length; i++) {
                    if (phoneCountrySelect.options[i].value === phoneCode) {
                        phoneCountrySelect.selectedIndex = i;
                        break;
                    }
                }
            }
        }
        
        // Add event listener when DOM is loaded
        document.addEventListener('DOMContentLoaded', function() {
            const countrySelect = document.getElementById('country');
            if (countrySelect) {
                countrySelect.addEventListener('change', updatePhoneCountryCode);
            }
        });
        
        // DOM Elements
        const form = document.getElementById('registration-form');
        const nextBtn = document.getElementById('next-btn');
        const prevBtn = document.getElementById('prev-btn');
        const submitBtn = document.getElementById('submit-btn');
        const step1Indicator = document.getElementById('step1-indicator');
        const step2Indicator = document.getElementById('step2-indicator');
        const step3Indicator = document.getElementById('step3-indicator');
        const progressBar = document.getElementById('progress-bar');
        
        // Business type toggles
        const businessTypeIndividual = document.getElementById('business-type-freelancer');
        const businessTypeCompany = document.getElementById('business-type-company');
        const businessTypeSole = document.getElementById('business-type-sole');
        const businessTypePartnership = document.getElementById('business-type-partnership');
        const businessNameGroup = document.getElementById('business-name-group');
        
        // Business type descriptions
        const businessTypeDescriptions = {
            'freelancer': 'Freelancer',
            'sole_proprietor': 'Sole Proprietor',
            'partnership': 'Partnership/LLP',
            'company': 'Company'
        };

        // Initialize the form
        document.addEventListener('DOMContentLoaded', function() {
            // Business type toggle
            businessTypeIndividual?.addEventListener('change', toggleBusinessType);
            businessTypeCompany?.addEventListener('change', toggleBusinessType);
            businessTypeSole?.addEventListener('change', toggleBusinessType);
            businessTypePartnership?.addEventListener('change', toggleBusinessType);
            
            // Form navigation
            nextBtn?.addEventListener('click', validateStep1);
            prevBtn?.addEventListener('click', goToPreviousStep);
            
            // Business type selection handler
            const businessTypeRadios = document.querySelectorAll('input[name="business_type"]');
            const businessTypeDesc = document.getElementById('business-type-description');
            const selectedTypeSpan = document.getElementById('selected-business-type');
            
            businessTypeRadios.forEach(radio => {
                radio.addEventListener('change', function() {
                    if (this.checked) {
                        const type = this.value;
                        selectedTypeSpan.textContent = businessTypeDescriptions[type] || '';
                        businessTypeDesc.classList.remove('hidden');
                    }
                });
            });
            
            // Initialize company/agency field based on current selection
            toggleBusinessType();

            // Password strength checker
            const passwordInput = document.getElementById('password');
            if (passwordInput) {
                passwordInput.addEventListener('input', checkPasswordStrength);
            }
            
            // Password match checker
            const confirmPasswordInput = document.getElementById('confirm-password');
            if (confirmPasswordInput) {
                confirmPasswordInput.addEventListener('input', checkPasswordMatch);
            }
            
            
            // Form submission
            form?.addEventListener('submit', handleFormSubmit);
            
            // Initialize tooltips
            initializeTooltips();
        });
        
        // Toggle password visibility
        function togglePasswordVisibility(fieldId) {
            const input = document.getElementById(fieldId);
            const icon = document.getElementById(`${fieldId}-toggle-icon`);
            
            if (input && icon) {
                const isPassword = input.type === 'password';
                input.type = isPassword ? 'text' : 'password';
                icon.className = isPassword ? 'fas fa-eye-slash' : 'fas fa-eye';
                
                // Update aria-label for accessibility
                const label = isPassword ? 'Hide password' : 'Show password';
                icon.setAttribute('aria-label', label);
            }
        }
        
        // Toggle business type fields
        function toggleBusinessType() {
            // Company/Agency required for any type other than freelancer
            const nonFreelancerSelected = document.querySelector('input[name="business_type"]:checked')?.value !== 'freelancer';
            if (nonFreelancerSelected) {
                businessNameGroup?.classList.remove('hidden');
                document.getElementById('business-name')?.setAttribute('required', 'required');
            } else {
                businessNameGroup?.classList.add('hidden');
                document.getElementById('business-name')?.removeAttribute('required');
            }
        }
        
        // Validate Step 1
        function validateStep1(e) {
            if (e) e.preventDefault();
            
            let isValid = true;
            
            // Reset errors
            document.querySelectorAll('.form-error').forEach(el => {
                el.classList.add('hidden');
            });
            
            document.querySelectorAll('.form-input, .form-select').forEach(input => {
                input.classList.remove('input-error');
            });
            
            // Validate name
            const name = document.getElementById('name');
            if (!name?.value.trim()) {
                showError('name-error', 'Please enter your full name');
                isValid = false;
            }
            
            // Validate email
            const email = document.getElementById('email');
            const emailRegex = /^[^\s@]+@[^\s@]+\.[^\s@]+$/;
            if (!email?.value.trim()) {
                showError('email-error', 'Please enter your email address');
                isValid = false;
            } else if (!emailRegex.test(email.value.trim())) {
                showError('email-error', 'Please enter a valid email address');
                isValid = false;
            }
            
            // Validate password
            const password = document.getElementById('password');
            if (!password?.value) {
                showError('password-error', 'Please enter a password');
                isValid = false;
            } else if (password.value.length < 8) {
                showError('password-error', 'Password must be at least 8 characters long');
                isValid = false;
            }
            
            // Validate confirm password
            const confirmPassword = document.getElementById('confirm-password');
            if (!confirmPassword?.value) {
                showError('confirm-password-error', 'Please confirm your password');
                isValid = false;
            } else if (password?.value !== confirmPassword.value) {
                showError('confirm-password-error', 'Passwords do not match');
                isValid = false;
            }
            
            // Validate terms
            const terms = document.getElementById('terms');
            if (!terms?.checked) {
                showError('terms-error', 'You must accept the terms and conditions');
                isValid = false;
            }
            
            // If valid, proceed to next step
            if (isValid) {
                // Show loading state
                const spinner = document.getElementById('next-btn-spinner');
                const buttonText = nextBtn?.querySelector('span:not(.hidden)');
                
                const btnTextEl = nextBtn?.querySelector('.btn-text');
                if (spinner && btnTextEl) {
                    spinner.classList.remove('hidden');
                    btnTextEl.textContent = 'Processing...';
                    nextBtn.disabled = true;
                }
                
                // Simulate API call
                setTimeout(() => {
                    goToStep(2);
                    // Reset button state
                    if (spinner && btnTextEl) {
                        spinner.classList.add('hidden');
                        btnTextEl.textContent = 'Continue to Business Info';
                        nextBtn.disabled = false;
                    }
                }, 800);
            } else {
                // Scroll to first error
                const firstError = document.querySelector('.form-error:not(.hidden)');
                if (firstError) {
                    firstError.scrollIntoView({ behavior: 'smooth', block: 'center' });
                }
            }
        }
        
        // Check password strength
        function checkPasswordStrength() {
            const password = document.getElementById('password')?.value || '';
            const strengthBar = document.getElementById('password-strength-bar');
            const strengthText = document.getElementById('password-strength-text');
            
            // Reset requirements
            const requirements = {
                length: { element: document.getElementById('req-length'), icon: document.getElementById('req-length-icon'), met: false },
                uppercase: { element: document.getElementById('req-uppercase'), icon: document.getElementById('req-uppercase-icon'), met: false },
                lowercase: { element: document.getElementById('req-lowercase'), icon: document.getElementById('req-lowercase-icon'), met: false },
                number: { element: document.getElementById('req-number'), icon: document.getElementById('req-number-icon'), met: false },
                special: { element: document.getElementById('req-special'), icon: document.getElementById('req-special-icon'), met: false }
            };
            
            // Check requirements
            let strength = 0;
            
            // Length check
            if (password.length >= 8) {
                requirements.length.met = true;
                strength++;
            }
            
            // Uppercase check
            if (/[A-Z]/.test(password)) {
                requirements.uppercase.met = true;
                strength++;
            }
            
            // Lowercase check
            if (/[a-z]/.test(password)) {
                requirements.lowercase.met = true;
                strength++;
            }
            
            // Number check
            if (/[0-9]/.test(password)) {
                requirements.number.met = true;
                strength++;
            }
            
            // Special character check
            if (/[!@#$%^&*]/.test(password)) {
                requirements.special.met = true;
                strength++;
            }
            
            // Update UI
            Object.values(requirements).forEach(req => {
                if (req.element && req.icon) {
                    if (req.met) {
                        req.element.classList.remove('text-gray-500');
                        req.element.classList.add('text-green-500');
                        req.icon.className = 'fas fa-check-circle text-green-500 text-xs mr-2';
                    } else {
                        req.element.classList.remove('text-green-500');
                        req.element.classList.add('text-gray-500');
                        req.icon.className = 'fas fa-circle text-gray-300 text-[6px] mr-2';
                    }
                }
            });
            
            // Update strength bar
            if (strengthBar) {
                strengthBar.className = 'password-strength-bar';
                strengthBar.classList.add(`strength-${strength - 1}`);
            }
            
            // Update strength text
            if (strengthText) {
                const strengthLabels = ['Very Weak', 'Weak', 'Fair', 'Strong', 'Very Strong'];
                const strengthColors = ['text-red-500', 'text-orange-500', 'text-yellow-500', 'text-blue-500', 'text-green-500'];
                
                strengthText.textContent = strengthLabels[strength - 1] || '';
                strengthText.className = `text-xs font-medium ${strengthColors[strength - 1] || 'text-gray-500'}`;
            }
            
            return strength >= 4; // At least 4 out of 5 requirements met
        }
        
        // Check password match
        function checkPasswordMatch() {
            const password = document.getElementById('password')?.value || '';
            const confirmPassword = document.getElementById('confirm-password')?.value || '';
            const errorElement = document.getElementById('confirm-password-error');
            
            if (!confirmPassword) {
                if (errorElement) {
                    errorElement.classList.add('hidden');
                }
                return false;
            }
            
            if (password !== confirmPassword) {
                if (errorElement) {
                    errorElement.classList.remove('hidden');
                    errorElement.querySelector('span').textContent = 'Passwords do not match';
                }
                return false;
            }
            
            if (errorElement) {
                errorElement.classList.add('hidden');
            }
            return true;
        }
        
        // Show error message
        function showError(id, message) {
            const element = document.getElementById(id);
            if (element) {
                const span = element.querySelector('span');
                if (span) {
                    span.textContent = message;
                }
                element.classList.remove('hidden');
                
                // Add error class to input
                const inputId = id.replace('-error', '');
                const input = document.getElementById(inputId);
                if (input) {
                    input.classList.add('input-error');
                    input.focus();
                }
            }
        }
        
        // Navigate to step
        function goToStep(step) {
            // Hide all steps
            document.querySelectorAll('.step-content').forEach(el => {
                el.classList.add('hidden');
            });
            
            // Show current step
            const currentStepElement = document.getElementById(`step-${step}`);
            if (currentStepElement) {
                currentStepElement.classList.remove('hidden');
            }
            
            // Update current step
            currentStep = step;
            
            // Update progress bar
            updateProgressBar();
            
            // Update step indicators
            updateStepIndicators();
            
            // Scroll to top
            window.scrollTo({ top: 0, behavior: 'smooth' });
            
            // Focus first input in step
            setTimeout(() => {
                const firstInput = currentStepElement?.querySelector('input:not([type="hidden"]), select, textarea');
                if (firstInput) {
                    firstInput.focus();
                }
            }, 100);
        }
        
        // Go to previous step
        function goToPreviousStep() {
            if (currentStep > 1) {
                goToStep(currentStep - 1);
            }
        }
        
        // Update progress bar
        function updateProgressBar() {
            if (progressBar) {
                const percentage = ((currentStep - 1) / (totalSteps - 1)) * 100;
                progressBar.style.width = `${percentage}%`;
            }
        }
        
        // Update step indicators
        function updateStepIndicators() {
            // Reset all indicators
            [step1Indicator, step2Indicator, step3Indicator].forEach((indicator, index) => {
                if (!indicator) return;
                
                indicator.classList.remove('active', 'completed');
                
                if (index + 1 < currentStep) {
                    indicator.classList.add('completed');
                } else if (index + 1 === currentStep) {
                    indicator.classList.add('active');
                }
            });
        }
        
        // Handle form submission
        function handleFormSubmit(e) {
            e.preventDefault();
            
            // Validate all fields
            let isValid = true;
            
            // Business type validation
            if (!document.querySelector('input[name="business_type"]:checked')) {
                showError('business-type-error', 'Please select a business type');
                isValid = false;
            }
            
            // Business name validation (required for any non-freelancer type)
            const selectedType = document.querySelector('input[name="business_type"]:checked')?.value || 'freelancer';
            if (selectedType !== 'freelancer') {
                const businessName = document.getElementById('business-name');
                if (!businessName?.value.trim()) {
                    showError('business-name-error', 'Please enter your company/agency');
                    isValid = false;
                }
            }
            
            // Phone validation (keep this)
            const phone = document.getElementById('phone');
            if (!phone?.value.trim()) {
                showError('phone-error', 'Please enter your phone number');
                isValid = false;
            }
            
            // If valid, submit the form
            if (isValid) {
                // Show loading state
                const spinner = document.getElementById('submit-spinner');
                const btnTextEl = submitBtn?.querySelector('.btn-text');
                
                if (spinner && btnTextEl) {
                    spinner.classList.remove('hidden');
                    btnTextEl.textContent = 'Processing...';
                    submitBtn.disabled = true;
                }
                
                // Combine country code with phone before submit
                const ccSel = document.getElementById('phone-country');
                const phoneInput = document.getElementById('phone');
                if (ccSel && phoneInput && phoneInput.value.trim()) {
                    const cc = ccSel.value || '';
                    // Avoid double-prefixing if user already typed code
                    const raw = phoneInput.value.trim();
                    if (!raw.startsWith(cc)) {
                        phoneInput.value = `${cc} ${raw}`.trim();
                    }
                }

                // Submit to server for account creation and OTP flow
                form?.submit();
            } else {
                // Scroll to first error
                const firstError = document.querySelector('.form-error:not(.hidden)');
                if (firstError) {
                    firstError.scrollIntoView({ behavior: 'smooth', block: 'center' });
                }
            }
        }
        
        // Show success message
        function showSuccess() {
            // Update registered email
            const email = document.getElementById('email')?.value || '';
            const registeredEmail = document.getElementById('registered-email');
            if (registeredEmail) {
                registeredEmail.textContent = email;
            }
            
            // Go to success step
            goToStep(3);
            
            // Reset form state after a delay (for demo)
            setTimeout(() => {
                // Reset form
                form?.reset();
                
                // Reset UI
                const spinner = document.getElementById('submit-spinner');
                const btnTextEl = submitBtn?.querySelector('.btn-text');
                
                if (spinner && btnTextEl) {
                    spinner.classList.add('hidden');
                    btnTextEl.textContent = 'Complete Registration';
                    submitBtn.disabled = false;
                }
                
                // Reset password strength
                checkPasswordStrength();
                
                // Reset business type
                if (businessTypeIndividual) {
                    businessTypeIndividual.checked = true;
                }
                toggleBusinessType();
                
                // Reset step indicators
                currentStep = 1;
                updateStepIndicators();
                updateProgressBar();
                
                // Go back to step 1 after a delay
                setTimeout(() => {
                    goToStep(1);
                }, 5000);
            }, 5000);
        }
        
        // Initialize tooltips
        function initializeTooltips() {
            // Add tooltips to info icons
            const tooltipTriggers = document.querySelectorAll('[data-tooltip]');
            
            tooltipTriggers.forEach(trigger => {
                const tooltipId = trigger.getAttribute('aria-describedby');
                const tooltip = tooltipId ? document.getElementById(tooltipId) : null;
                
                if (!tooltip) return;
                
                // Show tooltip on hover/focus
                const showTooltip = () => {
                    tooltip.classList.remove('hidden', 'opacity-0');
                    tooltip.classList.add('opacity-100');
                };
                
                // Hide tooltip
                const hideTooltip = () => {
                    tooltip.classList.remove('opacity-100');
                    tooltip.classList.add('opacity-0');
                    setTimeout(() => {
                        if (tooltip.classList.contains('opacity-0')) {
                            tooltip.classList.add('hidden');
                        }
                    }, 150);
                };
                
                // Add event listeners
                trigger.addEventListener('mouseenter', showTooltip);
                trigger.addEventListener('focus', showTooltip);
                trigger.addEventListener('mouseleave', hideTooltip);
                trigger.addEventListener('blur', hideTooltip);
                
                // Close on ESC key
                document.addEventListener('keydown', (e) => {
                    if (e.key === 'Escape') {
                        hideTooltip();
                    }
                });
            });
        }
    </script>
</body>

    <?php include __DIR__ . '/../partials/pwa_install_js.php'; ?>
</html>
