<?php
// app/Views/agent/activity_voucher_pending.php
$title = $title ?? 'Activity Voucher (Pending)';
$booking = $booking ?? [];
$guest = $guest ?? [];
$active = 'activities';

if (!function_exists('base_url')) {
  function base_url($path = '') { return '/b2b/' . ltrim($path, '/'); }
}

$company_name = trim($_ENV['COMPANY_NAME'] ?? 'So Simple Trip Co. Ltd', '"');
$company_website = trim($_ENV['COMPANY_WEBSITE'] ?? 'bookmythai.com', '"');
$powered_by = trim($_ENV['POWERED_BY'] ?? 'BookMyThai.com', '"');

require __DIR__ . '/partials/header.php';
?>

<div class="min-h-screen bg-gray-50 py-8">
  <div class="max-w-2xl mx-auto px-4">
    <div class="no-print mb-4 bg-red-50 border border-red-200 text-red-800 rounded-xl p-4 flex items-start gap-3">
      <svg class="w-5 h-5 mt-0.5" viewBox="0 0 24 24" fill="none" stroke="currentColor"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M13 16h-1v-4h-1m1-4h.01M12 2a10 10 0 100 20 10 10 0 000-20z"/></svg>
      <div>
        <div class="font-semibold">Payment Pending</div>
        <div class="text-sm opacity-90">Your payment has not been completed yet. Booking Code and QR will be available after payment is completed.</div>
      </div>

      <!-- (Watermark moved to main voucher card) -->
    </div>

    <div class="flex justify-between items-center mb-6 no-print">
      <a href="<?= base_url('agent/activities') ?>" class="inline-flex items-center px-4 py-2 bg-gray-600 text-white rounded-lg hover:bg-gray-700 transition-colors">
        <svg class="w-4 h-4 mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M10 19l-7-7m0 0l7-7m-7 7h18"/></svg>
        Back to Activities
      </a>
      <a href="<?= base_url('agent/bookings') ?>" class="inline-flex items-center px-4 py-2 bg-white border border-slate-300 text-slate-700 rounded-lg hover:bg-slate-50 transition-colors">
        <svg class="w-4 h-4 mr-2" viewBox="0 0 24 24" fill="none" stroke="currentColor"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 5H7a2 2 0 00-2 2v12a2 2 0 002 2h10a2 2 0 002-2V7a2 2 0 00-2-2h-2M9 5a2 2 0 002 2h2a2 2 0 002-2M9 5a2 2 0 012-2h2a2 2 0 012 2"/></svg>
        View All Bookings
      </a>
    </div>

    <?php 
      $customer_name = htmlspecialchars((string)($booking['customer_name'] ?? ($booking['lead_name'] ?? 'Guest')));
      $customer_email = htmlspecialchars((string)($booking['customer_email'] ?? ($booking['lead_email'] ?? '—')));
      $customer_phone = htmlspecialchars((string)($booking['customer_phone'] ?? ($booking['lead_phone'] ?? '—')));
      $activity_date = (string)($booking['activity_date'] ?? ($booking['booking_date'] ?? ''));
      $show_time = (string)($booking['show_time'] ?? '');
      $amount_total = (float)($booking['amount_total'] ?? 0);
      $currency = htmlspecialchars(strtoupper($booking['currency'] ?? 'THB'));
      $pax = (int)($booking['pax'] ?? ($booking['qty_total'] ?? 1));
      $activity_name = htmlspecialchars((string)($booking['activity_name'] ?? 'Activity'));
      $pretty_date = $activity_date !== '' ? date('d M Y', strtotime($activity_date)) : '—';
      $pretty_time = $show_time !== '' ? date('h:i A', strtotime($show_time)) : '—';
      $package_name = htmlspecialchars((string)($booking['package_name'] ?? ''));
      $variant_name = htmlspecialchars((string)($booking['variant_name'] ?? ''));
      $items = json_decode($booking['items_json'] ?? '[]', true) ?: [];
      $payment_status_text = ucfirst(strtolower((string)($booking['payment_status'] ?? 'pending')));
    ?>

    <div class="relative bg-white rounded-lg shadow-lg overflow-hidden">
      <div class="flex items-start p-6 border-b border-gray-200">
        <div class="flex-shrink-0 mr-4">
          <div class="w-16 h-16 bg-teal-600 text-white flex items-center justify-center rounded-md">
            <span class="text-xl font-bold">AC</span>
          </div>
        </div>
        <div class="flex-grow">
          <h1 class="text-lg font-bold text-gray-800"><?= htmlspecialchars($powered_by) ?> <span class="mx-2">—</span> Activity Voucher</h1>
          <p class="text-xs text-gray-500 mt-1">Issued by: <?= htmlspecialchars($company_name) ?></p>
          <div class="mt-1 text-xs text-gray-400">Issued on <?= date('d M Y H:i') ?></div>
        </div>
        <div class="text-right">
          <div class="text-sm text-gray-600">Voucher ID</div>
          <div class="font-mono font-bold text-gray-800">AC-<?= htmlspecialchars((string)($booking['id'] ?? 'N/A')) ?></div>
        </div>
      </div>

      <div class="p-6">
        <div class="grid grid-cols-3 gap-6">
          <div class="col-span-2">
            <div class="grid grid-cols-2 gap-6">
              <div class="col-span-2 border-b pb-2 mb-2">
                <h3 class="text-lg font-bold text-gray-800 mb-1">Guest Details</h3>
                <div class="grid grid-cols-2 gap-2">
                  <div>
                    <div class="text-xs text-gray-500">Name</div>
                    <div class="font-medium"><?= $customer_name ?></div>
                  </div>
                  <div>
                    <div class="text-xs text-gray-500">Contact</div>
                    <div class="font-medium"><?= $customer_phone ?></div>
                    <div class="text-xs"><?= $customer_email ?></div>
                  </div>
                </div>
              </div>

              <div class="col-span-2 border-b pb-2 mb-2">
                <h3 class="text-lg font-bold text-gray-800 mb-1">Activity Details</h3>
                <div class="grid grid-cols-2 gap-4">
                  <div>
                    <div class="text-xs text-gray-500">Activity</div>
                    <div class="font-medium"><?= $activity_name ?></div>
                    <div class="text-xs">PAX: <?= (int)$pax ?></div>
                    
                    <?php if ($package_name): ?>
                      <div class="mt-2">
                        <div class="text-xs text-gray-500">Package</div>
                        <div class="font-medium"><?= $package_name ?></div>
                      </div>
                    <?php endif; ?>
                    
                    <?php if ($variant_name): ?>
                      <div class="mt-1">
                        <div class="text-xs text-gray-500">Variant</div>
                        <div class="font-medium"><?= $variant_name ?></div>
                      </div>
                    <?php elseif (!empty($items[0]['variant_name'])): ?>
                      <div class="mt-1">
                        <div class="text-xs text-gray-500">Variant</div>
                        <div class="font-medium"><?= htmlspecialchars($items[0]['variant_name']) ?></div>
                      </div>
                    <?php endif; ?>
                  </div>
                  <div>
                    <div class="text-xs text-gray-500">Date & Time</div>
                    <div class="font-medium"><?= $pretty_date ?> <?= $pretty_time ?></div>
                  </div>
                </div>
              </div>

              <div class="col-span-2">
                <h3 class="text-lg font-bold text-gray-800 mb-1">Notes</h3>
                <div class="bg-gray-50 p-3 rounded-lg border border-gray-100 text-sm text-gray-700">
                  <?= htmlspecialchars((string)($guest['notes'] ?? 'Present this voucher at the venue entrance after completing payment.')) ?>
                </div>
              </div>
            </div>

            <div class="mt-6 bg-gray-50 p-4 rounded-lg">
              <h3 class="text-lg font-bold text-gray-800 mb-3">Booking Summary</h3>
              <div class="space-y-2">
                <div class="flex items-center justify-between text-sm">
                  <div class="text-gray-600">Total Amount</div>
                  <div class="font-semibold text-gray-900"><?= $currency ?> <?= number_format($amount_total, 2) ?></div>
                </div>
                <div class="text-sm text-gray-600">
                  <span class="font-medium">Payment Status:</span>
                  <span class="inline-block px-2.5 py-0.5 rounded-full text-xs font-medium bg-red-100 text-red-800"><?= $payment_status_text ?></span>
                </div>
              </div>
            </div>

            <div class="mt-4 text-xs text-gray-500">
              Please complete payment to receive your Booking Code and QR voucher.
            </div>
          </div>

          <div class="border-l border-gray-200 pl-6">
            <div class="text-center mb-6">
              <div class="inline-block px-3 py-1 rounded-full text-sm font-semibold bg-red-100 text-red-800"><?= $payment_status_text ?></div>
            </div>
            <div class="bg-red-50 border border-red-200 text-red-800 rounded-lg p-4 text-sm text-center">
              Payment is pending. Booking Code and QR will be generated after payment is completed.
            </div>

            <div class="mt-4 p-3 bg-gray-50 rounded-lg text-center">
              <div class="text-xs text-gray-500">Need help?</div>
              <div class="text-xs text-blue-600">support@<?= htmlspecialchars($company_website) ?></div>
            </div>
          </div>
        </div>
      </div>

      <!-- Watermark: UNPAID (visible over the whole voucher card) -->
      <div class="pointer-events-none select-none absolute inset-0 flex items-center justify-center z-20">
        <div class="rotate-45 font-extrabold tracking-widest" style="font-size: 120px; color: rgba(239,68,68,0.22);">
          UNPAID
        </div>
      </div>
    </div>
  </div>
</div>

<style>
@media print {
  body { background: white; margin: 0; padding: 0; }
  .no-print { display: none !important; }
  .shadow-lg { box-shadow: none !important; }
  .rounded-lg { border-radius: 0 !important; }
  .max-w-2xl { max-width: none !important; }
  .z-20 { z-index: 20 !important; }
  .px-4 { padding-left: 0 !important; padding-right: 0 !important; }
}
</style>

<?php require __DIR__ . '/partials/footer.php'; ?>
