<?php
// app/Views/agent/activity_voucher_boarding.php
$title = $title ?? 'Activity Voucher';
$booking = $booking ?? [];
$active = 'activities';

// Debug: Check if booking data exists
if (empty($booking)) {
    die('No booking data available. Please check if the booking ID is correct.');
}

if (!function_exists('base_url')) {
    function base_url($path = '') {
        return '/b2b/' . ltrim($path, '/');
    }
}

// Company information
$company_name = trim($_ENV['COMPANY_NAME'] ?? 'So Simple Trip Co. Ltd', '"');
$company_website = trim($_ENV['COMPANY_WEBSITE'] ?? 'bookmythai.com', '"');
$powered_by = trim($_ENV['POWERED_BY'] ?? 'BookMyThai.com', '"');
$company_email = trim($_ENV['COMPANY_EMAIL'] ?? 'support@bookmythai.com', '"');
$company_phone = trim($_ENV['COMPANY_PHONE'] ?? '+66 2 123 4567', '"');

// Get agent from session
$agent = $_SESSION['agent'] ?? null;

require __DIR__ . '/partials/header.php';

// Format booking data
$voucher_id = !empty($booking['booking_code']) ? strtoupper($booking['booking_code']) : 'ACT-' . substr(md5(uniqid()), 0, 8);
$booking_date = !empty($booking['booking_date']) ? date('d M Y', strtotime($booking['booking_date'])) : 'Not specified';

$is_cancelled = isset($booking['status']) && strtolower($booking['status']) === 'cancelled';
$payment_status = isset($booking['payment_status']) ? strtolower($booking['payment_status']) : 'unpaid';
$payment_status_class = $payment_status === 'paid' ? 'bg-green-100 text-green-800' : 'bg-yellow-100 text-yellow-800';

// Debug: Log booking data
error_log('Booking data: ' . print_r($booking, true));

// Guest information
$guest = $guest ?? [];
$guest_name = !empty($guest['lead']['name']) ? htmlspecialchars($guest['lead']['name']) : 
             (!empty($booking['customer_name']) ? htmlspecialchars($booking['customer_name']) : 'Guest');
$guest_email = !empty($guest['lead']['email']) ? htmlspecialchars($guest['lead']['email']) : 
              (!empty($booking['customer_email']) ? htmlspecialchars($booking['customer_email']) : 'Not provided');
$guest_phone = !empty($guest['lead']['phone']) ? htmlspecialchars($guest['lead']['phone']) : 
              (!empty($booking['customer_phone']) ? htmlspecialchars($booking['customer_phone']) : 'Not provided');

// Activity information
$activity_name = !empty($booking['package_name']) ? htmlspecialchars($booking['package_name']) : 'Activity Package';
$variant_name = !empty($booking['variant_name']) ? htmlspecialchars($booking['variant_name']) : '';
$activity_date = !empty($booking['activity_date']) ? date('d M Y', strtotime($booking['activity_date'])) : 'Not specified';
$show_time = !empty($booking['show_time']) ? $booking['show_time'] : 'Not specified';

// Guest counts
$adult_count = isset($booking['adult_count']) ? (int)$booking['adult_count'] : 0;
$child_count = isset($booking['child_count']) ? (int)$booking['child_count'] : 0;
$infant_count = isset($booking['infant_count']) ? (int)$booking['infant_count'] : 0;
$total_guests = $adult_count + $child_count + $infant_count;

// Process items for guest counts and types
$items = json_decode($booking['items_json'] ?? '[]', true) ?: [];
$processed_items = [];

foreach ($items as $item) {
    $qty = (int)($item['qty'] ?? 0);
    $pax_type = strtolower($item['pax_type'] ?? 'adult');
    $processed_items[] = [
        'name' => $item['price_name'] ?? 'Ticket',
        'variant' => $item['variant_name'] ?? 'Standard',
        'pax_type' => $pax_type,
        'qty' => $qty
    ];
}

// Generate verification URLs
$secret = $_ENV['VERIFY_SECRET'] ?? ($_ENV['APP_KEY'] ?? 'dev-secret-change');
$payload = rtrim(strtr(base64_encode($voucher_id), '+/', '-_'), '=');
$sig = hash_hmac('sha256', $voucher_id, $secret, true);
$sigB64 = rtrim(strtr(base64_encode($sig), '+/', '-_'), '=');
$verify_token = $payload . '.' . $sigB64;
$verify_path = base_url('activity/verify?t=' . urlencode($verify_token));
$scheme = (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off') ? 'https' : 'http';
$host = $_SERVER['HTTP_HOST'] ?? 'localhost';
$absolute_verify_url = $scheme . '://' . $host . $verify_path;
$qr_img_url = 'https://api.qrserver.com/v1/create-qr-code/?size=150x150&data=' . urlencode($absolute_verify_url);
$barcode_url = 'https://barcode.tec-it.com/barcode.ashx?data=' . urlencode($voucher_id) . '&code=Code128&dpi=96&dataseparator=';
?>

<!-- Main Voucher Container -->
<div class="min-h-screen bg-gray-50 py-8">
    <div class="max-w-2xl mx-auto px-4">
        
        <!-- Action Buttons -->
        <div class="flex justify-between items-center mb-6 no-print">
            <a href="<?= base_url('agent/activities') ?>" class="inline-flex items-center px-4 py-2 bg-gray-600 text-white rounded-lg hover:bg-gray-700 transition-colors">
                <svg class="w-4 h-4 mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M10 19l-7-7m0 0l7-7m-7 7h18"/>
                </svg>
                Back to Activities
            </a>
            
            <div class="flex space-x-2">
                <button id="moveStampBtn" class="inline-flex items-center px-4 py-2 bg-yellow-600 text-white rounded-lg hover:bg-yellow-700 transition-colors">
                    <svg class="w-4 h-4 mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M4 8h16M4 16h16M8 4v16m8-16v16" />
                    </svg>
                    Move Stamp
                </button>
                <button onclick="window.print()" class="inline-flex items-center px-4 py-2 bg-blue-600 text-white rounded-lg hover:bg-blue-700 transition-colors">
                    <svg class="w-4 h-4 mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M17 17h2a2 2 0 002-2v-4a2 2 0 00-2-2H5a2 2 0 00-2 2v4a2 2 0 002 2h2m2 4h6a2 2 0 002-2v-4a2 2 0 00-2-2H9a2 2 0 00-2 2v4a2 2 0 002 2zm8-12V5a2 2 0 00-2-2H9a2 2 0 00-2 2v4h10z"/>
                    </svg>
                    Print/Save as PDF
                </button>
            </div>
        </div>

        <!-- Voucher Card -->
        <div class="bg-white rounded-lg shadow-lg overflow-hidden relative">
            
            <!-- Header -->
            <div class="flex items-start p-6 border-b border-gray-200 relative">
                <!-- Stamp container -->
<div id="stampContainer" class="absolute" style="z-index: 1000; cursor: move; top: 40px; right: 40px;">
    <div class="relative">
        <div style="
            border: 3px solid #1b5e20;
            border-radius: 4px;
            padding: 15px 25px;
            display: inline-block;
            transform: rotate(-3deg);
            background: rgba(255, 255, 255, 0.85);
            box-shadow: 0 2px 8px rgba(0,0,0,0.1);
            position: relative;
            overflow: hidden;
            min-width: 160px;
            text-align: center;
            backdrop-filter: blur(1px);
            border-style: solid;
            border-width: 3px;
        ">
            <!-- Decorative corner elements -->
            <div style="
                position: absolute;
                width: 15px;
                height: 15px;
                border-color: #28a745;
                border-style: solid;
                border-width: 0 0 3px 3px;
                left: 5px;
                bottom: 5px;
                z-index: 2;
            "></div>
            <div style="
                position: absolute;
                width: 15px;
                height: 15px;
                border-color: #28a745;
                border-style: solid;
                border-width: 0 3px 3px 0;
                right: 5px;
                bottom: 5px;
                z-index: 2;
            "></div>
            <!-- Watermark pattern -->
            <div style="
                position: absolute;
                top: 0;
                left: 0;
                right: 0;
                bottom: 0;
                background: 
                    linear-gradient(135deg, rgba(27, 94, 32, 0.02) 25%, transparent 25%) -10px 0/ 20px 20px,
                    linear-gradient(225deg, rgba(27, 94, 32, 0.02) 25%, transparent 25%) -10px 0/ 20px 20px,
                    linear-gradient(315deg, rgba(27, 94, 32, 0.02) 25%, transparent 25%),
                    linear-gradient(45deg, rgba(27, 94, 32, 0.02) 25%, transparent 25%);
                z-index: 1;
                pointer-events: none;
            "></div>
            
            <div style="
                font-family: 'Arial', sans-serif;
                font-size: 2.2rem;
                font-weight: 900;
                color: #1b5e20;
                text-transform: uppercase;
                letter-spacing: 1px;
                position: relative;
                z-index: 2;
                text-shadow: 1px 1px 2px rgba(0,0,0,0.1);
                padding: 2px 10px;
                display: inline-block;
                margin: 5px 0;
                position: relative;
                line-height: 1;
            ">PAID</div>
            
            <div style="
                font-family: 'Courier New', monospace;
                font-size: 0.6rem;
                color: #28a745;
                margin-top: 5px;
                position: relative;
                z-index: 2;
                text-align: center;
                line-height: 1.2;
            ">
                <div style="
                    font-size: 0.7rem;
                    color: #1b5e20;
                    margin-top: 5px;
                    position: relative;
                    z-index: 2;
                    text-align: center;
                    letter-spacing: 0.3px;
                    font-weight: 500;
                ">
                    <div style="margin-bottom: 3px;">
                        <span style="opacity: 0.8;">ID: </span>
                        <span style="font-family: 'Courier New', monospace; font-weight: bold;"><?= $voucher_id ?></span>
                    </div>
                    <div style="
                        font-size: 0.65rem;
                        color: #1b5e20;
                        opacity: 0.9;
                    ">
                        <?= date('d M Y') ?>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
                <div class="flex-shrink-0 mr-4">
                    <div class="w-16 h-16 bg-teal-600 text-white flex items-center justify-center rounded-md">
                        <span class="text-xl font-bold">TH</span>
                    </div>
                </div>
                <div class="flex-grow">
                    <h1 class="text-lg font-bold text-gray-800 flex items-center">
                        <?= htmlspecialchars($powered_by) ?> 
                        <span class="mx-2">—</span>
                        <span class="flex items-center">
                            <?php if ($is_cancelled): ?>
                                <svg class="w-5 h-5 text-red-600 mr-1" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M6 18L18 6M6 6l12 12" />
                                </svg>
                            <?php endif; ?>
                            <?= $is_cancelled ? 'Cancelled Voucher' : 'Activity Confirmation Voucher' ?>
                        </span>
                    </h1>
                    <p class="text-xs text-gray-500 mt-1">Issued by: <?= htmlspecialchars($company_name) ?> (TAT Authorized)</p>
                    <div class="mt-1 text-xs text-gray-400">Issued on <?= date('d M Y H:i') ?></div>
                </div>
                <div class="text-right">
                    <div class="text-sm text-gray-600">Voucher ID</div>
                    <div class="font-mono font-bold text-gray-800"><?= $voucher_id ?></div>
                </div>
            </div>

            <!-- Status Bar -->
            <div class="bg-gradient-to-r from-gray-50 to-gray-100 px-6 py-3 border-b border-gray-200 flex flex-col sm:flex-row justify-between items-start sm:items-center gap-3">
                <div class="flex items-center flex-wrap gap-2">
                    <span class="inline-flex items-center px-3 py-1 rounded-full text-xs font-semibold bg-gradient-to-r from-green-50 to-green-100 text-green-800 border border-green-200 shadow-sm">
                        <svg class="mr-1.5 h-3 w-3 text-green-500" fill="currentColor" viewBox="0 0 20 20">
                            <path fill-rule="evenodd" d="M16.707 5.293a1 1 0 010 1.414l-8 8a1 1 0 01-1.414 0l-4-4a1 1 0 011.414-1.414L8 12.586l7.293-7.293a1 1 0 011.414 0z" clip-rule="evenodd" />
                        </svg>
                        Booking Confirmed
                    </span>
                    <div class="flex items-center text-sm text-gray-600 bg-white px-3 py-1 rounded-md border border-gray-200">
                        <svg class="w-4 h-4 mr-1.5 text-gray-400" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 5H7a2 2 0 00-2 2v12a2 2 0 002 2h10a2 2 0 002-2V7a2 2 0 00-2-2h-2M9 5a2 2 0 002 2h2a2 2 0 002-2M9 5a2 2 0 012-2h2a2 2 0 012 2" />
                        </svg>
                        <span class="font-mono font-medium text-gray-700">#<?= $voucher_id ?></span>
                    </div>
                </div>
                <div class="flex items-center text-xs text-gray-600 bg-white px-2.5 py-1 rounded-md border border-gray-200 shadow-sm space-x-2">
                    <span class="inline-flex items-center">
                        <span class="relative flex h-2 w-2 mr-1.5">
                            <span class="absolute inline-flex h-full w-full rounded-full bg-green-400 opacity-75 animate-ping"></span>
                            <span class="relative inline-flex rounded-full h-2 w-2 bg-green-500"></span>
                        </span>
                        <span class="font-medium text-gray-700 text-xs"><?= $is_cancelled ? 'Cancelled' : 'Active' ?></span>
                    </span>
                    <span class="text-gray-300">|</span>
                    <span class="flex items-center">
                        <svg class="w-3 h-3 mr-1 text-gray-400 flex-shrink-0" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M8 7V3m8 4V3m-9 8h10M5 21h14a2 2 0 002-2V7a2 2 0 00-2-2H5a2 2 0 00-2 2v12a2 2 0 002 2z" />
                        </svg>
                        <time datetime="<?= date('Y-m-d', strtotime($booking_date)) ?>" class="text-xs font-medium text-gray-700 whitespace-nowrap">
                            <span class="font-semibold"><?= date('D, ', strtotime($booking_date)) ?></span>
                            <?= date('M j, Y', strtotime($booking_date)) ?>
                            <span class="ml-1 inline-flex items-center text-[10px] font-medium bg-green-50 text-green-700 px-1.5 py-0.5 rounded-full border border-green-100">
                                <span class="relative flex h-1.5 w-1.5 mr-0.5">
                                    <span class="absolute inline-flex h-full w-full rounded-full bg-green-400 opacity-75 animate-ping"></span>
                                    <span class="relative inline-flex rounded-full h-1.5 w-1.5 bg-green-500"></span>
                                </span>
                                Live
                            </span>
                        </time>
                    </span>
                </div>
            </div>

            <!-- Main Content -->
            <div class="p-6">
                <!-- Activity Details -->
                <div class="mb-8">
                   
                    <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                        <div>
                          
                            <h3 class="text-lg font-semibold text-gray-700"><?= $activity_name ?></h3>
                            <div class="text-center">
                                <img src="<?= $barcode_url ?>" 
                                     alt="Barcode" class="h-16 w-38">
                               
                                <p class="text-xs text-gray-500 mt-1">Show QR Code to Staff</p>
                         
                            </div>
                            <?php if (!empty($variant_name)): ?>
                            <p class="text-gray-500 text-sm"><?= $variant_name ?></p>
                            <?php endif; ?>
                        </div>
                        <div class="flex items-center space-x-6">
                            <div class="text-center">
                                <img src="<?= $qr_img_url ?>" 
                                     alt="QR Code" class="h-24 w-24 mx-auto">
                                <p class="text-xs text-gray-500 mt-1">Scan QR Code for Verification of Booking</p>
                            </div>
                         
                        </div>
                    </div>
                </div>

               

                <!-- Booking Summary -->
                <div class="mb-8">
                    <h2 class="text-lg font-bold text-gray-500 mb-4 pb-2 border-b border-gray-200">
                        Booking Summary
                       
                        
                    </h2>
                    <p>Lead Guest: <?= $guest_name ?></p>
                    <br>
                    <div class="bg-gray-50 rounded-lg overflow-hidden">
                      
                        <table class="min-w-full divide-y divide-gray-200">
                            <thead class="bg-gray-50">
                                <tr>
                                    <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider"><?= $activity_name ?> Booking Summary</th>
                                          </tr>
                            </thead>
                            <tbody class="bg-white divide-y divide-gray-200">

                                <?php $i=1;
                                foreach ($processed_items as $item): ?>
                                <tr>
                                    <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-900">
                                        
                                        <?php if (!empty($item['variant'])): ?>
                                        <div class=""><h3><?= $i ?>.&nbsp;&nbsp;&nbsp; <?= htmlspecialchars($item['variant']) ?> x <?= $item['qty'] ?> / <?= htmlspecialchars($item['name']) ?> &nbsp;&nbsp;&nbsp; = &nbsp;&nbsp;&nbsp; <?= $item['qty'] ?>  <?= $item['name'] ?> </h3> </div>
                                        <?php endif; ?>
                                    </td>
                                    
                                </tr>
                                <?php $i++; endforeach; ?>
                            </tbody>
                        </table>
                    </div>
                </div>

             
            </div>

            <!-- Footer -->
            <div class="bg-gray-50 p-4 border-t border-gray-200 text-center text-xs text-gray-500">
                <p>This is an electronic ticket - no need to print. Show on your mobile device at check-in.</p>
                <p class="mt-1">Powered by <?= htmlspecialchars($powered_by) ?></p>
            </div>
        </div>
    </div>
</div>

<!-- Stamp Script -->
<script>
document.addEventListener('DOMContentLoaded', function() {
    const stampContainer = document.getElementById('stampContainer');
    const moveStampBtn = document.getElementById('moveStampBtn');
    const voucherContainer = document.querySelector('.bg-white.rounded-lg');
    let isDragging = false;
    let offsetX, offsetY;

    // Toggle move mode on button click
    moveStampBtn.addEventListener('click', function() {
        const isMoving = moveStampBtn.classList.toggle('bg-blue-600');
        moveStampBtn.textContent = isMoving ? 'Moving... (Click to Stop)' : 'Move Stamp';
        stampContainer.style.cursor = isMoving ? 'move' : 'default';
    });

    // Make stamp draggable only when in move mode
    stampContainer.addEventListener('mousedown', function(e) {
        if (!moveStampBtn.classList.contains('bg-blue-600')) return;
        
        isDragging = true;
        const rect = stampContainer.getBoundingClientRect();
        offsetX = e.clientX - rect.left;
        offsetY = e.clientY - rect.top;
        
        document.addEventListener('mousemove', onMouseMove);
        document.addEventListener('mouseup', onMouseUp);
        
        e.preventDefault();
    });

    function onMouseMove(e) {
        if (!isDragging) return;
        
        const containerRect = voucherContainer.getBoundingClientRect();
        let x = e.clientX - containerRect.left - offsetX;
        let y = e.clientY - containerRect.top - offsetY;
        
        // Keep stamp within voucher bounds
        x = Math.max(0, Math.min(x, containerRect.width - 150));
        y = Math.max(0, Math.min(y, containerRect.height - 100));
        
        stampContainer.style.left = x + 'px';
        stampContainer.style.top = y + 'px';
    }

    function onMouseUp() {
        isDragging = false;
        document.removeEventListener('mousemove', onMouseMove);
        document.removeEventListener('mouseup', onMouseUp);
    }

    // Hide stamp when printing
    window.addEventListener('beforeprint', function() {
        if (stampContainer.style.display === 'none') {
            stampContainer.style.display = 'block';
        }
    });
});
</script>

<!-- Print Styles -->
<style>
    @keyframes stamp {
        0% { transform: scale(3) rotate(5deg); opacity: 0; }
        10% { opacity: 0.5; }
        100% { transform: scale(1) rotate(5deg); opacity: 0.9; }
    }
    
    @media print {
        /* Ensure stamp prints with proper colors */
        [style*="background-color:"] {
            -webkit-print-color-adjust: exact !important;
            print-color-adjust: exact !important;
        }
    }
    @media print {
        body {
            -webkit-print-color-adjust: exact;
            print-color-adjust: exact;
            background: white;
            margin: 0;
            padding: 0;
        }
        @page {
            size: A4;
            margin: 1.5cm;
        }
        .no-print {
            display: none !important;
        }
        .voucher-print {
            box-shadow: none;
            border: 1px solid #e2e8f0;
        }
        body * {
            visibility: hidden;
        }
        .voucher-print, .voucher-print * {
            visibility: visible;
        }
        .voucher-print {
            position: absolute;
            left: 0;
            top: 0;
            width: 100%;
        }
    }
</style>

<script>
    // Auto-print when loaded in iframe (for print preview)
    if (window.self !== window.top) {
        window.onload = function() {
            setTimeout(function() {
                window.print();
            }, 500);
        };
    }
</script>

<?php 
// Include agent footer
require __DIR__ . '/partials/footer.php';
?>
echo $voucher->render();