<?php
// app/Views/agent/activity_checkout.php
$title = $title ?? 'Activity Checkout';
$csrf = $csrf ?? '';
$guest = $guest ?? [];
$cart = $cart ?? [];
$display_total = $display_total ?? 0.0;
require __DIR__ . '/partials/header.php';
?>
<div class="min-h-screen bg-gradient-to-br from-slate-50 via-white to-blue-50/30">
  <div class="max-w-6xl mx-auto px-4 sm:px-6 lg:px-8 py-6">
    <h1 class="text-2xl font-bold text-slate-900 mb-4">Customer Details</h1>

    <?php if (!empty($_GET['err']) && $_GET['err'] === 'csrf'): ?>
      <div class="alert alert-error mb-4">Your session expired. Please try again.</div>
    <?php endif; ?>
    <?php if (!empty($_GET['err']) && $_GET['err'] !== 'csrf'): ?>
      <?php
        $msg = '';
        switch ((string)$_GET['err']) {
          case 'missing_date': $msg = 'Please select a booking date to continue.'; break;
          case 'no_items': $msg = 'Your cart is empty. Please add at least one ticket.'; break;
          case 'no_package': $msg = 'We could not determine the package. Please re-open the activity and add items again.'; break;
          default: $msg = 'There was a problem with your submission. Please review and try again.'; break;
        }
      ?>
      <div class="alert alert-warning mb-4"><?= htmlspecialchars($msg) ?></div>
    <?php endif; ?>

    <div class="grid grid-cols-1 lg:grid-cols-3 gap-6">
      <div class="lg:col-span-2">
        <form method="post" action="/b2b/agent/activity/checkout" class="space-y-6">
          <input type="hidden" name="csrf_token" value="<?= htmlspecialchars((string)$csrf) ?>">

          <div class="card bg-white border shadow-sm">
            <div class="card-body">
              <h2 class="card-title">Lead Traveler</h2>
              <div class="grid grid-cols-1 md:grid-cols-2 gap-4 mt-2">
                <label class="form-control"><span class="label-text">Full Name</span><input name="lead_name" class="input input-bordered" required value="<?= htmlspecialchars((string)($guest['lead']['name'] ?? '')) ?>"></label>
                <label class="form-control"><span class="label-text">Phone</span><input name="lead_phone" class="input input-bordered" required value="<?= htmlspecialchars((string)($guest['lead']['phone'] ?? '')) ?>"></label>
                <label class="form-control md:col-span-2"><span class="label-text">Email</span><input type="email" name="lead_email" class="input input-bordered" required value="<?= htmlspecialchars((string)($guest['lead']['email'] ?? '')) ?>"></label>
                <label class="form-control"><span class="label-text">Nationality (optional)</span><input name="lead_nationality" class="input input-bordered" value="<?= htmlspecialchars((string)($guest['lead']['nationality'] ?? '')) ?>"></label>
                <label class="form-control"><span class="label-text">Passport No. (optional)</span><input name="lead_passport_no" class="input input-bordered" value="<?= htmlspecialchars((string)($guest['lead']['passport_no'] ?? '')) ?>"></label>
                <label class="form-control"><span class="label-text">Passport Expiry (optional)</span><input type="date" name="lead_passport_expiry" class="input input-bordered" value="<?= htmlspecialchars((string)($guest['lead']['passport_expiry'] ?? '')) ?>"></label>
              </div>
            </div>
          </div>

          <div class="card bg-white border shadow-sm">
            <div class="card-body">
              <h2 class="card-title">Experience</h2>
              <div class="grid grid-cols-1 md:grid-cols-3 gap-4 mt-2">
                <label class="form-control md:col-span-2"><span class="label-text">Booking Date</span><input name="booking_date" class="input input-bordered" placeholder="YYYY-MM-DD" required value="<?= htmlspecialchars((string)($guest['date'] ?? '')) ?>"></label>
                <label class="form-control"><span class="label-text">Show Time</span><input name="show_time" class="input input-bordered" placeholder="e.g., 19:00" value="<?= htmlspecialchars((string)($guest['show_time'] ?? '')) ?>"></label>
              </div>
            </div>
          </div>

          <div class="card bg-white border shadow-sm">
            <div class="card-body">
              <h2 class="card-title">Transport & Pickup (optional)</h2>
              <div class="grid grid-cols-1 md:grid-cols-2 gap-4 mt-2">
                <input type="hidden" name="transport_option_id" value="<?= (int)($guest['transport']['option_id'] ?? 0) ?>">
                <label class="form-control md:col-span-2"><span class="label-text">Pickup Notes</span><input name="pickup_notes" class="input input-bordered" placeholder="Hotel name, lobby, time, etc." value="<?= htmlspecialchars((string)($guest['transport']['pickup_notes'] ?? '')) ?>"></label>
                <label class="form-control"><span class="label-text">Pickup Hotel</span><input name="pickup_hotel_name" class="input input-bordered" placeholder="Hotel name" value="<?= htmlspecialchars((string)($guest['transport']['hotel_name'] ?? '')) ?>"></label>
                <label class="form-control"><span class="label-text">Hotel Address</span><input name="pickup_hotel_address" class="input input-bordered" placeholder="Address" value="<?= htmlspecialchars((string)($guest['transport']['hotel_address'] ?? '')) ?>"></label>
              </div>
            </div>
          </div>

          <div class="card bg-white border shadow-sm">
            <div class="card-body">
              <h2 class="card-title">Special Requests</h2>
              <label class="form-control"><textarea name="special_requests" class="textarea textarea-bordered" rows="3" placeholder="Any notes for vendor (optional)"><?= htmlspecialchars((string)($guest['notes'] ?? '')) ?></textarea></label>
            </div>
          </div>

          <div class="flex gap-3">
            <?php $backHref = (!empty($package_id) && (int)$package_id>0) ? ('/b2b/agent/activity?id='.(int)$package_id) : '/b2b/agent/activities'; ?>
            <a href="<?= htmlspecialchars($backHref) ?>" class="btn">Back</a>
            <button type="submit" class="btn btn-primary">Continue to Payment</button>
          </div>
        </form>
      </div>

      <aside>
        <div class="bg-white rounded-2xl shadow-xl border border-slate-200 p-5">
          <h3 class="text-sm font-semibold text-slate-800 mb-3">Order Summary</h3>
          <div class="space-y-2 text-sm text-slate-700">
            <?php if (!empty($items)): ?>
            <div class="space-y-1">
              <?php foreach ($items as $li): ?>
                <div class="flex items-center justify-between">
                  <div>
                    <div class="font-medium text-slate-800"><?= htmlspecialchars((string)($li['label'] ?? 'Ticket')) ?></div>
                    <div class="text-xs text-slate-500"><?= (int)($li['qty'] ?? 0) ?> × <?= number_format((float)($li['unit'] ?? 0), 2) ?> THB</div>
                  </div>
                  <div class="font-semibold text-slate-800"><?= number_format((float)($li['subtotal'] ?? 0), 2) ?> THB</div>
                </div>
              <?php endforeach; ?>
              <div class="border-t border-slate-200 my-2"></div>
            </div>
            <?php endif; ?>
            <div class="flex items-center justify-between">
              <span class="text-slate-600">Selected Date</span>
              <span class="font-medium"><?= htmlspecialchars((string)($guest['date'] ?? '—')) ?></span>
            </div>
            <div class="flex items-center justify-between">
              <span class="text-slate-600">Show Time</span>
              <span class="font-medium"><?= htmlspecialchars((string)($guest['show_time'] ?? '—')) ?></span>
            </div>
            <?php $topt = (int)($guest['transport']['option_id'] ?? 0); if ($topt > 0): ?>
            <div class="flex items-center justify-between">
              <span class="text-slate-600">Transport</span>
              <span class="font-medium">Selected</span>
            </div>
            <?php $pickup_notes = trim((string)($guest['transport']['pickup_notes'] ?? '')); $hotel_name = trim((string)($guest['transport']['hotel_name'] ?? '')); $hotel_addr = trim((string)($guest['transport']['hotel_address'] ?? '')); ?>
            <?php if ($pickup_notes !== '' || $hotel_name !== '' || $hotel_addr !== ''): ?>
            <div class="mt-1 text-xs text-slate-500 space-y-0.5">
              <?php if ($pickup_notes !== ''): ?><div>Notes: <?= htmlspecialchars($pickup_notes) ?></div><?php endif; ?>
              <?php if ($hotel_name !== ''): ?><div>Hotel: <?= htmlspecialchars($hotel_name) ?></div><?php endif; ?>
              <?php if ($hotel_addr !== ''): ?><div>Address: <?= htmlspecialchars($hotel_addr) ?></div><?php endif; ?>
            </div>
            <?php endif; ?>
            <?php endif; ?>
            <div class="pt-3 mt-2 border-t border-slate-200 flex items-center justify-between">
              <span class="font-semibold">Estimated Total</span>
              <span class="text-lg font-bold text-brand-600"><?= number_format((float)$display_total, 2) ?> THB</span>
            </div>
          </div>
        </div>
      </aside>
    </div>
  </div>
</div>
<?php require __DIR__ . '/partials/footer.php'; ?>
