<?php
// app/Views/admin/yachts_index.php
?>
<div class="container py-3">
  <style>
    .yh-table-wrap { border: 1px solid #e9ecef; border-radius: 8px; overflow-x: auto; background: #fff; }
    .yh-table thead th { position: sticky; top: 0; background: #f8f9fa; z-index: 1; box-shadow: inset 0 -1px 0 #e9ecef; }
    .yh-toolbar { gap: .5rem; flex-wrap: wrap; background:#fff; border:1px solid #e9ecef; border-radius:10px; padding:.5rem .75rem; box-shadow: 0 1px 2px rgba(16,24,40,.04); }
    .yh-action-btn.btn { background: transparent !important; border-color: transparent !important; box-shadow: none !important; padding: .125rem .25rem; border-radius: 6px; display:inline-flex; align-items:center; justify-content:center; color:#111827; }
    .yh-action-btn i { font-size:1.05rem; color:#111827 !important; }
    .yh-action-btn.btn:hover i { color:#0d6efd !important; }
    .badge.bg-success, .badge.bg-secondary { border-radius: 999px; padding:.35em .6em; font-weight:600; letter-spacing:.2px; }
    .badge.bg-secondary { background-color:#E5E7EB !important; color:#374151; }
    .pagination .page-link { color:#334155; border-color:#E5E7EB; }
    .pagination .page-item.active .page-link { background:#2E90FA; border-color:#2E90FA; color:#fff; box-shadow: 0 1px 2px rgba(16,24,40,.12); }
    .pagination .page-item.disabled .page-link { color:#94A3B8; }
    .form-check-input.yh-status-switch { width: 2.5em; height: 1.25em; }
    @media (max-width: 576px){
      .yh-toolbar { row-gap:.5rem; padding:.5rem; }
      .yh-toolbar .input-group { width: 100%; }
      .yh-toolbar .ms-auto { width: 100%; display:flex; flex-wrap: wrap; gap:.5rem; justify-content: space-between; }
      #yachtStatus, #yachtRows { flex:1 1 calc(50% - .5rem); min-width: 140px; }
    }
  </style>
  <h2 class="h5 mb-3"><i class="bi bi-tsunami me-2"></i>Yachts Management</h2>

  <?php if (!empty($_SESSION['flash'])): ?>
    <div class="alert alert-success py-1 small"><?php echo htmlspecialchars($_SESSION['flash']); unset($_SESSION['flash']); ?></div>
  <?php endif; ?>
  <?php if (!empty($_SESSION['errors'])): ?>
    <div class="alert alert-danger py-1 small">
      <?php foreach ($_SESSION['errors'] as $e): ?>
        <div><?php echo htmlspecialchars($e) ?></div>
      <?php endforeach; unset($_SESSION['errors']); ?>
    </div>
  <?php endif; ?>

  <?php if (empty($unlocked)): ?>
    <div class="card mx-auto" style="max-width: 420px;">
      <div class="card-body">
        <h5 class="card-title h6 mb-3">Unlock Yachts</h5>
        <form method="post" action="/admin/yachts/unlock">
          <input type="hidden" name="csrf" value="<?= htmlspecialchars($csrf) ?>">
          <div class="mb-3">
            <label class="form-label">Update Password</label>
            <input type="password" name="master_password" class="form-control form-control-sm" required>
          </div>
          <button class="btn btn-sm btn-primary">Unlock</button>
        </form>
      </div>
    </div>
  <?php else: ?>
    <div class="d-flex justify-content-between align-items-center mb-2">
      <h4 class="mb-0 h6">Yacht List</h4>
      <a class="btn btn-sm btn-primary" href="/admin/yachts/create" title="Add Yacht" data-bs-toggle="tooltip" aria-label="Add Yacht">
        <i class="bi bi-plus-circle"></i>
      </a>
    </div>
    <div class="d-flex yh-toolbar align-items-center mb-2">
      <div class="input-group input-group-sm" style="max-width:320px;">
        <span class="input-group-text"><i class="bi bi-search"></i></span>
        <input type="text" id="yachtSearch" class="form-control" placeholder="Search name, city">
      </div>
      <div class="ms-auto d-flex gap-2 align-items-center">
        <button type="button" class="btn btn-sm btn-warning" id="yachtsUnlockBtn" <?= empty($unlocked) ? '' : 'disabled' ?> data-bs-toggle="tooltip" title="Unlock delete functionality">
          <i class="bi bi-unlock me-1"></i> Unlock Delete
        </button>
        <label class="small text-muted mb-0">Status:</label>
        <select id="yachtStatus" class="form-select form-select-sm" style="width:130px;">
          <option value="">All</option>
          <option value="Active">Active</option>
          <option value="Inactive">Inactive</option>
        </select>
        <label class="small text-muted mb-0">Rows:</label>
        <select id="yachtRows" class="form-select form-select-sm" style="width:80px;">
          <option>10</option>
          <option selected>25</option>
          <option>50</option>
          <option>100</option>
        </select>
        <button id="yachtExportCsv" class="btn btn-outline-secondary btn-sm" title="Export CSV" data-bs-toggle="tooltip" aria-label="Export CSV">
          <i class="bi bi-download"></i>
        </button>
      </div>
    </div>
    <div class="table-responsive yh-table-wrap">
      <table class="table table-striped table-hover align-middle yh-table mb-0">
        <thead class="table-light">
          <tr>
            <th>#</th>
            <th>Thumbnail</th>
            <th>Name</th>
            <th>City</th>
            <th>Capacity</th>
            <th>Max Guests</th>
            <th>From Price</th>
            <th>Status</th>
            <th>Actions</th>
          </tr>
        </thead>
        <tbody>
        <?php foreach (($rows ?? []) as $r): ?>
          <tr>
            <td class="yh-col-idx"></td>
            <td>
              <?php
                $cover = (string)($r['cover_path'] ?? '');
                if ($cover !== '') {
                  $bn = basename($cover);
                  $thumbRel = '/assets/uploads/thumbs/' . 'th_' . $bn;
                  $thumbAbs = BASE_PATH . '/public' . $thumbRel;
                  $thumbUrl = file_exists($thumbAbs) ? $thumbRel : $cover;
                } else {
                  $thumbUrl = '';
                }
              ?>
              <?php if ($thumbUrl): ?>
                <img src="<?= htmlspecialchars($thumbUrl) ?>" alt="cover" class="img-thumbnail" style="width:56px;height:56px;object-fit:cover;">
              <?php else: ?>
                <span class="text-muted small">—</span>
              <?php endif; ?>
            </td>
            <td><?= htmlspecialchars($r['name'] ?? '') ?></td>
            <td><?= htmlspecialchars($r['city'] ?? '') ?></td>
            <td><?= htmlspecialchars((string)($r['capacity'] ?? '')) ?></td>
            <td><?= htmlspecialchars((string)($r['max_guests'] ?? '')) ?></td>
            <td><?= htmlspecialchars(number_format((float)($r['from_price'] ?? 0), 2)) ?> <?= htmlspecialchars($r['currency'] ?? 'THB') ?></td>
            <td>
              <?php if ((int)($r['active'] ?? 1) === 1): ?>
                <span class="badge text-bg-success">Active</span>
              <?php else: ?>
                <span class="badge text-bg-secondary">Inactive</span>
              <?php endif; ?>
            </td>
            <td class="text-end">
              <a class="btn btn-outline-secondary btn-sm yh-action-btn" href="/admin/yachts/edit?id=<?= (int)$r['id'] ?>" title="Edit" data-bs-toggle="tooltip" aria-label="Edit"><i class="bi bi-pencil"></i></a>
              <form method="post" action="<?= ((int)($r['active'] ?? 1) === 1) ? '/admin/yachts/disable' : '/admin/yachts/enable' ?>" class="d-inline-flex align-items-center gap-2 toggle-active-form" onsubmit="return confirm(this.querySelector('input[type=checkbox]').checked ? 'Enable this yacht?' : 'Disable this yacht?')">
                <input type="hidden" name="csrf" value="<?= htmlspecialchars($csrf) ?>">
                <input type="hidden" name="id" value="<?= (int)$r['id'] ?>">
                <div class="form-check form-switch m-0">
                  <input class="form-check-input yh-status-switch" type="checkbox"
                         role="switch"
                         data-enable-url="/admin/yachts/enable"
                         data-disable-url="/admin/yachts/disable"
                         onchange="this.form.action = this.checked ? this.dataset.enableUrl : this.dataset.disableUrl; this.form.submit();"
                         <?= ((int)($r['active'] ?? 1) === 1) ? 'checked' : '' ?>
                  >
                </div>
              </form>
              <form action="/admin/yachts/delete" method="post" class="d-inline" onsubmit="return confirm('Are you sure you want to delete this yacht?')">
                <input type="hidden" name="id" value="<?= (int)$r['id'] ?>">
                <input type="hidden" name="csrf" value="<?= htmlspecialchars($csrf) ?>">
                <button type="submit" class="btn btn-sm btn-danger yh-action-btn" title="Delete" data-bs-toggle="tooltip">
                  <i class="bi bi-trash3"></i>
                </button>
              </form>
            </td>
          </tr>
        <?php endforeach; ?>
        <?php if (empty($rows)): ?>
          <tr><td colspan="9" class="text-center text-muted py-3">No yachts yet.</td></tr>
        <?php endif; ?>
        </tbody>
      </table>
    </div>
    <div class="d-flex justify-content-between align-items-center mt-2">
      <div class="small text-muted" id="yachtCount"></div>
      <nav>
        <ul class="pagination pagination-sm mb-0" id="yachtPager"></ul>
      </nav>
    </div>
  <?php endif; ?>
</div>

<!-- Unlock Modal -->
<div class="modal fade" id="unlockYachtsModal" tabindex="-1" aria-hidden="true">
  <div class="modal-dialog">
    <div class="modal-content">
      <div class="modal-header">
        <h5 class="modal-title">Unlock Yacht Management</h5>
        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
      </div>
      <form method="post" action="/admin/yachts/unlock">
        <input type="hidden" name="csrf" value="<?= htmlspecialchars($csrf) ?>">
        <div class="modal-body">
          <div class="mb-3">
            <label for="masterPassword" class="form-label">Enter Admin Master Password</label>
            <input type="password" class="form-control" id="masterPassword" name="master_password" required autocomplete="off">
            <div class="form-text">Enter the master password to enable delete functionality.</div>
          </div>
        </div>
        <div class="modal-footer">
          <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancel</button>
          <button type="submit" class="btn btn-primary">Unlock</button>
        </div>
      </form>
    </div>
  </div>
</div>

<!-- Already Unlocked Toast -->
<div class="position-fixed bottom-0 end-0 p-3" style="z-index: 1200">
  <div id="alreadyUnlockedToast" class="toast" role="alert" aria-live="assertive" aria-atomic="true">
    <div class="toast-header bg-success text-white">
      <strong class="me-auto">Already Unlocked</strong>
      <button type="button" class="btn-close btn-close-white" data-bs-dismiss="toast" aria-label="Close"></button>
    </div>
    <div class="toast-body">
      Delete functionality is already unlocked for this session.
    </div>
  </div>
</div>

<script>
// Unlock delete functionality with enhanced error handling
(function(){
  const btn = document.getElementById('yachtsUnlockBtn');
  if (btn) {
    btn.addEventListener('click', function(e) {
      e.preventDefault();
      
      <?php if (empty($unlocked)): ?>
        // Show modal
        const modalEl = document.getElementById('unlockYachtsModal');
        if (modalEl) {
          const modal = new bootstrap.Modal(modalEl);
          modal.show();
        } else {
          console.error('Modal element not found');
          alert('Error: Could not load unlock form. Please refresh the page.');
        }
      <?php else: ?>
        // Show toast
        const toastEl = document.getElementById('alreadyUnlockedToast');
        if (toastEl) {
          const toast = new bootstrap.Toast(toastEl);
          toast.show();
        } else {
          alert('Delete functionality is already unlocked for this session.');
        }
      <?php endif; ?>
    });
  }

  // Initialize tooltips
  const tooltipTriggerList = [].slice.call(document.querySelectorAll('[data-bs-toggle="tooltip"]'));
  tooltipTriggerList.map(function (tooltipTriggerEl) {
    return new bootstrap.Tooltip(tooltipTriggerEl);
  });

  // Table functionality
  const table = document.querySelector('.yh-table');
  if (!table) return;
  const tbody = table.querySelector('tbody');
  const rows = Array.from(tbody.querySelectorAll('tr'));
  const search = document.getElementById('yachtSearch');
  const rowsSel = document.getElementById('yachtRows');
  const statusSel = document.getElementById('yachtStatus');
  const pager = document.getElementById('yachtPager');
  const count = document.getElementById('yachtCount');
  const exportBtn = document.getElementById('yachtExportCsv');

  const data = rows.map(tr => ({ tr }));
  let filtered = data.slice();
  let page = 1;
  let perPage = parseInt(rowsSel ? rowsSel.value : '25', 10) || 25;

  function normalize(s){ return (s||'').toString().toLowerCase(); }
  function rowStatus(tr){
    const badge = tr.querySelector('td:nth-child(8) .badge'); // Status column index
    return badge ? (badge.textContent||'').trim() : '';
  }

  function applyFilter(){
    const q = normalize(search ? search.value : '');
    const wantStatus = (statusSel && statusSel.value) ? statusSel.value : '';
    filtered = data.filter(item => {
      const trTxt = normalize(item.tr.innerText);
      const matchesText = q ? trTxt.includes(q) : true;
      const matchesStatus = wantStatus ? (rowStatus(item.tr) === wantStatus) : true;
      return matchesText && matchesStatus;
    });
    page = 1; render();
  }

  function render(){
    rows.forEach(r => r.style.display = 'none');
    const total = filtered.length;
    const pages = Math.max(1, Math.ceil(total / perPage));
    if (page > pages) page = pages;
    const start = (page - 1) * perPage;
    filtered.slice(start, start + perPage).forEach((item, idx) => {
      if (item.tr) {
        item.tr.style.display = '';
        const cell = item.tr.querySelector('td.yh-col-idx');
        if (cell) cell.textContent = String(start + idx + 1);
      }
    });
    if (pager){
      pager.innerHTML = '';
      const prev = document.createElement('li');
      prev.className = 'page-item' + (page<=1?' disabled':'');
      prev.innerHTML = '<a class="page-link" href="#" aria-label="Previous">&laquo;</a>';
      prev.onclick = (e)=>{ e.preventDefault(); if(page>1){ page--; render(); } };
      pager.appendChild(prev);
      const windowSize = 7;
      let startPage = Math.max(1, page - Math.floor(windowSize/2));
      let endPage = Math.min(pages, startPage + windowSize - 1);
      startPage = Math.max(1, endPage - windowSize + 1);
      for (let n = startPage; n <= endPage; n++){
        const li = document.createElement('li');
        li.className = 'page-item' + (n===page?' active':'');
        li.innerHTML = '<a class="page-link" href="#">'+n+'</a>';
        li.onclick = (e)=>{ e.preventDefault(); page=n; render(); };
        pager.appendChild(li);
      }
      const next = document.createElement('li');
      next.className = 'page-item' + (page>=pages?' disabled':'');
      next.innerHTML = '<a class="page-link" href="#" aria-label="Next">&raquo;</a>';
      next.onclick = (e)=>{ e.preventDefault(); if(page<pages){ page++; render(); } };
      pager.appendChild(next);
    }
    if (count) count.textContent = total + ' result' + (total===1?'':'s') + (pages>1? (' • page '+page+'/'+pages):'');
  }

  function exportCsv(){
    const headers = Array.from(table.querySelectorAll('thead th')).map(th => th.textContent.trim());
    const idxActions = headers.findIndex(h => h.toLowerCase() === 'actions');
    const headersOut = headers.filter((_,i)=> i !== idxActions);
    const visibleRows = filtered.map(item => Array.from(item.tr.children).filter((_,i)=> i !== idxActions).map(td => '"' + (td.innerText||'').replaceAll('"','""') + '"'));
    const csv = [headersOut.join(','), ...visibleRows.map(cols => cols.join(','))].join('\n');
    const blob = new Blob([csv], {type: 'text/csv;charset=utf-8;'});
    const url = URL.createObjectURL(blob);
    const a = document.createElement('a'); a.href = url; a.download = 'yachts.csv'; a.click(); URL.revokeObjectURL(url);
  }

  if (search) search.addEventListener('input', function(){ clearTimeout(window.__yhT); window.__yhT=setTimeout(applyFilter,150); });
  if (statusSel) statusSel.addEventListener('change', applyFilter);
  if (rowsSel) rowsSel.addEventListener('change', function(){ perPage = parseInt(this.value,10)||25; render(); });
  if (exportBtn) exportBtn.addEventListener('click', function(e){ e.preventDefault(); exportCsv(); });

  applyFilter();

  if (window.bootstrap) {
    var tts = [].slice.call(document.querySelectorAll('[data-bs-toggle="tooltip"]'));
    tts.forEach(function(el){ try { new bootstrap.Tooltip(el); } catch(e){} });
  }
})();
</script>
