<?php
// app/Views/admin/yachts_form.php
$editing = !empty($yacht['id']);
$action = $editing ? '/admin/yachts/update' : '/admin/yachts/store';
?>
<div class="container py-3">
  <h2 class="h5 mb-3 d-flex align-items-center">
    <i class="bi bi-tsunami me-2"></i>
    <?= $editing ? 'Edit Yacht' : 'Create Yacht' ?>
  </h2>

  <?php if (!empty($_SESSION['errors'])): ?>
    <div class="alert alert-danger py-2 small">
      <?php foreach ($_SESSION['errors'] as $e): ?>
        <div><?= htmlspecialchars($e) ?></div>
      <?php endforeach; unset($_SESSION['errors']); ?>
    </div>
  <?php endif; ?>

  <form method="post" action="<?= $action ?>" enctype="multipart/form-data" class="needs-validation" novalidate>
    <input type="hidden" name="csrf" value="<?= htmlspecialchars($csrf) ?>">
    <?php if ($editing): ?>
      <input type="hidden" name="id" value="<?= (int)$yacht['id'] ?>">
    <?php endif; ?>

    <ul class="nav nav-tabs small" id="yachtTabs" role="tablist">
      <li class="nav-item" role="presentation">
        <button class="nav-link active" id="tab-details" data-bs-toggle="tab" data-bs-target="#pane-details" type="button" role="tab">Details</button>
      </li>
      <li class="nav-item" role="presentation">
        <button class="nav-link" id="tab-media" data-bs-toggle="tab" data-bs-target="#pane-media" type="button" role="tab">Media</button>
      </li>
    </ul>

    <div class="tab-content border border-top-0 rounded-bottom p-3 bg-white" id="yachtTabsContent">
      <div class="tab-pane fade show active" id="pane-details" role="tabpanel" aria-labelledby="tab-details" tabindex="0">
        <div class="row g-3">
          <div class="col-md-4">
            <label class="form-label">Name</label>
            <input type="text" name="name" value="<?= htmlspecialchars((string)($yacht['name'] ?? '')) ?>" class="form-control form-control-sm" required />
          </div>
          <div class="col-md-4">
            <label class="form-label">Subtitle</label>
            <input type="text" name="subtitle" value="<?= htmlspecialchars((string)($yacht['subtitle'] ?? '')) ?>" class="form-control form-control-sm" />
          </div>
          <div class="col-md-4">
            <label class="form-label">City</label>
            <input type="text" name="city" value="<?= htmlspecialchars((string)($yacht['city'] ?? '')) ?>" class="form-control form-control-sm" />
          </div>

          <div class="col-md-3">
            <label class="form-label">Booking Code</label>
            <input type="text" name="booking_code" value="<?= htmlspecialchars((string)($yacht['booking_code'] ?? '')) ?>" class="form-control form-control-sm" placeholder="Optional code for API fetch" />
            <div class="form-text">Agents can search this code via API.</div>
          </div>
          <div class="col-md-2">
            <label class="form-label">Capacity</label>
            <input type="number" min="1" name="capacity" value="<?= htmlspecialchars((string)($yacht['capacity'] ?? '')) ?>" class="form-control form-control-sm" required />
          </div>
          <div class="col-md-2">
            <label class="form-label">Max Guests</label>
            <input type="number" min="1" name="max_guests" value="<?= htmlspecialchars((string)($yacht['max_guests'] ?? '')) ?>" class="form-control form-control-sm" required />
          </div>
          <div class="col-md-2">
            <label class="form-label">From Price</label>
            <input type="number" step="0.01" min="0" name="from_price" value="<?= htmlspecialchars((string)($yacht['from_price'] ?? '')) ?>" class="form-control form-control-sm" />
          </div>
          <div class="col-md-1">
            <label class="form-label">Currency</label>
            <?php
              $cur = (string)($yacht['currency'] ?? 'THB');
              $codes = [];
              if (!empty($currencyCodes) && is_array($currencyCodes)) {
                foreach ($currencyCodes as $row) {
                  if (is_array($row)) { $code = (string)($row['code'] ?? ''); }
                  else { $code = (string)$row; }
                  if ($code !== '') { $codes[] = $code; }
                }
                $codes = array_values(array_unique($codes));
              }
              if (empty($codes)) { $codes = ['THB','USD','INR','AED','EUR']; }
            ?>
            <select name="currency" class="form-select form-select-sm">
              <?php foreach ($codes as $cc): ?>
                <option value="<?= htmlspecialchars($cc) ?>" <?= $cur===$cc?'selected':'' ?>><?= htmlspecialchars($cc) ?></option>
              <?php endforeach; ?>
            </select>
          </div>
          <div class="col-md-2 form-check ms-2 mt-4">
            <?php $active = (int)($yacht['active'] ?? 1) === 1; ?>
            <input class="form-check-input" type="checkbox" value="1" id="activeChk" name="active" <?= $active ? 'checked' : '' ?>>
            <label class="form-check-label" for="activeChk">Active</label>
          </div>
          <div class="col-md-2 form-check ms-2 mt-4">
            <?php $visibleAgent = (int)($yacht['visible_agent'] ?? 1) === 1; ?>
            <input class="form-check-input" type="checkbox" value="1" id="visibleAgentChk" name="visible_agent" <?= $visibleAgent ? 'checked' : '' ?>>
            <label class="form-check-label" for="visibleAgentChk">Visible to Agents</label>
          </div>

          <div class="col-12">
            <label class="form-label">Description</label>
            <textarea name="description" rows="4" class="form-control form-control-sm" placeholder="Yacht details, inclusions, notes..."><?= htmlspecialchars((string)($yacht['description'] ?? '')) ?></textarea>
          </div>

          <div class="col-12">
            <div class="row g-3">
              <div class="col-md-3">
                <label class="form-label">Vendor Cost</label>
                <input type="number" step="0.01" min="0" name="vendor_cost" value="<?= htmlspecialchars((string)($yacht['vendor_cost'] ?? '')) ?>" class="form-control form-control-sm" />
              </div>
              <div class="col-md-3">
                <label class="form-label">Agent Cost</label>
                <input type="number" step="0.01" min="0" name="agent_cost" value="<?= htmlspecialchars((string)($yacht['agent_cost'] ?? '')) ?>" class="form-control form-control-sm" />
                <div class="form-text">B2B agents will see this in API.</div>
              </div>
              <div class="col-md-3">
                <label class="form-label">Customer Cost</label>
                <input type="number" step="0.01" min="0" name="customer_cost" value="<?= htmlspecialchars((string)($yacht['customer_cost'] ?? '')) ?>" class="form-control form-control-sm" />
                <div class="form-text">If From Price empty, we'll default to this for display.</div>
              </div>
            </div>
          </div>
        </div>
      </div>

      <div class="tab-pane fade" id="pane-media" role="tabpanel" aria-labelledby="tab-media" tabindex="0">
        <link rel="stylesheet" href="/assets/css/media-uploader.css">
        <div class="row g-3">
          <div class="col-md-8">
            <label class="form-label">Upload Images</label>
            <div id="yacht-media" class="mu" data-upload-url="/admin/media/upload">
              <input type="hidden" name="csrf" value="<?= htmlspecialchars($csrf) ?>">
            </div>
            <input type="hidden" name="media_json" id="media_json" value="<?= htmlspecialchars((string)($yacht['media_json'] ?? '')) ?>">
            <div class="form-text">Drag & drop images or click the box. JPG/PNG/WEBP up to 5MB each. Thumbnails are created automatically.</div>
            <input type="file" name="images[]" class="form-control form-control-sm d-none" accept="image/*" multiple>
          </div>
          <div class="col-md-4">
            <label class="form-label">Cover Index</label>
            <input type="number" min="0" name="cover_index" value="<?= htmlspecialchars((string)($yacht['cover_index'] ?? '0')) ?>" class="form-control form-control-sm" />
            <div class="form-text">Which image should be the cover (0-based).</div>
          </div>
        </div>
        <script src="/assets/js/media-uploader.js" defer></script>
        <script>
          document.addEventListener('DOMContentLoaded', function(){
            var container = document.getElementById('yacht-media');
            var hidden = document.getElementById('media_json');
            if (!container || !hidden) return;
            var gridObserver = new MutationObserver(function(){
              var items = container.querySelectorAll('.mu-item');
              var files = [];
              items.forEach(function(it){
                var orig = it.dataset.originalUrl; var th = it.dataset.thumbUrl;
                if (orig) files.push({originalUrl: orig, thumbUrl: th || ''});
              });
              hidden.value = JSON.stringify(files);
            });
            gridObserver.observe(container, {subtree:true, childList:true, attributes:true, attributeFilter:['data-original-url','data-thumb-url']});
          });
        </script>
      </div>
    </div>

    <div class="d-flex justify-content-between align-items-center gap-2 mt-3">
      <a class="btn btn-sm btn-secondary" href="/admin/yachts">Cancel</a>
      <button class="btn btn-sm btn-primary"><?= $editing ? 'Save Changes' : 'Create Yacht' ?></button>
    </div>
  </form>
</div>
