<?php /** @var array $settings */ ?>
<div class="container py-4">
  <div class="d-flex align-items-center mb-3">
    <h4 class="m-0">WhatsApp Settings</h4>
    <a href="/admin/logs/whatsapp" class="btn btn-link ms-auto">View Logs</a>
  </div>

  <?php if (!empty($_SESSION['flash'])): ?>
    <div class="alert alert-success"><?= htmlspecialchars($_SESSION['flash']); unset($_SESSION['flash']); ?></div>
  <?php endif; ?>
  <?php if (!empty($_SESSION['errors'])): ?>
    <div class="alert alert-danger">
      <?php foreach ((array)$_SESSION['errors'] as $e): ?><div>- <?= htmlspecialchars($e) ?></div><?php endforeach; unset($_SESSION['errors']); ?>
    </div>
  <?php endif; ?>

  <div class="card shadow-sm">
    <div class="card-body">
      <form method="post" action="/admin/settings/whatsapp">
        <input type="hidden" name="csrf" value="<?= htmlspecialchars($csrf) ?>">

        <div class="row g-3">
          <div class="col-md-4">
            <label class="form-label fw-semibold">Active Provider</label>
            <?php $ap = $settings['active_provider'] ?? 'disabled'; ?>
            <select name="active_provider" class="form-select">
              <option value="disabled" <?= $ap==='disabled'?'selected':'' ?>>Disabled</option>
              <option value="aisensy" <?= $ap==='aisensy'?'selected':'' ?>>AiSensy</option>
              <option value="twilio" <?= $ap==='twilio'?'selected':'' ?>>Twilio</option>
            </select>
          </div>
          <div class="col-md-4">
            <label class="form-label">Default Locale</label>
            <input type="text" name="default_locale" class="form-control" value="<?= htmlspecialchars($settings['default_locale'] ?? 'en') ?>">
          </div>
        </div>

        <hr>
        <h6 class="text-uppercase text-muted">AiSensy</h6>
        <div class="row g-3">
          <div class="col-md-6">
            <label class="form-label">API Base</label>
            <input type="text" name="aisensy_api_base" class="form-control" value="<?= htmlspecialchars($settings['aisensy_api_base'] ?? 'https://backend.aisensy.com') ?>">
          </div>
          <div class="col-md-6">
            <label class="form-label">API Key / Token</label>
            <input type="password" name="aisensy_api_key" class="form-control" value="<?= htmlspecialchars($settings['aisensy_api_key'] ?? '') ?>" placeholder="eyJhbGci...">
          </div>
          <div class="col-md-6">
            <label class="form-label">Sender</label>
            <input type="text" name="aisensy_sender" class="form-control" value="<?= htmlspecialchars($settings['aisensy_sender'] ?? '') ?>" placeholder="whatsapp:+E164 or sender id">
          </div>
        </div>

        <hr>
        <h6 class="text-uppercase text-muted">Twilio</h6>
        <div class="row g-3">
          <div class="col-md-4">
            <label class="form-label">Account SID</label>
            <input type="text" name="twilio_sid" class="form-control" value="<?= htmlspecialchars($settings['twilio_sid'] ?? '') ?>">
          </div>
          <div class="col-md-4">
            <label class="form-label">Auth Token</label>
            <input type="password" name="twilio_token" class="form-control" value="<?= htmlspecialchars($settings['twilio_token'] ?? '') ?>">
          </div>
          <div class="col-md-4">
            <label class="form-label">From (whatsapp:+E164)</label>
            <input type="text" name="twilio_from" class="form-control" value="<?= htmlspecialchars($settings['twilio_from'] ?? '') ?>" placeholder="whatsapp:+1415XXXXXXX">
          </div>
        </div>

        <hr>
        <h6 class="text-uppercase text-muted">Per-Notification Toggles</h6>
        <div class="row g-3">
          <?php function cbwa($key,$label,$settings){ $val = (int)($settings[$key] ?? 0); ?>
            <div class="col-md-3"><div class="form-check form-switch">
              <input class="form-check-input" type="checkbox" name="<?= $key ?>" id="<?= $key ?>" <?= $val? 'checked':'' ?>>
              <label class="form-check-label" for="<?= $key ?>"><?= $label ?></label>
            </div></div>
          <?php } ?>
          <?php cbwa('enable_taxi_vendor','Taxi → Vendor',$settings); cbwa('enable_taxi_agent','Taxi → Agent',$settings); cbwa('enable_taxi_internal','Taxi → Internal',$settings); ?>
          <?php cbwa('enable_hotel_vendor','Hotel → Vendor',$settings); cbwa('enable_hotel_agent','Hotel → Agent',$settings); cbwa('enable_hotel_internal','Hotel → Internal',$settings); ?>
          <?php cbwa('enable_activity_vendor','Activity → Vendor',$settings); cbwa('enable_activity_agent','Activity → Agent',$settings); cbwa('enable_activity_internal','Activity → Internal',$settings); ?>
        </div>

        <div class="mt-4 d-flex align-items-center gap-2">
          <div class="ms-auto"></div>
          <div>
            <label class="form-label">Master Password</label>
            <input type="password" class="form-control" name="master_password" required>
          </div>
          <button type="submit" class="btn btn-primary">Save Settings</button>
        </div>
      </form>

      <hr class="my-4">
      <div class="d-flex justify-content-between align-items-center">
        <div>
          <button type="button" class="btn btn-outline-primary" data-bs-toggle="modal" data-bs-target="#waTestModal">
            <i class="bi bi-send"></i> Send Test via Active Provider
          </button>
        </div>
        <form method="post" action="/admin/whatsapp/queue/process" class="d-flex align-items-end gap-2">
          <div>
            <label class="form-label">Process Queue (batch size)</label>
            <input type="number" name="limit" class="form-control" value="20" min="1" max="100">
          </div>
          <input type="hidden" name="csrf" value="<?= htmlspecialchars($csrf) ?>">
          <button type="submit" class="btn btn-success">Process Now</button>
        </form>
      </div>
    </div>
  </div>
</div>

<div class="modal fade" id="waTestModal" tabindex="-1" aria-hidden="true">
  <div class="modal-dialog modal-dialog-centered">
    <div class="modal-content">
      <form method="post" action="/admin/settings/whatsapp/test">
        <div class="modal-header">
          <h5 class="modal-title">Send WhatsApp Test</h5>
          <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
        </div>
        <div class="modal-body">
          <input type="hidden" name="csrf" value="<?= htmlspecialchars($csrf) ?>">
          <div class="mb-2">
            <label class="form-label">To Phone</label>
            <input type="text" class="form-control" name="to" placeholder="+66XXXXXXXXX or 91XXXXXXXXXX" required>
          </div>
          <div class="mb-2">
            <label class="form-label">From (optional)</label>
            <input type="text" class="form-control" name="from" placeholder="Mittos sender or whatsapp:+E164 for Twilio">
          </div>
          <div class="mb-2">
            <label class="form-label">Message</label>
            <textarea class="form-control" name="text" rows="3" placeholder="Hello, this is a test." required></textarea>
          </div>
          <hr>
          <div class="row g-2">
            <div class="col-md-6">
              <label class="form-label">Campaign/Template Name (AiSensy)</label>
              <input type="text" class="form-control" name="campaignName" placeholder="e.g., confirmation">
            </div>
            <div class="col-md-6">
              <label class="form-label">Template Params (comma-separated)</label>
              <input type="text" class="form-control" name="templateParams" placeholder="K Digital Solutions, ABC123, confirm">
            </div>
            <div class="col-md-6">
              <label class="form-label">userName (optional)</label>
              <input type="text" class="form-control" name="userName" placeholder="your username if required">
            </div>
            <div class="col-md-6">
              <label class="form-label">source (optional)</label>
              <input type="text" class="form-control" name="source" placeholder="api">
            </div>
          </div>
        </div>
        <div class="modal-footer">
          <button type="button" class="btn btn-light" data-bs-dismiss="modal">Cancel</button>
          <button type="submit" class="btn btn-primary">Send Test</button>
        </div>
      </form>
    </div>
  </div>
</div>
