<?php
// app/Views/admin/wallet_ledger.php
?>
<div class="container py-4">
  <div class="d-flex align-items-center justify-content-between mb-3">
    <h1 class="h4 mb-0">Wallet Ledger (Last 200)</h1>
    <div>
      <a href="/admin/wallet/manual" class="btn btn-sm btn-outline-primary">Manual Entry</a>
      <a href="/admin/wallet/secure" class="btn btn-sm btn-outline-secondary">Secure Wallet</a>
      <a href="/admin" class="btn btn-sm btn-outline-dark">Dashboard</a>
    </div>
  </div>

  <div class="card shadow-sm">
    <div class="table-responsive">
      <table class="table align-middle mb-0">
        <thead>
          <tr>
            <th>ID</th>
            <th>User</th>
            <th>Email</th>
            <th>Type</th>
            <th>Amount</th>
            <th>Method</th>
            <th>Status</th>
            <th>Created</th>
          </tr>
        </thead>
        <tbody>
          <?php if (!empty($rows)): foreach ($rows as $r): ?>
            <tr>
              <td>#<?php echo (int)$r['id']; ?></td>
              <td><?php echo htmlspecialchars($r['user_name']); ?></td>
              <td class="text-muted small"><?php echo htmlspecialchars($r['email']); ?></td>
              <td class="text-uppercase"><?php echo htmlspecialchars($r['type']); ?></td>
              <td><strong><?php echo number_format((float)$r['amount'], 2); ?></strong></td>
              <td><?php echo htmlspecialchars($r['method']); ?></td>
              <td>
                <?php
                  $status = (string)$r['status'];
                  $badge = $status === 'approved' ? 'bg-success' : ($status === 'pending' ? 'bg-warning text-dark' : 'bg-danger');
                ?>
                <span class="badge <?php echo $badge; ?>"><?php echo htmlspecialchars($status); ?></span>
              </td>
              <td><?php echo htmlspecialchars($r['created_at'] ?? ''); ?></td>
            </tr>
          <?php endforeach; else: ?>
            <tr>
              <td colspan="8" class="text-center text-muted py-4">No ledger entries.</td>
            </tr>
          <?php endif; ?>
        </tbody>
      </table>
    </div>
  </div>
</div>
