<div class="container-xxl py-3">
  <nav aria-label="breadcrumb" class="mb-3">
    <ol class="breadcrumb mb-0">
      <li class="breadcrumb-item"><a href="/admin">Dashboard</a></li>
      <li class="breadcrumb-item active" aria-current="page">Wallet Deposits</li>
    </ol>
  </nav>

  <div class="d-flex align-items-center justify-content-between mb-3">
    <div>
      <h1 class="h4 mb-0">Wallet Deposit Requests</h1>
      <div class="text-muted small">Track, verify and approve agent wallet top-ups</div>
    </div>
    <div class="btn-group">
      <a href="/admin/bank-accounts" class="btn btn-outline-secondary"><i class="bi bi-bank me-1"></i> Bank Accounts</a>
      <a href="/admin/wallet/deposits/export.csv<?php echo ($status??'')!==''?('?status='.urlencode($status)) : '';?>" class="btn btn-success"><i class="bi bi-download me-1"></i> Export CSV</a>
    </div>
  </div>

  <ul class="nav nav-pills gap-1 mb-3">
    <?php $st = (string)($status ?? 'pending');
      $pill = function($key,$label) use ($st){
        $active = $st===$key ? 'active' : '';
        echo '<li class="nav-item"><a class="nav-link '.$active.'" href="/admin/wallet/deposits?status='.$key.'">'.$label.'</a></li>';
      };
    ?>
    <?php $pill('pending','Pending'); ?>
    <?php $pill('bank_assigned','Bank Assigned'); ?>
    <?php $pill('under_verification','Under Verification'); ?>
    <?php $pill('approved','Approved'); ?>
    <?php $pill('rejected','Rejected'); ?>
  </ul>

  <div class="card card-elevated">
    <div class="table-responsive">
      <table class="table align-middle mb-0">
        <thead class="table-light">
          <tr>
            <th scope="col">#</th>
            <th scope="col">Reference</th>
            <th scope="col">Agent</th>
            <th scope="col" class="text-end">Amount</th>
            <th scope="col">Mode</th>
            <th scope="col">Requested</th>
            <th scope="col">Status</th>
            <th scope="col" class="text-end">Action</th>
          </tr>
        </thead>
        <tbody>
        <?php foreach (($rows ?? []) as $r): ?>
          <?php
            $status = (string)($r['status'] ?? '');
            $badge = 'bg-secondary';
            if ($status==='pending') $badge='bg-warning';
            elseif ($status==='bank_assigned') $badge='bg-info';
            elseif ($status==='under_verification') $badge='bg-primary';
            elseif ($status==='approved') $badge='bg-success';
            elseif ($status==='rejected') $badge='bg-danger';
          ?>
          <tr>
            <td>#<?php echo (int)$r['id']; ?></td>
            <td><code><?php echo htmlspecialchars($r['reference_code'] ?? ''); ?></code></td>
            <td><?php echo htmlspecialchars($r['agent_email'] ?? ''); ?> <span class="text-muted">(ID <?php echo (int)$r['agent_user_id']; ?>)</span></td>
            <td class="text-end">฿<?php echo number_format((float)$r['amount'], 2); ?></td>
            <td class="text-capitalize"><?php echo htmlspecialchars(str_replace('_',' ', (string)$r['payment_mode'])); ?></td>
            <td><span class="text-muted small"><?php echo htmlspecialchars($r['requested_at']); ?></span></td>
            <td><span class="badge <?php echo $badge; ?>"><?php echo htmlspecialchars($status); ?></span></td>
            <td class="text-end">
              <a class="btn btn-sm btn-outline-primary" href="/admin/wallet/deposits/view?id=<?php echo (int)$r['id']; ?>"><i class="bi bi-eye me-1"></i> View</a>
            </td>
          </tr>
        <?php endforeach; ?>
        <?php if (empty($rows)): ?>
          <tr>
            <td colspan="8" class="text-center text-muted py-5">
              <div class="mb-2"><i class="bi bi-wallet2 fs-3"></i></div>
              <div>No deposit requests found for this filter.</div>
            </td>
          </tr>
        <?php endif; ?>
        </tbody>
      </table>
    </div>
  </div>
</div>
