<div class="container-xxl py-3">
  <nav aria-label="breadcrumb" class="mb-3">
    <ol class="breadcrumb mb-0">
      <li class="breadcrumb-item"><a href="/admin">Dashboard</a></li>
      <li class="breadcrumb-item"><a href="/admin/wallet/deposits">Wallet Deposits</a></li>
      <li class="breadcrumb-item active" aria-current="page">Request #<?php echo (int)($request['id'] ?? 0); ?></li>
    </ol>
  </nav>

  <?php if (!empty($_SESSION['flash_error'])): ?>
    <div class="alert alert-danger border-0 shadow-sm mb-3"><?php echo htmlspecialchars($_SESSION['flash_error']); unset($_SESSION['flash_error']); ?></div>
  <?php endif; ?>
  <?php if (!empty($_SESSION['flash_success'])): ?>
    <div class="alert alert-success border-0 shadow-sm mb-3"><?php echo htmlspecialchars($_SESSION['flash_success']); unset($_SESSION['flash_success']); ?></div>
  <?php endif; ?>

  <?php $r = $request; $status = (string)($r['status'] ?? '');
    $badge = 'bg-secondary';
    if ($status==='pending') $badge='bg-warning';
    elseif ($status==='bank_assigned') $badge='bg-info';
    elseif ($status==='under_verification') $badge='bg-primary';
    elseif ($status==='approved') $badge='bg-success';
    elseif ($status==='rejected') $badge='bg-danger';
  ?>

  <div class="row g-3">
    <div class="col-12 col-lg-8">
      <div class="card card-elevated mb-3">
        <div class="card-body">
          <div class="row g-3">
            <div class="col-6">
              <div class="text-muted small">Reference</div>
              <div class="fw-semibold"><code><?php echo htmlspecialchars($r['reference_code']); ?></code></div>
            </div>
            <div class="col-6">
              <div class="text-muted small">Status</div>
              <span class="badge <?php echo $badge; ?> text-uppercase"><?php echo htmlspecialchars($status); ?></span>
            </div>
            <div class="col-6">
              <div class="text-muted small">Agent</div>
              <div class="fw-semibold">
                <?php echo htmlspecialchars($r['agent_email'] ?? ''); ?>
                <?php if (!empty($r['agent_company'])): ?>
                  <span class="text-muted">— <?php echo htmlspecialchars($r['agent_company']); ?></span>
                <?php endif; ?>
                <span class="text-muted">(ID <?php echo (int)$r['agent_user_id']; ?>)</span>
              </div>
            </div>
            <div class="col-6">
              <div class="text-muted small">Amount</div>
              <div class="fw-semibold">฿<?php echo number_format((float)$r['amount'], 2); ?></div>
            </div>
            <div class="col-6">
              <div class="text-muted small">Mode</div>
              <div class="text-capitalize"><?php echo htmlspecialchars(str_replace('_',' ', $r['payment_mode'])); ?></div>
            </div>
            <div class="col-6">
              <div class="text-muted small">Requested</div>
              <div class="text-muted"><?php echo htmlspecialchars($r['requested_at']); ?></div>
            </div>
          </div>
        </div>
      </div>

      <div class="card card-elevated mb-3">
        <div class="card-header d-flex justify-content-between align-items-center">
          <div class="fw-semibold">Assigned Bank Account</div>
          <small class="text-muted">Change assignment below</small>
        </div>
        <div class="card-body">
          <?php if (!empty($r['bank_account_id'])): ?>
            <div class="row g-3">
              <div class="col-sm-6"><span class="text-muted small d-block">Bank</span><div class="fw-semibold"><?php echo htmlspecialchars($r['bank_name']); ?></div></div>
              <div class="col-sm-6"><span class="text-muted small d-block">Account Holder</span><div class="fw-semibold"><?php echo htmlspecialchars($r['account_name']); ?></div></div>
              <div class="col-sm-6"><span class="text-muted small d-block">Account No.</span><div class="fw-semibold"><code><?php echo htmlspecialchars($r['account_number']); ?></code></div></div>
            </div>
            <hr>
          <?php endif; ?>
          <form action="/admin/wallet/deposits/assign" method="post" class="row g-2">
            <input type="hidden" name="csrf" value="<?php echo \App\Core\Security::csrfToken(); ?>" />
            <input type="hidden" name="id" value="<?php echo (int)$r['id']; ?>" />
            <div class="col-md-8">
              <label class="form-label">Company Bank Account</label>
              <select name="bank_account_id" class="form-select">
                <option value="">Select account...</option>
                <?php foreach (($banks ?? []) as $b): ?>
                  <option value="<?php echo (int)$b['id']; ?>" <?php echo ((int)($r['bank_account_id'] ?? 0) === (int)$b['id']) ? 'selected' : ''; ?>>
                    <?php echo htmlspecialchars($b['bank_name'].' — '.$b['account_name'].' — '.$b['account_number'].' ('.$b['currency'].')'); ?>
                  </option>
                <?php endforeach; ?>
              </select>
            </div>
            <div class="col-md-4 d-flex align-items-end">
              <button class="btn btn-primary w-100" type="submit"><i class="bi bi-check2-circle me-1"></i> Assign</button>
            </div>
          </form>
        </div>
      </div>

      <div class="card card-elevated mb-3">
        <div class="card-header fw-semibold">Deposit Proof</div>
        <div class="card-body">
          <div class="row g-3">
            <div class="col-sm-4"><span class="text-muted small d-block">Transaction Ref</span><div class="fw-semibold"><?php echo htmlspecialchars($r['transaction_ref'] ?? '—'); ?></div></div>
            <div class="col-sm-8"><span class="text-muted small d-block">Proof</span>
              <?php if (!empty($r['proof_file'])): ?>
                <?php 
                  $pf = (string)$r['proof_file'];
                  $isImg = preg_match('/\.(jpg|jpeg|png|gif|webp)$/i', $pf);
                  $isPdf = preg_match('/\.(pdf)$/i', $pf);
                  $exp = time() + 600; // 10 minutes
                  $secret = function_exists('env') ? (string)env('APP_SECRET','dev-secret') : 'dev-secret';
                  $baseSig = ((int)$r['id']).'|'.$exp;
                  $sig = hash_hmac('sha256', $baseSig, $secret);
                  $signed = '/file/wallet-deposit?id='.(int)$r['id'].'&exp='.$exp.'&sig='.$sig;
                ?>
                <div class="border rounded p-2 bg-white">
                  <?php if ($isImg): ?>
                    <img src="<?php echo $signed; ?>" alt="Deposit Slip" class="img-fluid rounded" style="max-height:320px; object-fit:contain;" />
                    <div class="mt-2">
                      <a class="btn btn-sm btn-outline-secondary" href="<?php echo $signed; ?>" target="_blank"><i class="bi bi-box-arrow-up-right me-1"></i> View full</a>
                      <a class="btn btn-sm btn-primary" href="<?php echo $signed.'&download=1'; ?>"><i class="bi bi-download me-1"></i> Download</a>
                    </div>
                  <?php elseif ($isPdf): ?>
                    <object data="<?php echo $signed; ?>" type="application/pdf" width="100%" height="420" class="rounded border">
                      <a href="<?php echo $signed; ?>" target="_blank">Open PDF</a>
                    </object>
                    <div class="mt-2">
                      <a class="btn btn-sm btn-primary" href="<?php echo $signed.'&download=1'; ?>"><i class="bi bi-download me-1"></i> Download PDF</a>
                    </div>
                  <?php else: ?>
                    <a class="btn btn-sm btn-outline-primary" href="<?php echo $signed; ?>" target="_blank"><i class="bi bi-box-arrow-up-right me-1"></i> View</a>
                    <a class="btn btn-sm btn-primary" href="<?php echo $signed.'&download=1'; ?>"><i class="bi bi-download me-1"></i> Download</a>
                  <?php endif; ?>
                </div>
              <?php else: ?>
                <span class="text-muted">—</span>
              <?php endif; ?>
            </div>
          </div>
        </div>
      </div>
    </div>

    <div class="col-12 col-lg-4">
      <div class="card card-elevated mb-3">
        <div class="card-header fw-semibold">Actions</div>
        <div class="card-body">
          <form id="approveForm" action="/admin/wallet/deposits/approve" method="post" class="mb-2">
            <input type="hidden" name="csrf" value="<?php echo \App\Core\Security::csrfToken(); ?>" />
            <input type="hidden" name="id" value="<?php echo (int)$r['id']; ?>" />
            <input type="hidden" name="master_password" value="" />
            <button id="approveOpen" class="btn btn-success w-100" <?php echo ($r['status']==='approved')?'disabled':''; ?> type="button" data-bs-toggle="modal" data-bs-target="#masterPwModal">
              <i class="bi bi-check-lg me-1"></i> Approve & Credit
            </button>
          </form>
          <form action="/admin/wallet/deposits/reject" method="post" onsubmit="return confirm('Reject this deposit?');">
            <input type="hidden" name="csrf" value="<?php echo \App\Core\Security::csrfToken(); ?>" />
            <input type="hidden" name="id" value="<?php echo (int)$r['id']; ?>" />
            <div class="input-group">
              <input type="text" name="rejection_reason" class="form-control" placeholder="Reason">
              <button class="btn btn-outline-danger" <?php echo ($r['status']==='rejected')?'disabled':''; ?> type="submit"><i class="bi bi-x-lg me-1"></i> Reject</button>
            </div>
          </form>
        </div>
      </div>
    </div>
  </div>
</div>

<!-- Master Password Modal -->
<div class="modal fade" id="masterPwModal" tabindex="-1" aria-labelledby="masterPwModalLabel" aria-hidden="true">
  <div class="modal-dialog">
    <div class="modal-content">
      <div class="modal-header">
        <h5 class="modal-title" id="masterPwModalLabel">Confirm Approval</h5>
        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
      </div>
      <div class="modal-body">
        <div class="mb-2 small text-muted">Enter the master password to approve and credit this deposit.</div>
        <div class="mb-3">
          <label class="form-label">Master Password</label>
          <input type="password" class="form-control" id="masterPwInput" placeholder="••••••" autocomplete="current-password" />
        </div>
      </div>
      <div class="modal-footer">
        <button type="button" class="btn btn-outline-secondary" data-bs-dismiss="modal">Cancel</button>
        <button type="button" class="btn btn-primary" id="masterPwConfirm">Approve</button>
      </div>
    </div>
  </div>
</div>

<script>
  (function(){
    var confirmBtn = document.getElementById('masterPwConfirm');
    var input = document.getElementById('masterPwInput');
    var form = document.getElementById('approveForm');
    if (confirmBtn && input && form) {
      confirmBtn.addEventListener('click', function(){
        var val = input.value || '';
        form.querySelector('input[name="master_password"]').value = val;
        form.submit();
      });
    }
  })();
</script>
