<?php
// app/Views/admin/vendors_create.php
?>
<div class="container py-2">
  <h2 class="h5 mb-3"><i class="bi bi-person-plus me-2"></i>Vendors</h2>
  <style>
    @media (max-width: 576px) {
      .vendors-toolbar { flex-direction: column; align-items: stretch !important; gap: .5rem !important; }
      .vendors-toolbar .input-group { max-width: 100% !important; width: 100%; }
      #vendorsFilterCountry, #vendorsFilterCity, #vendorsPageSize { min-width: 0 !important; width: 100% !important; }
      .vendors-toolbar .d-flex.align-items-center.gap-1 { width: 100%; }
      #vendorsTable th, #vendorsTable td { white-space: nowrap; }
      .card { margin-left: -8px; margin-right: -8px; }
    }
  </style>
  <?php if (!empty($_SESSION['flash'])): ?>
    <div class="alert alert-success py-2">
      <?= htmlspecialchars($_SESSION['flash']); unset($_SESSION['flash']); ?>
    </div>
  <?php endif; ?>
  <?php if (!empty($_SESSION['errors'])): ?>
    <div class="alert alert-danger py-2">
      <ul class="mb-0 small">
        <?php foreach ($_SESSION['errors'] as $e): ?>
          <li><?= htmlspecialchars($e) ?></li>
        <?php endforeach; unset($_SESSION['errors']); ?>
      </ul>
    </div>
  <?php endif; ?>
  <?php $old = $_SESSION['old'] ?? []; ?>
  <div class="card">
    <div class="card-header d-flex justify-content-between align-items-center">
      <span class="fw-semibold">Vendors</span>
      <button id="btnOpenVendorModal" type="button" class="btn btn-sm btn-primary">Add Vendor</button>
    </div>
    <div class="card-body">
      <div class="d-flex justify-content-between align-items-center mb-2 flex-wrap gap-2 vendors-toolbar">
        <div class="input-group input-group-sm" style="max-width:320px;">
          <span class="input-group-text"><i class="bi bi-search"></i></span>
          <input id="vendorsSearch" type="text" class="form-control" placeholder="Search name or email..." autocomplete="off">
        </div>
        <div class="d-flex align-items-center gap-2 flex-wrap">
          <div class="d-flex align-items-center gap-1">
            <label for="vendorsFilterModule" class="small text-muted mb-0">Module:</label>
            <select id="vendorsFilterModule" class="form-select form-select-sm" style="width:auto; min-width:140px;"><option value="">All Modules</option></select>
          </div>
          <div class="d-flex align-items-center gap-1">
            <label for="vendorsFilterCountry" class="small text-muted mb-0">Country:</label>
            <select id="vendorsFilterCountry" class="form-select form-select-sm" style="width:auto; min-width:160px;"><option value="">All Countries</option><option value="Thailand">Thailand</option></select>
          </div>
          <div class="d-flex align-items-center gap-1">
            <label for="vendorsFilterCity" class="small text-muted mb-0">Location:</label>
            <select id="vendorsFilterCity" class="form-select form-select-sm" style="width:auto; min-width:180px;" disabled><option value="">All Locations</option></select>
          </div>
          <div class="d-flex align-items-center gap-1">
            <label for="vendorsPageSize" class="small text-muted mb-0">Rows:</label>
            <select id="vendorsPageSize" class="form-select form-select-sm" style="width:auto; min-width:72px;">
              <option>10</option><option>20</option><option>50</option>
            </select>
          </div>
          <div class="d-flex align-items-center gap-1">
            <button id="vendorsExportCsv" type="button" class="btn btn-outline-secondary btn-sm"><i class="bi bi-download me-1"></i>Export</button>
          </div>
        </div>
      </div>
      <div class="table-responsive">
        <table class="table table-sm align-middle" id="vendorsTable">
          <thead class="table-light">
            <tr>
              <th style="width:6%" class="text-muted">#</th>
              <th style="width:30%">Name</th>
              <th style="width:20%">Contact Email</th>
              <th style="width:16%">Country</th>
              <th style="width:14%">Location</th>
              <th style="width:10%" class="text-end">Actions</th>
            </tr>
          </thead>
          <tbody>
            <?php foreach (($vendors ?? []) as $i => $v): ?>
              <?php $payload = htmlspecialchars(json_encode($v), ENT_QUOTES, 'UTF-8'); ?>
              <tr data-country="<?= htmlspecialchars($v['country'] ?? '') ?>" data-city="<?= htmlspecialchars($v['city'] ?? '') ?>" data-module="<?= htmlspecialchars($v['module'] ?? '') ?>">
                <td class="vd-col-idx text-muted"></td>
                <td>
                  <a href="/admin/vendors/package_manage?vendor_id=<?= (int)($v['id'] ?? 0) ?>" class="text-decoration-none">
                    <?= htmlspecialchars($v['name'] ?? '') ?>
                  </a>
                </td>
                <td>
                  <?= htmlspecialchars($v['contact_email'] ?? '') ?>
                  <button type="button" class="btn btn-link btn-sm p-0 ms-2 align-baseline js-view-vendor" data-vendor='<?= $payload ?>'>View</button>
                  <button type="button" class="btn btn-link btn-sm p-0 ms-2 align-baseline js-view-bank" data-vendor='<?= $payload ?>'>Bank</button>
                </td>
                <td><?= htmlspecialchars($v['country'] ?? '') ?></td>
                <td><?= htmlspecialchars($v['city'] ?? '') ?></td>
                <td class="text-end text-nowrap">
                  <div class="d-inline-flex align-items-center gap-2">
                    <?php
                      $emailKey = strtolower((string)($v['contact_email'] ?? ''));
                      $hasLogin = !empty($loginsByEmail[$emailKey] ?? []);
                    ?>
                    <?php if ($hasLogin): $li = $loginsByEmail[$emailKey]; ?>
                      <button type="button" class="btn btn-outline-secondary btn-sm rounded-pill px-3 js-view-login" data-email="<?= htmlspecialchars((string)($v['contact_email'] ?? '')) ?>" data-user='<?= htmlspecialchars(json_encode($li), ENT_QUOTES, 'UTF-8') ?>' title="View login">
                        <i class="bi bi-person-badge me-1"></i> View Login
                      </button>
                    <?php else: ?>
                      <form id="createLoginForm_<?= (int)($v['id'] ?? 0) ?>" class="d-inline" method="post" action="/admin/vendors/create-login">
                        <input type="hidden" name="csrf" value="<?= htmlspecialchars($csrf ?? '') ?>">
                        <input type="hidden" name="vendor_id" value="<?= (int)($v['id'] ?? 0) ?>">
                        <input type="hidden" name="email" value="<?= htmlspecialchars((string)($v['contact_email'] ?? '')) ?>">
                        <input type="hidden" name="password" value="">
                        <input type="hidden" name="master_password" value="">
                        <button type="button" class="btn btn-outline-success btn-sm rounded-pill px-3 js-open-cl" data-form="createLoginForm_<?= (int)($v['id'] ?? 0) ?>" title="Create vendor login using contact email">
                          <i class="bi bi-person-check me-1"></i> Create Login
                        </button>
                      </form>
                    <?php endif; ?>
                    <button type="button" class="btn btn-primary btn-sm rounded-pill px-3 js-open-edit" title="Edit vendor" data-vendor='<?= $payload ?>'>
                      <i class="bi bi-pencil-square me-1"></i> Update
                    </button>
                    <form class="d-inline" method="post" action="/admin/vendors/delete">
                    <input type="hidden" name="csrf" value="<?= htmlspecialchars($csrf ?? '') ?>">
                    <input type="hidden" name="id" value="<?= htmlspecialchars($v['id']) ?>">
                    <input type="hidden" name="master_password" value="">
                      <button data-action="delete-vendor" class="btn btn-outline-danger btn-sm rounded-pill px-3 js-ask-pass" type="button" title="Delete vendor">
                        <i class="bi bi-trash me-1"></i> Delete
                      </button>
                    </form>
                  </div>
                </td>
              </tr>
            <?php endforeach; ?>
          </tbody>
        </table>
      </div>
      <div class="d-flex justify-content-between align-items-center mt-2">
        <div class="small text-muted">
          <span id="vendorsPageInfo">Showing 0 to 0 of 0</span>
        </div>
        <nav>
          <ul class="pagination pagination-sm mb-0" id="vendorsPager">
            <li class="page-item"><button class="page-link" id="vendorsPrev" type="button">Previous</button></li>
            <li class="page-item disabled"><span class="page-link" id="vendorsCurr">1</span></li>
            <li class="page-item"><button class="page-link" id="vendorsNext" type="button">Next</button></li>
          </ul>
        </nav>
      </div>
    </div>
  </div>

  <style>
    @media (max-width: 576px) {
      .table-responsive { overflow-x: auto; }
      table.table { min-width: 420px; }
    }
    /* Modal styles */
    .vd-overlay { position: fixed; inset: 0; background: rgba(0,0,0,.45); display: none; z-index: 20000; }
    .vd-modal { position: fixed; left: 50%; top: 50%; transform: translate(-50%,-50%); background: #fff; border-radius: 10px; box-shadow: 0 10px 30px rgba(0,0,0,.2); width: min(96vw, 880px); max-height: 90vh; overflow: hidden; display: none; z-index: 20001; }
    .vd-hdr { padding: 12px 14px; border-bottom: 1px solid #eee; font-weight: 600; display:flex; justify-content: space-between; align-items:center; }
    .vd-body { padding: 12px 14px; overflow: auto; max-height: calc(90vh - 52px - 58px); }
    .vd-ftr { padding: 10px 14px; display:flex; justify-content: flex-end; gap: 8px; border-top: 1px solid #eee; background: #fff; }
    @media (max-width: 576px) {
      .vd-modal { width: 96vw; border-radius: 8px; }
      .vd-body { max-height: calc(90vh - 50px - 58px); }
    }
    body.vd-lock { overflow: hidden; }
    /* Prevent multi-line labels that push inputs up/down across the row */
    .vd-modal .form-label { white-space: nowrap; overflow: hidden; text-overflow: ellipsis; }
  </style>

  <script>
    (function(){
      const table = document.getElementById('vendorsTable');
      if (!table) return;
      const rowsAll = Array.from(table.tBodies[0].rows);
      const searchInput = document.getElementById('vendorsSearch');
      const pageSizeSel = document.getElementById('vendorsPageSize');
      const prevBtn = document.getElementById('vendorsPrev');
      const nextBtn = document.getElementById('vendorsNext');
      const currSpan = document.getElementById('vendorsCurr');
      const pageInfo = document.getElementById('vendorsPageInfo');
      const moduleSel = document.getElementById('vendorsFilterModule');
      const countrySel = document.getElementById('vendorsFilterCountry');
      const citySel = document.getElementById('vendorsFilterCity');
      const countries = <?php echo json_encode(array_map(fn($r)=>$r['country']??'', $countries ?? [])); ?>;
      const cities = <?php echo json_encode($cities ?? []); ?>;
      const state = { q: '', page: 1, pageSize: parseInt((pageSizeSel && pageSizeSel.value) ? pageSizeSel.value : '10', 10), module: '', country: '', city: '' };

      // Build Country/City filters
      function uniq(arr){ return Array.from(new Set(arr.filter(Boolean))); }
      function vendorsModules(){ return uniq(rowsAll.map(tr=> (tr.getAttribute('data-module')||'').trim())); }
      function vendorsCountries(){ return uniq(rowsAll.map(tr=>tr.getAttribute('data-country')||'')); }
      function vendorsCitiesFor(country){
        return uniq(rowsAll
          .filter(tr=>!country || (tr.getAttribute('data-country')||'')===country)
          .map(tr=>tr.getAttribute('data-city')||''));
      }

      // View Login modal (single, dynamic)
      let vlModal=null, vlBody=null;
      function ensureViewLoginModal(){
        if (vlModal) return;
        const wrap = document.createElement('div');
        wrap.innerHTML = `
        <div class="modal fade" id="vendorLoginViewModal" tabindex="-1" aria-hidden="true">
          <div class="modal-dialog">
            <div class="modal-content">
              <div class="modal-header">
                <h5 class="modal-title">Vendor Login</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
              </div>
              <div class="modal-body" id="vlvBody"></div>
              <div class="modal-footer">
                <button type="button" class="btn btn-outline-secondary" data-bs-dismiss="modal">Close</button>
              </div>
            </div>
          </div>
        </div>`;
        document.body.appendChild(wrap);
        const el = document.getElementById('vendorLoginViewModal');
        vlModal = (window.bootstrap && window.bootstrap.Modal) ? new window.bootstrap.Modal(el) : null;
        vlBody = document.getElementById('vlvBody');
      }
      function fillModules(){
        if (!moduleSel) return;
        const mods = vendorsModules();
        moduleSel.innerHTML = '<option value="">All Modules</option>' + mods.map(m=>`<option value="${m}">${m.charAt(0).toUpperCase()+m.slice(1)}</option>`).join('');
      }
      function fillCountries(){
        const merged = uniq([...(countries||[]), ...vendorsCountries()]);
        countrySel.innerHTML = '<option value="">All Countries</option>' + merged.map(c=>`<option value="${c}">${c}</option>`).join('');
      }
      function fillCities(country){
        const fromLocations = (cities||[]).filter(r=>!country || (r.country||'')===country).map(r=>r.city||'');
        const fromVendors = vendorsCitiesFor(country);
        const list = uniq([ ...fromLocations, ...fromVendors ]);
        citySel.innerHTML = '<option value="">All Locations</option>' + list.map(c=>`<option value="${c}">${c}</option>`).join('');
        citySel.disabled = false;
      }
      fillModules();
      fillCountries();
      // Sync initial state from any preselected values (e.g., browser persistence)
      if (countrySel && countrySel.value) {
        state.country = countrySel.value;
        fillCities(state.country);
        if (citySel && citySel.value) { state.city = citySel.value; }
      } else {
        citySel.innerHTML = '<option value="">All Locations</option>';
        citySel.disabled = true;
      }

      function matches(row, q){ if (!q) return true; return row.innerText.toLowerCase().includes(q.toLowerCase()); }
      function render(){
        const q = state.q.toLowerCase();
        const filtered = rowsAll.filter(tr=>{
          const name = (((tr && tr.cells && tr.cells[0]) ? tr.cells[0].textContent : '') || '').toLowerCase();
          const mail = (((tr && tr.cells && tr.cells[1]) ? tr.cells[1].textContent : '') || '').toLowerCase();
          if (q && !(name.includes(q) || mail.includes(q))) return false;
          const mod = (tr.getAttribute('data-module') || '');
          const ctry = (tr.getAttribute('data-country') || '');
          const cty = (tr.getAttribute('data-city') || '');
          if (state.module && mod !== state.module) return false;
          if (state.country && ctry !== state.country) return false;
          if (state.city && cty !== state.city) return false;
          return true;
        });
        const total = filtered.length;
        const pages = Math.max(1, Math.ceil(total / state.pageSize));
        if (state.page > pages) state.page = pages;
        const start = (state.page - 1) * state.pageSize;
        const end = start + state.pageSize;
        rowsAll.forEach(r => r.style.display = 'none');
        filtered.slice(start, end).forEach((r, idx) => { r.style.display = ''; const cell = r.querySelector('td.vd-col-idx'); if (cell) cell.textContent = String(start + idx + 1); });
        if (currSpan) currSpan.textContent = String(state.page);
        if (prevBtn && prevBtn.parentElement) prevBtn.parentElement.classList.toggle('disabled', state.page <= 1);
        if (nextBtn && nextBtn.parentElement) nextBtn.parentElement.classList.toggle('disabled', state.page >= pages);
        const from = total === 0 ? 0 : start + 1; const to = Math.min(total, end);
        if (pageInfo) pageInfo.textContent = 'Showing ' + from + ' to ' + to + ' of ' + total;
      }
      if (searchInput) searchInput.addEventListener('input', function(){ state.q = searchInput.value.trim(); state.page = 1; render(); });
      if (pageSizeSel) pageSizeSel.addEventListener('change', function(){ state.pageSize = parseInt(pageSizeSel.value,10) || 10; state.page = 1; render(); });
      if (prevBtn) prevBtn.addEventListener('click', function(){ if (state.page > 1) { state.page--; render(); } });
      if (nextBtn) nextBtn.addEventListener('click', function(){ state.page++; render(); });
      if (moduleSel) moduleSel.addEventListener('change', function(){ state.module = moduleSel.value; state.page=1; render(); });
      if (countrySel) countrySel.addEventListener('change', function(){ state.country = countrySel.value; state.city=''; if (state.country) { fillCities(state.country); } else { citySel.innerHTML='<option value="">All Locations</option>'; citySel.disabled=true; } state.page=1; render(); });
      if (citySel) citySel.addEventListener('change', function(){ state.city = citySel.value; state.page=1; render(); });
      render();

      // CSV Export of current filtered list
      const exportBtn = document.getElementById('vendorsExportCsv');
      if (exportBtn) exportBtn.addEventListener('click', function(){
        const q = state.q.toLowerCase();
        const filtered = rowsAll.filter(tr=>{
          const name = ((tr.cells[0] ? tr.cells[0].textContent : '') || '').toLowerCase();
          const mail = ((tr.cells[1] ? tr.cells[1].textContent : '') || '').toLowerCase();
          const mod = (tr.getAttribute('data-module') || '');
          const ctry = (tr.getAttribute('data-country') || '');
          const cty = (tr.getAttribute('data-city') || '');
          if (q && !(name.includes(q) || mail.includes(q))) return false;
          if (state.module && mod !== state.module) return false;
          if (state.country && ctry !== state.country) return false;
          if (state.city && cty !== state.city) return false;
          return true;
        });
        const rows = [['#','Name','Contact Email','Country','City','Module']];
        filtered.forEach((tr, i)=>{
          const nameEl = tr.querySelector('td:nth-child(2)');
          const name = nameEl ? (nameEl.innerText || '').trim() : '';
          const emailCell = tr.querySelector('td:nth-child(3)');
          const firstNode = emailCell && emailCell.childNodes && emailCell.childNodes[0] ? emailCell.childNodes[0] : null;
          const email = firstNode && firstNode.nodeValue ? String(firstNode.nodeValue).trim() : '';
          const countryEl = tr.querySelector('td:nth-child(4)');
          const country = countryEl ? (countryEl.innerText || '').trim() : '';
          const cityEl = tr.querySelector('td:nth-child(5)');
          const city = cityEl ? (cityEl.innerText || '').trim() : '';
          const mod = (tr.getAttribute('data-module') || '').trim();
          rows.push([String(i+1), name, email, country, city, mod]);
        });
        const csv = rows.map(function(r){ return r.map(function(v){ return '"'+String(v).replace(/\"/g,'"').replace(/"/g,'""')+'"'; }).join(','); }).join('\n');
        const blob = new Blob([csv], {type:'text/csv;charset=utf-8;'});
        const url = URL.createObjectURL(blob);
        const a = document.createElement('a'); a.href=url; a.download='vendors_export.csv'; document.body.appendChild(a); a.click(); setTimeout(()=>{ URL.revokeObjectURL(url); a.remove(); }, 0);
      });
    })();
   // Password modal for Update/Delete and Add actions (shared with this page only)
      let txOverlay=null, txModal=null, txInput=null, txConfirm=null, txCancel=null, targetForm=null, txDesc=null;
      function ensurePassModal(){
        if (txOverlay) return;
        txOverlay = document.createElement('div');
        txOverlay.style.cssText = 'position:fixed;inset:0;background:rgba(0,0,0,.45);display:none;z-index:21000;';
        txModal = document.createElement('div');
        txModal.style.cssText = 'position:fixed;left:50%;top:50%;transform:translate(-50%,-50%);background:#fff;border-radius:8px;box-shadow:0 10px 30px rgba(0,0,0,.2);width:min(92vw,380px);z-index:21001;display:none;';
        const hdr=document.createElement('div'); hdr.style.cssText='padding:10px 12px;border-bottom:1px solid #eee;font-weight:600;display:flex;justify-content:space-between;align-items:center;'; hdr.textContent='Enter Update Password';
        const x=document.createElement('button'); x.type='button'; x.textContent='×'; x.style.cssText='border:0;background:transparent;font-size:20px;line-height:1;cursor:pointer;'; hdr.appendChild(x);
        const body=document.createElement('div'); body.style.cssText='padding:12px;';
        txDesc=document.createElement('p'); txDesc.className='small'; txDesc.style.margin='0 0 8px 0'; txDesc.textContent='This action requires your update password.';
        txInput=document.createElement('input'); txInput.type='password'; txInput.placeholder='Update Password'; txInput.autocomplete='current-password'; txInput.className='form-control';
        body.appendChild(txDesc); body.appendChild(txInput);
        const ftr=document.createElement('div'); ftr.style.cssText='padding:10px 12px;border-top:1px solid #eee;display:flex;justify-content:flex-end;gap:8px;';
        txCancel=document.createElement('button'); txCancel.type='button'; txCancel.className='btn btn-outline-secondary btn-sm'; txCancel.textContent='Cancel';
        txConfirm=document.createElement('button'); txConfirm.type='button'; txConfirm.className='btn btn-primary btn-sm'; txConfirm.textContent='Confirm';
        ftr.appendChild(txCancel); ftr.appendChild(txConfirm);
        txModal.appendChild(hdr); txModal.appendChild(body); txModal.appendChild(ftr);
        document.body.appendChild(txOverlay); document.body.appendChild(txModal);
        function show(){ txOverlay.style.display='block'; txModal.style.display='block'; setTimeout(()=>txInput.focus(),50); }
        function hide(){ txOverlay.style.display='none'; txModal.style.display='none'; }
        txOverlay.addEventListener('click', hide); x.addEventListener('click', hide); txCancel.addEventListener('click', hide);
        txConfirm.addEventListener('click', ()=>{
          if (!targetForm) return;
          let hidden = targetForm.querySelector('input[name="master_password"]');
          if (!hidden) { hidden = document.createElement('input'); hidden.type='hidden'; hidden.name='master_password'; targetForm.appendChild(hidden);} 
          const pwd=(txInput.value||'').trim(); if(!pwd){ txInput.focus(); return; }
          hidden.value=pwd; setTimeout(()=>{ targetForm.submit(); hide(); },0);
        });
        document.addEventListener('keydown', (e)=>{ if(e.key==='Escape') hide(); });
        txOverlay.show = show; txOverlay.hide = hide;
      }
      function openPass(actionLabel, form){ ensurePassModal(); targetForm=form; txInput.value=''; if(txDesc) txDesc.textContent = `Please enter your update password to ${actionLabel}.`; txOverlay.show(); }

      // Bootstrap modal for Create Login password entry
      let clModal=null, clPwEl=null, clEmailEl=null, clConfirmBtn=null, clFormId=null;
      function ensureCLModal(){
        if (clModal) return;
        const wrap = document.createElement('div');
        wrap.innerHTML = `
        <div class="modal fade" id="vendorCreateLoginModal" tabindex="-1" aria-hidden="true">
          <div class="modal-dialog">
            <div class="modal-content">
              <div class="modal-header">
                <h5 class="modal-title">Create Vendor Login</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
              </div>
              <div class="modal-body">
                <div class="mb-2 small text-muted">Contact Email</div>
                <div id="vclEmail" class="mb-3 fw-semibold"></div>
                <div class="mb-2 small text-muted">Set Temporary Password</div>
                <input type="password" id="vclTemp" class="form-control mb-2" placeholder="Temp password (min 6)" minlength="6" autocomplete="new-password">
                <div class="mb-2 small text-muted">Enter Update Password</div>
                <input type="password" id="vclMaster" class="form-control" placeholder="Update Password" autocomplete="current-password">
              </div>
              <div class="modal-footer">
                <button type="button" class="btn btn-outline-secondary" data-bs-dismiss="modal">Cancel</button>
                <button type="button" id="vclConfirm" class="btn btn-primary">Create Login</button>
              </div>
            </div>
          </div>
        </div>`;
        document.body.appendChild(wrap);
        const el = document.getElementById('vendorCreateLoginModal');
        clModal = (window.bootstrap && window.bootstrap.Modal) ? new window.bootstrap.Modal(el) : null;
        clPwEl = document.getElementById('vclTemp');
        clEmailEl = document.getElementById('vclEmail');
        clConfirmBtn = document.getElementById('vclConfirm');
        clConfirmBtn.addEventListener('click', function(){
          if (!clFormId) return;
          const form = document.getElementById(clFormId);
          const pwd = (clPwEl && clPwEl.value) ? clPwEl.value.trim() : '';
          if (!pwd || pwd.length < 6) { clPwEl && clPwEl.focus(); return; }
          const hid = form.querySelector('input[name="password"]');
          if (hid) hid.value = pwd;
          const mp = document.getElementById('vclMaster');
          const mh = form.querySelector('input[name="master_password"]');
          if (mh) mh.value = (mp && mp.value) ? mp.value : '';
          if (clModal) clModal.hide();
          form.submit();
        });
      }

      document.addEventListener('click', (ev)=>{
        const mk2 = ev.target.closest('button.js-open-cl');
        if (mk2) {
          const formId = mk2.getAttribute('data-form');
          const f = document.getElementById(formId);
          if (!f) return;
          const email = f.querySelector('input[name="email"]').value.trim();
          // If Bootstrap JS is available, show modal; otherwise fallback to prompt
          if (window.bootstrap && window.bootstrap.Modal) {
            ensureCLModal();
            clFormId = formId;
            if (clEmailEl) clEmailEl.textContent = email || '(no email)';
            if (clPwEl) { clPwEl.value = ''; }
            if (clModal) clModal.show();
          } else {
            const pwd = window.prompt('Enter temporary password (min 6 chars):');
            if (!pwd || pwd.length < 6) { ev.preventDefault(); return false; }
            const hid = f.querySelector('input[name="password"]');
            if (hid) hid.value = pwd;
            const mp = window.prompt('Enter Update Password:');
            const mh = f.querySelector('input[name="master_password"]');
            if (mh) mh.value = (mp||'');
            f.submit();
          }

        const vbtn = ev.target.closest('button.js-view-login');
        if (vbtn) {
          try {
            const email = vbtn.getAttribute('data-email') || '';
            const info = JSON.parse(vbtn.getAttribute('data-user') || '{}');
            // If Bootstrap is available, show modal UI; else fall back to alerts/prompts
            if (window.bootstrap && window.bootstrap.Modal) {
              ensureViewLoginModal();
              if (vlBody) {
                vlBody.innerHTML = ''
                  + '<div class="mb-2 small text-muted">Email</div><div class="fw-semibold mb-2">' + (email||'') + '</div>'
                  + '<div class="mb-2 small text-muted">User ID</div><div class="fw-semibold mb-2">' + (info.user_id||'') + '</div>'
                  + '<div class="mb-2 small text-muted">Role</div><div class="fw-semibold mb-2">' + (info.role||'') + '</div>'
                  + '<div class="mb-2 small text-muted">Status</div><div class="fw-semibold mb-3">' + (info.status||'') + '</div>'
                  + '<form method="post" action="/admin/vendors/reset-login" class="d-flex align-items-center gap-2">'
                  + '  <input type="hidden" name="csrf" value="<?= htmlspecialchars($csrf ?? '') ?>">'
                  + '  <input type="hidden" name="email" value="' + (email||'') + '">'
                  + '  <div class="input-group" style="max-width:260px">'
                  + '    <input type="password" id="vlNewPass" name="new_password" class="form-control" minlength="6" placeholder="New password" required autocomplete="new-password">'
                  + '    <button class="btn btn-outline-secondary" type="button" id="vlToggle" title="Show/Hide"><i class="bi bi-eye"></i></button>'
                  + '  </div>'
                  + '  <button class="btn btn-sm btn-primary" type="submit">Reset Password</button>'
                  + '</form>';
                // attach toggle handler
                setTimeout(function(){
                  var inp = document.getElementById('vlNewPass');
                  var btn = document.getElementById('vlToggle');
                  if (inp && btn) {
                    btn.addEventListener('click', function(){
                      var isPw = inp.getAttribute('type') === 'password';
                      inp.setAttribute('type', isPw ? 'text' : 'password');
                      try { var icon = btn.querySelector('i'); if (icon) icon.className = isPw ? 'bi bi-eye-slash' : 'bi bi-eye'; } catch(e){}
                    });
                  }
                }, 0);
              }
              ensureViewLoginModal(); if (vlModal) vlModal.show();
            } else {
              // Fallback: alert + prompt + submit temp form
              alert('Email: ' + (email||'') + '\nUser ID: ' + (info.user_id||'') + '\nRole: ' + (info.role||'') + '\nStatus: ' + (info.status||''));
              var np = window.prompt('Enter new password (min 6 chars):');
              if (np && np.length >= 6) {
                var tmpForm = document.createElement('form');
                tmpForm.method = 'POST'; tmpForm.action = '/admin/vendors/reset-login';
                var fCsrf = document.createElement('input'); fCsrf.type='hidden'; fCsrf.name='csrf'; fCsrf.value='<?= htmlspecialchars($csrf ?? '') ?>'; tmpForm.appendChild(fCsrf);
                var fEmail = document.createElement('input'); fEmail.type='hidden'; fEmail.name='email'; fEmail.value=email; tmpForm.appendChild(fEmail);
                var fPwd = document.createElement('input'); fPwd.type='hidden'; fPwd.name='new_password'; fPwd.value=np; tmpForm.appendChild(fPwd);
                document.body.appendChild(tmpForm); tmpForm.submit();
              }
            }
          } catch(e) {
            alert('Unable to show login details.');
          }
          ev.preventDefault();
          return false;
        }
          ev.preventDefault();
          return false;
        }
        const btn = ev.target.closest('.js-ask-pass');
        if (!btn) return;
        let form = null; if (btn.dataset.form) { form = document.getElementById(btn.dataset.form); }
        if (!form) form = btn.closest('form');
        if (!form) return;
        const action = btn.dataset.action || 'proceed';
        openPass(action.replace('-', ' '), form);
      });

      // Edit modal open handler
      document.addEventListener('click', (ev)=>{
        const b = ev.target.closest('.js-open-edit');
        if (!b) return;
        try { const v = JSON.parse(b.getAttribute('data-vendor')); openEditModal(v); } catch(e){}
      });

      // View details modal (compact, read-only)
      let vOverlay=null, vModal=null, vCurrent=null;
      function ensureViewModal(){
        if (vOverlay) return;
        vOverlay = document.createElement('div');
        vOverlay.style.cssText='position:fixed;inset:0;background:rgba(0,0,0,.45);display:none;z-index:22000;';
        vModal = document.createElement('div');
        vModal.style.cssText='position:fixed;left:50%;top:50%;transform:translate(-50%,-50%);background:#fff;border-radius:10px;box-shadow:0 10px 30px rgba(0,0,0,.2);width:min(94vw,560px);max-height:88vh;overflow:hidden;display:none;z-index:22001;font-size:0.9rem;';
        const hdr=document.createElement('div'); hdr.className='vd-hdr'; hdr.textContent='Vendor Details';
        const x=document.createElement('button'); x.type='button'; x.textContent='×'; x.style.cssText='border:0;background:transparent;font-size:20px;line-height:1;cursor:pointer;'; hdr.appendChild(x);
        const body=document.createElement('div'); body.className='vd-body'; body.style.maxHeight='calc(88vh - 50px)';
        const ftr=document.createElement('div'); ftr.className='vd-ftr';
        const editBtn=document.createElement('button'); editBtn.type='button'; editBtn.className='btn btn-primary btn-sm'; editBtn.textContent='Edit';
        const closeBtn=document.createElement('button'); closeBtn.type='button'; closeBtn.className='btn btn-outline-secondary btn-sm'; closeBtn.textContent='Close';
        ftr.appendChild(closeBtn); ftr.appendChild(editBtn);
        vModal.appendChild(hdr); vModal.appendChild(body); vModal.appendChild(ftr);
        document.body.appendChild(vOverlay); document.body.appendChild(vModal);
        function show(){ vOverlay.style.display='block'; vModal.style.display='block'; }
        function hide(){ vOverlay.style.display='none'; vModal.style.display='none'; }
        vOverlay.addEventListener('click', hide); x.addEventListener('click', hide); closeBtn.addEventListener('click', hide);
        editBtn.addEventListener('click', ()=>{ if (vCurrent) { hide(); openEditModal(vCurrent); } });
        vModal.show = show; vModal.hide = hide; vModal.body = body; // expose
      }
      function openView(v){
        ensureViewModal();
        const b = vModal.body; b.innerHTML = '';
        function row(label, val){
          const dv=document.createElement('div'); dv.className='d-flex justify-content-between border-bottom py-1';
          const l=document.createElement('div'); l.className='text-muted'; l.textContent=label; l.style.minWidth='42%';
          const r=document.createElement('div'); r.className='text-break'; r.style.maxWidth='58%'; r.textContent=(val&&String(val).trim()!==''? String(val): '—');
          dv.appendChild(l); dv.appendChild(r); b.appendChild(dv);
        }
        const yesNo = x => (x? 'Yes' : 'No');
        const showTimes = (()=>{
          let st = v.show_times; if (!st) return '';
          try { if (typeof st === 'string') st = JSON.parse(st); } catch(e){}
          if (Array.isArray(st)) return st.join(', ');
          return String(st);
        })();
        row('Name', v.name||'');
        row('Company', v.company_name||'');
        row('Module', v.module||'');
        row('Country', v.country||'');
        row('City', v.city||'');
        row('Address', v.address||'');
        row('Contact Email', v.contact_email||'');
        row('Enquiry Email', v.enquiry_email||'');
        row('Confirmation Email', v.confirm_email||'');
        row('WhatsApp', v.whatsapp_number||'');
        row('Calling Number', v.calling_number||'');
        row('Line ID', v.line_id||'');
        row('VAT Number', v.vat_number||'');
        row('TAT Number', v.tat_number||'');
        row('Bank Account', v.bank_account||'');
        row('Bank Name', v.bank_name||'');
        row('Bank Branch', v.bank_branch||'');
        row('Account Holder', v.bank_account_name||'');
        row('SWIFT/BIC', v.bank_swift||'');
        row('IBAN', v.bank_iban||'');
        row('Rep. Name', v.contact_person_name||'');
        row('Rep. Phone', v.contact_person_phone||'');
        row('Rep. Email', v.contact_person_email||'');
        row('Adult Only', yesNo(Number(v.is_adult_only||0)===1));
        row('Family Allowed', yesNo(Number((v.is_family_allowed !== undefined && v.is_family_allowed !== null) ? v.is_family_allowed : 1)===1));
        row('Has Show Times', yesNo(Number(v.has_show_times||0)===1));
        row('Show Times', showTimes);
        row('Last Booking Cutoff', v.last_booking_cutoff||'');
        vModal.show();
      }
      document.addEventListener('click', (ev)=>{
        const b = ev.target.closest('.js-view-vendor');
        if (!b) return;
        try { const v = JSON.parse(b.getAttribute('data-vendor')); vCurrent = v; openView(v); } catch(e){}
      });

      // Bank quick view modal with copy helpers
      let bOverlay=null, bModal=null, bCurrent=null;
      function ensureBankModal(){
        if (bOverlay) return;
        bOverlay = document.createElement('div');
        bOverlay.style.cssText='position:fixed;inset:0;background:rgba(0,0,0,.45);display:none;z-index:22100;';
        bModal = document.createElement('div');
        bModal.style.cssText='position:fixed;left:50%;top:50%;transform:translate(-50%,-50%);background:#fff;border-radius:10px;box-shadow:0 10px 30px rgba(0,0,0,.2);width:min(94vw,520px);max-height:80vh;overflow:hidden;display:none;z-index:22101;font-size:0.9rem;';
        const hdr=document.createElement('div'); hdr.className='vd-hdr'; hdr.textContent='Bank Details';
        const x=document.createElement('button'); x.type='button'; x.textContent='×'; x.style.cssText='border:0;background:transparent;font-size:20px;line-height:1;cursor:pointer;'; hdr.appendChild(x);
        const body=document.createElement('div'); body.className='vd-body'; body.style.maxHeight='calc(80vh - 50px)';
        const ftr=document.createElement('div'); ftr.className='vd-ftr';
        const copyAll=document.createElement('button'); copyAll.type='button'; copyAll.className='btn btn-primary btn-sm'; copyAll.textContent='Copy All';
        const editBtn=document.createElement('button'); editBtn.type='button'; editBtn.className='btn btn-outline-secondary btn-sm'; editBtn.textContent='Edit';
        const closeBtn=document.createElement('button'); closeBtn.type='button'; closeBtn.className='btn btn-outline-secondary btn-sm'; closeBtn.textContent='Close';
        ftr.appendChild(closeBtn); ftr.appendChild(editBtn); ftr.appendChild(copyAll);
        bModal.appendChild(hdr); bModal.appendChild(body); bModal.appendChild(ftr);
        document.body.appendChild(bOverlay); document.body.appendChild(bModal);
        function show(){ bOverlay.style.display='block'; bModal.style.display='block'; }
        function hide(){ bOverlay.style.display='none'; bModal.style.display='none'; }
        bOverlay.addEventListener('click', hide); x.addEventListener('click', hide); closeBtn.addEventListener('click', hide);
        editBtn.addEventListener('click', ()=>{ if (bCurrent){ hide(); openEditModal(bCurrent); }});
        copyAll.addEventListener('click', ()=>{
          if (!bCurrent) return;
          const lines = [];
          function push(label, val){ if(val && String(val).trim()!==''){ lines.push(label+': '+String(val)); } }
          push('Bank Name', bCurrent.bank_name);
          push('Branch', bCurrent.bank_branch);
          push('Account Holder', bCurrent.bank_account_name);
          push('Account Number', bCurrent.bank_account);
          push('SWIFT/BIC', bCurrent.bank_swift);
          push('IBAN', bCurrent.bank_iban);
          const text = lines.join('\n');
          if (navigator.clipboard && navigator.clipboard.writeText) { navigator.clipboard.writeText(text); copyAll.textContent='Copied!'; setTimeout(()=>copyAll.textContent='Copy All',1200); }
        });
        bModal.show=show; bModal.hide=hide; bModal.body=body;
      }
      function openBank(v){
        ensureBankModal(); bCurrent=v; const b=bModal.body; b.innerHTML='';
        function row(label, val){
          const dv=document.createElement('div'); dv.className='d-flex justify-content-between align-items-center border-bottom py-1 gap-2';
          const l=document.createElement('div'); l.className='text-muted'; l.textContent=label; l.style.minWidth='40%';
          const mid=document.createElement('div'); mid.className='text-break small flex-grow-1'; mid.textContent=(val&&String(val).trim()!==''? String(val): '—');
          const btn=document.createElement('button'); btn.type='button'; btn.className='btn btn-outline-primary btn-sm'; btn.textContent='Copy'; btn.addEventListener('click', ()=>{ const t=(val||'').toString(); if(!t) return; if (navigator.clipboard && navigator.clipboard.writeText) { navigator.clipboard.writeText(t); } btn.textContent='Copied!'; setTimeout(()=>btn.textContent='Copy',1000); });
          dv.appendChild(l); dv.appendChild(mid); dv.appendChild(btn); b.appendChild(dv);
        }
        row('Bank Name', v.bank_name);
        row('Branch', v.bank_branch);
        row('Account Holder', v.bank_account_name);
        row('Account Number', v.bank_account);
        row('SWIFT/BIC', v.bank_swift);
        row('IBAN', v.bank_iban);
        bModal.show();
      }
      document.addEventListener('click', (ev)=>{
        const b = ev.target.closest('.js-view-bank');
        if (!b) return;
        try { const v = JSON.parse(b.getAttribute('data-vendor')); openBank(v); } catch(e){}
      });

      // Edit: reuse the Add Vendor modal by auto-opening and pre-filling, then switching to update
      function setVal(form, name, val){ const el=form.querySelector(`[name="${name}"]`); if(!el) return; el.value = (val==null? '': val); }
      function setChecked(form, name, truthy){ const el=form.querySelector(`[name="${name}"]`); if(!el) return; el.checked = !!truthy; el.dispatchEvent(new Event('change')); }
      function openEditModal(v){
        const btnOpen = document.getElementById('btnOpenVendorModal');
        if (!btnOpen) return;
        // Open the Add modal (builds DOM and populates selects)
        btnOpen.click();
        // Give the modal a tick to build
        setTimeout(()=>{
          const modal = document.querySelector('.vd-modal');
          const form = modal ? modal.querySelector('form') : null;
          if (!form) return;
          // Switch to Update mode
          const hdr = modal.querySelector('.vd-hdr'); if (hdr) hdr.textContent = 'Update Vendor';
          form.action = '/admin/vendors/update';
          // ensure id hidden
          let idHidden = form.querySelector('input[name="id"]'); if (!idHidden) { idHidden = document.createElement('input'); idHidden.type='hidden'; idHidden.name='id'; form.appendChild(idHidden); }
          idHidden.value = v.id || '';
          // Update Save button label/action
          const saveBtn = modal.querySelector('.js-ask-pass'); if (saveBtn){ saveBtn.textContent='Update Vendor'; saveBtn.dataset.action='update-vendor'; }

          // Prefill basics
          setVal(form, 'name', v.name);
          setVal(form, 'company_name', v.company_name);
          // Module select then trigger change to show/hide activity section
          setVal(form, 'module', v.module);
          const moduleSel = form.querySelector('#fieldModule'); if (moduleSel) moduleSel.dispatchEvent(new Event('change'));

          // Country/city with dependent list
          const countrySel = form.querySelector('#fieldCountry');
          const citySel = form.querySelector('#fieldCity');
          if (countrySel){ countrySel.value = v.country || ''; countrySel.dispatchEvent(new Event('change')); }
          setTimeout(()=>{ if (citySel){ citySel.value = v.city || ''; citySel.dispatchEvent(new Event('change')); } }, 0);
          setVal(form, 'address', v.address);

          // Contact
          setVal(form, 'contact_email', v.contact_email);
          setVal(form, 'enquiry_email', v.enquiry_email);
          setVal(form, 'confirm_email', v.confirm_email);
          setVal(form, 'whatsapp_number', v.whatsapp_number);
          setVal(form, 'calling_number', v.calling_number);
          setVal(form, 'line_id', v.line_id);

          // Compliance & Banking
          setVal(form, 'vat_number', v.vat_number);
          setVal(form, 'tat_number', v.tat_number);
          setVal(form, 'bank_account', v.bank_account);
          setVal(form, 'bank_name', v.bank_name);
          setVal(form, 'bank_branch', v.bank_branch);
          setVal(form, 'bank_account_name', v.bank_account_name);
          setVal(form, 'bank_swift', v.bank_swift);
          setVal(form, 'bank_iban', v.bank_iban);

          // Representative
          setVal(form, 'contact_person_name', v.contact_person_name);
          setVal(form, 'contact_person_phone', v.contact_person_phone);
          setVal(form, 'contact_person_email', v.contact_person_email);

          // Activity options
          const isAdult = String(v.is_adult_only||'0')==='1';
          const isFamily = String((v.is_family_allowed !== undefined && v.is_family_allowed !== null) ? v.is_family_allowed : '1')==='1';
          const hasShow = String(v.has_show_times||'0')==='1';
          setChecked(form, 'is_adult_only', isAdult);
          setChecked(form, 'is_family_allowed', isFamily || !isAdult);
          setChecked(form, 'has_show_times', hasShow);

          // Show times chips + hidden field
          let times = [];
          if (v.show_times){
            try {
              let st = v.show_times;
              if (typeof st === 'string' && st.includes('[')) st = JSON.parse(st);
              if (typeof st === 'string' && st.includes(',')) st = st.split(',').map(s=>s.trim());
              if (Array.isArray(st)) times = st;
            } catch(e){}
          }
          const chips = form.querySelector('#showTimesChips');
          const hiddenShow = form.querySelector('#fieldShowTimes');
          function renderChips(){ if(!chips) return; chips.innerHTML=''; times.forEach((t, idx)=>{ const span=document.createElement('span'); span.className='badge bg-light text-dark border'; span.textContent=t+' '; const x=document.createElement('button'); x.type='button'; x.className='btn-close btn-close-white btn-sm'; x.style.filter='invert(1)'; x.style.marginLeft='6px'; x.addEventListener('click', ()=>{ times.splice(idx,1); renderChips(); syncHidden(); }); span.appendChild(x); chips.appendChild(span); }); }
          function syncHidden(){ if(hiddenShow) hiddenShow.value = times.join(','); }
          renderChips(); syncHidden();

          // Last booking cutoff
          setVal(form, 'last_booking_cutoff', (v.last_booking_cutoff||'').slice(0,5));
        }, 0);
      }
  </script>
  <script>
    // Add Vendor Modal (custom, no Bootstrap)
    (function(){
      const openBtn = document.getElementById('btnOpenVendorModal');
      if (!openBtn) return;
      let overlay, modal, form, closeBtn, cancelBtn, saveBtn;
      const modules = <?php echo json_encode($modules ?? []); ?>;
      const countries = <?php echo json_encode(array_map(fn($r)=>$r['country']??'', $countries ?? [])); ?>;
      const allCities = <?php echo json_encode($cities ?? []); ?>;
      const citiesByCountry = (function(){
        const m = {};
        (allCities || []).forEach(r => {
          const c = (r.country || '').trim();
          const city = (r.city || '').trim();
          if (!c || !city) return;
          if (!m[c]) m[c] = [];
          if (!m[c].includes(city)) m[c].push(city);
        });
        return m;
      })();
      const old = <?php echo json_encode($_SESSION['old'] ?? []); unset($_SESSION['old']); ?>;

      function build(){
        overlay = document.createElement('div'); overlay.className = 'vd-overlay';
        modal = document.createElement('div'); modal.className = 'vd-modal';
        const hdr = document.createElement('div'); hdr.className = 'vd-hdr'; hdr.textContent = 'Add Vendor';
        closeBtn = document.createElement('button'); closeBtn.type='button'; closeBtn.textContent='×'; closeBtn.style.cssText='border:0;background:transparent;font-size:20px;line-height:1;cursor:pointer;'; hdr.appendChild(closeBtn);
        const body = document.createElement('div'); body.className = 'vd-body';
        form = document.createElement('form'); form.method = 'post'; form.action = '/admin/vendors/store';
        const formId = 'vendorAddForm_' + Math.random().toString(36).slice(2);
        form.id = formId;
        form.innerHTML = `
          <input type="hidden" name="csrf" value="<?= htmlspecialchars($csrf ?? '') ?>">
          <input type="hidden" name="master_password" value="">
          <div class="row g-3">
            <div class="col-12"><div class="fw-semibold small text-uppercase text-muted">Basic</div></div>
            <div class="col-md-6">
              <label class="form-label">Vendor Display Name <span class="text-danger">*</span></label>
              <input type="text" name="name" class="form-control" placeholder="e.g., Sunshine Tours" required>
            </div>
            <div class="col-md-6">
              <label class="form-label">Company Name</label>
              <input type="text" name="company_name" class="form-control" placeholder="Legal company name">
            </div>
            <div class="col-md-6">
              <label class="form-label">Category / Module</label>
              <select name="module" class="form-select" id="fieldModule">
                <option value="">Select module</option>
              </select>
            </div>
            <div class="col-md-6"></div>

            <div class="col-12"><hr class="my-2"><div class="fw-semibold small text-uppercase text-muted">Location</div></div>
            <div class="col-md-6">
              <label class="form-label">Country</label>
              <select name="country" class="form-select" id="fieldCountry">
                <option value="">Select country</option>
              </select>
            </div>
            <div class="col-md-6">
              <label class="form-label">City</label>
              <select name="city" class="form-select" id="fieldCity">
                <option value="">Select city</option>
              </select>
            </div>
            <div class="col-12">
              <label class="form-label">Address</label>
              <textarea name="address" class="form-control" rows="2" placeholder="Street, area, landmarks..."></textarea>
            </div>

            <div class="col-12"><hr class="my-2"><div class="fw-semibold small text-uppercase text-muted">Contact</div></div>
            <div class="col-md-6">
              <label class="form-label">WhatsApp Number</label>
              <input type="text" name="whatsapp_number" class="form-control" placeholder="e.g., +66 8x xxx xxxx">
            </div>
            <div class="col-md-6">
              <label class="form-label">Calling Number</label>
              <input type="text" name="calling_number" class="form-control" placeholder="Phone number">
            </div>
            <div class="col-md-6">
              <label class="form-label">Line ID</label>
              <input type="text" name="line_id" class="form-control" placeholder="Line ID">
            </div>
            <div class="col-md-6">
              <label class="form-label">Contact Email</label>
              <input type="email" name="contact_email" class="form-control" placeholder="vendor@example.com">
            </div>
            <div class="col-md-6">
              <label class="form-label">Enquiry Email</label>
              <input type="email" name="enquiry_email" class="form-control" placeholder="sales@example.com">
            </div>
            <div class="col-md-6">
              <label class="form-label">Confirmation Email</label>
              <input type="email" name="confirm_email" class="form-control" placeholder="booking@example.com">
            </div>

            <div class="col-12"><hr class="my-2"><div class="fw-semibold small text-uppercase text-muted">Compliance & Banking</div></div>
            <div class="col-md-4">
              <label class="form-label">VAT Number</label>
              <input type="text" name="vat_number" class="form-control" placeholder="VAT / Tax ID">
            </div>
            <div class="col-md-4">
              <label class="form-label">TAT Number</label>
              <input type="text" name="tat_number" class="form-control" placeholder="Tourism Authority ID">
            </div>
            <div class="col-12"><div class="fw-semibold small text-uppercase text-muted mt-2">Company Representative (Payments & Coordination)</div><div class="form-text mb-1">Primary person we can call/email for payments and operational coordination.</div></div>
            <div class="col-md-4">
              <label class="form-label">Name</label>
              <input type="text" name="contact_person_name" class="form-control" placeholder="Full name">
            </div>
            <div class="col-md-4">
              <label class="form-label">Phone</label>
              <input type="text" name="contact_person_phone" class="form-control" placeholder="Phone">
            </div>
            <div class="col-md-4">
              <label class="form-label">Email</label>
              <input type="email" name="contact_person_email" class="form-control" placeholder="person@example.com">
            </div>
            <div class="col-12"><div class="fw-semibold small text-uppercase text-muted mt-2">Bank Details</div></div>
            <div class="col-md-4">
              <label class="form-label">Bank Name</label>
              <input type="text" name="bank_name" class="form-control" placeholder="Bank name">
            </div>
            <div class="col-md-4">
              <label class="form-label">Branch</label>
              <input type="text" name="bank_branch" class="form-control" placeholder="Branch">
            </div>
            <div class="col-md-4">
              <label class="form-label">Account Holder Name</label>
              <input type="text" name="bank_account_name" class="form-control" placeholder="As per bank">
            </div>
            <div class="col-md-4">
              <label class="form-label">Bank Account Number</label>
              <input type="text" name="bank_account" class="form-control" placeholder="Account number">
            </div>
            <div class="col-md-6">
              <label class="form-label">SWIFT/BIC</label>
              <input type="text" name="bank_swift" class="form-control" placeholder="SWIFT/BIC">
            </div>
            <div class="col-md-6">
              <label class="form-label">IBAN</label>
              <input type="text" name="bank_iban" class="form-control" placeholder="IBAN">
            </div>

            <div class="col-12" id="activitySection" style="display:none;">
              <hr class="my-2"><div class="fw-semibold small text-uppercase text-muted">Activity Options</div>
              <div class="row g-3">
                <div class="col-md-4">
                  <div class="form-check mt-4">
                    <input class="form-check-input" type="checkbox" id="chkAdultOnly" name="is_adult_only">
                    <label class="form-check-label" for="chkAdultOnly">Adult only</label>
                  </div>
                </div>
                <div class="col-md-4">
                  <div class="form-check mt-4">
                    <input class="form-check-input" type="checkbox" id="chkFamilyAllowed" name="is_family_allowed" checked>
                    <label class="form-check-label" for="chkFamilyAllowed">Family allowed</label>
                  </div>
                </div>
                <div class="col-md-4">
                  <div class="form-check mt-4">
                    <input class="form-check-input" type="checkbox" id="chkHasShowTimes" name="has_show_times">
                    <label class="form-check-label" for="chkHasShowTimes">Has show time(s)</label>
                  </div>
                </div>
                <div class="col-12" id="showTimesBlock" style="display:none;">
                  <label class="form-label">Show times</label>
                  <div class="d-flex gap-2 align-items-center mb-2">
                    <input type="time" class="form-control" id="inputShowTime" style="max-width:180px;">
                    <button type="button" class="btn btn-outline-primary btn-sm" id="btnAddTime">Add</button>
                  </div>
                  <div id="showTimesChips" class="d-flex flex-wrap gap-2"></div>
                  <input type="hidden" name="show_times" id="fieldShowTimes" value="">
                </div>
                <div class="col-md-6">
                  <label class="form-label">Last booking cutoff (today)</label>
                  <input type="time" name="last_booking_cutoff" class="form-control" placeholder="e.g., 17:00">
                  <div class="form-text">After this time, same-day bookings will be disallowed (next day only).</div>
                </div>
              </div>
            </div>
          </div>`;
        body.appendChild(form);
        const ftr = document.createElement('div'); ftr.className = 'vd-ftr';
        cancelBtn = document.createElement('button'); cancelBtn.type='button'; cancelBtn.className='btn btn-outline-secondary'; cancelBtn.textContent='Cancel';
        saveBtn = document.createElement('button'); saveBtn.type='button'; saveBtn.className='btn btn-primary js-ask-pass'; saveBtn.dataset.action='add-vendor'; saveBtn.dataset.form = formId; saveBtn.textContent='Save Vendor';
        ftr.appendChild(cancelBtn); ftr.appendChild(saveBtn);
        modal.appendChild(hdr); modal.appendChild(body); modal.appendChild(ftr);
        document.body.appendChild(overlay); document.body.appendChild(modal);
        overlay.addEventListener('click', hide);
        closeBtn.addEventListener('click', hide);
        cancelBtn.addEventListener('click', hide);
        // Gate saving with password: try global .js-ask-pass handler; fallback to prompt -> submit
        saveBtn.addEventListener('click', (ev)=>{
          if (!form.reportValidity()) return;
          // If a global delegated handler is present, it will also run; but provide a fallback prompt to ensure submission
          try {
            // If the delegated handler doesn't run within a tick, do fallback
            setTimeout(()=>{
              // If form still not submitted (heuristic: hidden master_password empty), use prompt
              const mp = form.querySelector('input[name="master_password"]');
              if (!mp) return; // safety
              if ((mp.value||'') !== '') return; // assume submission already triggered via global handler
              const pwd = window.prompt('Enter update password to save vendor');
              if (!pwd) return;
              mp.value = pwd;
              form.submit();
            }, 0);
          } catch (e) {
            const mp = form.querySelector('input[name="master_password"]');
            const pwd = window.prompt('Enter update password to save vendor');
            if (mp && pwd) { mp.value = pwd; form.submit(); }
          }
        });
        document.addEventListener('keydown', escHandler);

        // Populate module select
        const moduleSel = form.querySelector('#fieldModule');
        (modules || []).forEach(m=>{
          const opt = document.createElement('option');
          opt.value = m.slug || '';
          opt.textContent = m.name || m.slug;
          moduleSel.appendChild(opt);
        });

        // Populate country select
        const countrySel = form.querySelector('#fieldCountry');
        (countries || []).forEach(c=>{ if(!c) return; const opt=document.createElement('option'); opt.value=c; opt.textContent=c; countrySel.appendChild(opt); });

        // City select, dependent on country
        const citySel = form.querySelector('#fieldCity');
        function refillCities(){
          const c = countrySel.value || '';
          citySel.innerHTML = '<option value="">Select city</option>';
          const arr = (citiesByCountry && citiesByCountry[c]) ? Array.from(new Set(citiesByCountry[c])) : [];
          arr.forEach(ci=>{ const opt=document.createElement('option'); opt.value=ci; opt.textContent=ci; citySel.appendChild(opt); });
        }
        countrySel.addEventListener('change', refillCities);

        // Activity section show/hide
        const activitySec = form.querySelector('#activitySection');
        const chkHasShow = form.querySelector('#chkHasShowTimes');
        const showTimesBlock = form.querySelector('#showTimesBlock');
        const chkAdult = form.querySelector('#chkAdultOnly');
        const chkFamily = form.querySelector('#chkFamilyAllowed');
        function onModuleChange(){ activitySec.style.display = (moduleSel.value === 'activity') ? '' : 'none'; }
        moduleSel.addEventListener('change', onModuleChange);
        chkHasShow.addEventListener('change', ()=>{ showTimesBlock.style.display = chkHasShow.checked ? '' : 'none'; });

        // Make Adult only vs Family allowed mutually exclusive, always keep one selected
        function enforceAudience(excluded){
          if (excluded === 'adult') {
            if (chkAdult.checked) { chkFamily.checked = false; }
            else if (!chkFamily.checked) { chkFamily.checked = true; }
          } else {
            if (chkFamily.checked) { chkAdult.checked = false; }
            else if (!chkAdult.checked) { chkAdult.checked = true; }
          }
        }
        chkAdult.addEventListener('change', ()=>enforceAudience('adult'));
        chkFamily.addEventListener('change', ()=>enforceAudience('family'));

        // Show time chip management
        const inputShow = form.querySelector('#inputShowTime');
        const chips = form.querySelector('#showTimesChips');
        const hiddenField = form.querySelector('#fieldShowTimes');
        const btnAdd = form.querySelector('#btnAddTime');
        let times = [];
        function syncHidden(){ hiddenField.value = times.join(','); }
        function renderChips(){
          chips.innerHTML = '';
          times.forEach((t, idx)=>{
            const span = document.createElement('span');
            span.className = 'badge bg-light text-dark border';
            span.textContent = t + ' ';
            const x = document.createElement('button'); x.type='button'; x.className='btn-close btn-close-white btn-sm'; x.style.filter='invert(1)'; x.style.marginLeft='6px';
            x.addEventListener('click', ()=>{ times.splice(idx,1); renderChips(); syncHidden(); });
            span.appendChild(x);
            chips.appendChild(span);
          });
        }
        btnAdd.addEventListener('click', ()=>{
          const val = (inputShow.value || '').trim();
          if (!val) return;
          if (!times.includes(val)) { times.push(val); times.sort(); renderChips(); syncHidden(); }
          inputShow.value='';
        });

        // Repopulate old values if validation failed
        function setVal(name, val){ const el=form.querySelector(`[name="${name}"]`); if(el){ if(el.tagName==='SELECT' || el.tagName==='TEXTAREA' || el.tagName==='INPUT'){ el.value = val; if(name==='country') refillCities(); if(name==='city') {/* rely on refill*/} } } }
        if (old && Object.keys(old).length){
          ['name','company_name','module','country','city','address','whatsapp_number','calling_number','line_id','contact_email','enquiry_email','confirm_email','vat_number','tat_number','bank_account','contact_person_name','contact_person_phone','contact_person_email','bank_name','bank_branch','bank_account_name','bank_swift','bank_iban','last_booking_cutoff'].forEach(k=>{ if(old[k]!==undefined) setVal(k, old[k]); });
          if (old['is_adult_only']) form.querySelector('#chkAdultOnly').checked = true;
          if (old['is_family_allowed']===undefined || old['is_family_allowed']) form.querySelector('#chkFamilyAllowed').checked = true; else form.querySelector('#chkFamilyAllowed').checked = false;
          enforceAudience('family');
        }

        // Initial UI state
        onModuleChange();
        enforceAudience('family');
      }

      function escHandler(e){ if (e.key === 'Escape') hide(); }
      function show(){ if(!overlay) build(); overlay.style.display='block'; modal.style.display='block'; document.body.classList.add('vd-lock'); setTimeout(()=>{ const n=form.querySelector('input[name="name"]'); if(n) n.focus(); }, 50); }
      function hide(){ if(!overlay) return; overlay.style.display='none'; modal.style.display='none'; document.body.classList.remove('vd-lock'); }
      openBtn.addEventListener('click', show);
    })();
  </script>
</div>
