<?php
// app/Views/admin/tools_payment_gateways.php
// expects: $csrf, $cfg
?>
<!doctype html>
<html>
<head>
  <meta charset="utf-8">
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <title>Payment Gateways</title>
  <link href="/assets/css/bootstrap.min.css" rel="stylesheet">
  <style>
    .gateway-card{border:1px solid #eaecef;border-radius:10px;box-shadow:0 1px 2px rgba(16,24,40,.06)}
    .gateway-name{font-weight:600}
    .settings-btn{border-color:#ff6b6b;color:#ff6b6b}
    .settings-btn:hover{background:#ff6b6b;color:#fff}
  </style>
  <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.3/font/bootstrap-icons.css">
  </head>
<body class="p-3">
  <div class="container-fluid">
    <?php if (!empty($_SESSION['flash'])): ?>
      <div class="alert alert-success py-2">
        <?= htmlspecialchars($_SESSION['flash']); unset($_SESSION['flash']); ?>
      </div>
    <?php endif; ?>
    <?php if (!empty($_SESSION['errors'])): ?>
      <div class="alert alert-danger py-2">
        <ul class="mb-0 small">
          <?php foreach ($_SESSION['errors'] as $e): ?>
            <li><?= htmlspecialchars($e) ?></li>
          <?php endforeach; unset($_SESSION['errors']); ?>
        </ul>
      </div>
    <?php endif; ?>

    <div class="d-flex align-items-center justify-content-between mb-3">
      <h3 class="mb-0">Payment Gateways</h3>
      <a class="btn btn-secondary btn-sm" href="/admin"><i class="bi bi-arrow-left"></i> Back</a>
    </div>

    <div class="row g-3">
      <!-- Wallet Card -->
      <div class="col-12 col-md-6 col-lg-4">
        <div class="p-3 gateway-card h-100">
          <div class="d-flex align-items-center justify-content-between mb-2">
            <div class="d-flex align-items-center gap-2">
              <i class="bi bi-wallet2 fs-4 text-warning"></i>
              <span class="gateway-name">Wallet Balance</span>
            </div>
            <form method="post" action="/admin/tools/payment-gateways/toggle" class="d-flex align-items-center gap-2">
              <input type="hidden" name="csrf" value="<?= htmlspecialchars($csrf ?? '') ?>">
              <input type="hidden" name="gateway" value="wallet">
              <input type="hidden" name="enabled" value="<?= !empty($cfg['wallet']['enabled']) ? '0' : '1' ?>">
              <span class="me-1 small text-muted">Status</span>
              <div class="form-check form-switch m-0">
                <input class="form-check-input" type="checkbox" role="switch" <?= !empty($cfg['wallet']['enabled']) ? 'checked' : '' ?> onclick="this.form.submit()">
              </div>
              <input type="password" class="form-control form-control-sm" style="width:150px" name="master_password" placeholder="Update Password" autocomplete="current-password" required>
            </form>
          </div>
          <button type="button" class="btn settings-btn btn-sm" onclick="location.href='/admin/wallet/secure'">
            <i class="bi bi-gear"></i> Settings
          </button>
        </div>
      </div>

      <!-- Stripe Card -->
      <div class="col-12 col-md-6 col-lg-4">
        <div class="p-3 gateway-card h-100">
          <div class="d-flex align-items-center justify-content-between mb-2">
            <div class="d-flex align-items-center gap-2">
              <i class="bi bi-stripe fs-4 text-primary"></i>
              <span class="gateway-name">Stripe</span>
            </div>
            <form method="post" action="/admin/tools/payment-gateways/toggle" class="d-flex align-items-center gap-2">
              <input type="hidden" name="csrf" value="<?= htmlspecialchars($csrf ?? '') ?>">
              <input type="hidden" name="gateway" value="stripe">
              <input type="hidden" name="enabled" value="<?= !empty($cfg['stripe']['enabled']) ? '0' : '1' ?>">
              <span class="me-1 small text-muted">Status</span>
              <div class="form-check form-switch m-0">
                <input class="form-check-input" type="checkbox" role="switch" <?= !empty($cfg['stripe']['enabled']) ? 'checked' : '' ?> onclick="this.form.submit()">
              </div>
              <input type="password" class="form-control form-control-sm" style="width:150px" name="master_password" placeholder="Update Password" autocomplete="current-password" required>
            </form>
          </div>
          <button type="button" class="btn settings-btn btn-sm" data-bs-toggle="modal" data-bs-target="#stripeModal">
            <i class="bi bi-gear"></i> Settings
          </button>
        </div>
      </div>

      <!-- PayPal Card -->
      <div class="col-12 col-md-6 col-lg-4">
        <div class="p-3 gateway-card h-100">
          <div class="d-flex align-items-center justify-content-between mb-2">
            <div class="d-flex align-items-center gap-2">
              <i class="bi bi-paypal fs-4" style="color:#0070ba"></i>
              <span class="gateway-name">PayPal</span>
            </div>
            <form method="post" action="/admin/tools/payment-gateways/toggle" class="d-flex align-items-center gap-2">
              <input type="hidden" name="csrf" value="<?= htmlspecialchars($csrf ?? '') ?>">
              <input type="hidden" name="gateway" value="paypal">
              <input type="hidden" name="enabled" value="<?= !empty($cfg['paypal']['enabled']) ? '0' : '1' ?>">
              <span class="me-1 small text-muted">Status</span>
              <div class="form-check form-switch m-0">
                <input class="form-check-input" type="checkbox" role="switch" <?= !empty($cfg['paypal']['enabled']) ? 'checked' : '' ?> onclick="this.form.submit()">
              </div>
              <input type="password" class="form-control form-control-sm" style="width:150px" name="master_password" placeholder="Update Password" autocomplete="current-password" required>
            </form>
          </div>
          <button type="button" class="btn settings-btn btn-sm" data-bs-toggle="modal" data-bs-target="#paypalModal">
            <i class="bi bi-gear"></i> Settings
          </button>
        </div>
      </div>
    </div>

    
  </div>

  <!-- Stripe Modal -->
  <div class="modal fade" id="stripeModal" tabindex="-1" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered">
      <div class="modal-content">
        <div class="modal-header">
          <h5 class="modal-title">Stripe Settings</h5>
          <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
        </div>
        <form method="post" action="/admin/tools/payment-gateways/save">
          <div class="modal-body">
            <input type="hidden" name="csrf" value="<?= htmlspecialchars($csrf ?? '') ?>">
            <input type="hidden" name="gateway" value="stripe">
            <div class="mb-2">
              <label class="form-label">Publishable key</label>
              <input type="text" name="publishable_key" class="form-control" value="<?= htmlspecialchars($cfg['stripe']['publishable_key'] ?? '') ?>" placeholder="pk_live_... or pk_test_...">
            </div>
            <div class="mb-2">
              <label class="form-label">Secret key</label>
              <input type="password" name="secret_key" class="form-control" value="<?= htmlspecialchars($cfg['stripe']['secret_key'] ?? '') ?>" placeholder="sk_live_... or sk_test_...">
            </div>
            <div class="mb-2">
              <label class="form-label">Webhook secret</label>
              <input type="password" name="webhook_secret" class="form-control" value="<?= htmlspecialchars($cfg['stripe']['webhook_secret'] ?? '') ?>" placeholder="whsec_...">
            </div>
            <div class="mb-2">
              <label class="form-label">Currency</label>
              <input type="text" name="currency" class="form-control" value="<?= htmlspecialchars($cfg['stripe']['currency'] ?? 'THB') ?>" placeholder="THB">
            </div>
            <div class="mb-2">
              <input type="password" class="form-control" name="master_password" placeholder="Update Password" autocomplete="current-password" required>
            </div>
          </div>
          <div class="modal-footer">
            <button type="button" class="btn btn-outline-secondary" data-bs-dismiss="modal">Cancel</button>
            <button class="btn btn-primary" <?= empty($cfg['stripe']['enabled']) ? 'disabled' : '' ?>>Save</button>
          </div>
        </form>
      </div>
    </div>
  </div>

  <!-- PayPal Modal -->
  <div class="modal fade" id="paypalModal" tabindex="-1" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered">
      <div class="modal-content">
        <div class="modal-header">
          <h5 class="modal-title">PayPal Settings</h5>
          <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
        </div>
        <form method="post" action="/admin/tools/payment-gateways/save">
          <div class="modal-body">
            <input type="hidden" name="csrf" value="<?= htmlspecialchars($csrf ?? '') ?>">
            <input type="hidden" name="gateway" value="paypal">
            <div class="mb-2">
              <label class="form-label">Client ID</label>
              <input type="text" name="client_id" class="form-control" value="<?= htmlspecialchars($cfg['paypal']['client_id'] ?? '') ?>" placeholder="PayPal client ID">
            </div>
            <div class="mb-2">
              <label class="form-label">Client Secret</label>
              <input type="password" name="client_secret" class="form-control" value="<?= htmlspecialchars($cfg['paypal']['client_secret'] ?? '') ?>" placeholder="PayPal client secret">
            </div>
            <div class="mb-2">
              <label class="form-label">Mode</label>
              <select name="mode" class="form-select">
                <?php $mode = $cfg['paypal']['mode'] ?? 'sandbox'; ?>
                <option value="sandbox" <?= $mode==='sandbox' ? 'selected' : '' ?>>Sandbox</option>
                <option value="live" <?= $mode==='live' ? 'selected' : '' ?>>Live</option>
              </select>
            </div>
            <div class="mb-2">
              <label class="form-label">Currency</label>
              <input type="text" name="currency" class="form-control" value="<?= htmlspecialchars($cfg['paypal']['currency'] ?? 'USD') ?>" placeholder="USD">
            </div>
            <div class="mb-2">
              <input type="password" class="form-control" name="master_password" placeholder="Update Password" autocomplete="current-password" required>
            </div>
          </div>
          <div class="modal-footer">
            <button type="button" class="btn btn-outline-secondary" data-bs-dismiss="modal">Cancel</button>
            <button class="btn btn-primary" <?= empty($cfg['paypal']['enabled']) ? 'disabled' : '' ?>>Save</button>
          </div>
        </form>
      </div>
    </div>
  </div>

  <script src="/assets/js/bootstrap.bundle.min.js"></script>
</body>
</html>
