<?php
// app/Views/admin/tools_email_templates.php
// $csrf and $unlocked are passed from controller
?>
<!doctype html>
<html>
<head>
  <meta charset="utf-8">
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <title>Email Templates Preview</title>
  <link href="/assets/css/bootstrap.min.css" rel="stylesheet">
  <style>
    .preview-frame{width:100%;height:70vh;border:1px solid #dee2e6;border-radius:8px}
    .editor{width:100%;min-height:70vh;border:1px solid #dee2e6;border-radius:8px;font-family:monospace}
    .code-area{width:100%;min-height:70vh;border:0;padding:12px;border-radius:8px}
    .wysiwyg{padding:12px;overflow:auto}
    .toolbar .btn-group>.btn{margin-right:6px}
  </style>
</head>
<body class="p-3">
  <div class="container-fluid">
    <?php if (!empty($_SESSION['flash'])): ?>
      <div class="alert alert-success py-2">
        <?= htmlspecialchars($_SESSION['flash']); unset($_SESSION['flash']); ?>
      </div>
    <?php endif; ?>
    <?php if (!empty($_SESSION['errors'])): ?>
      <div class="alert alert-danger py-2">
        <ul class="mb-0 small">
          <?php foreach ($_SESSION['errors'] as $e): ?>
            <li><?= htmlspecialchars($e) ?></li>
          <?php endforeach; unset($_SESSION['errors']); ?>
        </ul>
      </div>
    <?php endif; ?>

    <?php if (empty($unlocked)): ?>
      <div class="d-flex justify-content-center align-items-center" style="min-height:60vh;">
        <div class="card" style="width:min(92vw,420px)">
          <div class="card-header fw-semibold">Enter Update Password</div>
          <form method="post" action="/admin/tools/email-templates/unlock">
            <input type="hidden" name="csrf" value="<?= htmlspecialchars($csrf ?? '') ?>">
            <div class="card-body">
              <p class="small text-muted mb-2">This page is protected. Please enter your update password to continue.</p>
              <input type="password" name="master_password" class="form-control" placeholder="Update Password" autocomplete="current-password" required>
            </div>
            <div class="card-footer d-grid">
              <button type="submit" class="btn btn-primary">Unlock</button>
            </div>
          </form>
        </div>
      </div>
    <?php else: ?>
    <div class="d-flex align-items-center justify-content-between mb-3">
      <h3 class="mb-0">Email Templates Preview</h3>
      <a class="btn btn-secondary btn-sm" href="/admin"><i class="bi bi-arrow-left"></i> Back</a>
    </div>

    <ul class="nav nav-tabs" id="tplTabs" role="tablist">
      <li class="nav-item" role="presentation">
        <button class="nav-link active" id="hotel-tab" data-type="hotel" data-bs-toggle="tab" data-bs-target="#preview" type="button" role="tab">Hotel</button>
      </li>
      <li class="nav-item" role="presentation">
        <button class="nav-link" id="activity-tab" data-type="activity" data-bs-toggle="tab" data-bs-target="#preview" type="button" role="tab">Activity</button>
      </li>
      <li class="nav-item" role="presentation">
        <button class="nav-link" id="taxi-tab" data-type="taxi" data-bs-toggle="tab" data-bs-target="#preview" type="button" role="tab">Taxi</button>
      </li>
      <li class="nav-item" role="presentation">
        <button class="nav-link" id="visa-tab" data-type="visa" data-bs-toggle="tab" data-bs-target="#preview" type="button" role="tab">Visa</button>
      </li>
      <li class="nav-item" role="presentation">
        <button class="nav-link" id="login-tab" data-type="login" data-bs-toggle="tab" data-bs-target="#preview" type="button" role="tab">Login (System)</button>
      </li>
    </ul>
    <div class="row mt-3 g-3">
      <div class="col-lg-7">
        <div class="mb-2 d-flex align-items-center justify-content-between">
          <div class="fw-semibold">Live Preview</div>
          <button class="btn btn-outline-secondary btn-sm" id="refreshBtn">Refresh</button>
        </div>
        <iframe id="previewFrame" class="preview-frame" src="/admin/tools/email-templates/preview?type=hotel"></iframe>
      </div>
      <div class="col-lg-5">
        <div class="mb-3">
          <div class="fw-semibold mb-2">Branding</div>
          <div class="row g-2">
            <div class="col-12">
              <label class="form-label">Mode</label>
              <select id="mode" class="form-select">
                <option value="b2c" selected>B2C (Customer)</option>
                <option value="b2b">B2B (Agent)</option>
                <option value="vendor">Vendor (Final booking)</option>
              </select>
            </div>
            <div class="col-12" id="brand_name_wrap">
              <label class="form-label">Brand name</label>
              <input type="text" id="brand_name" class="form-control" placeholder="e.g., My Travel Brand">
            </div>
            <div class="col-12" id="logo_url_wrap">
              <label class="form-label">Logo URL</label>
              <input type="url" id="logo_url" class="form-control" placeholder="https://.../logo.png">
            </div>
            <div class="col-12 form-check mt-1">
              <input class="form-check-input" type="checkbox" id="hide_branding">
              <label class="form-check-label" for="hide_branding">Hide branding (logo and name) in header</label>
            </div>
            <div class="col-6">
              <label class="form-label">Brand color</label>
              <input type="text" id="brand_color" class="form-control" placeholder="#0d6efd">
            </div>
            <div class="col-6 d-flex align-items-end">
              <button class="btn btn-outline-primary w-100" type="button" id="applyBrand">Apply to preview</button>
            </div>
            <div class="col-12">
              <label class="form-label">Signature (HTML)</label>
              <textarea id="signature_html" class="form-control" rows="2" placeholder="e.g., Regards,<br>Operations Team"></textarea>
            </div>
            <div class="col-12">
              <label class="form-label">Footer text</label>
              <input type="text" id="footer_text" class="form-control" placeholder="This is a system-generated booking.">
            </div>
          </div>
        </div>
        <div class="d-flex align-items-center justify-content-between mb-2">
          <div class="fw-semibold">Editor</div>
          <div class="toolbar d-flex align-items-center">
            <div class="btn-group me-2" role="group" aria-label="Part">
              <input type="radio" class="btn-check" name="part" id="partBlock" autocomplete="off" value="block" checked>
              <label class="btn btn-outline-primary btn-sm" for="partBlock">Block</label>
              <input type="radio" class="btn-check" name="part" id="partBase" autocomplete="off" value="base">
              <label class="btn btn-outline-primary btn-sm" for="partBase">Base</label>
            </div>
            <div class="btn-group me-2" role="group" aria-label="Mode">
              <input type="radio" class="btn-check" name="mode" id="modeHtml" autocomplete="off" value="html" checked>
              <label class="btn btn-outline-secondary btn-sm" for="modeHtml">HTML</label>
              <input type="radio" class="btn-check" name="mode" id="modeWys" autocomplete="off" value="wysiwyg">
              <label class="btn btn-outline-secondary btn-sm" for="modeWys">WYSIWYG</label>
            </div>
            <button class="btn btn-success btn-sm" id="saveBtn">Save</button>
          </div>
        </div>
        <div id="editorWrap" class="editor">
          <textarea id="codeArea" class="code-area" spellcheck="false"></textarea>
          <div id="wysiwyg" class="wysiwyg" contenteditable="true" style="display:none"></div>
        </div>
        <input type="hidden" id="csrf" value="<?= htmlspecialchars($csrf) ?>">

        <form class="mt-3" method="post" action="/admin/tools/email-templates/test-send" onsubmit="return setHiddenTypeBeforeSend();">
          <input type="hidden" name="csrf" value="<?= htmlspecialchars($csrf) ?>">
          <input type="hidden" name="type" id="hiddenType" value="hotel">
          <input type="hidden" name="mode" id="hiddenMode" value="b2c">
          <input type="hidden" name="brand_name" id="hiddenBrandName" value="">
          <input type="hidden" name="logo_url" id="hiddenLogoUrl" value="">
          <input type="hidden" name="hide_branding" id="hiddenHideBranding" value="0">
          <input type="hidden" name="brand_color" id="hiddenBrandColor" value="">
          <input type="hidden" name="signature_html" id="hiddenSignatureHtml" value="">
          <input type="hidden" name="footer_text" id="hiddenFooterText" value="">
          <div class="row g-2 align-items-end">
            <div class="col-12">
              <label class="form-label">Send test to</label>
              <input type="email" class="form-control" name="to" placeholder="you@example.com" required>
            </div>
            <div class="col-12">
              <label class="form-label">Subject</label>
              <input type="text" class="form-control" name="subject" placeholder="Template Test Email">
            </div>
            <div class="col-12">
              <label class="form-label">Profile (optional)</label>
              <select class="form-select" name="profile">
                <option value="">Auto (by tab)</option>
                <option value="hotel">Hotel</option>
                <option value="activity">Activity</option>
                <option value="taxi">Taxi</option>
                <option value="visa">Visa</option>
              </select>
            </div>
            <div class="col-12 d-grid">
              <button class="btn btn-primary">Send test email</button>
            </div>
          </div>
        </form>
      </div>
    </div>
  </div>

  <script src="/assets/js/bootstrap.bundle.min.js"></script>
  <script>
    const frame = document.getElementById('previewFrame');
    const codeArea = document.getElementById('codeArea');
    const wys = document.getElementById('wysiwyg');
    const csrf = document.getElementById('csrf').value;
    let currentType = 'hotel';
    const BRANDING_KEY = 'email_branding_prefs';

    function getBrandingQuery(){
      const mode = encodeURIComponent(document.getElementById('mode').value || 'b2c');
      const bn = encodeURIComponent(document.getElementById('brand_name').value || '');
      const lu = encodeURIComponent(document.getElementById('logo_url').value || '');
      const bc = encodeURIComponent(document.getElementById('brand_color').value || '');
      const sh = encodeURIComponent(document.getElementById('signature_html').value || '');
      const ft = encodeURIComponent(document.getElementById('footer_text').value || '');
      const hb = document.getElementById('hide_branding').checked ? '1' : '0';
      let q = `&mode=${mode}&hide_branding=${hb}`;
      if(bn) q += `&brand_name=${bn}`;
      if(lu) q += `&logo_url=${lu}`;
      if(bc) q += `&brand_color=${bc}`;
      if(sh) q += `&signature_html=${sh}`;
      if(ft) q += `&footer_text=${ft}`;
      return q;
    }

    function setPreview(type){
      const cacheBust = '&_=' + Date.now();
      frame.src = '/admin/tools/email-templates/preview?type=' + encodeURIComponent(type) + getBrandingQuery() + cacheBust;
    }

    function toggleBrandingInputs(){
      const hb = document.getElementById('hide_branding').checked;
      const bnWrap = document.getElementById('brand_name_wrap');
      const luWrap = document.getElementById('logo_url_wrap');
      const bn = document.getElementById('brand_name');
      const lu = document.getElementById('logo_url');
      if(hb){
        bnWrap.classList.add('d-none');
        luWrap.classList.add('d-none');
        bnWrap.style.display = 'none';
        luWrap.style.display = 'none';
        bn.setAttribute('disabled','disabled');
        lu.setAttribute('disabled','disabled');
      }else{
        bnWrap.classList.remove('d-none');
        luWrap.classList.remove('d-none');
        bnWrap.style.display = '';
        luWrap.style.display = '';
        bn.removeAttribute('disabled');
        lu.removeAttribute('disabled');
      }
    }

    function loadBrandingPrefs(){
      try{
        const raw = localStorage.getItem(BRANDING_KEY);
        if(!raw) return;
        const p = JSON.parse(raw) || {};
        if(p.mode) document.getElementById('mode').value = p.mode;
        if(typeof p.hide_branding !== 'undefined'){
          const v = (p.hide_branding === '1' || p.hide_branding === 1 || p.hide_branding === true);
          document.getElementById('hide_branding').checked = v;
        }
        if(p.brand_name) document.getElementById('brand_name').value = p.brand_name;
        if(p.logo_url) document.getElementById('logo_url').value = p.logo_url;
        if(p.brand_color) document.getElementById('brand_color').value = p.brand_color;
        if(p.signature_html) document.getElementById('signature_html').value = p.signature_html;
        if(p.footer_text) document.getElementById('footer_text').value = p.footer_text;
      }catch(e){/* ignore */}
    }

    function saveBrandingPrefs(){
      const hb = document.getElementById('hide_branding').checked ? '1' : '0';
      const obj = {
        mode: document.getElementById('mode').value || 'b2c',
        brand_name: hb==='1' ? '' : (document.getElementById('brand_name').value || ''),
        logo_url: hb==='1' ? '' : (document.getElementById('logo_url').value || ''),
        brand_color: document.getElementById('brand_color').value || '',
        signature_html: document.getElementById('signature_html').value || '',
        footer_text: document.getElementById('footer_text').value || '',
        hide_branding: hb
      };
      try{ localStorage.setItem(BRANDING_KEY, JSON.stringify(obj)); }catch(e){/* ignore */}
    }

    function getSelectedPart(){
      return document.querySelector('input[name="part"]:checked').value;
    }

    async function loadFile(){
      const part = getSelectedPart();
      const res = await fetch(`/admin/tools/email-templates/file?type=${encodeURIComponent(currentType)}&part=${encodeURIComponent(part)}`);
      if(!res.ok){ alert('Failed to load template'); return; }
      const json = await res.json();
      codeArea.value = json.content || '';
      wys.innerHTML = json.content || '';
    }

    async function saveFile(){
      const part = getSelectedPart();
      const mode = document.querySelector('input[name="mode"]:checked').value;
      const content = mode==='html' ? codeArea.value : wys.innerHTML;
      const form = new FormData();
      form.append('type', currentType);
      form.append('part', part);
      form.append('content', content);
      // Backend expects 'csrf' (see App/Core/Security::requireCsrf)
      form.append('csrf', csrf);
      const res = await fetch('/admin/tools/email-templates/file', { method:'POST', body: form });
      if(res.ok){
        alert('Saved');
        setPreview(currentType);
      }else{
        alert('Save failed');
      }
    }

    // Tab click -> change type, preview, and load file
    document.querySelectorAll('[data-type]').forEach(btn => {
      btn.addEventListener('click', () => {
        currentType = btn.getAttribute('data-type');
        setPreview(currentType);
        loadFile();
      });
    });

    // Part toggle -> reload file
    document.querySelectorAll('input[name="part"]').forEach(r => r.addEventListener('change', loadFile));

    // Mode toggle -> switch visibility and sync
    document.querySelectorAll('input[name="mode"]').forEach(r => r.addEventListener('change', () =>{
      const val = document.querySelector('input[name="mode"]:checked').value;
      if(val==='html'){
        codeArea.style.display='block';
        wys.style.display='none';
        codeArea.value = wys.innerHTML;
      }else{
        codeArea.style.display='none';
        wys.style.display='block';
        wys.innerHTML = codeArea.value;
      }
    }));

    document.getElementById('saveBtn').addEventListener('click', saveFile);
    document.getElementById('refreshBtn').addEventListener('click', ()=> setPreview(currentType));
    document.getElementById('applyBrand').addEventListener('click', ()=> { saveBrandingPrefs(); setPreview(currentType); });
    ['mode','brand_name','logo_url','brand_color','signature_html','footer_text','hide_branding'].forEach(id=>{
      const el = document.getElementById(id);
      el.addEventListener('change', ()=> { if(id==='hide_branding') toggleBrandingInputs(); saveBrandingPrefs(); setPreview(currentType); });
      el.addEventListener('blur', ()=> { saveBrandingPrefs(); setPreview(currentType); });
    });

    // Initial load
    loadBrandingPrefs();
    toggleBrandingInputs();
    setPreview(currentType);
    loadFile();

    // ensure test form uses current tab type
    function setHiddenTypeBeforeSend(){
      document.getElementById('hiddenType').value = currentType;
      document.getElementById('hiddenMode').value = document.getElementById('mode').value || 'b2c';
      const hideBranding = document.getElementById('hide_branding').checked;
      document.getElementById('hiddenBrandName').value = hideBranding ? '' : (document.getElementById('brand_name').value || '');
      document.getElementById('hiddenLogoUrl').value = hideBranding ? '' : (document.getElementById('logo_url').value || '');
      document.getElementById('hiddenHideBranding').value = document.getElementById('hide_branding').checked ? '1' : '0';
      document.getElementById('hiddenBrandColor').value = document.getElementById('brand_color').value || '';
      document.getElementById('hiddenSignatureHtml').value = document.getElementById('signature_html').value || '';
      document.getElementById('hiddenFooterText').value = document.getElementById('footer_text').value || '';
      return true;
    }
  </script>
    <?php endif; ?>
  </body>
  </html>
