<?php
// app/Views/admin/tools_country_currency.php
?>
<div class="container py-2">
  <h2 class="h5 mb-3"><i class="bi bi-geo me-2"></i>Country & Currency</h2>
  <style>
    /* Admin Tools responsive tweaks */
    @media (max-width: 576px) {
      /* Make add forms stack and become full-width */
      .card .row.g-2.align-items-end > .col-auto { width: 100%; }
      .card .row.g-2.align-items-end .form-label { margin-bottom: 4px; }
      .card .row.g-2.align-items-end input.form-control,
      .card .row.g-2.align-items-end select.form-select { width: 100%; }
      .card .row.g-2.align-items-end .btn.mt-4 { margin-top: 8px !important; width: 100%; }

      /* Search + rows selector bar stacks */
      .card-body .d-flex.justify-content-between.align-items-center { flex-direction: column; align-items: stretch; gap: 8px; }
      #pager, #locationPager { align-self: flex-end; }

      /* Tables scroll horizontally if needed */
      .table-responsive { overflow-x: auto; }
      table.table { min-width: 420px; }

      /* Stack action buttons in the last column */
      #countriesTable td.text-end,
      #locationsTable td.text-end { display: flex; flex-direction: column; gap: 6px; align-items: stretch; }
      #countriesTable td.text-end .btn,
      #locationsTable td.text-end .btn { width: 100%; }

      /* Make in-row inputs span full cell width */
      #countriesTable td input.form-control,
      #locationsTable td input.form-control { width: 100%; }

      /* Compact pagination */
      .pagination .page-link { padding: .25rem .5rem; }

      /* Actions button group behaves nicely */
      .btn-group.btn-group-sm { display: flex; gap: 6px; }
      .btn-group.btn-group-sm .btn { flex: 1 1 auto; }
    }

    @media (max-width: 360px) {
      table.table { min-width: 360px; }
    }
  </style>
  <?php if (!empty($_SESSION['flash'])): ?>
    <div class="alert alert-success py-2">
      <?= htmlspecialchars($_SESSION['flash']); unset($_SESSION['flash']); ?>
    </div>
  <?php endif; ?>
  <?php if (!empty($_SESSION['errors'])): ?>
    <div class="alert alert-danger py-2">
      <ul class="mb-0 small">
        <?php foreach ($_SESSION['errors'] as $e): ?>
          <li><?= htmlspecialchars($e) ?></li>
        <?php endforeach; unset($_SESSION['errors']); ?>
      </ul>
    </div>
  <?php endif; ?>
  <?php $old = $_SESSION['old'] ?? []; ?>
  <?php if (empty($unlocked)): ?>
    <div class="d-flex justify-content-center align-items-center" style="min-height:50vh;">
      <div class="card" style="width:min(92vw,420px)">
        <div class="card-header fw-semibold">Enter Update Password</div>
        <form method="post" action="/admin/tools/country-currency/unlock">
          <input type="hidden" name="csrf" value="<?= htmlspecialchars($csrf ?? '') ?>">
          <div class="card-body">
            <p class="small text-muted mb-2">This page is protected. Please enter your update password to continue.</p>
            <input type="password" name="master_password" class="form-control" placeholder="Update Password" autocomplete="current-password" required>
          </div>
          <div class="card-footer d-grid">
            <button type="submit" class="btn btn-primary">Unlock</button>
          </div>
        </form>
      </div>
    </div>
  <?php else: ?>
  <div class="row g-4">
    <div class="col-12">
      <div class="card h-100">
        <div class="card-header d-flex justify-content-between align-items-center">
          <span>Countries</span>
          <form class="row g-2 align-items-end" method="post" action="/admin/tools/country-currency/country">
            <input type="hidden" name="csrf" value="<?= htmlspecialchars($csrf ?? '') ?>">
            <input type="hidden" name="master_password" value="">
            <div class="col-auto">
              <label class="form-label">Country</label>
              <input type="text" name="country" class="form-control form-control-sm" placeholder="e.g., Thailand" value="<?= htmlspecialchars($old['country'] ?? '') ?>">
            </div>
            <div class="col-auto">
              <label class="form-label">Currency</label>
              <input type="text" name="currency_code" class="form-control form-control-sm" placeholder="e.g., THB" maxlength="3" value="<?= htmlspecialchars($old['currency_code'] ?? '') ?>">
            </div>
            <div class="col-auto">
              <button class="btn btn-sm btn-primary mt-4 js-ask-pass" data-action="add-country" type="button">Add</button>
            </div>
          </form>
        </div>
        <div class="card-body">
          <div class="d-flex justify-content-between align-items-center mb-2">
            <div class="input-group input-group-sm" style="max-width:320px;">
              <span class="input-group-text"><i class="bi bi-search"></i></span>
              <input id="countrySearch" type="text" class="form-control" placeholder="Search country or currency..." autocomplete="off">
            </div>
            <div class="d-flex align-items-center gap-2">
              <label class="small text-muted mb-0">Rows:</label>
              <select id="pageSize" class="form-select form-select-sm" style="width:auto;">
                <option value="10" selected>10</option>
                <option value="25">25</option>
                <option value="50">50</option>
                <option value="100">100</option>
              </select>
            </div>
          </div>
          <div class="table-responsive">
            <table class="table table-sm align-middle" id="countriesTable">
              <thead class="table-light">
                <tr>
                  <th style="width:45%">Country</th>
                  <th style="width:25%">Currency</th>
                  <th style="width:30%" class="text-end">Actions</th>
                </tr>
              </thead>
              <tbody>
              <?php foreach (($countries ?? []) as $idx => $c): ?>
                <?php $formId = 'f_rename_' . $idx; ?>
                <tr>
                  <td>
                    <form id="<?= $formId ?>" method="post" action="/admin/tools/country-currency/country/update">
                      <input type="hidden" name="csrf" value="<?= htmlspecialchars($csrf ?? '') ?>">
                      <input type="hidden" name="original_country" value="<?= htmlspecialchars($c['country']) ?>">
                      <input type="hidden" name="master_password" value="">
                    </form>
                    <input form="<?= $formId ?>" type="text" name="country" class="form-control form-control-sm" value="<?= htmlspecialchars($c['country']) ?>" placeholder="Country">
                  </td>
                  <td>
                    <input form="<?= $formId ?>" type="text" name="currency_code" class="form-control form-control-sm" placeholder="THB" maxlength="3" value="<?= htmlspecialchars($c['currency_code'] ?? '') ?>" style="text-transform: uppercase;">
                  </td>
                  <td class="text-end">
                    <div class="btn-group btn-group-sm" role="group">
                      <button data-action="rename" data-form="<?= $formId ?>" class="btn btn-outline-primary js-ask-pass" type="button">Rename</button>
                    </div>
                    <form class="d-inline js-delete-form" method="post" action="/admin/tools/country-currency/country/delete">
                      <input type="hidden" name="csrf" value="<?= htmlspecialchars($csrf ?? '') ?>">
                      <input type="hidden" name="country" value="<?= htmlspecialchars($c['country']) ?>">
                      <input type="hidden" name="master_password" value="">
                      <button data-action="delete" class="btn btn-sm btn-outline-danger js-ask-pass" type="button">Delete</button>
                    </form>
                  </td>
                </tr>
              <?php endforeach; ?>
              </tbody>
            </table>
          </div>
          <div class="d-flex justify-content-between align-items-center mt-2">
            <div class="small text-muted">
              <span id="pageInfo">Showing 0 to 0 of 0</span>
            </div>
            <nav>
              <ul class="pagination pagination-sm mb-0" id="pager">
                <li class="page-item"><button class="page-link" id="prevPage" type="button">Previous</button></li>
                <li class="page-item disabled"><span class="page-link" id="currPage">1</span></li>
                <li class="page-item"><button class="page-link" id="nextPage" type="button">Next</button></li>
              </ul>
            </nav>
          </div>
        </div>
      </div>
    </div>
  </div>

  <div class="row g-4 mt-2">
    <div class="col-12">
      <div class="card">
        <div class="card-header d-flex justify-content-between align-items-center">
          <span>Locations</span>
          <form class="row g-2 align-items-end" method="post" action="/admin/tools/country-currency/location">
            <input type="hidden" name="csrf" value="<?= htmlspecialchars($csrf ?? '') ?>">
            <input type="hidden" name="master_password" value="">
            <div class="col-auto">
              <label class="form-label">Country</label>
              <select name="country" class="form-select form-select-sm">
                <?php foreach (($countries ?? []) as $c): ?>
                  <option value="<?= htmlspecialchars($c['country']) ?>" <?= isset($old['country']) && $old['country'] === $c['country'] ? 'selected' : '' ?>><?= htmlspecialchars($c['country']) ?></option>
                <?php endforeach; ?>
              </select>
            </div>
            <div class="col-auto">
              <label class="form-label">City</label>
              <input type="text" name="city" class="form-control form-control-sm" placeholder="e.g., Phuket" value="<?= htmlspecialchars($old['city'] ?? '') ?>">
            </div>
            <div class="col-auto">
              <button class="btn btn-sm btn-primary mt-4 js-ask-pass" data-action="add-location" type="button">Add Location</button>
            </div>
          </form>
        </div>
        <div class="card-body">
          <div class="d-flex justify-content-between align-items-center mb-2">
            <div class="input-group input-group-sm" style="max-width:320px;">
              <span class="input-group-text"><i class="bi bi-search"></i></span>
              <input id="locationSearch" type="text" class="form-control" placeholder="Search country or city..." autocomplete="off">
            </div>
            <div class="d-flex align-items-center gap-2">
              <label class="small text-muted mb-0">Rows:</label>
              <select id="locationPageSize" class="form-select form-select-sm" style="width:auto;">
                <option value="10" selected>10</option>
                <option value="25">25</option>
                <option value="50">50</option>
                <option value="100">100</option>
              </select>
            </div>
          </div>
          <div class="table-responsive">
            <table class="table table-sm align-middle" id="locationsTable">
              <thead class="table-light">
                <tr>
                  <th style="width:40%">Country</th>
                  <th style="width:40%">City</th>
                  <th style="width:20%" class="text-end">Actions</th>
                </tr>
              </thead>
              <tbody>
                <?php foreach (($locations ?? []) as $i => $loc): ?>
                  <tr>
                    <td><?= htmlspecialchars($loc['country']) ?></td>
                    <td><?= htmlspecialchars($loc['city']) ?></td>
                    <td class="text-end">
                      <form class="d-inline js-delete-form" method="post" action="/admin/tools/country-currency/location/delete">
                        <input type="hidden" name="csrf" value="<?= htmlspecialchars($csrf ?? '') ?>">
                        <input type="hidden" name="country" value="<?= htmlspecialchars($loc['country']) ?>">
                        <input type="hidden" name="city" value="<?= htmlspecialchars($loc['city']) ?>">
                        <input type="hidden" name="master_password" value="">
                        <button data-action="delete-location" class="btn btn-sm btn-outline-danger js-ask-pass" type="button">Delete</button>
                      </form>
                    </td>
                  </tr>
                <?php endforeach; ?>
              </tbody>
            </table>
          </div>
          <div class="d-flex justify-content-between align-items-center mt-2">
            <div class="small text-muted">
              <span id="locationPageInfo">Showing 0 to 0 of 0</span>
            </div>
            <nav>
              <ul class="pagination pagination-sm mb-0" id="locationPager">
                <li class="page-item"><button class="page-link" id="locationPrev" type="button">Previous</button></li>
                <li class="page-item disabled"><span class="page-link" id="locationCurr">1</span></li>
                <li class="page-item"><button class="page-link" id="locationNext" type="button">Next</button></li>
              </ul>
            </nav>
          </div>
        </div>
      </div>
    </div>
  </div>
</div>

<?php endif; ?>

<script>
  (function(){
    console.log('[tools] script loaded');
    const $ = (sel, root=document) => root.querySelector(sel);
    const $$ = (sel, root=document) => Array.from(root.querySelectorAll(sel));

    // Countries table search + pagination
    const table = document.getElementById('countriesTable');
    if (table) {
      const allRows = Array.from(table.tBodies[0].rows);
      const searchInput = document.getElementById('countrySearch');
      const pageSizeSel = document.getElementById('pageSize');
      const prevBtn = document.getElementById('prevPage');
      const nextBtn = document.getElementById('nextPage');
      const currPageSpan = document.getElementById('currPage');
      const pageInfo = document.getElementById('pageInfo');

      const state = { q: '', page: 1, pageSize: parseInt(pageSizeSel?.value || '10', 10) };

      function matches(row, q){
        if (!q) return true;
        const t = row.innerText.toLowerCase();
        return t.includes(q.toLowerCase());
      }

      function render(){
        const filtered = allRows.filter(r => matches(r, state.q));
        const total = filtered.length;
        const pages = Math.max(1, Math.ceil(total / state.pageSize));
        if (state.page > pages) state.page = pages;
        const start = (state.page - 1) * state.pageSize;
        const end = start + state.pageSize;
        allRows.forEach(r => r.style.display = 'none');
        filtered.slice(start, end).forEach(r => r.style.display = '');
        currPageSpan.textContent = String(state.page);
        prevBtn.parentElement.classList.toggle('disabled', state.page <= 1);
        nextBtn.parentElement.classList.toggle('disabled', state.page >= pages);
        const from = total === 0 ? 0 : start + 1;
        const to = Math.min(total, end);
        pageInfo.textContent = `Showing ${from} to ${to} of ${total}`;
      }

      searchInput?.addEventListener('input', () => { state.q = searchInput.value.trim(); state.page = 1; render(); });
      pageSizeSel?.addEventListener('change', () => { state.pageSize = parseInt(pageSizeSel.value,10) || 10; state.page = 1; render(); });
      prevBtn?.addEventListener('click', () => { if (state.page > 1) { state.page--; render(); } });
      nextBtn?.addEventListener('click', () => { state.page++; render(); });

      // Uppercase currency codes
      $$('#countriesTable input[name="currency_code"]').forEach(inp => {
        inp.addEventListener('input', () => { inp.value = inp.value.toUpperCase(); });
      });

      render();
    }

    // Locations table search + pagination
    const locTable = document.getElementById('locationsTable');
    if (locTable) {
      const allLocRows = Array.from(locTable.tBodies[0].rows);
      const searchInput = document.getElementById('locationSearch');
      const pageSizeSel = document.getElementById('locationPageSize');
      const prevBtn = document.getElementById('locationPrev');
      const nextBtn = document.getElementById('locationNext');
      const currPageSpan = document.getElementById('locationCurr');
      const pageInfo = document.getElementById('locationPageInfo');

      const state = { q: '', page: 1, pageSize: parseInt(pageSizeSel?.value || '10', 10) };

      function matches(row, q){
        if (!q) return true;
        const t = row.innerText.toLowerCase();
        return t.includes(q.toLowerCase());
      }

      function render(){
        const filtered = allLocRows.filter(r => matches(r, state.q));
        const total = filtered.length;
        const pages = Math.max(1, Math.ceil(total / state.pageSize));
        if (state.page > pages) state.page = pages;
        const start = (state.page - 1) * state.pageSize;
        const end = start + state.pageSize;
        allLocRows.forEach(r => r.style.display = 'none');
        filtered.slice(start, end).forEach(r => r.style.display = '');
        currPageSpan.textContent = String(state.page);
        prevBtn.parentElement.classList.toggle('disabled', state.page <= 1);
        nextBtn.parentElement.classList.toggle('disabled', state.page >= pages);
        const from = total === 0 ? 0 : start + 1;
        const to = Math.min(total, end);
        pageInfo.textContent = `Showing ${from} to ${to} of ${total}`;
      }

      searchInput?.addEventListener('input', () => { state.q = searchInput.value.trim(); state.page = 1; render(); });
      pageSizeSel?.addEventListener('change', () => { state.pageSize = parseInt(pageSizeSel.value,10) || 10; state.page = 1; render(); });
      prevBtn?.addEventListener('click', () => { if (state.page > 1) { state.page--; render(); } });
      nextBtn?.addEventListener('click', () => { state.page++; render(); });

      render();
    }

    // Transaction password custom modal (no Bootstrap)
    let targetForm = null;
    let txOverlay = null, txModal = null, txDesc = null, txInput = null, txConfirm = null, txCancel = null;

    function ensureTxModal(){
      if (txOverlay) return;
      txOverlay = document.createElement('div');
      txOverlay.id = 'txOverlay';
      txOverlay.style.cssText = 'position:fixed;inset:0;background:rgba(0,0,0,.4);display:none;z-index:20000;';

      txModal = document.createElement('div');
      txModal.id = 'txModal';
      txModal.style.cssText = 'position:fixed;left:50%;top:50%;transform:translate(-50%,-50%);background:#fff;border-radius:8px;box-shadow:0 10px 30px rgba(0,0,0,.2);width:min(92vw,380px);z-index:20001;';

      const hdr = document.createElement('div');
      hdr.style.cssText = 'padding:10px 12px;border-bottom:1px solid #eee;font-weight:600;display:flex;justify-content:space-between;align-items:center;';
      hdr.textContent = 'Enter Transaction Password';
      hdr.textContent = 'Enter Update Password';
      const closeBtn = document.createElement('button');
      closeBtn.type = 'button';
      closeBtn.textContent = '×';
      closeBtn.style.cssText = 'border:0;background:transparent;font-size:20px;line-height:1;cursor:pointer;';
      hdr.appendChild(closeBtn);

      const body = document.createElement('div');
      body.style.cssText = 'padding:12px 12px 0 12px;';
      txDesc = document.createElement('p');
      txDesc.className = 'small';
      txDesc.style.margin = '0 0 8px 0';
      txDesc.textContent = 'This action requires your update password.';
      txInput = document.createElement('input');
      txInput.type = 'password';
      txInput.placeholder = 'Update Password';
      txInput.autocomplete = 'current-password';
      txInput.style.cssText = 'width:100%;padding:8px;border:1px solid #ced4da;border-radius:6px;';
      body.appendChild(txDesc);
      body.appendChild(txInput);

      const ftr = document.createElement('div');
      ftr.style.cssText = 'padding:10px 12px;display:flex;justify-content:flex-end;gap:8px;border-top:1px solid #eee;margin-top:12px;';
      txCancel = document.createElement('button');
      txCancel.type = 'button';
      txCancel.textContent = 'Cancel';
      txCancel.style.cssText = 'padding:6px 10px;border:1px solid #ced4da;background:#fff;border-radius:6px;cursor:pointer;';
      txConfirm = document.createElement('button');
      txConfirm.type = 'button';
      txConfirm.textContent = 'Confirm';
      txConfirm.style.cssText = 'padding:6px 10px;border:1px solid #0d6efd;background:#0d6efd;color:#fff;border-radius:6px;cursor:pointer;';
      ftr.appendChild(txCancel);
      ftr.appendChild(txConfirm);

      txModal.appendChild(hdr);
      txModal.appendChild(body);
      txModal.appendChild(ftr);
      document.body.appendChild(txOverlay);
      document.body.appendChild(txModal);

      function hide(){ txOverlay.style.display='none'; txModal.style.display='none'; }
      function show(){ txOverlay.style.display='block'; txModal.style.display='block'; setTimeout(()=>txInput.focus(), 50); }
      txOverlay.addEventListener('click', hide);
      closeBtn.addEventListener('click', hide);
      txCancel.addEventListener('click', hide);
      txConfirm.addEventListener('click', (e) => {
        e.stopPropagation();
        if (!targetForm) { console.warn('[tools] no targetForm on confirm'); return; }
        let hidden = targetForm.querySelector('input[name="master_password"]');
        if (!hidden) {
          hidden = document.createElement('input');
          hidden.type = 'hidden';
          hidden.name = 'master_password';
          targetForm.appendChild(hidden);
        }
        const pwd = (txInput.value || '').trim();
        if (!pwd) { txInput.focus(); return; }
        if (hidden) hidden.value = pwd;
        try {
          const fdKeys = Array.from(new FormData(targetForm).keys());
          console.log('[tools] confirm click -> submitting form', { action: targetForm.getAttribute('action'), fields: fdKeys });
        } catch (e) {
          console.log('[tools] formdata inspect failed');
        }
        // Submit in next tick to avoid any focus/blur side-effects
        setTimeout(() => {
          // Always use submit() to avoid requestSubmit() requiring a submit button
          targetForm.submit();
          // hide slightly after to avoid visual flicker
          setTimeout(() => hide(), 50);
        }, 0);
      });
      // Enter key triggers confirm
      txInput.addEventListener('keydown', (ev) => {
        if (ev.key === 'Enter') {
          ev.preventDefault();
          txConfirm.click();
        }
      });
      document.addEventListener('keydown', (e) => { if (e.key === 'Escape') hide(); });

      // expose
      txOverlay.show = show; txOverlay.hide = hide;
    }

    function openPass(actionLabel, form){
      targetForm = form;
      ensureTxModal();
      txInput.value = '';
      txDesc.textContent = `Please enter your update password to ${actionLabel}.`;
      console.log('[tools] openPass for', { actionLabel, formAction: form?.getAttribute('action') });
      try {
        if (txOverlay && typeof txOverlay.show === 'function') {
          txOverlay.show();
        } else {
          throw new Error('txOverlay.show missing');
        }
      } catch (e) {
        console.warn('[tools] custom modal unavailable, using prompt fallback');
        const pwd = window.prompt('Enter Update Password');
        if (!pwd) return;
        let hidden = targetForm.querySelector('input[name="master_password"]');
        if (!hidden) {
          hidden = document.createElement('input');
          hidden.type = 'hidden';
          hidden.name = 'master_password';
          targetForm.appendChild(hidden);
        }
        hidden.value = pwd.trim();
        targetForm.submit();
      }
    }

    document.addEventListener('click', (ev) => {
      const btn = ev.target.closest('.js-ask-pass');
      if (!btn) return;
      try {
        const action = btn.dataset.action || 'proceed';
        console.log('[tools] ask-pass click:', action);
        // skip native confirm; we'll show warning in the password modal description
        if (/delete/i.test(action)) {
          console.log('[tools] delete action -> skipping native confirm, using modal warning');
        }
        let form = null;
        if (btn.dataset.form) form = document.getElementById(btn.dataset.form);
        if (!form) form = btn.closest('form');
        if (!form) {
          console.warn('No form found for action button', btn);
          alert('No form found for this action.');
          return;
        }
        console.log('[tools] calling openPass with form action:', form.getAttribute('action'));
        openPass(action.replace('-', ' '), form);
      } catch (e) {
        console.error('[tools] click handler error:', e);
        alert('Unexpected error. Please refresh and try again.');
      }
    });

    // Removed legacy Bootstrap modal handler (mpSubmit/mpInput/modal)
  })();
</script>
