<?php
// app/Views/admin/taxis_index.php
?>
<div class="container py-3">
  <style>
    .tx-table-wrap { border: 1px solid #e9ecef; border-radius: 8px; overflow-x: auto; overflow-y: visible; background: #fff; }
    .tx-table thead th { position: sticky; top: 0; background: #f8f9fa; z-index: 1; box-shadow: inset 0 -1px 0 #e9ecef; }
    .tx-toolbar { gap: .5rem; flex-wrap: wrap; background:#fff; border:1px solid #e9ecef; border-radius:10px; padding:.5rem .75rem; box-shadow: 0 1px 2px rgba(16,24,40,.04); }
    .tx-action-btn.btn { background: transparent !important; border-color: transparent !important; box-shadow: none !important; padding: .125rem .25rem; border-radius: 6px; display:inline-flex; align-items:center; justify-content:center; color:#111827; }
    .tx-action-btn i { font-size:1.05rem; color:#111827 !important; }
    .tx-action-btn.btn:hover i { color:#0d6efd !important; }
    .badge.bg-success, .badge.bg-secondary { border-radius: 999px; padding:.35em .6em; font-weight:600; letter-spacing:.2px; }
    .badge.bg-secondary { background-color:#E5E7EB !important; color:#374151; }
    .pagination .page-link { color:#334155; border-color:#E5E7EB; }
    .pagination .page-item.active .page-link { background:#2E90FA; border-color:#2E90FA; color:#fff; box-shadow: 0 1px 2px rgba(16,24,40,.12); }
    .pagination .page-item.disabled .page-link { color:#94A3B8; }
    .form-check-input.tx-status-switch { width: 2.5em; height: 1.25em; }
    @media (max-width: 576px){
      .tx-toolbar { row-gap:.5rem; padding:.5rem; }
      .tx-toolbar .input-group { width: 100%; }
      .tx-toolbar .ms-auto { width: 100%; display:flex; flex-wrap: wrap; gap:.5rem; justify-content: space-between; }
      #taxiStatus, #taxiRows { flex:1 1 calc(50% - .5rem); min-width: 140px; }
    }
  </style>
  <h2 class="h5 mb-3"><i class="bi bi-taxi-front me-2"></i>Taxis Management</h2>

  <?php if (!empty($_SESSION['flash'])): ?>
    <div class="alert alert-success py-1 small"><?= htmlspecialchars($_SESSION['flash']); unset($_SESSION['flash']); ?></div>
  <?php endif; ?>
  <?php if (!empty($_SESSION['errors'])): ?>
    <div class="alert alert-danger py-1 small">
      <?php foreach ($_SESSION['errors'] as $e): ?>
        <div><?= htmlspecialchars($e) ?></div>
      <?php endforeach; unset($_SESSION['errors']); ?>
    </div>
  <?php endif; ?>

  <?php if (empty($unlocked)): ?>
    <div class="card mx-auto" style="max-width: 420px;">
      <div class="card-body">
        <h5 class="card-title h6 mb-3">Unlock Taxis</h5>
        <form method="post" action="/admin/taxis/unlock">
          <input type="hidden" name="csrf" value="<?= htmlspecialchars($csrf) ?>">
          <div class="mb-3">
            <label class="form-label">Update Password</label>
            <input type="password" name="master_password" class="form-control form-control-sm" required>
          </div>
          <button class="btn btn-sm btn-primary">Unlock</button>
        </form>
      </div>
    </div>
  <?php else: ?>
    <div class="d-flex justify-content-between align-items-center mb-2">
      <h4 class="mb-0 h6">Taxi List</h4>
      <a class="btn btn-sm btn-primary" href="/admin/taxis/create" title="Add Taxi" data-bs-toggle="tooltip" aria-label="Add Taxi">
        <i class="bi bi-plus-circle"></i>
      </a>
    </div>
    <div class="d-flex tx-toolbar align-items-center mb-2">
      <div class="input-group input-group-sm" style="max-width:320px;">
        <span class="input-group-text"><i class="bi bi-search"></i></span>
        <input type="text" id="taxiSearch" class="form-control" placeholder="Search title, vendor, route, price">
      </div>
      <div class="ms-auto d-flex gap-2 align-items-center">
        <label class="small text-muted">Status:</label>
        <select id="taxiStatus" class="form-select form-select-sm" style="width:130px;">
          <option value="">All</option>
          <option value="Active">Active</option>
          <option value="Inactive">Inactive</option>
        </select>
        <label class="small text-muted">Rows:</label>
        <select id="taxiRows" class="form-select form-select-sm" style="width:80px;">
          <option>10</option>
          <option selected>25</option>
          <option>50</option>
          <option>100</option>
        </select>
        <button id="taxiExportCsv" class="btn btn-outline-secondary btn-sm" title="Export CSV" data-bs-toggle="tooltip" aria-label="Export CSV">
          <i class="bi bi-download"></i>
        </button>
        <button id="taxiExportXls" class="btn btn-outline-secondary btn-sm" title="Export Excel" data-bs-toggle="tooltip" aria-label="Export Excel">
          <i class="bi bi-file-earmark-excel"></i>
        </button>
      </div>
    </div>
    <div class="table-responsive tx-table-wrap">
      <table class="table table-striped table-hover align-middle tx-table mb-0">
        <thead class="table-light">
          <tr>
            <th>#</th>
            <th>Thumbnail</th>
            <th>Title</th>
            <th>Vendor</th>
            <th>Route</th>
            <th>B2B Price</th>
            <th>B2C Price</th>
            <th>Base Price</th>
            <th>Status</th>
            <th>Actions</th>
          </tr>
        </thead>
        <tbody>
        <?php foreach (($rows ?? []) as $r): ?>
          <tr>
            <td class="tx-col-idx"></td>
            <td>
              <?php
                $cover = (string)($r['cover_path'] ?? '');
                if ($cover !== '') {
                  $bn = basename($cover);
                  $thumbRel = '/assets/uploads/thumbs/' . 'th_' . $bn;
                  $thumbAbs = BASE_PATH . '/public' . $thumbRel;
                  $thumbUrl = file_exists($thumbAbs) ? $thumbRel : $cover;
                } else {
                  $thumbUrl = '';
                }
              ?>
              <?php if ($thumbUrl): ?>
                <img src="<?= htmlspecialchars($thumbUrl) ?>" alt="cover" class="img-thumbnail" style="width:56px;height:56px;object-fit:cover;">
              <?php else: ?>
                <span class="text-muted small">—</span>
              <?php endif; ?>
            </td>
            <td><?= htmlspecialchars($r['title'] ?? $r['name']) ?></td>
            <td><?= htmlspecialchars($r['vendor']) ?></td>
            <td><?= htmlspecialchars($r['route']) ?></td>
            <td>
              <?php if (isset($r['b2c_price']) && $r['b2c_price'] !== null && $r['b2c_price'] !== ''): ?>
                <?= number_format((float)$r['b2c_price'], 2) ?>
              <?php else: ?>
                <span class="text-muted">—</span>
              <?php endif; ?>
            </td>
            <td>
              <?php if (isset($r['b2b_price']) && $r['b2b_price'] !== null && $r['b2b_price'] !== ''): ?>
                <?= number_format((float)$r['b2b_price'], 2) ?>
              <?php else: ?>
                <span class="text-muted">—</span>
              <?php endif; ?>
            </td>
            <td><?= number_format((float)$r['base_price'], 2) ?></td>
            <td>
              <?php if ((int)($r['active'] ?? 1) === 1): ?>
                <span class="badge text-bg-success">Active</span>
              <?php else: ?>
                <span class="badge text-bg-secondary">Inactive</span>
              <?php endif; ?>
            </td>
            <td class="text-end">
              <a class="btn btn-outline-secondary btn-sm tx-action-btn" href="/admin/taxis/view?id=<?= (int)$r['id'] ?>" title="View" data-bs-toggle="tooltip" aria-label="View"><i class="bi bi-eye-fill"></i></a>
              <a class="btn btn-outline-secondary btn-sm tx-action-btn" href="/admin/taxis/edit?id=<?= (int)$r['id'] ?>" title="Edit" data-bs-toggle="tooltip" aria-label="Edit"><i class="bi bi-pencil"></i></a>
              <a class="btn btn-outline-secondary btn-sm tx-action-btn" href="/admin/taxi/itineraries/create?taxi_id=<?= (int)$r['id'] ?>" title="Add Itinerary" data-bs-toggle="tooltip" aria-label="Add Itinerary"><i class="bi bi-signpost-split"></i></a>
              <form method="post" action="<?= ((int)($r['active'] ?? 1) === 1) ? '/admin/taxis/disable' : '/admin/taxis/enable' ?>" class="d-inline-flex align-items-center gap-2 toggle-active-form" onsubmit="return confirm(this.querySelector('input[type=checkbox]').checked ? 'Enable this taxi?' : 'Disable this taxi?')">
                <input type="hidden" name="csrf" value="<?= htmlspecialchars($csrf) ?>">
                <input type="hidden" name="id" value="<?= (int)$r['id'] ?>">
                <div class="form-check form-switch m-0">
                  <input class="form-check-input tx-status-switch" type="checkbox"
                         role="switch"
                         data-enable-url="/admin/taxis/enable"
                         data-disable-url="/admin/taxis/disable"
                         onchange="this.form.action = this.checked ? this.dataset.enableUrl : this.dataset.disableUrl; this.form.submit();"
                         <?= ((int)($r['active'] ?? 1) === 1) ? 'checked' : '' ?>
                  >
                </div>
              </form>
              <form method="post" action="/admin/taxis/delete" class="d-inline" onsubmit="return confirm('Delete this taxi?')">
                <input type="hidden" name="csrf" value="<?= htmlspecialchars($csrf) ?>">
                <input type="hidden" name="id" value="<?= (int)$r['id'] ?>">
                <button class="btn btn-outline-danger btn-sm tx-action-btn" title="Delete" data-bs-toggle="tooltip" aria-label="Delete"><i class="bi bi-trash"></i></button>
              </form>
            </td>
          </tr>
        <?php endforeach; ?>
        <?php if (empty($rows)): ?>
          <tr><td colspan="9" class="text-center text-muted py-3">No taxis yet.</td></tr>
        <?php endif; ?>
        </tbody>
      </table>
    </div>
    <div class="d-flex justify-content-between align-items-center mt-2">
      <div class="small text-muted" id="taxiCount"></div>
      <nav>
        <ul class="pagination pagination-sm mb-0" id="taxiPager"></ul>
      </nav>
    </div>
  <?php endif; ?>
</div>

<script>
(function(){
  const table = document.querySelector('.tx-table');
  if (!table) return;
  const tbody = table.querySelector('tbody');
  const rows = Array.from(tbody.querySelectorAll('tr'));
  const search = document.getElementById('taxiSearch');
  const rowsSel = document.getElementById('taxiRows');
  const statusSel = document.getElementById('taxiStatus');
  const pager = document.getElementById('taxiPager');
  const count = document.getElementById('taxiCount');
  const exportBtn = document.getElementById('taxiExportCsv');
  const exportXlsBtn = document.getElementById('taxiExportXls');

  const data = rows.map(tr => ({ tr }));
  let filtered = data.slice();
  let page = 1;
  let perPage = parseInt(rowsSel ? rowsSel.value : '25', 10) || 25;

  function normalize(s){ return (s||'').toString().toLowerCase(); }
  function rowStatus(tr){
    const badge = tr.querySelector('span.badge');
    return badge ? (badge.textContent||'').trim() : '';
  }

  function applyFilter(){
    const q = normalize(search ? search.value : '');
    const wantStatus = (statusSel && statusSel.value) ? statusSel.value : '';
    filtered = data.filter(item => {
      const trTxt = normalize(item.tr.innerText);
      const matchesText = q ? trTxt.includes(q) : true;
      const matchesStatus = wantStatus ? (rowStatus(item.tr) === wantStatus) : true;
      return matchesText && matchesStatus;
    });
    page = 1; render();
  }

  function render(){
    rows.forEach(r => r.style.display = 'none');
    const total = filtered.length;
    const pages = Math.max(1, Math.ceil(total / perPage));
    if (page > pages) page = pages;
    const start = (page - 1) * perPage;
    filtered.slice(start, start + perPage).forEach((item, idx) => {
      if (item.tr) {
        item.tr.style.display = '';
        const cell = item.tr.querySelector('td.tx-col-idx');
        if (cell) cell.textContent = String(start + idx + 1);
      }
    });
    // pager
    if (pager){
      pager.innerHTML = '';
      const prev = document.createElement('li');
      prev.className = 'page-item' + (page<=1?' disabled':'');
      prev.innerHTML = '<a class="page-link" href="#" aria-label="Previous">&laquo;</a>';
      prev.onclick = (e)=>{ e.preventDefault(); if(page>1){ page--; render(); } };
      pager.appendChild(prev);
      const windowSize = 7;
      let startPage = Math.max(1, page - Math.floor(windowSize/2));
      let endPage = Math.min(pages, startPage + windowSize - 1);
      startPage = Math.max(1, endPage - windowSize + 1);
      for (let n = startPage; n <= endPage; n++){
        const li = document.createElement('li');
        li.className = 'page-item' + (n===page?' active':'');
        li.innerHTML = '<a class="page-link" href="#">'+n+'</a>';
        li.onclick = (e)=>{ e.preventDefault(); page=n; render(); };
        pager.appendChild(li);
      }
      const next = document.createElement('li');
      next.className = 'page-item' + (page>=pages?' disabled':'');
      next.innerHTML = '<a class="page-link" href="#" aria-label="Next">&raquo;</a>';
      next.onclick = (e)=>{ e.preventDefault(); if(page<pages){ page++; render(); } };
      pager.appendChild(next);
    }
    if (count) count.textContent = total + ' result' + (total===1?'':'s') + (pages>1? (' • page '+page+'/'+pages):'');
  }

  function exportCsv(){
    const headers = Array.from(table.querySelectorAll('thead th')).map(th => th.textContent.trim());
    const idxActions = headers.findIndex(h => h.toLowerCase() === 'actions');
    const headersOut = headers.filter((_,i)=> i !== idxActions);
    const visibleRows = filtered.map(item => Array.from(item.tr.children).filter((_,i)=> i !== idxActions).map(td => '"' + (td.innerText||'').replaceAll('"','""') + '"'));
    const csv = [headersOut.join(','), ...visibleRows.map(cols => cols.join(','))].join('\n');
    const blob = new Blob([csv], {type: 'text/csv;charset=utf-8;'});
    const url = URL.createObjectURL(blob);
    const a = document.createElement('a'); a.href = url; a.download = 'taxis.csv'; a.click(); URL.revokeObjectURL(url);
  }

  function exportXls(){
    const headersAll = Array.from(table.querySelectorAll('thead th')).map(th => th.textContent.trim());
    const idxActions = headersAll.findIndex(h => h.toLowerCase() === 'actions');
    const headersOut = headersAll.filter((_,i)=> i !== idxActions);
    const rowsHtml = filtered.map(item => {
      const tds = Array.from(item.tr.children).map(td => (td.innerText||'').trim());
      const cols = tds.filter((_,i)=> i !== idxActions).map(txt => `<td>${escapeHtml(txt)}</td>`).join('');
      return `<tr>${cols}</tr>`;
    }).join('');
    const thead = `<thead><tr>${headersOut.map(h=>`<th>${escapeHtml(h)}</th>`).join('')}</tr></thead>`;
    const tbody = `<tbody>${rowsHtml}</tbody>`;
    const html = `<!DOCTYPE html><html><head><meta charset="utf-8"><meta http-equiv="X-UA-Compatible" content="IE=edge"><title>Taxis</title></head><body><table border="1">${thead}${tbody}</table></body></html>`;
    const blob = new Blob([html], { type: 'application/vnd.ms-excel' });
    const url = URL.createObjectURL(blob);
    const a = document.createElement('a'); a.href = url; a.download = 'taxis.xls'; a.click(); URL.revokeObjectURL(url);
  }

  function escapeHtml(s){
    return (s||'').replace(/&/g,'&amp;').replace(/</g,'&lt;/').replace(/>/g,'&gt;').replace(/\"/g,'&quot;').replace(/'/g,'&#39;');
  }

  // events
  if (search) search.addEventListener('input', function(){ clearTimeout(window.__txT); window.__txT=setTimeout(applyFilter,150); });
  if (statusSel) statusSel.addEventListener('change', applyFilter);
  if (rowsSel) rowsSel.addEventListener('change', function(){ perPage = parseInt(this.value,10)||25; render(); });
  if (exportBtn) exportBtn.addEventListener('click', function(e){ e.preventDefault(); exportCsv(); });
  if (exportXlsBtn) exportXlsBtn.addEventListener('click', function(e){ e.preventDefault(); exportXls(); });

  // Require master password for delete
  document.querySelectorAll('form[action="/admin/taxis/delete"]').forEach(function(f){
    f.addEventListener('submit', function(e){
      // let the native confirm run first (already on form attribute); if user cancels, the event is already prevented
      // We still ensure master password is provided
      const mp = window.prompt('Enter Master Password to delete taxi:');
      if (!mp) { e.preventDefault(); return false; }
      // attach hidden field
      let hid = f.querySelector('input[name="master_password"]');
      if (!hid) { hid = document.createElement('input'); hid.type = 'hidden'; hid.name = 'master_password'; f.appendChild(hid); }
      hid.value = mp;
    }, { capture: true });
  });

  // initial
  applyFilter();

  // Init tooltips
  if (window.bootstrap) {
    var tts = [].slice.call(document.querySelectorAll('[data-bs-toggle="tooltip"]'));
    tts.forEach(function(el){ try { new bootstrap.Tooltip(el); } catch(e){} });
  }
})();
</script>
