<?php
// app/Views/admin/taxi_itineraries_index.php
$unlocked = !empty($unlocked);
?>
<div class="container py-3">
  <h2 class="h5 mb-3 d-flex align-items-center">
    <i class="bi bi-signpost-split me-2"></i>
    Taxi Itineraries
  </h2>

  <?php if (!empty($_SESSION['flash'])): ?>
    <div class="alert alert-success py-2 small mb-2"><?= htmlspecialchars($_SESSION['flash']); unset($_SESSION['flash']); ?></div>
  <?php endif; ?>
  <?php if (!empty($_SESSION['errors'])): ?>
    <div class="alert alert-danger py-2 small mb-2">
      <?php foreach ($_SESSION['errors'] as $e): ?><div><?= htmlspecialchars($e) ?></div><?php endforeach; unset($_SESSION['errors']); ?>
    </div>
  <?php endif; ?>

  <?php if (!$unlocked): ?>
    <div class="card mx-auto" style="max-width: 540px;">
      <div class="card-body">
        <h5 class="card-title h6 mb-3">Unlock Taxi Itineraries</h5>
        <form method="post" action="/admin/taxi/itineraries/unlock">
          <input type="hidden" name="csrf" value="<?= htmlspecialchars($csrf) ?>">
          <div class="mb-3">
            <label class="form-label">Update Password</label>
            <input type="password" name="master_password" class="form-control form-control-sm" required>
          </div>
          <button class="btn btn-sm btn-primary">Unlock</button>
        </form>
      </div>
    </div>
  <?php else: ?>
    <div class="d-flex justify-content-between mb-2">
      <div></div>
      <a href="/admin/taxi/itineraries/create" class="btn btn-sm btn-primary"><i class="bi bi-plus"></i> Add Itinerary</a>
    </div>
    <div class="table-responsive">
      <table class="table table-sm table-striped align-middle">
        <thead class="table-light">
          <tr>
            <th style="width:70px">ID</th>
            <th>Name</th>
            <th>Taxi</th>
            <th style="width:100px">Active</th>
            <th style="width:180px"></th>
          </tr>
        </thead>
        <tbody>
          <?php if (!empty($rows)): foreach ($rows as $r): ?>
            <tr>
              <td><?= (int)($r['id'] ?? 0) ?></td>
              <td><?= htmlspecialchars((string)($r['name'] ?? '')) ?></td>
              <td><?= htmlspecialchars((string)($r['taxi'] ?? '')) ?></td>
              <td><?= ((int)($r['active'] ?? 0) === 1 ? '<span class="badge bg-success">Yes</span>' : '<span class="badge bg-secondary">No</span>') ?></td>
              <td class="text-end">
                <a class="btn btn-sm btn-outline-secondary" href="/admin/taxi/itineraries/edit?id=<?= (int)($r['id'] ?? 0) ?>">Edit</a>
                <form method="post" action="/admin/taxi/itineraries/delete" class="d-inline" onsubmit="return confirm('Delete this itinerary?');">
                  <input type="hidden" name="csrf" value="<?= htmlspecialchars($csrf) ?>">
                  <input type="hidden" name="id" value="<?= (int)($r['id'] ?? 0) ?>">
                  <button class="btn btn-sm btn-outline-danger">Delete</button>
                </form>
              </td>
            </tr>
          <?php endforeach; else: ?>
            <tr><td colspan="5" class="text-center text-muted small">No itineraries yet.</td></tr>
          <?php endif; ?>
        </tbody>
      </table>
    </div>
  <?php endif; ?>
</div>
