<?php
// app/Views/admin/taxi_bookings_index.php
?>
<div class="container py-3">
  <style>
    .tx-table-wrap { border: 1px solid #e9ecef; border-radius: 8px; overflow-x: auto; overflow-y: visible; background: #fff; }
    .tx-table thead th { position: sticky; top: 0; background: #f8f9fa; z-index: 1; box-shadow: inset 0 -1px 0 #e9ecef; }
    .tx-toolbar { gap: .5rem; flex-wrap: wrap; background:#fff; border:1px solid #e9ecef; border-radius:10px; padding:.5rem .75rem; box-shadow: 0 1px 2px rgba(16,24,40,.04); }
    .tx-action-btn.btn { background: transparent !important; border-color: transparent !important; box-shadow: none !important; padding: .125rem .25rem; border-radius: 6px; display:inline-flex; align-items:center; justify-content:center; color:#111827; }
    .tx-action-btn i { font-size:1.05rem; color:#111827 !important; }
    .tx-action-btn.btn:hover i { color:#0d6efd !important; }
    .badge { border-radius: 999px; padding:.35em .6em; font-weight:500; letter-spacing:.2px; }
    .badge.bg-success { background-color: #10B981 !important; }
    .badge.bg-warning { background-color: #F59E0B !important; }
    .badge.bg-danger { background-color: #EF4444 !important; }
    .badge.bg-secondary { background-color:#E5E7EB !important; color:#374151; }
    .pagination .page-link { color:#334155; border-color:#E5E7EB; }
    .pagination .page-item.active .page-link { background:#2E90FA; border-color:#2E90FA; color:#fff; box-shadow: 0 1px 2px rgba(16,24,40,.12); }
    .pagination .page-item.disabled .page-link { color:#94A3B8; }
    /* Status-based row highlighting */
    /* Completed */
    .tx-table tbody tr.completed {
      background-color: #f0fdf4 !important;
      border-left: 4px solid #10B981 !important;
    }
    .tx-table tbody tr.completed:hover {
      background-color: #dcfce7 !important;
    }
    .tx-table tbody tr.completed td {
      border-color: #e2f3e9 !important;
    }
    
    /* Confirmed */
    .tx-table tbody tr.confirmed {
      background-color: #eff6ff !important;
      border-left: 4px solid #3b82f6 !important;
    }
    .tx-table tbody tr.confirmed:hover {
      background-color: #dbeafe !important;
    }
    
    /* Pending - More prominent yellow */
    .tx-table tbody tr.pending {
      background-color: #fffbeb !important;
      border-left: 4px solid #f59e0b !important;
      animation: pulseYellow 2s infinite;
    }
    .tx-table tbody tr.pending:hover {
      background-color: #fef3c7 !important;
    }
    @keyframes pulseYellow {
      0% { background-color: #fffbeb; }
      50% { background-color: #fef3c7; }
      100% { background-color: #fffbeb; }
    }
    
    /* Cancelled/Refunded */
    .tx-table tbody tr.cancelled,
    .tx-table tbody tr.refunded {
      background-color: #fef2f2 !important;
      border-left: 4px solid #ef4444 !important;
    }
    .tx-table tbody tr.cancelled:hover,
    .tx-table tbody tr.refunded:hover {
      background-color: #fee2e2 !important;
    }
    @media (max-width: 768px) {
      .tx-toolbar { row-gap:.5rem; padding:.5rem; }
      .tx-toolbar .input-group { width: 100%; }
      .tx-toolbar .ms-auto { width: 100%; display:flex; flex-wrap: wrap; gap:.5rem; justify-content: space-between; }
      #bookingStatus, #bookingRows { flex:1 1 calc(50% - .5rem); min-width: 140px; }
    }
  </style>
  <h2 class="h5 mb-3"><i class="bi bi-journal-text me-2"></i>Taxi Bookings</h2>

  <?php if (!empty($_SESSION['flash'])): ?>
    <div class="alert alert-success py-1 small"><?= htmlspecialchars($_SESSION['flash']); unset($_SESSION['flash']); ?></div>
  <?php endif; ?>
  <?php if (!empty($_SESSION['errors'])): ?>
    <div class="alert alert-danger py-1 small">
      <?php foreach ($_SESSION['errors'] as $e): ?>
        <div><?= htmlspecialchars($e) ?></div>
      <?php endforeach; unset($_SESSION['errors']); ?>
    </div>
  <?php endif; ?>

  <div class="d-flex justify-content-between align-items-center mb-2">
    <h4 class="mb-0 h6">All Bookings</h4>
    <a class="btn btn-sm btn-primary" href="/admin/booking/taxi/create" title="New Booking" data-bs-toggle="tooltip" aria-label="New Booking">
      <i class="bi bi-plus-circle"></i> New Booking
    </a>
  </div>
  
  <div class="d-flex tx-toolbar align-items-center mb-2">
    <div class="input-group input-group-sm" style="max-width:320px;">
      <span class="input-group-text"><i class="bi bi-search"></i></span>
      <input type="text" id="bookingSearch" class="form-control" placeholder="Search booking ID, customer, etc.">
    </div>
    <div class="ms-auto d-flex gap-2 align-items-center">
      <label class="small text-muted">Status:</label>
      <select id="bookingStatus" class="form-select form-select-sm" style="width:150px;">
        <option value="">All Status</option>
        <option value="confirmed">Confirmed</option>
        <option value="pending">Pending</option>
        <option value="cancelled">Cancelled</option>
        <option value="completed">Completed</option>
      </select>
      <label class="small text-muted">Date Range:</label>
      <input type="date" id="bookingDateFrom" class="form-control form-control-sm" style="width:140px;">
      <span class="text-muted small">to</span>
      <input type="date" id="bookingDateTo" class="form-control form-control-sm" style="width:140px;">
      <label class="small text-muted">Rows:</label>
      <select id="bookingRows" class="form-select form-select-sm" style="width:80px;">
        <option value="10">10</option>
        <option value="25" selected>25</option>
        <option value="50">50</option>
        <option value="100">100</option>
      </select>
      <button id="bookingExportCsv" class="btn btn-outline-secondary btn-sm" title="Export CSV" data-bs-toggle="tooltip" aria-label="Export CSV">
        <i class="bi bi-download"></i>
      </button>
      <button id="bookingExportXls" class="btn btn-outline-secondary btn-sm" title="Export Excel" data-bs-toggle="tooltip" aria-label="Export Excel">
        <i class="bi bi-file-earmark-excel"></i>
      </button>
    </div>
  </div>
  
  <div class="table-responsive tx-table-wrap">
    <table class="table table-striped table-hover align-middle tx-table mb-0">
      <thead class="table-light">
        <tr>
          <th>#</th>
          <th>Booking Code</th>
          <th>Booking Date</th>
          <th>Agency</th>
          <th>Taxi / Vendor</th>
          <th>Amount</th>
          <th>Status</th>
          <th>Actions</th>
        </tr>
      </thead>
      <tbody>
      <?php foreach (($rows ?? []) as $r): 
        $statusClass = '';
        $statusText = ucfirst($r['status'] ?? 'pending');
        $rowClass = '';
        
        $status = strtolower($r['status'] ?? '');
        // Check if booking is completed based on completed_at field
        $isCompleted = !empty($r['completed_at']);
        
        // Set row class based on status for background highlighting
        $auditStatus = strtolower($r['audit_status'] ?? '');
        
        // First check if we have an audit status that should override the main status
        if (in_array($auditStatus, ['picked_up', 'in_progress', 'on_the_way'])) {
            $statusClass = 'bg-warning';
            $rowClass = 'pending';
            $statusText = ucfirst(str_replace('_', ' ', $auditStatus));
        } else {
            // Use the main status if no relevant audit status
            switch($status) {
                case 'confirmed':
                    $statusClass = 'bg-primary';
                    $statusText = 'Confirmed';
                    $rowClass = 'confirmed';
                    // Override to completed if completed_at is set
                    if ($isCompleted) {
                        $statusClass = 'bg-success';
                        $rowClass = 'completed';
                        $statusText = 'Completed';
                    }
                    break;
                case 'completed':
                    $statusClass = 'bg-success';
                    $rowClass = 'completed';
                    $statusText = 'Completed';
                    break;
                case 'cancelled': 
                    $statusClass = 'bg-danger';
                    $rowClass = 'cancelled';
                    break;
                case 'refunded': 
                    $statusClass = 'bg-secondary';
                    $rowClass = 'refunded';
                    break;
                case 'pending': 
                default: 
                    $statusClass = 'bg-warning';
                    $rowClass = 'pending';
                    break;
            }
        }
      ?>
        <tr class="<?= $rowClass ?>">
          <td class="tx-col-idx"></td>
          <td>
            <a href="/admin/booking/taxi/view?id=<?= (int)($r['id'] ?? 0) ?>" class="text-decoration-none">
              <div class="fw-semibold text-primary"><?= htmlspecialchars($r['booking_code'] ?? 'N/A') ?></div>
              <small class="text-muted">#<?= (int)($r['id'] ?? 0) ?></small>
            </a>
          </td>
          <td class="text-nowrap">
            <div><?= date('d M Y', strtotime($r['trip_date'] ?? '')) ?></div>
            <small class="text-muted"><?= date('h:i A', strtotime($r['pickup_time'] ?? '')) ?></small>
            <div class="small text-muted">Pax: <?= (int)($r['pax'] ?? 1) ?></div>
          </td>
          <td>
            <?php if (!empty($r['agent_name'])): ?>
              <div class="fw-medium"><?= htmlspecialchars($r['agent_name']) ?></div>
              <small class="text-muted"><?= htmlspecialchars($r['agent_email'] ?? '') ?></small>
            <?php else: ?>
              <span class="text-muted">-</span>
            <?php endif; ?>
          </td>
          <td>
            <div class="fw-medium d-flex align-items-center gap-2">
              <span><?= htmlspecialchars($r['ride_name'] ?? 'N/A') ?></span>
              <?php if (!empty($r['vehicle_type'])): 
                    $vt = strtoupper((string)$r['vehicle_type']);
                    $vtClass = 'bg-secondary';
                    if (stripos($vt,'SEDAN')!==false) $vtClass='bg-primary';
                    elseif (stripos($vt,'SUV')!==false) $vtClass='bg-dark';
                    elseif (stripos($vt,'VAN')!==false) $vtClass='bg-info';
                    elseif (stripos($vt,'MINIVAN')!==false) $vtClass='bg-info';
                    elseif (stripos($vt,'BUS')!==false) $vtClass='bg-warning';
              ?>
                <span class="badge <?= $vtClass ?> text-white" title="Vehicle Type"><?= htmlspecialchars($vt) ?></span>
              <?php endif; ?>
            </div>
            <?php if (!empty($r['vendor_name'])): ?>
              <small class="text-muted"><?= htmlspecialchars($r['vendor_name']) ?></small>
            <?php endif; ?>
          </td>
          <td class="text-nowrap">
            <div class="fw-medium"><?= number_format((float)($r['amount_total'] ?? 0), 2) ?> <?= htmlspecialchars($r['currency'] ?? 'THB') ?></div>
            <small class="text-muted"><?= strtoupper($r['payment_method'] ?? '') ?></small>
            <?php if (isset($r['vendor_cost'])): ?>
              <div class="small text-muted">Vendor: <?= number_format((float)$r['vendor_cost'], 2) ?> <?= htmlspecialchars($r['vendor_currency'] ?? 'THB') ?></div>
            <?php endif; ?>
          </td>
          <td class="text-center">
            <div class="d-flex flex-column gap-1 align-items-center">
              <span class="badge <?= $statusClass ?>" data-bs-toggle="tooltip" title="Status: <?= htmlspecialchars($statusText) ?>">
                <?= $statusText ?>
              </span>
              <?php if (!empty($r['audit_status'])): ?>
                <small class="text-muted" data-bs-toggle="tooltip" title="Last Audit Status">
                  <i class="bi bi-clock-history me-1"></i><?= htmlspecialchars($r['audit_status']) ?>
                </small>
              <?php endif; ?>
            </div>
          </td>
          <td class="text-end">
            <a class="btn btn-outline-secondary btn-sm tx-action-btn" href="/admin/booking/taxi/view?id=<?= (int)($r['id'] ?? 0) ?>" title="View" data-bs-toggle="tooltip" aria-label="View">
              <i class="bi bi-eye-fill"></i>
            </a>
            <a class="btn btn-outline-secondary btn-sm tx-action-btn" href="/admin/booking/taxi/edit?id=<?= (int)($r['id'] ?? 0) ?>" title="Edit" data-bs-toggle="tooltip" aria-label="Edit">
              <i class="bi bi-pencil"></i>
            </a>
            <button class="btn btn-outline-secondary btn-sm tx-action-btn" title="Print" data-bs-toggle="tooltip" aria-label="Print" onclick="printBooking(<?= (int)($r['id'] ?? 0) ?>)">
              <i class="bi bi-printer"></i>
            </button>
            <?php if (strtolower($r['status'] ?? '') !== 'cancelled'): ?>
              <button class="btn btn-outline-danger btn-sm tx-action-btn" title="Cancel" data-bs-toggle="tooltip" aria-label="Cancel" onclick="showCancelModal(<?= (int)($r['id'] ?? 0) ?>)">
                <i class="bi bi-x-circle"></i>
              </button>
            <?php endif; ?>
          </td>
        </tr>
      <?php endforeach; ?>
      <?php if (empty($rows)): ?>
        <tr><td colspan="11" class="text-center text-muted py-3">No bookings found.</td></tr>
      <?php endif; ?>
      </tbody>
    </table>
  </div>
  
  <div class="d-flex justify-content-between align-items-center mt-2">
    <div class="small text-muted" id="bookingCount">
      Showing <?= count($rows ?? []) ?> of <?= $pager['totalItems'] ?? 0 ?> entries
    </div>
    <nav>
      <ul class="pagination pagination-sm mb-0" id="bookingPager">
        <?php if (($pager['currentPage'] ?? 1) > 1): ?>
          <li class="page-item">
            <a class="page-link" href="?page=<?= ($pager['currentPage'] ?? 1) - 1 ?>">
              <i class="bi bi-chevron-left"></i>
            </a>
          </li>
        <?php endif; ?>
        
        <?php 
        $totalPages = $pager['totalPages'] ?? 1;
        $currentPage = $pager['currentPage'] ?? 1;
        $startPage = max(1, $currentPage - 2);
        $endPage = min($totalPages, $currentPage + 2);
        
        if ($startPage > 1): ?>
          <li class="page-item"><a class="page-link" href="?page=1">1</a></li>
          <?php if ($startPage > 2): ?>
            <li class="page-item disabled"><span class="page-link">...</span></li>
          <?php endif; ?>
        <?php endif; ?>
        
        <?php for ($i = $startPage; $i <= $endPage; $i++): ?>
          <li class="page-item <?= $i === $currentPage ? 'active' : '' ?>">
            <a class="page-link" href="?page=<?= $i ?>"><?= $i ?></a>
          </li>
        <?php endfor; ?>
        
        <?php if ($endPage < $totalPages): ?>
          <?php if ($endPage < $totalPages - 1): ?>
            <li class="page-item disabled"><span class="page-link">...</span></li>
          <?php endif; ?>
          <li class="page-item"><a class="page-link" href="?page=<?= $totalPages ?>"><?= $totalPages ?></a></li>
        <?php endif; ?>
        
        <?php if (($pager['currentPage'] ?? 1) < ($pager['totalPages'] ?? 1)): ?>
          <li class="page-item">
            <a class="page-link" href="?page=<?= ($pager['currentPage'] ?? 1) + 1 ?>">
              <i class="bi bi-chevron-right"></i>
            </a>
          </li>
        <?php endif; ?>
      </ul>
    </nav>
  </div>
</div>

<!-- Cancel Booking Modal -->
<div class="modal fade" id="cancelBookingModal" tabindex="-1" aria-labelledby="cancelBookingModalLabel" aria-hidden="true">
  <div class="modal-dialog">
    <div class="modal-content">
      <div class="modal-header">
        <h5 class="modal-title" id="cancelBookingModalLabel">Cancel Booking</h5>
        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
      </div>
      <form action="/admin/booking/taxi/cancel" method="post">
        <div class="modal-body">
          <input type="hidden" name="csrf" value="<?= htmlspecialchars($csrf) ?>">
          <input type="hidden" name="id" id="cancelBookingId">
          
          <div class="mb-3">
            <label for="cancelReason" class="form-label">Reason for Cancellation</label>
            <select class="form-select" id="cancelReason" name="reason" required>
              <option value="">Select a reason</option>
              <option value="customer_request">Customer Request</option>
              <option value="no_show">No Show</option>
              <option value="taxi_unavailable">Taxi Unavailable</option>
              <option value="weather">Weather Conditions</option>
              <option value="other">Other Reason</option>
            </select>
          </div>
          
          <div class="mb-3" id="otherReasonContainer" style="display: none;">
            <label for="otherReason" class="form-label">Please specify</label>
            <textarea class="form-control" id="otherReason" name="other_reason" rows="3"></textarea>
          </div>
          
          <div class="mb-3">
            <label for="refundAmount" class="form-label">Refund Amount (if any)</label>
            <div class="input-group">
              <input type="number" class="form-control" id="refundAmount" name="refund_amount" min="0" step="0.01" value="0">
              <span class="input-group-text">THB</span>
            </div>
          </div>
          
          <div class="form-check">
            <input class="form-check-input" type="checkbox" name="notify_customer" id="notifyCustomer" checked>
            <label class="form-check-label" for="notifyCustomer">
              Notify customer via email/SMS
            </label>
          </div>
        </div>
        <div class="modal-footer">
          <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Close</button>
          <button type="submit" class="btn btn-danger">Confirm Cancellation</button>
        </div>
      </form>
    </div>
  </div>
</div>

<script>
// Initialize tooltips
document.addEventListener('DOMContentLoaded', function() {
  // Initialize Bootstrap tooltips
  var tooltipTriggerList = [].slice.call(document.querySelectorAll('[data-bs-toggle="tooltip"]'));
  tooltipTriggerList.map(function (tooltipTriggerEl) {
    return new bootstrap.Tooltip(tooltipTriggerEl);
  });
  
  // Show/hide other reason field
  const cancelReason = document.getElementById('cancelReason');
  const otherReasonContainer = document.getElementById('otherReasonContainer');
  if (cancelReason && otherReasonContainer) {
    cancelReason.addEventListener('change', function() {
      otherReasonContainer.style.display = this.value === 'other' ? 'block' : 'none';
      if (this.value !== 'other') {
        document.getElementById('otherReason').value = '';
      }
    });
  }
  
  // Row number counter
  const rowCounters = document.querySelectorAll('.tx-col-idx');
  rowCounters.forEach((el, idx) => {
    el.textContent = idx + 1 + ((<?= (($pager['currentPage'] ?? 1) - 1) * ($pager['perPage'] ?? 25) ?>));
  });
  
  // Update count text
  const totalItems = <?= $pager['totalItems'] ?? 0 ?>;
  const currentPage = <?= $pager['currentPage'] ?? 1 ?>;
  const perPage = <?= $pager['perPage'] ?? 25 ?>;
  const startItem = ((currentPage - 1) * perPage) + 1;
  const endItem = Math.min(currentPage * perPage, totalItems);
  
  const countEl = document.getElementById('bookingCount');
  if (countEl) {
    countEl.textContent = `Showing ${startItem} to ${endItem} of ${totalItems.toLocaleString()} entries`;
  }
});

// Show cancel booking modal
function showCancelModal(bookingId) {
  const modal = new bootstrap.Modal(document.getElementById('cancelBookingModal'));
  document.getElementById('cancelBookingId').value = bookingId;
  modal.show();
}

// Print booking
function printBooking(bookingId) {
  window.open(`/admin/booking/taxi/print/${bookingId}`, '_blank');
}

// Table filtering and search functionality
(function() {
  const table = document.querySelector('.tx-table');
  if (!table) return;
  
  const tbody = table.querySelector('tbody');
  const rows = Array.from(tbody.querySelectorAll('tr'));
  const search = document.getElementById('bookingSearch');
  const statusFilter = document.getElementById('bookingStatus');
  const dateFrom = document.getElementById('bookingDateFrom');
  const dateTo = document.getElementById('bookingDateTo');
  const rowsSel = document.getElementById('bookingRows');
  const countEl = document.getElementById('bookingCount');
  
  // Set default date range (last 30 days to today)
  const today = new Date();
  const thirtyDaysAgo = new Date();
  thirtyDaysAgo.setDate(today.getDate() - 30);
  
  dateFrom.valueAsDate = thirtyDaysAgo;
  dateTo.valueAsDate = today;
  
  function filterRows() {
    const searchTerm = (search.value || '').toLowerCase();
    const status = (statusFilter.value || '').toLowerCase();
    const fromDate = dateFrom.value ? new Date(dateFrom.value) : null;
    const toDate = dateTo.value ? new Date(dateTo.value) : null;
    
    if (fromDate) fromDate.setHours(0, 0, 0, 0);
    if (toDate) toDate.setHours(23, 59, 59, 999);
    
    let visibleCount = 0;
    
    rows.forEach(row => {
      const cells = row.querySelectorAll('td');
      if (cells.length < 10) return; // Skip if not a data row
      
      const bookingId = (cells[1]?.textContent || '').toLowerCase();
      const customer = (cells[2]?.textContent || '').toLowerCase();
      const taxi = (cells[3]?.textContent || '').toLowerCase();
      const pickup = (cells[4]?.textContent || '').toLowerCase();
      const dropoff = (cells[5]?.textContent || '').toLowerCase();
      const dateTime = cells[6]?.textContent || '';
      const statusCell = cells[9]?.textContent || '';
      
      // Check search term
      const matchesSearch = !searchTerm || 
        bookingId.includes(searchTerm) || 
        customer.includes(searchTerm) || 
        taxi.includes(searchTerm) ||
        pickup.includes(searchTerm) ||
        dropoff.includes(searchTerm);
      
      // Check status filter
      const matchesStatus = !status || statusCell.toLowerCase().includes(status);
      
      // Check date range
      let matchesDate = true;
      if (fromDate || toDate) {
        const rowDate = new Date(dateTime);
        if (fromDate && rowDate < fromDate) matchesDate = false;
        if (toDate && rowDate > toDate) matchesDate = false;
      }
      
      // Show/hide row based on filters
      if (matchesSearch && matchesStatus && matchesDate) {
        row.style.display = '';
        visibleCount++;
      } else {
        row.style.display = 'none';
      }
    });
    
    // Update count text
    if (countEl) {
      countEl.textContent = `Showing ${visibleCount} of ${rows.length} filtered entries`;
    }
  }
  
  // Event listeners
  if (search) search.addEventListener('input', filterRows);
  if (statusFilter) statusFilter.addEventListener('change', filterRows);
  if (dateFrom) dateFrom.addEventListener('change', filterRows);
  if (dateTo) dateTo.addEventListener('change', filterRows);
  if (rowsSel) {
    rowsSel.addEventListener('change', function() {
      const url = new URL(window.location.href);
      url.searchParams.set('per_page', this.value);
      url.searchParams.set('page', 1);
      window.location.href = url.toString();
    });
  }
  
  // Initial filter
  filterRows();
})();
</script>
