<?php
// app/Views/admin/support_index.php
$title = $title ?? 'Support Tickets';
$tickets = $tickets ?? [];
$csrf = $csrf ?? '';
?>

<div class="container-fluid my-4">
  <div class="card card-elevated mb-4">
    <div class="card-body d-flex align-items-start justify-content-between">
      <div>
        <h1 class="h4 mb-1">Support Tickets</h1>
        <div class="text-muted small">Monitor, triage, and resolve agent tickets</div>
        <div class="text-muted small mt-1">Timezone: <?= htmlspecialchars(date_default_timezone_get()) ?></div>
      </div>
      <form method="get" class="d-flex align-items-center gap-2">
        <select name="status" class="form-select form-select-sm">
          <option value="">All</option>
          <option value="open" <?= (($_GET['status'] ?? '')==='open')?'selected':''; ?>>Open</option>
          <option value="in_progress" <?= (($_GET['status'] ?? '')==='in_progress')?'selected':''; ?>>In Progress</option>
          <option value="resolved" <?= (($_GET['status'] ?? '')==='resolved')?'selected':''; ?>>Resolved</option>
          <option value="closed" <?= (($_GET['status'] ?? '')==='closed')?'selected':''; ?>>Closed</option>
        </select>
        <button class="btn btn-primary btn-sm">Filter</button>
      </form>
    </div>
  </div>

  <div class="card">
    <div class="table-responsive">
    <table class="table table-hover align-middle mb-0">
      <thead class="table-light">
        <tr>
          <th class="text-uppercase small fw-semibold">ID</th>
          <th class="text-uppercase small fw-semibold">Subject</th>
          <th class="text-uppercase small fw-semibold">Agent</th>
          <th class="text-uppercase small fw-semibold">Category</th>
          <th class="text-uppercase small fw-semibold">Priority</th>
          <th class="text-uppercase small fw-semibold">Status</th>
          <th class="text-uppercase small fw-semibold">Created</th>
          <th class="text-uppercase small fw-semibold">Updated</th>
          <th class="text-uppercase small fw-semibold">Last Reply</th>
          <th class="text-end text-uppercase small fw-semibold">Actions</th>
        </tr>
      </thead>
      <tbody>
        <?php if (empty($tickets)): ?>
          <tr><td colspan="10" class="text-center text-muted py-5">No tickets found.</td></tr>
        <?php else: foreach ($tickets as $t):
          $status = strtolower((string)($t['status'] ?? 'open'));
          $badge = [
            'open' => 'badge bg-primary',
            'in_progress' => 'badge bg-warning text-dark',
            'resolved' => 'badge bg-success',
            'closed' => 'badge bg-secondary',
          ][$status] ?? 'badge bg-secondary';
          $created = $t['created_at'] ?? '';
          $updated = $t['updated_at'] ?? '';
          $lastRep = $t['last_replied_at'] ?? '';
          $fmt = function($ts){ if(!$ts) return '—'; $tm = strtotime((string)$ts); return $tm? date('d M Y, H:i', $tm): htmlspecialchars((string)$ts); };
        ?>
          <tr>
            <td class="fw-semibold">#<?= (int)$t['id'] ?></td>
            <td><?= htmlspecialchars((string)$t['subject']) ?></td>
            <td class="text-muted small"><?= htmlspecialchars((string)($t['user_email'] ?? 'Agent #'.$t['user_id'])) ?></td>
            <td class="text-capitalize text-muted small"><?= htmlspecialchars((string)$t['category']) ?></td>
            <td class="text-capitalize"><span class="badge bg-info text-dark text-uppercase small"><?= htmlspecialchars((string)$t['priority']) ?></span></td>
            <td><span class="<?= $badge ?> text-uppercase small"><?= htmlspecialchars($status) ?></span></td>
            <td class="text-muted small"><?= $fmt($created) ?></td>
            <td class="text-muted small"><?= $fmt($updated) ?></td>
            <td class="text-muted small"><?= $fmt($lastRep) ?></td>
            <td class="text-end">
              <a class="btn btn-sm btn-primary" href="/admin/support/view?id=<?= (int)$t['id'] ?>">View</a>
              <form method="post" action="/admin/support/status" class="d-inline-flex align-items-center gap-2 ms-2">
                <input type="hidden" name="csrf_token" value="<?= htmlspecialchars($csrf) ?>">
                <input type="hidden" name="ticket_id" value="<?= (int)$t['id'] ?>">
                <select name="status" class="form-select form-select-sm">
                  <option value="open" <?= $status==='open'?'selected':''; ?>>Open</option>
                  <option value="in_progress" <?= $status==='in_progress'?'selected':''; ?>>In Progress</option>
                  <option value="resolved" <?= $status==='resolved'?'selected':''; ?>>Resolved</option>
                  <option value="closed" <?= $status==='closed'?'selected':''; ?>>Closed</option>
                </select>
                <button class="btn btn-sm btn-outline-secondary">Update</button>
              </form>
            </td>
          </tr>
        <?php endforeach; endif; ?>
      </tbody>
    </table>
    </div>
  </div>
</div>
