<?php
// app/Views/admin/settings_smtp.php
?>
<div class="container py-3">
  <h2 class="h5 mb-3"><i class="bi bi-envelope me-2"></i>SMTP Settings</h2>

  <?php if (!empty($_SESSION['flash'])): ?>
    <div class="alert alert-success py-2">
      <?= htmlspecialchars($_SESSION['flash']); unset($_SESSION['flash']); ?>
    </div>
  <?php endif; ?>
  <?php if (!empty($_SESSION['errors'])): ?>
    <div class="alert alert-danger py-2">
      <ul class="mb-0 small">
        <?php foreach ($_SESSION['errors'] as $e): ?>
          <li><?= htmlspecialchars($e) ?></li>
        <?php endforeach; unset($_SESSION['errors']); ?>
      </ul>
    </div>
  <?php endif; ?>

  <?php if (empty($unlocked)): ?>
    <div class="d-flex justify-content-center align-items-center" style="min-height:50vh;">
      <div class="card" style="width:min(92vw,420px)">
        <div class="card-header fw-semibold">Enter Update Password</div>
        <form method="post" action="/admin/settings/smtp/unlock">
          <input type="hidden" name="csrf" value="<?= htmlspecialchars($csrf ?? '') ?>">
          <div class="card-body">
            <p class="small text-muted mb-2">This page is protected. Please enter your update password to continue.</p>
            <input type="password" name="master_password" class="form-control" placeholder="Update Password" autocomplete="current-password" required>
          </div>
          <div class="card-footer d-grid">
            <button type="submit" class="btn btn-primary">Unlock</button>
          </div>
        </form>
      </div>
    </div>
  <?php else: ?>

  <div class="card">
    <div class="card-body">
      <form method="post" action="/admin/settings/smtp" autocomplete="off">
        <input type="hidden" name="csrf" value="<?= htmlspecialchars($csrf ?? '') ?>">

        <?php
          // Expect $profiles from controller
          $profiles = $profiles ?? [];
        ?>

        <ul class="nav nav-tabs" id="smtpTabs" role="tablist">
          <?php $first = true; foreach ($profiles as $key => $meta): ?>
            <li class="nav-item" role="presentation">
              <button class="nav-link <?= $first ? 'active' : '' ?>" id="tab-<?= htmlspecialchars($key) ?>" data-bs-toggle="tab" data-bs-target="#pane-<?= htmlspecialchars($key) ?>" type="button" role="tab" aria-controls="pane-<?= htmlspecialchars($key) ?>" aria-selected="<?= $first ? 'true' : 'false' ?>">
                <?= htmlspecialchars($meta['label'] ?? ucfirst($key)) ?>
              </button>
            </li>
          <?php $first = false; endforeach; ?>
          <li class="nav-item" role="presentation">
            <button class="nav-link" id="tab-providers" data-bs-toggle="tab" data-bs-target="#pane-providers" type="button" role="tab" aria-controls="pane-providers" aria-selected="false">
              Providers (API)
            </button>
          </li>
        </ul>

        <div class="tab-content border border-top-0 rounded-bottom p-3" id="smtpTabsContent">
          <?php $first = true; foreach ($profiles as $key => $meta): $p = $meta['prefix']; $v = $meta['values'] ?? []; ?>
          <div class="tab-pane fade <?= $first ? 'show active' : '' ?>" id="pane-<?= htmlspecialchars($key) ?>" role="tabpanel" aria-labelledby="tab-<?= htmlspecialchars($key) ?>">
            <div class="row g-3">
              <div class="col-md-6">
                <label for="<?= $p ?>_HOST" class="form-label">SMTP Host</label>
                <input type="text" class="form-control" id="<?= $p ?>_HOST" name="<?= $p ?>_HOST" value="<?= htmlspecialchars($v['HOST'] ?? '') ?>" placeholder="smtp.example.com">
              </div>
              <div class="col-md-3">
                <label for="<?= $p ?>_PORT" class="form-label">Port</label>
                <input type="number" class="form-control" id="<?= $p ?>_PORT" name="<?= $p ?>_PORT" value="<?= htmlspecialchars($v['PORT'] ?? '587') ?>" min="1" max="65535">
              </div>
              <div class="col-md-3">
                <label for="<?= $p ?>_ENCRYPTION" class="form-label">Encryption</label>
                <?php $enc = strtolower((string)($v['ENCRYPTION'] ?? 'tls')); ?>
                <select id="<?= $p ?>_ENCRYPTION" name="<?= $p ?>_ENCRYPTION" class="form-select">
                  <option value="none" <?= ($enc === 'none' || $enc === '') ? 'selected' : '' ?>>None</option>
                  <option value="tls" <?= $enc === 'tls' ? 'selected' : '' ?>>TLS</option>
                  <option value="ssl" <?= $enc === 'ssl' ? 'selected' : '' ?>>SSL</option>
                </select>
              </div>

              <div class="col-md-6">
                <label for="<?= $p ?>_USERNAME" class="form-label">Username</label>
                <input type="text" class="form-control" id="<?= $p ?>_USERNAME" name="<?= $p ?>_USERNAME" value="<?= htmlspecialchars($v['USERNAME'] ?? '') ?>">
              </div>
              <div class="col-md-6">
                <label for="<?= $p ?>_PASSWORD" class="form-label">Password</label>
                <input type="password" class="form-control" id="<?= $p ?>_PASSWORD" name="<?= $p ?>_PASSWORD" value="" placeholder="Leave blank to keep current">
                <div class="form-text">Leave blank to keep existing password.</div>
              </div>

              <div class="col-md-6">
                <label for="<?= $p ?>_FROM_ADDRESS" class="form-label">From Address</label>
                <input type="email" class="form-control" id="<?= $p ?>_FROM_ADDRESS" name="<?= $p ?>_FROM_ADDRESS" value="<?= htmlspecialchars($v['FROM_ADDRESS'] ?? '') ?>" placeholder="noreply@example.com">
              </div>
              <div class="col-md-6">
                <label for="<?= $p ?>_FROM_NAME" class="form-label">From Name</label>
                <input type="text" class="form-control" id="<?= $p ?>_FROM_NAME" name="<?= $p ?>_FROM_NAME" value="<?= htmlspecialchars($v['FROM_NAME'] ?? '') ?>" placeholder="Your App Name">
              </div>
              <div class="col-12">
                <label for="<?= $p ?>_COPY_TO" class="form-label">BCC Copy To (comma-separated)</label>
                <input type="text" class="form-control" id="<?= $p ?>_COPY_TO" name="<?= $p ?>_COPY_TO" value="<?= htmlspecialchars($v['COPY_TO'] ?? '') ?>" placeholder="admin@example.com, ops@example.com">
                <div class="form-text">We will add these addresses as BCC recipients for this module. Leave blank to disable.</div>
              </div>
            </div>
          </div>
          <?php $first = false; endforeach; ?>

          <div class="tab-pane fade" id="pane-providers" role="tabpanel" aria-labelledby="tab-providers">
            <?php $providers = $providers ?? ['SENDGRID_API_KEY'=>'','SES_REGION'=>'','SES_ACCESS_KEY_ID'=>'','SES_SECRET_ACCESS_KEY'=>'']; $activeProvider = $activeProvider ?? 'smtp'; ?>
            <div class="row g-3">
              <div class="col-12">
                <label class="form-label fw-semibold">Active Provider</label>
                <div class="d-flex align-items-center gap-3">
                  <div class="form-check">
                    <input class="form-check-input" type="radio" name="MAIL_ACTIVE_PROVIDER" id="ap_smtp" value="smtp" <?= $activeProvider==='smtp'?'checked':'' ?>>
                    <label class="form-check-label" for="ap_smtp">SMTP (default)</label>
                  </div>
                  <div class="form-check">
                    <input class="form-check-input" type="radio" name="MAIL_ACTIVE_PROVIDER" id="ap_sendgrid" value="sendgrid" <?= $activeProvider==='sendgrid'?'checked':'' ?>>
                    <label class="form-check-label" for="ap_sendgrid">SendGrid API</label>
                  </div>
                  <div class="form-check">
                    <input class="form-check-input" type="radio" name="MAIL_ACTIVE_PROVIDER" id="ap_ses" value="ses" <?= $activeProvider==='ses'?'checked':'' ?>>
                    <label class="form-check-label" for="ap_ses">Amazon SES API</label>
                  </div>
                  <div class="form-check">
                    <input class="form-check-input" type="radio" name="MAIL_ACTIVE_PROVIDER" id="ap_elastic" value="elasticemail" <?= $activeProvider==='elasticemail'?'checked':'' ?>>
                    <label class="form-check-label" for="ap_elastic">Elastic Email API</label>
                  </div>
                </div>
                <div class="form-text">Only one provider is active at a time. Queue sends will use the selected provider.</div>
              </div>

              <div class="col-12">
                <h6 class="text-uppercase text-muted">SendGrid (API)</h6>
              </div>
              <div class="col-md-8">
                <label class="form-label">SendGrid API Key</label>
                <input type="password" class="form-control" name="SENDGRID_API_KEY" value="<?= htmlspecialchars($providers['SENDGRID_API_KEY'] ?? '') ?>" placeholder="SG.xxxxx...">
              </div>

              <div class="col-12 mt-2">
                <h6 class="text-uppercase text-muted">Amazon SES (API)</h6>
              </div>
              <div class="col-md-4">
                <label class="form-label">Region</label>
                <input type="text" class="form-control" name="SES_REGION" value="<?= htmlspecialchars($providers['SES_REGION'] ?? '') ?>" placeholder="ap-southeast-1">
              </div>
              <div class="col-md-4">
                <label class="form-label">Access Key ID</label>
                <input type="text" class="form-control" name="SES_ACCESS_KEY_ID" value="<?= htmlspecialchars($providers['SES_ACCESS_KEY_ID'] ?? '') ?>">
              </div>
              <div class="col-md-4">
                <label class="form-label">Secret Access Key</label>
                <input type="password" class="form-control" name="SES_SECRET_ACCESS_KEY" value="" placeholder="Leave blank to keep current">
              </div>

              <div class="col-12 mt-3">
                <h6 class="text-uppercase text-muted">Elastic Email (API)</h6>
              </div>
              <div class="col-md-8">
                <label class="form-label">Elastic Email API Key</label>
                <input type="password" class="form-control" name="ELASTICEMAIL_API_KEY" value="<?= htmlspecialchars($providers['ELASTICEMAIL_API_KEY'] ?? '') ?>" placeholder="EE.xxxxx...">
                <div class="form-text">Store your Elastic Email REST API Key here. We will use it when 'Elastic Email API' is selected above.</div>
              </div>

              <div class="col-12">
                <div class="form-text">Note: For SMTP sending you can still configure the SMTP tabs. These API keys are for direct provider SDK usage or the new mail system.</div>
              </div>

              <div class="col-12 d-flex justify-content-end mt-2">
                <button type="button" class="btn btn-outline-primary" data-bs-toggle="modal" data-bs-target="#modalTestProvider">
                  <i class="bi bi-send"></i> Send Test via Active Provider
                </button>
              </div>
              <div class="col-12 d-flex justify-content-end mt-2">
                <button type="button" class="btn btn-outline-secondary" data-bs-toggle="modal" data-bs-target="#modalElasticDirect">
                  <i class="bi bi-gear"></i> Direct Elastic API Test (Raw)
                </button>
              </div>
            </div>
          </div>
        </div>

        <div class="d-flex justify-content-end gap-2 mt-3">
          <button type="submit" class="btn btn-primary">
            <i class="bi bi-save me-1"></i>Save Settings
          </button>
        </div>
      </form>
    </div>
  </div>

  <!-- Test Provider Modal -->
  <div class="modal fade" id="modalTestProvider" tabindex="-1" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered">
      <div class="modal-content">
        <form method="post" action="/admin/settings/smtp/test-api">
          <div class="modal-header">
            <h5 class="modal-title">Send Test via Active Provider</h5>
            <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
          </div>
          <div class="modal-body">
            <input type="hidden" name="csrf" value="<?= htmlspecialchars($csrf ?? '') ?>">
            <div class="mb-3">
              <label class="form-label">Recipient Email</label>
              <input type="email" name="to" class="form-control" placeholder="you@example.com" required>
              <div class="form-text">We will use the currently selected Active Provider.</div>
            </div>
            <div class="mb-3">
              <label class="form-label">From Email (optional)</label>
              <input type="email" name="from_email" class="form-control" placeholder="noreply@example.com">
              <div class="form-text">Leave blank to use Default profile: MAIL_FROM_ADDRESS</div>
            </div>
            <div class="mb-3">
              <label class="form-label">From Name (optional)</label>
              <input type="text" name="from_name" class="form-control" placeholder="B2B Travel">
              <div class="form-text">Leave blank to use Default profile: MAIL_FROM_NAME</div>
            </div>
          </div>
          <div class="modal-footer">
            <button type="button" class="btn btn-light" data-bs-dismiss="modal">Cancel</button>
            <button type="submit" class="btn btn-primary">Send Test</button>
          </div>
        </form>
      </div>
    </div>
  </div>

  <!-- Direct Elastic API Test Modal -->
  <div class="modal fade" id="modalElasticDirect" tabindex="-1" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered">
      <div class="modal-content">
        <form method="post" action="/admin/settings/smtp/test-elastic-direct">
          <div class="modal-header">
            <h5 class="modal-title">Direct Elastic Email API Test</h5>
            <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
          </div>
          <div class="modal-body">
            <input type="hidden" name="csrf" value="<?= htmlspecialchars($csrf ?? '') ?>">
            <div class="mb-3">
              <label class="form-label">Recipient Email</label>
              <input type="email" name="to" class="form-control" placeholder="you@example.com" required>
              <div class="form-text">This will call Elastic Email REST API via cURL and show the raw response below.</div>
            </div>
            <div class="row g-3">
              <div class="col-md-6">
                <label class="form-label">From Email (optional)</label>
                <input type="email" name="from_email" class="form-control" placeholder="noreply@example.com">
              </div>
              <div class="col-md-6">
                <label class="form-label">From Name (optional)</label>
                <input type="text" name="from_name" class="form-control" placeholder="B2B Travel">
              </div>
            </div>
          </div>
          <div class="modal-footer">
            <button type="button" class="btn btn-light" data-bs-dismiss="modal">Cancel</button>
            <button type="submit" class="btn btn-primary">Send Direct Test</button>
          </div>
        </form>
      </div>
    </div>
  </div>

  <?php if (!empty($_SESSION['raw_mail_test'])): ?>
    <div class="card mt-3">
      <div class="card-header fw-semibold">Raw Mail Provider Response</div>
      <div class="card-body">
        <pre class="small mb-0" style="white-space:pre-wrap; word-break:break-word;"><?= htmlspecialchars($_SESSION['raw_mail_test']) ?></pre>
      </div>
    </div>
    <?php unset($_SESSION['raw_mail_test']); ?>
  <?php endif; ?>

  <div class="small text-muted mt-2">
    Note: These settings are stored in the application's .env file.
  </div>

  <?php endif; ?>
</div>
