<?php
// app/Views/admin/settings_kyc.php
?>
<div class="container py-3">
  <h2 class="h5 mb-3"><i class="bi bi-gear me-2"></i>KYC Settings</h2>

  <?php if (!empty($_SESSION['flash'])): ?>
    <div class="alert alert-success py-2">
      <?= htmlspecialchars($_SESSION['flash']); unset($_SESSION['flash']); ?>
    </div>
  <?php endif; ?>

  <?php if (!empty($_SESSION['errors'])): ?>
    <div class="alert alert-danger py-2">
      <ul class="mb-0 small">
        <?php foreach ($_SESSION['errors'] as $e): ?>
          <li><?= htmlspecialchars($e) ?></li>
        <?php endforeach; unset($_SESSION['errors']); ?>
      </ul>
    </div>
  <?php endif; ?>

  <?php if (empty($unlocked)): ?>
    <div class="d-flex justify-content-center align-items-center" style="min-height:50vh;">
      <div class="card" style="width:min(92vw,420px)">
        <div class="card-header fw-semibold">Enter Update Password</div>
        <form method="post" action="/admin/settings/kyc/unlock">
          <input type="hidden" name="csrf" value="<?= htmlspecialchars($csrf ?? '') ?>">
          <div class="card-body">
            <p class="small text-muted mb-2">This page is protected. Please enter your update password to continue.</p>
            <input type="password" name="master_password" class="form-control" placeholder="Update Password" autocomplete="current-password" required>
          </div>
          <div class="card-footer d-grid">
            <button type="submit" class="btn btn-primary">Unlock</button>
          </div>
        </form>
      </div>
    </div>
  <?php else: ?>

  <div class="card">
    <div class="card-body">
      <form method="post" action="/admin/settings/kyc">
        <input type="hidden" name="csrf" value="<?= htmlspecialchars($csrf ?? '') ?>">
        <?php $f = $flags ?? []; $on = fn($k) => (!empty($f[$k]) && $f[$k]==='true'); ?>
        
        <div class="form-check form-switch mb-3">
          <input class="form-check-input" type="checkbox" id="allowManualUploads" name="allow_manual_uploads" value="1" <?= !empty($allowManual) ? 'checked' : '' ?>>
          <label class="form-check-label" for="allowManualUploads">Allow manual file selection</label>
          <div class="form-text">When off, agents must use Take Photo.</div>
        </div>

        <h6 class="mb-2">Per Business Type — Media</h6>
        <div class="row g-3">
          <div class="col-12">
            <div class="border rounded p-2 h-100">
              <div class="fw-semibold mb-2">Per Business Type</div>

              <ul class="nav nav-tabs" id="kycBizTabs" role="tablist">
                <li class="nav-item" role="presentation">
                  <button class="nav-link active" id="tab-freelancer" data-bs-toggle="tab" data-bs-target="#pane-freelancer" type="button" role="tab" aria-controls="pane-freelancer" aria-selected="true">Freelancer</button>
                </li>
                <li class="nav-item" role="presentation">
                  <button class="nav-link" id="tab-sp" data-bs-toggle="tab" data-bs-target="#pane-sp" type="button" role="tab" aria-controls="pane-sp" aria-selected="false">Sole Proprietor</button>
                </li>
                <li class="nav-item" role="presentation">
                  <button class="nav-link" id="tab-llp" data-bs-toggle="tab" data-bs-target="#pane-llp" type="button" role="tab" aria-controls="pane-llp" aria-selected="false">Partnership/LLP</button>
                </li>
                <li class="nav-item" role="presentation">
                  <button class="nav-link" id="tab-co" data-bs-toggle="tab" data-bs-target="#pane-co" type="button" role="tab" aria-controls="pane-co" aria-selected="false">Company</button>
                </li>
              </ul>

              <div class="tab-content p-2 border border-top-0 rounded-bottom" id="kycBizTabsContent">
                <div class="tab-pane fade show active" id="pane-freelancer" role="tabpanel" aria-labelledby="tab-freelancer">
                  <div class="d-flex justify-content-end gap-2 mb-2">
                    <button type="button" class="btn btn-sm btn-outline-success btn-kyc-enable-all"><i class="bi bi-check2-all me-1"></i>Enable All</button>
                    <button type="button" class="btn btn-sm btn-outline-danger btn-kyc-disable-all"><i class="bi bi-x-lg me-1"></i>Disable All</button>
                  </div>
                  <div class="fw-semibold mb-1">KYC Government ID — Override</div>
                  <div class="form-check form-switch mb-2">
                    <input class="form-check-input" type="checkbox" id="BT_FREELANCER_OVERRIDE_GOVID" name="BT_FREELANCER_OVERRIDE_GOVID" value="1" <?= $on('BT_FREELANCER_OVERRIDE_GOVID') ? 'checked' : '' ?>>
                    <label class="form-check-label" for="BT_FREELANCER_OVERRIDE_GOVID">Override Government ID section</label>
                  </div>
                  <div class="row g-3 ms-2 mb-3">
                    <div class="col-6">
                      <div class="fw-semibold small mb-1">General</div>
                      <div class="form-check form-switch">
                        <input class="form-check-input" type="checkbox" id="BT_FREELANCER_REQUIRE_ID_TYPE" name="BT_FREELANCER_REQUIRE_ID_TYPE" value="1" <?= $on('BT_FREELANCER_REQUIRE_ID_TYPE') ? 'checked' : '' ?>>
                        <label class="form-check-label" for="BT_FREELANCER_REQUIRE_ID_TYPE">Require ID Type</label>
                      </div>
                      <div class="form-check form-switch">
                        <input class="form-check-input" type="checkbox" id="BT_FREELANCER_REQUIRE_ID_NUMBER" name="BT_FREELANCER_REQUIRE_ID_NUMBER" value="1" <?= $on('BT_FREELANCER_REQUIRE_ID_NUMBER') ? 'checked' : '' ?>>
                        <label class="form-check-label" for="BT_FREELANCER_REQUIRE_ID_NUMBER">Require ID Number</label>
                      </div>
                    </div>
                    <div class="col-6">
                      <div class="fw-semibold small mb-1">Images</div>
                      <div class="form-check form-switch">
                        <input class="form-check-input" type="checkbox" id="BT_FREELANCER_ENABLE_ID_FRONT" name="BT_FREELANCER_ENABLE_ID_FRONT" value="1" <?= $on('BT_FREELANCER_ENABLE_ID_FRONT') ? 'checked' : '' ?>>
                        <label class="form-check-label" for="BT_FREELANCER_ENABLE_ID_FRONT">Enable Front</label>
                      </div>
                      <div class="form-check form-switch">
                        <input class="form-check-input" type="checkbox" id="BT_FREELANCER_REQUIRE_ID_FRONT" name="BT_FREELANCER_REQUIRE_ID_FRONT" value="1" <?= $on('BT_FREELANCER_REQUIRE_ID_FRONT') ? 'checked' : '' ?>>
                        <label class="form-check-label" for="BT_FREELANCER_REQUIRE_ID_FRONT">Require Front</label>
                      </div>
                      <div class="form-check form-switch">
                        <input class="form-check-input" type="checkbox" id="BT_FREELANCER_ENABLE_ID_BACK" name="BT_FREELANCER_ENABLE_ID_BACK" value="1" <?= $on('BT_FREELANCER_ENABLE_ID_BACK') ? 'checked' : '' ?>>
                        <label class="form-check-label" for="BT_FREELANCER_ENABLE_ID_BACK">Enable Back</label>
                      </div>
                      <div class="form-check form-switch mb-2">
                        <input class="form-check-input" type="checkbox" id="BT_FREELANCER_REQUIRE_ID_BACK" name="BT_FREELANCER_REQUIRE_ID_BACK" value="1" <?= $on('BT_FREELANCER_REQUIRE_ID_BACK') ? 'checked' : '' ?>>
                        <label class="form-check-label" for="BT_FREELANCER_REQUIRE_ID_BACK">Require Back</label>
                      </div>
                    </div>
                  </div>

                  <div class="fw-semibold mb-1">Business Registration — Override</div>
                  <div class="form-check form-switch mb-2">
                    <input class="form-check-input" type="checkbox" id="BT_FREELANCER_OVERRIDE_REG" name="BT_FREELANCER_OVERRIDE_REG" value="1" <?= $on('BT_FREELANCER_OVERRIDE_REG') ? 'checked' : '' ?>>
                    <label class="form-check-label" for="BT_FREELANCER_OVERRIDE_REG">Override Registration (IATA/GST)</label>
                  </div>
                  <div class="row g-3 ms-2 mb-3">
                    <div class="col-6">
                      <div class="fw-semibold small mb-1">IATA</div>
                      <div class="form-check form-switch">
                        <input class="form-check-input" type="checkbox" id="BT_FREELANCER_IATA_ENABLE" name="BT_FREELANCER_IATA_ENABLE" value="1" <?= $on('BT_FREELANCER_IATA_ENABLE') ? 'checked' : '' ?>>
                        <label class="form-check-label" for="BT_FREELANCER_IATA_ENABLE">Enable</label>
                      </div>
                      <div class="form-check form-switch">
                        <input class="form-check-input" type="checkbox" id="BT_FREELANCER_IATA_REQUIRE_CODE" name="BT_FREELANCER_IATA_REQUIRE_CODE" value="1" <?= $on('BT_FREELANCER_IATA_REQUIRE_CODE') ? 'checked' : '' ?>>
                        <label class="form-check-label" for="BT_FREELANCER_IATA_REQUIRE_CODE">Require Code when Yes</label>
                      </div>
                    </div>
                    <div class="col-6">
                      <div class="fw-semibold small mb-1">GST</div>
                      <div class="form-check form-switch">
                        <input class="form-check-input" type="checkbox" id="BT_FREELANCER_GST_NUMBER_ENABLE" name="BT_FREELANCER_GST_NUMBER_ENABLE" value="1" <?= $on('BT_FREELANCER_GST_NUMBER_ENABLE') ? 'checked' : '' ?>>
                        <label class="form-check-label" for="BT_FREELANCER_GST_NUMBER_ENABLE">Enable GST Number</label>
                      </div>
                      <div class="form-check form-switch">
                        <input class="form-check-input" type="checkbox" id="BT_FREELANCER_GST_NUMBER_REQUIRE" name="BT_FREELANCER_GST_NUMBER_REQUIRE" value="1" <?= $on('BT_FREELANCER_GST_NUMBER_REQUIRE') ? 'checked' : '' ?>>
                        <label class="form-check-label" for="BT_FREELANCER_GST_NUMBER_REQUIRE">Require GST Number</label>
                      </div>
                      <div class="form-check form-switch">
                        <input class="form-check-input" type="checkbox" id="BT_FREELANCER_GST_COMPANY_ENABLE" name="BT_FREELANCER_GST_COMPANY_ENABLE" value="1" <?= $on('BT_FREELANCER_GST_COMPANY_ENABLE') ? 'checked' : '' ?>>
                        <label class="form-check-label" for="BT_FREELANCER_GST_COMPANY_ENABLE">Enable GST Company</label>
                      </div>
                      <div class="form-check form-switch mb-2">
                        <input class="form-check-input" type="checkbox" id="BT_FREELANCER_GST_COMPANY_REQUIRE" name="BT_FREELANCER_GST_COMPANY_REQUIRE" value="1" <?= $on('BT_FREELANCER_GST_COMPANY_REQUIRE') ? 'checked' : '' ?>>
                        <label class="form-check-label" for="BT_FREELANCER_GST_COMPANY_REQUIRE">Require GST Company</label>
                      </div>
                    </div>
                  </div>

                  <div class="fw-semibold mb-1">Business Documents — Override</div>
                  <div class="form-check form-switch mb-2">
                    <input class="form-check-input" type="checkbox" id="BT_FREELANCER_OVERRIDE_DOCS" name="BT_FREELANCER_OVERRIDE_DOCS" value="1" <?= $on('BT_FREELANCER_OVERRIDE_DOCS') ? 'checked' : '' ?>>
                    <label class="form-check-label" for="BT_FREELANCER_OVERRIDE_DOCS">Override Business Documents (Selfie / Address Proof)</label>
                  </div>
                  <div class="row g-3 ms-2 mb-3">
                    <div class="col-6">
                      <div class="fw-semibold small mb-1">Selfie</div>
                      <div class="form-check form-switch">
                        <input class="form-check-input" type="checkbox" id="BT_FREELANCER_SELFIE_ENABLE" name="BT_FREELANCER_SELFIE_ENABLE" value="1" <?= $on('BT_FREELANCER_SELFIE_ENABLE') ? 'checked' : '' ?>>
                        <label class="form-check-label" for="BT_FREELANCER_SELFIE_ENABLE">Enable</label>
                      </div>
                      <div class="form-check form-switch mb-2">
                        <input class="form-check-input" type="checkbox" id="BT_FREELANCER_SELFIE_REQUIRE" name="BT_FREELANCER_SELFIE_REQUIRE" value="1" <?= $on('BT_FREELANCER_SELFIE_REQUIRE') ? 'checked' : '' ?>>
                        <label class="form-check-label" for="BT_FREELANCER_SELFIE_REQUIRE">Required</label>
                      </div>
                    </div>
                    <div class="col-6">
                      <div class="fw-semibold small mb-1">Address Proof</div>
                      <div class="form-check form-switch">
                        <input class="form-check-input" type="checkbox" id="BT_FREELANCER_ADDRESS_PROOF_ENABLE" name="BT_FREELANCER_ADDRESS_PROOF_ENABLE" value="1" <?= $on('BT_FREELANCER_ADDRESS_PROOF_ENABLE') ? 'checked' : '' ?>>
                        <label class="form-check-label" for="BT_FREELANCER_ADDRESS_PROOF_ENABLE">Enable</label>
                      </div>
                      <div class="form-check form-switch mb-2">
                        <input class="form-check-input" type="checkbox" id="BT_FREELANCER_ADDRESS_PROOF_REQUIRE" name="BT_FREELANCER_ADDRESS_PROOF_REQUIRE" value="1" <?= $on('BT_FREELANCER_ADDRESS_PROOF_REQUIRE') ? 'checked' : '' ?>>
                        <label class="form-check-label" for="BT_FREELANCER_ADDRESS_PROOF_REQUIRE">Required</label>
                      </div>
                    </div>
                  </div>

                  <div class="fw-semibold mb-1">Media — Override</div>
                  <div class="form-check form-switch mb-2">
                    <input class="form-check-input" type="checkbox" id="BT_FREELANCER_OVERRIDE_MEDIA" name="BT_FREELANCER_OVERRIDE_MEDIA" value="1" <?= $on('BT_FREELANCER_OVERRIDE_MEDIA') ? 'checked' : '' ?>>
                    <label class="form-check-label" for="BT_FREELANCER_OVERRIDE_MEDIA">Override Profile Photo / Business Card</label>
                  </div>
                  <div class="row g-3 ms-2">
                    <div class="col-6">
                      <div class="fw-semibold small mb-1">Profile Photo</div>
                      <div class="form-check form-switch">
                        <input class="form-check-input" type="checkbox" id="BT_FREELANCER_PROFILE_PHOTO_ENABLE" name="BT_FREELANCER_PROFILE_PHOTO_ENABLE" value="1" <?= $on('BT_FREELANCER_PROFILE_PHOTO_ENABLE') ? 'checked' : '' ?>>
                        <label class="form-check-label" for="BT_FREELANCER_PROFILE_PHOTO_ENABLE">Enable</label>
                      </div>
                      <div class="form-check form-switch mb-2">
                        <input class="form-check-input" type="checkbox" id="BT_FREELANCER_PROFILE_PHOTO_REQUIRE" name="BT_FREELANCER_PROFILE_PHOTO_REQUIRE" value="1" <?= $on('BT_FREELANCER_PROFILE_PHOTO_REQUIRE') ? 'checked' : '' ?>>
                        <label class="form-check-label" for="BT_FREELANCER_PROFILE_PHOTO_REQUIRE">Required</label>
                      </div>
                    </div>
                    <div class="col-6">
                      <div class="fw-semibold small mb-1">Business Card</div>
                      <div class="form-check form-switch">
                        <input class="form-check-input" type="checkbox" id="BT_FREELANCER_BUSINESS_CARD_ENABLE" name="BT_FREELANCER_BUSINESS_CARD_ENABLE" value="1" <?= $on('BT_FREELANCER_BUSINESS_CARD_ENABLE') ? 'checked' : '' ?>>
                        <label class="form-check-label" for="BT_FREELANCER_BUSINESS_CARD_ENABLE">Enable</label>
                      </div>
                      <div class="form-check form-switch mb-2">
                        <input class="form-check-input" type="checkbox" id="BT_FREELANCER_BUSINESS_CARD_REQUIRE" name="BT_FREELANCER_BUSINESS_CARD_REQUIRE" value="1" <?= $on('BT_FREELANCER_BUSINESS_CARD_REQUIRE') ? 'checked' : '' ?>>
                        <label class="form-check-label" for="BT_FREELANCER_BUSINESS_CARD_REQUIRE">Required</label>
                      </div>
                    </div>
                  </div>
                </div>

                <div class="tab-pane fade" id="pane-sp" role="tabpanel" aria-labelledby="tab-sp">
                  <div class="d-flex justify-content-end gap-2 mb-2">
                    <button type="button" class="btn btn-sm btn-outline-success btn-kyc-enable-all"><i class="bi bi-check2-all me-1"></i>Enable All</button>
                    <button type="button" class="btn btn-sm btn-outline-danger btn-kyc-disable-all"><i class="bi bi-x-lg me-1"></i>Disable All</button>
                  </div>
                  <div class="fw-semibold mb-1">KYC Government ID — Override</div>
                  <div class="form-check form-switch mb-2">
                    <input class="form-check-input" type="checkbox" id="BT_SP_OVERRIDE_GOVID" name="BT_SP_OVERRIDE_GOVID" value="1" <?= $on('BT_SP_OVERRIDE_GOVID') ? 'checked' : '' ?>>
                    <label class="form-check-label" for="BT_SP_OVERRIDE_GOVID">Override Government ID section</label>
                  </div>
                  <div class="row g-3 ms-2 mb-3">
                    <div class="col-6">
                      <div class="fw-semibold small mb-1">General</div>
                      <div class="form-check form-switch">
                        <input class="form-check-input" type="checkbox" id="BT_SP_REQUIRE_ID_TYPE" name="BT_SP_REQUIRE_ID_TYPE" value="1" <?= $on('BT_SP_REQUIRE_ID_TYPE') ? 'checked' : '' ?>>
                        <label class="form-check-label" for="BT_SP_REQUIRE_ID_TYPE">Require ID Type</label>
                      </div>
                      <div class="form-check form-switch">
                        <input class="form-check-input" type="checkbox" id="BT_SP_REQUIRE_ID_NUMBER" name="BT_SP_REQUIRE_ID_NUMBER" value="1" <?= $on('BT_SP_REQUIRE_ID_NUMBER') ? 'checked' : '' ?>>
                        <label class="form-check-label" for="BT_SP_REQUIRE_ID_NUMBER">Require ID Number</label>
                      </div>
                    </div>
                    <div class="col-6">
                      <div class="fw-semibold small mb-1">Images</div>
                      <div class="form-check form-switch">
                        <input class="form-check-input" type="checkbox" id="BT_SP_ENABLE_ID_FRONT" name="BT_SP_ENABLE_ID_FRONT" value="1" <?= $on('BT_SP_ENABLE_ID_FRONT') ? 'checked' : '' ?>>
                        <label class="form-check-label" for="BT_SP_ENABLE_ID_FRONT">Enable Front</label>
                      </div>
                      <div class="form-check form-switch">
                        <input class="form-check-input" type="checkbox" id="BT_SP_REQUIRE_ID_FRONT" name="BT_SP_REQUIRE_ID_FRONT" value="1" <?= $on('BT_SP_REQUIRE_ID_FRONT') ? 'checked' : '' ?>>
                        <label class="form-check-label" for="BT_SP_REQUIRE_ID_FRONT">Require Front</label>
                      </div>
                      <div class="form-check form-switch">
                        <input class="form-check-input" type="checkbox" id="BT_SP_ENABLE_ID_BACK" name="BT_SP_ENABLE_ID_BACK" value="1" <?= $on('BT_SP_ENABLE_ID_BACK') ? 'checked' : '' ?>>
                        <label class="form-check-label" for="BT_SP_ENABLE_ID_BACK">Enable Back</label>
                      </div>
                      <div class="form-check form-switch mb-2">
                        <input class="form-check-input" type="checkbox" id="BT_SP_REQUIRE_ID_BACK" name="BT_SP_REQUIRE_ID_BACK" value="1" <?= $on('BT_SP_REQUIRE_ID_BACK') ? 'checked' : '' ?>>
                        <label class="form-check-label" for="BT_SP_REQUIRE_ID_BACK">Require Back</label>
                      </div>
                    </div>
                  </div>

                  <div class="fw-semibold mb-1">Business Registration — Override</div>
                  <div class="form-check form-switch mb-2">
                    <input class="form-check-input" type="checkbox" id="BT_SP_OVERRIDE_REG" name="BT_SP_OVERRIDE_REG" value="1" <?= $on('BT_SP_OVERRIDE_REG') ? 'checked' : '' ?>>
                    <label class="form-check-label" for="BT_SP_OVERRIDE_REG">Override Registration (IATA/GST)</label>
                  </div>
                  <div class="row g-3 ms-2 mb-3">
                    <div class="col-6">
                      <div class="fw-semibold small mb-1">IATA</div>
                      <div class="form-check form-switch">
                        <input class="form-check-input" type="checkbox" id="BT_SP_IATA_ENABLE" name="BT_SP_IATA_ENABLE" value="1" <?= $on('BT_SP_IATA_ENABLE') ? 'checked' : '' ?>>
                        <label class="form-check-label" for="BT_SP_IATA_ENABLE">Enable</label>
                      </div>
                      <div class="form-check form-switch">
                        <input class="form-check-input" type="checkbox" id="BT_SP_IATA_REQUIRE_CODE" name="BT_SP_IATA_REQUIRE_CODE" value="1" <?= $on('BT_SP_IATA_REQUIRE_CODE') ? 'checked' : '' ?>>
                        <label class="form-check-label" for="BT_SP_IATA_REQUIRE_CODE">Require Code when Yes</label>
                      </div>
                    </div>
                    <div class="col-6">
                      <div class="fw-semibold small mb-1">GST</div>
                      <div class="form-check form-switch">
                        <input class="form-check-input" type="checkbox" id="BT_SP_GST_NUMBER_ENABLE" name="BT_SP_GST_NUMBER_ENABLE" value="1" <?= $on('BT_SP_GST_NUMBER_ENABLE') ? 'checked' : '' ?>>
                        <label class="form-check-label" for="BT_SP_GST_NUMBER_ENABLE">Enable GST Number</label>
                      </div>
                      <div class="form-check form-switch">
                        <input class="form-check-input" type="checkbox" id="BT_SP_GST_NUMBER_REQUIRE" name="BT_SP_GST_NUMBER_REQUIRE" value="1" <?= $on('BT_SP_GST_NUMBER_REQUIRE') ? 'checked' : '' ?>>
                        <label class="form-check-label" for="BT_SP_GST_NUMBER_REQUIRE">Require GST Number</label>
                      </div>
                      <div class="form-check form-switch">
                        <input class="form-check-input" type="checkbox" id="BT_SP_GST_COMPANY_ENABLE" name="BT_SP_GST_COMPANY_ENABLE" value="1" <?= $on('BT_SP_GST_COMPANY_ENABLE') ? 'checked' : '' ?>>
                        <label class="form-check-label" for="BT_SP_GST_COMPANY_ENABLE">Enable GST Company</label>
                      </div>
                      <div class="form-check form-switch mb-2">
                        <input class="form-check-input" type="checkbox" id="BT_SP_GST_COMPANY_REQUIRE" name="BT_SP_GST_COMPANY_REQUIRE" value="1" <?= $on('BT_SP_GST_COMPANY_REQUIRE') ? 'checked' : '' ?>>
                        <label class="form-check-label" for="BT_SP_GST_COMPANY_REQUIRE">Require GST Company</label>
                      </div>
                    </div>
                  </div>

                  <div class="fw-semibold mb-1">Business Documents — Override</div>
                  <div class="form-check form-switch mb-2">
                    <input class="form-check-input" type="checkbox" id="BT_SP_OVERRIDE_DOCS" name="BT_SP_OVERRIDE_DOCS" value="1" <?= $on('BT_SP_OVERRIDE_DOCS') ? 'checked' : '' ?>>
                    <label class="form-check-label" for="BT_SP_OVERRIDE_DOCS">Override Business Documents (Selfie / Address Proof)</label>
                  </div>
                  <div class="row g-3 ms-2 mb-3">
                    <div class="col-6">
                      <div class="fw-semibold small mb-1">Selfie</div>
                      <div class="form-check form-switch">
                        <input class="form-check-input" type="checkbox" id="BT_SP_SELFIE_ENABLE" name="BT_SP_SELFIE_ENABLE" value="1" <?= $on('BT_SP_SELFIE_ENABLE') ? 'checked' : '' ?>>
                        <label class="form-check-label" for="BT_SP_SELFIE_ENABLE">Enable</label>
                      </div>
                      <div class="form-check form-switch mb-2">
                        <input class="form-check-input" type="checkbox" id="BT_SP_SELFIE_REQUIRE" name="BT_SP_SELFIE_REQUIRE" value="1" <?= $on('BT_SP_SELFIE_REQUIRE') ? 'checked' : '' ?>>
                        <label class="form-check-label" for="BT_SP_SELFIE_REQUIRE">Required</label>
                      </div>
                    </div>
                    <div class="col-6">
                      <div class="fw-semibold small mb-1">Address Proof</div>
                      <div class="form-check form-switch">
                        <input class="form-check-input" type="checkbox" id="BT_SP_ADDRESS_PROOF_ENABLE" name="BT_SP_ADDRESS_PROOF_ENABLE" value="1" <?= $on('BT_SP_ADDRESS_PROOF_ENABLE') ? 'checked' : '' ?>>
                        <label class="form-check-label" for="BT_SP_ADDRESS_PROOF_ENABLE">Enable</label>
                      </div>
                      <div class="form-check form-switch mb-2">
                        <input class="form-check-input" type="checkbox" id="BT_SP_ADDRESS_PROOF_REQUIRE" name="BT_SP_ADDRESS_PROOF_REQUIRE" value="1" <?= $on('BT_SP_ADDRESS_PROOF_REQUIRE') ? 'checked' : '' ?>>
                        <label class="form-check-label" for="BT_SP_ADDRESS_PROOF_REQUIRE">Required</label>
                      </div>
                    </div>
                  </div>

                  <div class="fw-semibold mb-1">Media — Override</div>
                  <div class="form-check form-switch mb-2">
                    <input class="form-check-input" type="checkbox" id="BT_SP_OVERRIDE_MEDIA" name="BT_SP_OVERRIDE_MEDIA" value="1" <?= $on('BT_SP_OVERRIDE_MEDIA') ? 'checked' : '' ?>>
                    <label class="form-check-label" for="BT_SP_OVERRIDE_MEDIA">Override Profile Photo / Business Card</label>
                  </div>
                  <div class="row g-3 ms-2">
                    <div class="col-6">
                      <div class="fw-semibold small mb-1">Profile Photo</div>
                      <div class="form-check form-switch">
                        <input class="form-check-input" type="checkbox" id="BT_SP_PROFILE_PHOTO_ENABLE" name="BT_SP_PROFILE_PHOTO_ENABLE" value="1" <?= $on('BT_SP_PROFILE_PHOTO_ENABLE') ? 'checked' : '' ?>>
                        <label class="form-check-label" for="BT_SP_PROFILE_PHOTO_ENABLE">Enable</label>
                      </div>
                      <div class="form-check form-switch mb-2">
                        <input class="form-check-input" type="checkbox" id="BT_SP_PROFILE_PHOTO_REQUIRE" name="BT_SP_PROFILE_PHOTO_REQUIRE" value="1" <?= $on('BT_SP_PROFILE_PHOTO_REQUIRE') ? 'checked' : '' ?>>
                        <label class="form-check-label" for="BT_SP_PROFILE_PHOTO_REQUIRE">Required</label>
                      </div>
                    </div>
                    <div class="col-6">
                      <div class="fw-semibold small mb-1">Business Card</div>
                      <div class="form-check form-switch">
                        <input class="form-check-input" type="checkbox" id="BT_SP_BUSINESS_CARD_ENABLE" name="BT_SP_BUSINESS_CARD_ENABLE" value="1" <?= $on('BT_SP_BUSINESS_CARD_ENABLE') ? 'checked' : '' ?>>
                        <label class="form-check-label" for="BT_SP_BUSINESS_CARD_ENABLE">Enable</label>
                      </div>
                      <div class="form-check form-switch mb-2">
                        <input class="form-check-input" type="checkbox" id="BT_SP_BUSINESS_CARD_REQUIRE" name="BT_SP_BUSINESS_CARD_REQUIRE" value="1" <?= $on('BT_SP_BUSINESS_CARD_REQUIRE') ? 'checked' : '' ?>>
                        <label class="form-check-label" for="BT_SP_BUSINESS_CARD_REQUIRE">Required</label>
                      </div>
                    </div>
                  </div>
                </div>

                <div class="tab-pane fade" id="pane-llp" role="tabpanel" aria-labelledby="tab-llp">
                  <div class="d-flex justify-content-end gap-2 mb-2">
                    <button type="button" class="btn btn-sm btn-outline-success btn-kyc-enable-all"><i class="bi bi-check2-all me-1"></i>Enable All</button>
                    <button type="button" class="btn btn-sm btn-outline-danger btn-kyc-disable-all"><i class="bi bi-x-lg me-1"></i>Disable All</button>
                  </div>
                  <div class="fw-semibold mb-1">KYC Government ID — Override</div>
                  <div class="form-check form-switch mb-2">
                    <input class="form-check-input" type="checkbox" id="BT_LLP_OVERRIDE_GOVID" name="BT_LLP_OVERRIDE_GOVID" value="1" <?= $on('BT_LLP_OVERRIDE_GOVID') ? 'checked' : '' ?>>
                    <label class="form-check-label" for="BT_LLP_OVERRIDE_GOVID">Override Government ID section</label>
                  </div>
                  <div class="row g-3 ms-2 mb-3">
                    <div class="col-6">
                      <div class="fw-semibold small mb-1">General</div>
                      <div class="form-check form-switch">
                        <input class="form-check-input" type="checkbox" id="BT_LLP_REQUIRE_ID_TYPE" name="BT_LLP_REQUIRE_ID_TYPE" value="1" <?= $on('BT_LLP_REQUIRE_ID_TYPE') ? 'checked' : '' ?>>
                        <label class="form-check-label" for="BT_LLP_REQUIRE_ID_TYPE">Require ID Type</label>
                      </div>
                      <div class="form-check form-switch">
                        <input class="form-check-input" type="checkbox" id="BT_LLP_REQUIRE_ID_NUMBER" name="BT_LLP_REQUIRE_ID_NUMBER" value="1" <?= $on('BT_LLP_REQUIRE_ID_NUMBER') ? 'checked' : '' ?>>
                        <label class="form-check-label" for="BT_LLP_REQUIRE_ID_NUMBER">Require ID Number</label>
                      </div>
                    </div>
                    <div class="col-6">
                      <div class="fw-semibold small mb-1">Images</div>
                      <div class="form-check form-switch">
                        <input class="form-check-input" type="checkbox" id="BT_LLP_ENABLE_ID_FRONT" name="BT_LLP_ENABLE_ID_FRONT" value="1" <?= $on('BT_LLP_ENABLE_ID_FRONT') ? 'checked' : '' ?>>
                        <label class="form-check-label" for="BT_LLP_ENABLE_ID_FRONT">Enable Front</label>
                      </div>
                      <div class="form-check form-switch">
                        <input class="form-check-input" type="checkbox" id="BT_LLP_REQUIRE_ID_FRONT" name="BT_LLP_REQUIRE_ID_FRONT" value="1" <?= $on('BT_LLP_REQUIRE_ID_FRONT') ? 'checked' : '' ?>>
                        <label class="form-check-label" for="BT_LLP_REQUIRE_ID_FRONT">Require Front</label>
                      </div>
                      <div class="form-check form-switch">
                        <input class="form-check-input" type="checkbox" id="BT_LLP_ENABLE_ID_BACK" name="BT_LLP_ENABLE_ID_BACK" value="1" <?= $on('BT_LLP_ENABLE_ID_BACK') ? 'checked' : '' ?>>
                        <label class="form-check-label" for="BT_LLP_ENABLE_ID_BACK">Enable Back</label>
                      </div>
                      <div class="form-check form-switch mb-2">
                        <input class="form-check-input" type="checkbox" id="BT_LLP_REQUIRE_ID_BACK" name="BT_LLP_REQUIRE_ID_BACK" value="1" <?= $on('BT_LLP_REQUIRE_ID_BACK') ? 'checked' : '' ?>>
                        <label class="form-check-label" for="BT_LLP_REQUIRE_ID_BACK">Require Back</label>
                      </div>
                    </div>
                  </div>

                  <div class="fw-semibold mb-1">Business Registration — Override</div>
                  <div class="form-check form-switch mb-2">
                    <input class="form-check-input" type="checkbox" id="BT_LLP_OVERRIDE_REG" name="BT_LLP_OVERRIDE_REG" value="1" <?= $on('BT_LLP_OVERRIDE_REG') ? 'checked' : '' ?>>
                    <label class="form-check-label" for="BT_LLP_OVERRIDE_REG">Override Registration (IATA/GST)</label>
                  </div>
                  <div class="row g-3 ms-2 mb-3">
                    <div class="col-6">
                      <div class="fw-semibold small mb-1">IATA</div>
                      <div class="form-check form-switch">
                        <input class="form-check-input" type="checkbox" id="BT_LLP_IATA_ENABLE" name="BT_LLP_IATA_ENABLE" value="1" <?= $on('BT_LLP_IATA_ENABLE') ? 'checked' : '' ?>>
                        <label class="form-check-label" for="BT_LLP_IATA_ENABLE">Enable</label>
                      </div>
                      <div class="form-check form-switch">
                        <input class="form-check-input" type="checkbox" id="BT_LLP_IATA_REQUIRE_CODE" name="BT_LLP_IATA_REQUIRE_CODE" value="1" <?= $on('BT_LLP_IATA_REQUIRE_CODE') ? 'checked' : '' ?>>
                        <label class="form-check-label" for="BT_LLP_IATA_REQUIRE_CODE">Require Code when Yes</label>
                      </div>
                    </div>
                    <div class="col-6">
                      <div class="fw-semibold small mb-1">GST</div>
                      <div class="form-check form-switch">
                        <input class="form-check-input" type="checkbox" id="BT_LLP_GST_NUMBER_ENABLE" name="BT_LLP_GST_NUMBER_ENABLE" value="1" <?= $on('BT_LLP_GST_NUMBER_ENABLE') ? 'checked' : '' ?>>
                        <label class="form-check-label" for="BT_LLP_GST_NUMBER_ENABLE">Enable GST Number</label>
                      </div>
                      <div class="form-check form-switch">
                        <input class="form-check-input" type="checkbox" id="BT_LLP_GST_NUMBER_REQUIRE" name="BT_LLP_GST_NUMBER_REQUIRE" value="1" <?= $on('BT_LLP_GST_NUMBER_REQUIRE') ? 'checked' : '' ?>>
                        <label class="form-check-label" for="BT_LLP_GST_NUMBER_REQUIRE">Require GST Number</label>
                      </div>
                      <div class="form-check form-switch">
                        <input class="form-check-input" type="checkbox" id="BT_LLP_GST_COMPANY_ENABLE" name="BT_LLP_GST_COMPANY_ENABLE" value="1" <?= $on('BT_LLP_GST_COMPANY_ENABLE') ? 'checked' : '' ?>>
                        <label class="form-check-label" for="BT_LLP_GST_COMPANY_ENABLE">Enable GST Company</label>
                      </div>
                      <div class="form-check form-switch mb-2">
                        <input class="form-check-input" type="checkbox" id="BT_LLP_GST_COMPANY_REQUIRE" name="BT_LLP_GST_COMPANY_REQUIRE" value="1" <?= $on('BT_LLP_GST_COMPANY_REQUIRE') ? 'checked' : '' ?>>
                        <label class="form-check-label" for="BT_LLP_GST_COMPANY_REQUIRE">Require GST Company</label>
                      </div>
                    </div>
                  </div>

                  <div class="fw-semibold mb-1">Business Documents — Override</div>
                  <div class="form-check form-switch mb-2">
                    <input class="form-check-input" type="checkbox" id="BT_LLP_OVERRIDE_DOCS" name="BT_LLP_OVERRIDE_DOCS" value="1" <?= $on('BT_LLP_OVERRIDE_DOCS') ? 'checked' : '' ?>>
                    <label class="form-check-label" for="BT_LLP_OVERRIDE_DOCS">Override Business Documents (Selfie / Address Proof)</label>
                  </div>
                  <div class="row g-3 ms-2 mb-3">
                    <div class="col-6">
                      <div class="fw-semibold small mb-1">Selfie</div>
                      <div class="form-check form-switch">
                        <input class="form-check-input" type="checkbox" id="BT_LLP_SELFIE_ENABLE" name="BT_LLP_SELFIE_ENABLE" value="1" <?= $on('BT_LLP_SELFIE_ENABLE') ? 'checked' : '' ?>>
                        <label class="form-check-label" for="BT_LLP_SELFIE_ENABLE">Enable</label>
                      </div>
                      <div class="form-check form-switch mb-2">
                        <input class="form-check-input" type="checkbox" id="BT_LLP_SELFIE_REQUIRE" name="BT_LLP_SELFIE_REQUIRE" value="1" <?= $on('BT_LLP_SELFIE_REQUIRE') ? 'checked' : '' ?>>
                        <label class="form-check-label" for="BT_LLP_SELFIE_REQUIRE">Required</label>
                      </div>
                    </div>
                    <div class="col-6">
                      <div class="fw-semibold small mb-1">Address Proof</div>
                      <div class="form-check form-switch">
                        <input class="form-check-input" type="checkbox" id="BT_LLP_ADDRESS_PROOF_ENABLE" name="BT_LLP_ADDRESS_PROOF_ENABLE" value="1" <?= $on('BT_LLP_ADDRESS_PROOF_ENABLE') ? 'checked' : '' ?>>
                        <label class="form-check-label" for="BT_LLP_ADDRESS_PROOF_ENABLE">Enable</label>
                      </div>
                      <div class="form-check form-switch mb-2">
                        <input class="form-check-input" type="checkbox" id="BT_LLP_ADDRESS_PROOF_REQUIRE" name="BT_LLP_ADDRESS_PROOF_REQUIRE" value="1" <?= $on('BT_LLP_ADDRESS_PROOF_REQUIRE') ? 'checked' : '' ?>>
                        <label class="form-check-label" for="BT_LLP_ADDRESS_PROOF_REQUIRE">Required</label>
                      </div>
                    </div>
                  </div>

                  <div class="fw-semibold mb-1">Media — Override</div>
                  <div class="form-check form-switch mb-2">
                    <input class="form-check-input" type="checkbox" id="BT_LLP_OVERRIDE_MEDIA" name="BT_LLP_OVERRIDE_MEDIA" value="1" <?= $on('BT_LLP_OVERRIDE_MEDIA') ? 'checked' : '' ?>>
                    <label class="form-check-label" for="BT_LLP_OVERRIDE_MEDIA">Override Profile Photo / Business Card</label>
                  </div>
                  <div class="row g-3 ms-2">
                    <div class="col-6">
                      <div class="fw-semibold small mb-1">Profile Photo</div>
                      <div class="form-check form-switch">
                        <input class="form-check-input" type="checkbox" id="BT_LLP_PROFILE_PHOTO_ENABLE" name="BT_LLP_PROFILE_PHOTO_ENABLE" value="1" <?= $on('BT_LLP_PROFILE_PHOTO_ENABLE') ? 'checked' : '' ?>>
                        <label class="form-check-label" for="BT_LLP_PROFILE_PHOTO_ENABLE">Enable</label>
                      </div>
                      <div class="form-check form-switch mb-2">
                        <input class="form-check-input" type="checkbox" id="BT_LLP_PROFILE_PHOTO_REQUIRE" name="BT_LLP_PROFILE_PHOTO_REQUIRE" value="1" <?= $on('BT_LLP_PROFILE_PHOTO_REQUIRE') ? 'checked' : '' ?>>
                        <label class="form-check-label" for="BT_LLP_PROFILE_PHOTO_REQUIRE">Required</label>
                      </div>
                    </div>
                    <div class="col-6">
                      <div class="fw-semibold small mb-1">Business Card</div>
                      <div class="form-check form-switch">
                        <input class="form-check-input" type="checkbox" id="BT_LLP_BUSINESS_CARD_ENABLE" name="BT_LLP_BUSINESS_CARD_ENABLE" value="1" <?= $on('BT_LLP_BUSINESS_CARD_ENABLE') ? 'checked' : '' ?>>
                        <label class="form-check-label" for="BT_LLP_BUSINESS_CARD_ENABLE">Enable</label>
                      </div>
                      <div class="form-check form-switch mb-2">
                        <input class="form-check-input" type="checkbox" id="BT_LLP_BUSINESS_CARD_REQUIRE" name="BT_LLP_BUSINESS_CARD_REQUIRE" value="1" <?= $on('BT_LLP_BUSINESS_CARD_REQUIRE') ? 'checked' : '' ?>>
                        <label class="form-check-label" for="BT_LLP_BUSINESS_CARD_REQUIRE">Required</label>
                      </div>
                    </div>
                  </div>
                </div>

                <div class="tab-pane fade" id="pane-co" role="tabpanel" aria-labelledby="tab-co">
                  <div class="d-flex justify-content-end gap-2 mb-2">
                    <button type="button" class="btn btn-sm btn-outline-success btn-kyc-enable-all"><i class="bi bi-check2-all me-1"></i>Enable All</button>
                    <button type="button" class="btn btn-sm btn-outline-danger btn-kyc-disable-all"><i class="bi bi-x-lg me-1"></i>Disable All</button>
                  </div>
                  <div class="fw-semibold mb-1">KYC Government ID — Override</div>
                  <div class="form-check form-switch mb-2">
                    <input class="form-check-input" type="checkbox" id="BT_CO_OVERRIDE_GOVID" name="BT_CO_OVERRIDE_GOVID" value="1" <?= $on('BT_CO_OVERRIDE_GOVID') ? 'checked' : '' ?>>
                    <label class="form-check-label" for="BT_CO_OVERRIDE_GOVID">Override Government ID section</label>
                  </div>
                  <div class="row g-3 ms-2 mb-3">
                    <div class="col-6">
                      <div class="fw-semibold small mb-1">General</div>
                      <div class="form-check form-switch">
                        <input class="form-check-input" type="checkbox" id="BT_CO_REQUIRE_ID_TYPE" name="BT_CO_REQUIRE_ID_TYPE" value="1" <?= $on('BT_CO_REQUIRE_ID_TYPE') ? 'checked' : '' ?>>
                        <label class="form-check-label" for="BT_CO_REQUIRE_ID_TYPE">Require ID Type</label>
                      </div>
                      <div class="form-check form-switch">
                        <input class="form-check-input" type="checkbox" id="BT_CO_REQUIRE_ID_NUMBER" name="BT_CO_REQUIRE_ID_NUMBER" value="1" <?= $on('BT_CO_REQUIRE_ID_NUMBER') ? 'checked' : '' ?>>
                        <label class="form-check-label" for="BT_CO_REQUIRE_ID_NUMBER">Require ID Number</label>
                      </div>
                    </div>
                    <div class="col-6">
                      <div class="fw-semibold small mb-1">Images</div>
                      <div class="form-check form-switch">
                        <input class="form-check-input" type="checkbox" id="BT_CO_ENABLE_ID_FRONT" name="BT_CO_ENABLE_ID_FRONT" value="1" <?= $on('BT_CO_ENABLE_ID_FRONT') ? 'checked' : '' ?>>
                        <label class="form-check-label" for="BT_CO_ENABLE_ID_FRONT">Enable Front</label>
                      </div>
                      <div class="form-check form-switch">
                        <input class="form-check-input" type="checkbox" id="BT_CO_REQUIRE_ID_FRONT" name="BT_CO_REQUIRE_ID_FRONT" value="1" <?= $on('BT_CO_REQUIRE_ID_FRONT') ? 'checked' : '' ?>>
                        <label class="form-check-label" for="BT_CO_REQUIRE_ID_FRONT">Require Front</label>
                      </div>
                      <div class="form-check form-switch">
                        <input class="form-check-input" type="checkbox" id="BT_CO_ENABLE_ID_BACK" name="BT_CO_ENABLE_ID_BACK" value="1" <?= $on('BT_CO_ENABLE_ID_BACK') ? 'checked' : '' ?>>
                        <label class="form-check-label" for="BT_CO_ENABLE_ID_BACK">Enable Back</label>
                      </div>
                      <div class="form-check form-switch mb-2">
                        <input class="form-check-input" type="checkbox" id="BT_CO_REQUIRE_ID_BACK" name="BT_CO_REQUIRE_ID_BACK" value="1" <?= $on('BT_CO_REQUIRE_ID_BACK') ? 'checked' : '' ?>>
                        <label class="form-check-label" for="BT_CO_REQUIRE_ID_BACK">Require Back</label>
                      </div>
                    </div>
                  </div>

                  <div class="fw-semibold mb-1">Business Registration — Override</div>
                  <div class="form-check form-switch mb-2">
                    <input class="form-check-input" type="checkbox" id="BT_CO_OVERRIDE_REG" name="BT_CO_OVERRIDE_REG" value="1" <?= $on('BT_CO_OVERRIDE_REG') ? 'checked' : '' ?>>
                    <label class="form-check-label" for="BT_CO_OVERRIDE_REG">Override Registration (IATA/GST)</label>
                  </div>
                  <div class="row g-3 ms-2 mb-3">
                    <div class="col-6">
                      <div class="fw-semibold small mb-1">IATA</div>
                      <div class="form-check form-switch">
                        <input class="form-check-input" type="checkbox" id="BT_CO_IATA_ENABLE" name="BT_CO_IATA_ENABLE" value="1" <?= $on('BT_CO_IATA_ENABLE') ? 'checked' : '' ?>>
                        <label class="form-check-label" for="BT_CO_IATA_ENABLE">Enable</label>
                      </div>
                      <div class="form-check form-switch">
                        <input class="form-check-input" type="checkbox" id="BT_CO_IATA_REQUIRE_CODE" name="BT_CO_IATA_REQUIRE_CODE" value="1" <?= $on('BT_CO_IATA_REQUIRE_CODE') ? 'checked' : '' ?>>
                        <label class="form-check-label" for="BT_CO_IATA_REQUIRE_CODE">Require Code when Yes</label>
                      </div>
                    </div>
                    <div class="col-6">
                      <div class="fw-semibold small mb-1">GST</div>
                      <div class="form-check form-switch">
                        <input class="form-check-input" type="checkbox" id="BT_CO_GST_NUMBER_ENABLE" name="BT_CO_GST_NUMBER_ENABLE" value="1" <?= $on('BT_CO_GST_NUMBER_ENABLE') ? 'checked' : '' ?>>
                        <label class="form-check-label" for="BT_CO_GST_NUMBER_ENABLE">Enable GST Number</label>
                      </div>
                      <div class="form-check form-switch">
                        <input class="form-check-input" type="checkbox" id="BT_CO_GST_NUMBER_REQUIRE" name="BT_CO_GST_NUMBER_REQUIRE" value="1" <?= $on('BT_CO_GST_NUMBER_REQUIRE') ? 'checked' : '' ?>>
                        <label class="form-check-label" for="BT_CO_GST_NUMBER_REQUIRE">Require GST Number</label>
                      </div>
                      <div class="form-check form-switch">
                        <input class="form-check-input" type="checkbox" id="BT_CO_GST_COMPANY_ENABLE" name="BT_CO_GST_COMPANY_ENABLE" value="1" <?= $on('BT_CO_GST_COMPANY_ENABLE') ? 'checked' : '' ?>>
                        <label class="form-check-label" for="BT_CO_GST_COMPANY_ENABLE">Enable GST Company</label>
                      </div>
                      <div class="form-check form-switch mb-2">
                        <input class="form-check-input" type="checkbox" id="BT_CO_GST_COMPANY_REQUIRE" name="BT_CO_GST_COMPANY_REQUIRE" value="1" <?= $on('BT_CO_GST_COMPANY_REQUIRE') ? 'checked' : '' ?>>
                        <label class="form-check-label" for="BT_CO_GST_COMPANY_REQUIRE">Require GST Company</label>
                      </div>
                    </div>
                  </div>

                  <div class="fw-semibold mb-1">Business Documents — Override</div>
                  <div class="form-check form-switch mb-2">
                    <input class="form-check-input" type="checkbox" id="BT_CO_OVERRIDE_DOCS" name="BT_CO_OVERRIDE_DOCS" value="1" <?= $on('BT_CO_OVERRIDE_DOCS') ? 'checked' : '' ?>>
                    <label class="form-check-label" for="BT_CO_OVERRIDE_DOCS">Override Business Documents (Selfie / Address Proof)</label>
                  </div>
                  <div class="row g-3 ms-2 mb-3">
                    <div class="col-6">
                      <div class="fw-semibold small mb-1">Selfie</div>
                      <div class="form-check form-switch">
                        <input class="form-check-input" type="checkbox" id="BT_CO_SELFIE_ENABLE" name="BT_CO_SELFIE_ENABLE" value="1" <?= $on('BT_CO_SELFIE_ENABLE') ? 'checked' : '' ?>>
                        <label class="form-check-label" for="BT_CO_SELFIE_ENABLE">Enable</label>
                      </div>
                      <div class="form-check form-switch mb-2">
                        <input class="form-check-input" type="checkbox" id="BT_CO_SELFIE_REQUIRE" name="BT_CO_SELFIE_REQUIRE" value="1" <?= $on('BT_CO_SELFIE_REQUIRE') ? 'checked' : '' ?>>
                        <label class="form-check-label" for="BT_CO_SELFIE_REQUIRE">Required</label>
                      </div>
                    </div>
                    <div class="col-6">
                      <div class="fw-semibold small mb-1">Address Proof</div>
                      <div class="form-check form-switch">
                        <input class="form-check-input" type="checkbox" id="BT_CO_ADDRESS_PROOF_ENABLE" name="BT_CO_ADDRESS_PROOF_ENABLE" value="1" <?= $on('BT_CO_ADDRESS_PROOF_ENABLE') ? 'checked' : '' ?>>
                        <label class="form-check-label" for="BT_CO_ADDRESS_PROOF_ENABLE">Enable</label>
                      </div>
                      <div class="form-check form-switch mb-2">
                        <input class="form-check-input" type="checkbox" id="BT_CO_ADDRESS_PROOF_REQUIRE" name="BT_CO_ADDRESS_PROOF_REQUIRE" value="1" <?= $on('BT_CO_ADDRESS_PROOF_REQUIRE') ? 'checked' : '' ?>>
                        <label class="form-check-label" for="BT_CO_ADDRESS_PROOF_REQUIRE">Required</label>
                      </div>
                    </div>
                  </div>

                  <div class="fw-semibold mb-1">Media — Override</div>
                  <div class="form-check form-switch mb-2">
                    <input class="form-check-input" type="checkbox" id="BT_CO_OVERRIDE_MEDIA" name="BT_CO_OVERRIDE_MEDIA" value="1" <?= $on('BT_CO_OVERRIDE_MEDIA') ? 'checked' : '' ?>>
                    <label class="form-check-label" for="BT_CO_OVERRIDE_MEDIA">Override Profile Photo / Business Card</label>
                  </div>
                  <div class="row g-3 ms-2">
                    <div class="col-6">
                      <div class="fw-semibold small mb-1">Profile Photo</div>
                      <div class="form-check form-switch">
                        <input class="form-check-input" type="checkbox" id="BT_CO_PROFILE_PHOTO_ENABLE" name="BT_CO_PROFILE_PHOTO_ENABLE" value="1" <?= $on('BT_CO_PROFILE_PHOTO_ENABLE') ? 'checked' : '' ?>>
                        <label class="form-check-label" for="BT_CO_PROFILE_PHOTO_ENABLE">Enable</label>
                      </div>
                      <div class="form-check form-switch mb-2">
                        <input class="form-check-input" type="checkbox" id="BT_CO_PROFILE_PHOTO_REQUIRE" name="BT_CO_PROFILE_PHOTO_REQUIRE" value="1" <?= $on('BT_CO_PROFILE_PHOTO_REQUIRE') ? 'checked' : '' ?>>
                        <label class="form-check-label" for="BT_CO_PROFILE_PHOTO_REQUIRE">Required</label>
                      </div>
                    </div>
                    <div class="col-6">
                      <div class="fw-semibold small mb-1">Business Card</div>
                      <div class="form-check form-switch">
                        <input class="form-check-input" type="checkbox" id="BT_CO_BUSINESS_CARD_ENABLE" name="BT_CO_BUSINESS_CARD_ENABLE" value="1" <?= $on('BT_CO_BUSINESS_CARD_ENABLE') ? 'checked' : '' ?>>
                        <label class="form-check-label" for="BT_CO_BUSINESS_CARD_ENABLE">Enable</label>
                      </div>
                      <div class="form-check form-switch mb-2">
                        <input class="form-check-input" type="checkbox" id="BT_CO_BUSINESS_CARD_REQUIRE" name="BT_CO_BUSINESS_CARD_REQUIRE" value="1" <?= $on('BT_CO_BUSINESS_CARD_REQUIRE') ? 'checked' : '' ?>>
                        <label class="form-check-label" for="BT_CO_BUSINESS_CARD_REQUIRE">Required</label>
                      </div>
                    </div>
                  </div>
                </div>
              </div>
            </div>
          </div>
        </div>

        <div class="d-flex gap-2 mt-3">
          <button class="btn btn-primary" type="submit">Save Settings</button>
          <a href="/admin" class="btn btn-outline-secondary">Back to Dashboard</a>
        </div>
      </form>
    </div>
  </div>
</div>

<?php endif; ?>
