<?php
// app/Views/admin/security_agent_unlock.php
$title = $title ?? 'Unlock Agent Login';
$csrf  = $csrf  ?? (\App\Core\Security::csrfToken());
?>
<div class="container-xxl">
  <div class="row justify-content-center">
    <div class="col-12 col-lg-8 col-xl-6">
      <div class="card shadow-sm border-0">
        <div class="card-header bg-white d-flex align-items-center justify-content-between">
          <h5 class="mb-0"><i class="bi bi-unlock me-2"></i> Unlock Agent Login</h5>
          <a href="/admin" class="btn btn-sm btn-outline-secondary"><i class="bi bi-arrow-left me-1"></i> Back</a>
        </div>
        <div class="card-body">
          <p class="text-muted small mb-4">
            Use this tool to clear an agent's login lock. This resets failed attempts and removes any temporary lock windows and IP throttles for the provided email.
          </p>

          <?php if (!empty($_SESSION['flash'])): ?>
            <div class="alert alert-warning border-0 shadow-sm"><?= htmlspecialchars($_SESSION['flash']); unset($_SESSION['flash']); ?></div>
          <?php endif; ?>

          <form method="post" action="/admin/security/agent/unlock" class="row g-3">
            <input type="hidden" name="csrf" value="<?= htmlspecialchars($csrf) ?>">
            <div class="col-12">
              <label class="form-label">Agent Email <span class="text-danger">*</span></label>
              <input type="email" name="email" class="form-control" placeholder="agent@example.com" required>
              <div class="form-text">We recommend using email. You may leave User ID blank.</div>
            </div>
            <div class="col-12 col-md-6">
              <label class="form-label">User ID (optional)</label>
              <input type="number" name="user_id" class="form-control" min="1" placeholder="123">
            </div>
            <div class="col-12 d-flex align-items-center gap-2">
              <button type="submit" class="btn btn-warning"><i class="bi bi-unlock me-1"></i> Unlock Now</button>
              <a href="/admin" class="btn btn-outline-secondary">Cancel</a>
            </div>
          </form>

          <hr>
          <div class="small text-muted">
            <strong>What this does:</strong>
            <ul class="mb-0">
              <li>Resets <code>users.failed_login_attempts</code> to 0</li>
              <li>Clears <code>users.locked_until</code></li>
              <li>Clears IP+email throttle rows in <code>login_ip_throttle</code> for the provided email</li>
            </ul>
          </div>
        </div>
      </div>
    </div>
  </div>

  <div class="row mb-5">
    <div class="col-12">
      <div class="card shadow-sm border-0">
        <div class="card-header bg-white"><strong>All Block History (IP + Email)</strong></div>
        <div class="card-body p-0">
          <div class="table-responsive">
            <table class="table table-sm align-middle mb-0">
              <thead class="table-light">
                <tr><th>Email</th><th>IP</th><th>Attempts</th><th>Blocked Until</th><th>Last Attempt</th><th></th></tr>
              </thead>
              <tbody>
              <?php if (!empty($ip_block_history)): foreach ($ip_block_history as $b): ?>
                <tr>
                  <td><?= htmlspecialchars((string)$b['email']) ?></td>
                  <td><?= htmlspecialchars((string)$b['ip']) ?></td>
                  <td><?= (int)$b['attempts'] ?></td>
                  <td><?= htmlspecialchars((string)($b['blocked_until'] ?? '')) ?></td>
                  <td><?= htmlspecialchars((string)($b['last_attempt_at'] ?? '')) ?></td>
                  <td>
                    <form method="post" action="/admin/security/ip-throttle/clear" class="d-inline">
                      <input type="hidden" name="csrf" value="<?= htmlspecialchars($csrf) ?>">
                      <input type="hidden" name="email" value="<?= htmlspecialchars((string)$b['email']) ?>">
                      <input type="hidden" name="ip" value="<?= htmlspecialchars((string)$b['ip']) ?>">
                      <button type="submit" class="btn btn-sm btn-outline-secondary">Clear</button>
                    </form>
                  </td>
                </tr>
              <?php endforeach; else: ?>
                <tr><td colspan="5" class="text-center text-muted small py-3">No history available.</td></tr>
              <?php endif; ?>
              </tbody>
            </table>
          </div>
        </div>
      </div>
    </div>
  </div>

  <div class="row mt-4">
    <div class="col-12 col-xl-6 mb-4">
      <div class="card shadow-sm border-0">
        <div class="card-header bg-white"><strong>Currently Locked Users</strong></div>
        <div class="card-body p-0">
          <div class="table-responsive">
            <table class="table table-sm align-middle mb-0">
              <thead class="table-light">
                <tr><th>ID</th><th>Name</th><th>Email</th><th>Locked Until</th><th></th></tr>
              </thead>
              <tbody>
              <?php if (!empty($locked_users)): foreach ($locked_users as $u): ?>
                <tr>
                  <td><?= (int)$u['id'] ?></td>
                  <td><?= htmlspecialchars((string)$u['name']) ?></td>
                  <td><?= htmlspecialchars((string)$u['email']) ?></td>
                  <td><?= htmlspecialchars((string)$u['locked_until']) ?></td>
                  <td>
                    <form method="post" action="/admin/security/agent/unlock" class="d-inline">
                      <input type="hidden" name="csrf" value="<?= htmlspecialchars($csrf) ?>">
                      <input type="hidden" name="user_id" value="<?= (int)$u['id'] ?>">
                      <input type="hidden" name="email" value="<?= htmlspecialchars((string)$u['email']) ?>">
                      <button type="submit" class="btn btn-sm btn-outline-primary">Unlock</button>
                    </form>
                  </td>
                </tr>
              <?php endforeach; else: ?>
                <tr><td colspan="5" class="text-center text-muted small py-3">No active locks.</td></tr>
              <?php endif; ?>
              </tbody>
            </table>
          </div>
        </div>
      </div>
    </div>
    <div class="col-12 col-xl-6 mb-4">
      <div class="card shadow-sm border-0">
        <div class="card-header bg-white"><strong>Recent Failed Attempts (Not Locked)</strong></div>
        <div class="card-body p-0">
          <div class="table-responsive">
            <table class="table table-sm align-middle mb-0">
              <thead class="table-light">
                <tr><th>ID</th><th>Email</th><th>Failed</th><th>Locked Until</th></tr>
              </thead>
              <tbody>
              <?php if (!empty($attempt_users)): foreach ($attempt_users as $u): ?>
                <tr>
                  <td><?= (int)$u['id'] ?></td>
                  <td><?= htmlspecialchars((string)$u['email']) ?></td>
                  <td><?= (int)$u['failed_login_attempts'] ?></td>
                  <td><?= htmlspecialchars((string)($u['locked_until'] ?? '')) ?></td>
                </tr>
              <?php endforeach; else: ?>
                <tr><td colspan="4" class="text-center text-muted small py-3">No recent failed attempts.</td></tr>
              <?php endif; ?>
              </tbody>
            </table>
          </div>
        </div>
      </div>
    </div>
  </div>

  <div class="row mb-4">
    <div class="col-12">
      <div class="card shadow-sm border-0">
        <div class="card-header bg-white"><strong>Blocked IP + Email Pairs</strong></div>
        <div class="card-body p-0">
          <div class="table-responsive">
            <table class="table table-sm align-middle mb-0">
              <thead class="table-light">
                <tr><th>Email</th><th>IP</th><th>Attempts</th><th>Blocked Until</th><th>Last Attempt</th><th></th></tr>
              </thead>
              <tbody>
              <?php if (!empty($ip_blocks)): foreach ($ip_blocks as $b): ?>
                <tr>
                  <td><?= htmlspecialchars((string)$b['email']) ?></td>
                  <td><?= htmlspecialchars((string)$b['ip']) ?></td>
                  <td><?= (int)$b['attempts'] ?></td>
                  <td><?= htmlspecialchars((string)$b['blocked_until']) ?></td>
                  <td><?= htmlspecialchars((string)$b['last_attempt_at']) ?></td>
                  <td>
                    <form method="post" action="/admin/security/ip-throttle/clear" class="d-inline">
                      <input type="hidden" name="csrf" value="<?= htmlspecialchars($csrf) ?>">
                      <input type="hidden" name="email" value="<?= htmlspecialchars((string)$b['email']) ?>">
                      <input type="hidden" name="ip" value="<?= htmlspecialchars((string)$b['ip']) ?>">
                      <button type="submit" class="btn btn-sm btn-outline-danger">Clear</button>
                    </form>
                  </td>
                </tr>
              <?php endforeach; else: ?>
                <tr><td colspan="5" class="text-center text-muted small py-3">No active IP blocks.</td></tr>
              <?php endif; ?>
              </tbody>
            </table>
          </div>
        </div>
      </div>
    </div>
  </div>
</div>
