<?php
// app/Views/admin/promos/form.php
$editing = ($mode ?? 'create') === 'edit';
$action = $editing ? '/admin/promos/update' : '/admin/promos/store';
$promo = $promo ?? null;
?>
<div class="container py-4">
  <div class="d-flex align-items-center justify-content-between mb-3">
    <h1 class="h4 mb-0"><?php echo $editing ? 'Edit Promo' : 'New Promo'; ?></h1>
    <div>
      <a href="/admin/promos" class="btn btn-sm btn-outline-secondary">Back</a>
    </div>
  </div>

  <?php if (!empty($_SESSION['flash'])): ?>
    <div class="alert alert-info py-2"><?php echo htmlspecialchars($_SESSION['flash']); unset($_SESSION['flash']); ?></div>
  <?php endif; ?>

  <div class="card shadow-sm">
    <div class="card-body">
      <form method="post" action="<?php echo $action; ?>">
        <input type="hidden" name="csrf" value="<?php echo htmlspecialchars($csrf); ?>" />
        <?php if ($editing): ?>
          <input type="hidden" name="id" value="<?php echo (int)$promo['id']; ?>" />
        <?php endif; ?>
        <div class="row g-3">
          <div class="col-md-4">
            <label class="form-label">Code</label>
            <input type="text" name="code" class="form-control" value="<?php echo htmlspecialchars($promo['code'] ?? ''); ?>" required />
          </div>
          <div class="col-md-3">
            <label class="form-label">Type</label>
            <select name="discount_type" class="form-select">
              <?php $t = $promo['discount_type'] ?? 'percent'; ?>
              <option value="percent" <?php echo $t==='percent'?'selected':''; ?>>Percent</option>
              <option value="flat" <?php echo $t==='flat'?'selected':''; ?>>Flat</option>
            </select>
          </div>
          <div class="col-md-3">
            <label class="form-label">Value</label>
            <input type="number" step="0.01" name="discount_value" class="form-control" value="<?php echo htmlspecialchars($promo['discount_value'] ?? ''); ?>" required />
          </div>
          <div class="col-md-3">
            <label class="form-label">Valid From</label>
            <input type="date" name="valid_from" class="form-control" value="<?php echo htmlspecialchars($promo['valid_from'] ?? ''); ?>" />
          </div>
          <div class="col-md-3">
            <label class="form-label">Valid To</label>
            <input type="date" name="valid_to" class="form-control" value="<?php echo htmlspecialchars($promo['valid_to'] ?? ''); ?>" />
          </div>
          <div class="col-md-3">
            <label class="form-label">Usage Limit</label>
            <input type="number" name="usage_limit" class="form-control" value="<?php echo htmlspecialchars($promo['usage_limit'] ?? ''); ?>" />
          </div>
          <div class="col-12">
            <button type="submit" class="btn btn-primary"><?php echo $editing ? 'Update' : 'Create'; ?></button>
          </div>
        </div>
      </form>
    </div>
  </div>
</div>
