<?php /** @var array $partner */ ?>
<div class="container py-3">
  <div class="d-flex justify-content-between align-items-center mb-3">
    <h4 class="mb-0">Channel Partner Details</h4>
    <div class="d-flex gap-2">
      <a class="btn btn-sm btn-secondary" href="/admin/management/partners"><i class="bi bi-arrow-left"></i> Back</a>
      <a class="btn btn-sm btn-primary" href="/admin/management/partners/edit?id=<?= (int)$partner['id'] ?>"><i class="bi bi-pencil-square"></i> Edit</a>
    </div>
  </div>
  <div class="row g-3">
    <div class="col-md-6">
      <div class="card">
        <div class="card-body">
          <h6 class="text-muted">Basic Info</h6>
          <dl class="row mb-0">
            <dt class="col-sm-4">ID</dt><dd class="col-sm-8"><?= (int)$partner['id'] ?></dd>
            <dt class="col-sm-4">Name</dt><dd class="col-sm-8"><?= htmlspecialchars($partner['name'] ?? '') ?></dd>
            <dt class="col-sm-4">Email</dt><dd class="col-sm-8"><?= htmlspecialchars($partner['contact_email'] ?? '') ?></dd>
            <dt class="col-sm-4">Status</dt><dd class="col-sm-8"><span class="badge bg-<?= ($partner['status']==='Active'?'success':'secondary') ?>"><?= htmlspecialchars($partner['status'] ?? '') ?></span></dd>
            <dt class="col-sm-4">Created</dt><dd class="col-sm-8"><?= htmlspecialchars($partner['created_at'] ?? '') ?></dd>
            <?php $pwb = (float)($partner['wallet_balance'] ?? 0); ?>
            <dt class="col-sm-4">Wallet</dt>
            <dd class="col-sm-8">
              <span class="badge bg-<?= $pwb > 0 ? 'success' : 'secondary' ?>"><?= number_format($pwb, 2) ?></span>
            </dd>
          </dl>
        </div>
      </div>
    </div>
    <div class="col-md-6">
      <div class="card">
        <div class="card-body">
          <h6 class="text-muted">Contacts</h6>
          <dl class="row mb-0">
            <dt class="col-sm-4">Contact Person</dt><dd class="col-sm-8"><?= htmlspecialchars($partner['contact_person'] ?? '') ?></dd>
            <dt class="col-sm-4">Mobile</dt><dd class="col-sm-8"><?= htmlspecialchars($partner['contact_mobile'] ?? '') ?></dd>
            <dt class="col-sm-4">WhatsApp</dt><dd class="col-sm-8"><?= htmlspecialchars($partner['contact_whatsapp'] ?? '') ?></dd>
            <dt class="col-sm-4">LINE</dt><dd class="col-sm-8"><?= htmlspecialchars($partner['contact_line'] ?? '') ?></dd>
          </dl>
        </div>
      </div>
    </div>
    <div class="col-12">
      <div class="card">
        <div class="card-body">
          <h6 class="text-muted">Address</h6>
          <dl class="row mb-0">
            <dt class="col-sm-2">Address</dt><dd class="col-sm-10"><?= htmlspecialchars($partner['address_line'] ?? '') ?></dd>
            <dt class="col-sm-2">City</dt><dd class="col-sm-4"><?= htmlspecialchars($partner['city'] ?? '') ?></dd>
            <dt class="col-sm-2">State</dt><dd class="col-sm-4"><?= htmlspecialchars($partner['state'] ?? '') ?></dd>
            <dt class="col-sm-2">Pincode</dt><dd class="col-sm-4"><?= htmlspecialchars($partner['pincode'] ?? '') ?></dd>
            <dt class="col-sm-2">Country</dt><dd class="col-sm-4"><?= htmlspecialchars($partner['country'] ?? '') ?></dd>
          </dl>
        </div>
      </div>
    </div>
  </div>
</div>
