<?php /** @var array $partners */ ?>
<div class="container py-3">
  <style>
    /* Sticky header + subtle polish */
    /* Keep horizontal scroll for wide tables, but allow dropdowns to overflow vertically */
    .cp-table-wrap { border: 1px solid #e9ecef; border-radius: 8px; overflow-x: auto; overflow-y: visible; background: #fff; }
    .cp-table thead th { position: sticky; top: 0; background: #f8f9fa; z-index: 1; box-shadow: inset 0 -1px 0 #e9ecef; }
    .cp-toolbar { gap: .5rem; flex-wrap: wrap; }
    /* Ensure dropdown appears above pager and is not clipped */
    .cp-table-wrap .dropdown-menu { z-index: 2005; }
    /* CSS-anchored dropdown for Actions: stable inside table cell */
    .cp-dd { position: relative; }
    .cp-dd .dropdown-menu { position: absolute; left: auto !important; right: 0; top: calc(100% + 6px); transform: none !important; display: none; }
    .cp-dd .dropdown-menu.show { display: block; }
    .cp-dd.dropup .dropdown-menu { left: auto !important; right: 0; top: auto; bottom: calc(100% + 6px); }
    /* Body-level portal menu styling */
    .dropdown-portal { position: absolute; z-index: 3000; }
    .cp-crumb { font-size: .875rem; color: #6c757d; }
    .cp-crumb a { color: inherit; text-decoration: none; }
    .cp-crumb a:hover { text-decoration: underline; }
    .cp-stats { display: grid; grid-template-columns: repeat(4, minmax(0,1fr)); gap: .75rem; margin-bottom: .75rem; }
    .cp-stat { border: 1px solid #e9ecef; border-radius: 10px; background: #fff; padding: .9rem; box-shadow: 0 1px 2px rgba(16,24,40,.04); }
    .cp-stat .lbl { color:#6c757d; font-size:.8rem; }
    .cp-stat .val { font-weight:600; font-size:1.05rem; }
    @media (max-width: 768px){
      .cp-stats { grid-template-columns: repeat(2, minmax(0,1fr)); }
      .cp-toolbar { gap:.5rem; }
      #partnerSearch { min-width: 100%; }
    }
    /* xs mobile tweaks */
    @media (max-width: 576px){
      .cp-toolbar { row-gap:.5rem; }
      .cp-toolbar .input-group { width: 100%; }
      .cp-toolbar .ms-auto { width: 100%; display:flex; flex-wrap: wrap; gap:.5rem; justify-content: space-between; }
      #partnerStatus, #partnerRows { flex:1 1 calc(50% - .5rem); min-width: 140px; }
      #partnerExportCsv, #partnerExportXls { flex: 1 1 calc(50% - .5rem); min-width: 140px; }
      .pagination .page-link { min-width: 36px; height: 36px; display:flex; align-items:center; justify-content:center; }
      .btn.btn-sm { padding: .35rem .6rem; }
    }
    /* Ensure dropdowns on cards overlay above neighbors */
    .cp-card .dropdown-menu { z-index: 2005; }
    /* Mobile cards */
    .cp-card { border:1px solid #e9ecef; border-radius:10px; background:#fff; padding:12px; box-shadow: 0 1px 2px rgba(16,24,40,.05); }
    .cp-card + .cp-card { margin-top:10px; }
    .cp-card .cp-card-head { display:flex; align-items:center; justify-content:space-between; gap:8px; }
    .cp-card .cp-card-sub { color:#6c757d; font-size:.875rem; margin-top:4px; }
    .cp-card .cp-card-meta { display:flex; flex-wrap:wrap; gap:6px 10px; margin-top:8px; }
    .cp-card .cp-card-meta .item { color:#6c757d; font-size:.85rem; }
    .cp-card .cp-actions { display:flex; align-items:center; justify-content:space-between; gap:8px; margin-top:10px; }
    /* Professional button styling for actions */
    .cp-action-btn.btn {
      --cpb-radius: 10px;
      border-radius: var(--cpb-radius);
      border-color: #D0D5DD;
      color: #344054;
      background-color: #fff;
      padding: .35rem .6rem;
      line-height: 1.25;
    }
    .cp-action-btn.btn:hover { background-color: #F9FAFB; border-color:#D0D5DD; }
    .cp-action-btn.btn:active { background-color: #F3F4F6; border-color:#D0D5DD; }
    .cp-action-btn.btn:focus { box-shadow: 0 0 0 .2rem rgba(13,110,253,.1); }
    .cp-actions-td .cp-action-btn i, .cp-card .cp-action-btn i { opacity:.9; }
    /* Icon-only action buttons (match Agents page) */
    .cp-actions-td .cp-action-btn.btn,
    .cp-card .cp-action-btn.btn {
      background: transparent !important;
      border-color: transparent !important;
      box-shadow: none !important;
      padding: .25rem !important;
      min-width: auto;
      color: #111827 !important; /* text color fallback */
    }
    .cp-actions-td .cp-action-btn i,
    .cp-card .cp-action-btn i {
      margin-right: 0 !important;
      font-size: 1.05rem;
      color: #111827 !important; /* icon color */
    }
    .cp-actions-td .cp-action-btn:hover i,
    .cp-card .cp-action-btn:hover i { color: #0d6efd !important; }
    .cp-actions-td .cp-action-btn:focus-visible,
    .cp-card .cp-action-btn:focus-visible { outline: 2px solid rgba(13,110,253,.5); outline-offset: 2px; border-radius: 6px; }
    /* Visually hide labels but keep for screen readers */
    .cp-action-btn .cp-label { position: absolute !important; width: 1px !important; height: 1px !important; padding: 0 !important; margin: -1px !important; overflow: hidden !important; clip: rect(0,0,0,0) !important; white-space: nowrap !important; border: 0 !important; }
  </style>
  <div class="cp-crumb mb-2">
    <a href="/admin">Admin</a> / <a href="/admin/management">Management</a> / <span>Channel Partners</span>
  </div>
  <div class="d-flex justify-content-between align-items-start mb-3">
    <div>
      <h4 class="mb-1">Channel Partner List</h4>
      <div class="text-muted small">Manage partners, wallet access, and permissions</div>
    </div>
    <a class="btn btn-sm btn-primary" href="/admin/management/partners/create"><i class="bi bi-people me-1"></i>Add Channel Partner</a>
  </div>

  <div class="cp-stats" id="cpStats" aria-live="polite">
    <div class="cp-stat"><div class="lbl">Total Partners</div><div class="val" id="statTotal">0</div></div>
    <div class="cp-stat"><div class="lbl">Active</div><div class="val text-success" id="statActive">0</div></div>
    <div class="cp-stat"><div class="lbl">Inactive</div><div class="val text-muted" id="statInactive">0</div></div>
    <div class="cp-stat"><div class="lbl">Total Wallet (THB)</div><div class="val" id="statWallet">0.00</div></div>
  </div>

  

  <div class="d-flex cp-toolbar align-items-center mb-2">
    <div class="input-group input-group-sm" style="max-width:360px;">
      <span class="input-group-text"><i class="bi bi-search"></i></span>
      <input type="text" id="partnerSearch" class="form-control" placeholder="Search name, email, contact, city, country">
    </div>
    <div class="ms-auto d-flex gap-2 align-items-center">
      <label class="small text-muted">Status:</label>
      <select id="partnerStatus" class="form-select form-select-sm" style="width:130px;">
        <option value="">All</option>
        <option value="Active">Active</option>
        <option value="Inactive">Inactive</option>
      </select>
      <label class="small text-muted">Rows:</label>
      <select id="partnerRows" class="form-select form-select-sm" style="width:80px;">
        <option>10</option>
        <option selected>25</option>
        <option>50</option>
        <option>100</option>
      </select>
      <button id="partnerExportCsv" class="btn btn-outline-secondary btn-sm"><i class="bi bi-download me-1"></i>Export CSV</button>
      <button id="partnerExportXls" class="btn btn-outline-secondary btn-sm"><i class="bi bi-file-earmark-excel me-1"></i>Export Excel</button>
    </div>
  </div>

  <!-- Mobile Cards (visible on < md) -->
  <div id="cpCards" class="d-md-none">
    <?php if (empty($partners)): ?>
      <div class="text-center text-muted py-5">No channel partners found</div>
    <?php else: foreach ($partners as $p): ?>
      <?php
        $pwb = (float)($p['wallet_balance'] ?? 0);
        $tier = 'Zero'; $tierClass = 'secondary';
        if ($pwb >= 100000) { $tier='High'; $tierClass='success'; }
        elseif ($pwb >= 10000) { $tier='Medium'; $tierClass='info'; }
        elseif ($pwb > 0) { $tier='Low'; $tierClass='secondary'; }
        $created = htmlspecialchars($p['created_at'] ?? '');
        $isNew = false;
        if (!empty($p['created_at'])) {
          $ts = @strtotime($p['created_at']);
          if ($ts) { $isNew = (time() - $ts) <= (7*24*60*60); }
        }
      ?>
      <div class="cp-card" data-id="<?= (int)$p['id'] ?>">
        <div class="cp-card-head">
          <div>
            <a href="/admin/management/partners/agents?id=<?= (int)$p['id'] ?>" class="fw-semibold text-decoration-underline">
              <?= htmlspecialchars($p['name'] ?? '') ?>
            </a>
            <div class="cp-card-sub">
              <span class="me-2">ID: <?= (int)$p['id'] ?></span>
              <span class="badge bg-<?= ($p['status'] === 'Active' ? 'success' : 'secondary') ?>"><?= htmlspecialchars($p['status'] ?? '') ?></span>
            </div>
          </div>
          <a class="text-decoration-none" href="/admin/management/partners/wallet?id=<?= (int)$p['id'] ?>">
            <span class="badge bg-<?= $tierClass ?>"><?= $tier ?> · <?= number_format($pwb, 2) ?></span>
          </a>
        </div>
        <div class="cp-card-meta">
          <div class="item"><i class="bi bi-envelope me-1"></i><?= htmlspecialchars($p['contact_email'] ?? '-') ?></div>
          <div class="item"><i class="bi bi-person me-1"></i><?= htmlspecialchars($p['contact_person'] ?? '-') ?></div>
          <div class="item"><i class="bi bi-phone me-1"></i><?= htmlspecialchars($p['contact_mobile'] ?? '-') ?></div>
          <div class="item"><i class="bi bi-geo-alt me-1"></i><?= htmlspecialchars($p['city'] ?? '-') ?>, <?= htmlspecialchars($p['country'] ?? '-') ?></div>
          <div class="item"><i class="bi bi-calendar3 me-1"></i><?= $created ?><?php if ($isNew): ?> <span class="badge bg-warning text-dark ms-1">New</span><?php endif; ?></div>
        </div>
        <div class="cp-actions">
          <div class="d-flex flex-wrap gap-1">
            <a class="btn btn-outline-secondary btn-sm cp-action-btn" href="/admin/management/partners/view?id=<?= (int)$p['id'] ?>" title="View"><i class="bi bi-eye-fill"></i><span class="cp-label">View</span></a>
            <a class="btn btn-outline-secondary btn-sm cp-action-btn" href="/admin/management/partners/edit?id=<?= (int)$p['id'] ?>" title="Edit"><i class="bi bi-pencil"></i><span class="cp-label">Edit</span></a>
            <a class="btn btn-outline-secondary btn-sm cp-action-btn" href="/admin/management/partners/wallet?id=<?= (int)$p['id'] ?>" title="Wallet"><i class="bi bi-wallet2"></i><span class="cp-label">Wallet</span></a>
            <button type="button" class="btn btn-outline-secondary btn-sm cp-action-btn js-open-settings" data-partner-id="<?= (int)$p['id'] ?>" data-partner-name="<?= htmlspecialchars($p['name'] ?? '') ?>" title="Settings"><i class="bi bi-sliders2"></i><span class="cp-label">Settings</span></button>
            <button type="button" class="btn btn-outline-secondary btn-sm cp-action-btn js-open-change-password" data-partner-id="<?= (int)$p['id'] ?>" data-partner-name="<?= htmlspecialchars($p['name'] ?? '') ?>" title="Change Password"><i class="bi bi-key-fill"></i><span class="cp-label">Password</span></button>
          </div>
          <form method="post" action="/admin/management/partners/toggle_status" class="d-inline align-middle cp-switch-form ms-2">
            <input type="hidden" name="csrf" value="<?= htmlspecialchars($csrf ?? '') ?>">
            <input type="hidden" name="id" value="<?= (int)$p['id'] ?>">
            <div class="form-check form-switch m-0" title="Enable/Disable Partner">
              <?php $isActive = ($p['status'] === 'Active'); ?>
              <input class="form-check-input cp-status-switch" type="checkbox" role="switch" <?= $isActive ? 'checked' : '' ?> aria-label="Toggle status">
            </div>
          </form>
          <form method="post" action="/admin/management/partners/reset_password" class="d-inline js-hidden-reset-form">
            <input type="hidden" name="csrf" value="<?= htmlspecialchars($csrf ?? '') ?>">
            <input type="hidden" name="id" value="<?= (int)$p['id'] ?>">
            <input type="hidden" name="new_password" value="">
            <input type="hidden" name="master_password" value="">
            <button type="button" class="btn btn-outline-dark btn-sm d-none js-ask-pass-partner" data-action="change password for <?= htmlspecialchars($p['name'] ?? 'this partner') ?>">
              <i class="bi bi-key me-1"></i> Change Password
            </button>
          </form>
          <button type="button" class="btn btn-outline-success btn-sm d-none js-partner-settings" data-partner-id="<?= (int)$p['id'] ?>" data-partner-name="<?= htmlspecialchars($p['name'] ?? '') ?>">
            <i class="bi bi-sliders"></i> Settings
          </button>
        </div>
      </div>
    <?php endforeach; endif; ?>
  </div>

  <!-- Desktop table (hidden on < md) -->
  <div class="table-responsive cp-table-wrap d-none d-md-block">
    <table class="table table-striped table-hover align-middle cp-table mb-0">
      <thead>
        <tr>
          <th>ID</th>
          <th>Name</th>
          <th class="d-none d-lg-table-cell">Email</th>
          <th class="d-none d-xl-table-cell">Contact Person</th>
          <th class="d-none d-lg-table-cell">Mobile</th>
          <th class="d-none d-xl-table-cell">WhatsApp</th>
          <th class="d-none d-xl-table-cell">LINE</th>
          <th class="d-none d-md-table-cell">City</th>
          <th class="d-none d-lg-table-cell">Country</th>
          <th>Status</th>
          <th>Wallet</th>
          <th>Created</th>
          <th>Actions</th>
        </tr>
      </thead>
      <tbody>
        <?php if (empty($partners)): ?>
          <tr>
            <td colspan="13" class="text-center text-muted py-5">
              <div class="mb-2" style="font-size:28px;">🧭</div>
              <div class="fw-semibold">No channel partners found</div>
              <div class="small">Use the button above to add your first partner.</div>
            </td>
          </tr>
        <?php else: foreach ($partners as $p): ?>
          <tr>
            <td><?= (int)$p['id'] ?></td>
            <td>
              <a href="/admin/management/partners/agents?id=<?= (int)$p['id'] ?>" class="text-decoration-underline" title="View Agents under this Partner">
                <?= htmlspecialchars($p['name'] ?? '') ?>
              </a>
            </td>
            <td class="d-none d-lg-table-cell"><?= htmlspecialchars($p['contact_email'] ?? '') ?></td>
            <td class="d-none d-xl-table-cell"><?= htmlspecialchars($p['contact_person'] ?? '') ?></td>
            <td class="d-none d-lg-table-cell"><?= htmlspecialchars($p['contact_mobile'] ?? '') ?></td>
            <td class="d-none d-xl-table-cell"><?= htmlspecialchars($p['contact_whatsapp'] ?? '') ?></td>
            <td class="d-none d-xl-table-cell"><?= htmlspecialchars($p['contact_line'] ?? '') ?></td>
            <td class="d-none d-md-table-cell"><?= htmlspecialchars($p['city'] ?? '') ?></td>
            <td class="d-none d-lg-table-cell"><?= htmlspecialchars($p['country'] ?? '') ?></td>
            <td><span class="badge bg-<?= ($p['status'] === 'Active' ? 'success' : 'secondary') ?>"><?= htmlspecialchars($p['status'] ?? '') ?></span></td>
            <?php
              $pwb = (float)($p['wallet_balance'] ?? 0);
              // Wallet tiering
              $tier = 'Zero'; $tierClass = 'secondary';
              if ($pwb >= 100000) { $tier='High'; $tierClass='success'; }
              elseif ($pwb >= 10000) { $tier='Medium'; $tierClass='info'; }
              elseif ($pwb > 0) { $tier='Low'; $tierClass='secondary'; }
            ?>
            <td>
              <a class="text-decoration-none" href="/admin/management/partners/wallet?id=<?= (int)$p['id'] ?>" title="Wallet: <?= number_format($pwb,2) ?> (<?= $tier ?>)">
                <span class="badge bg-<?= $tierClass ?>">
                  <?= $tier ?> · <?= number_format($pwb, 2) ?>
                </span>
              </a>
            </td>
            <td>
              <?php
                $created = htmlspecialchars($p['created_at'] ?? '');
                $isNew = false;
                if (!empty($p['created_at'])) {
                  $ts = @strtotime($p['created_at']);
                  if ($ts) { $isNew = (time() - $ts) <= (7*24*60*60); }
                }
              ?>
              <?= $created ?>
              <?php if ($isNew): ?><span class="badge bg-warning text-dark ms-1">New</span><?php endif; ?>
            </td>
            <td class="cp-actions-td">
              <div class="d-flex align-items-center justify-content-between flex-wrap gap-2">
                <div class="d-flex flex-wrap gap-1">
                  <a class="btn btn-outline-secondary btn-sm cp-action-btn" href="/admin/management/partners/view?id=<?= (int)$p['id'] ?>" title="View"><i class="bi bi-eye-fill"></i><span class="cp-label">View</span></a>
                  <a class="btn btn-outline-secondary btn-sm cp-action-btn" href="/admin/management/partners/edit?id=<?= (int)$p['id'] ?>" title="Edit"><i class="bi bi-pencil"></i><span class="cp-label">Edit</span></a>
                  <a class="btn btn-outline-secondary btn-sm cp-action-btn" href="/admin/management/partners/wallet?id=<?= (int)$p['id'] ?>" title="Wallet"><i class="bi bi-wallet2"></i><span class="cp-label">Wallet</span></a>
                  <button type="button" class="btn btn-outline-secondary btn-sm cp-action-btn js-open-settings" data-partner-id="<?= (int)$p['id'] ?>" data-partner-name="<?= htmlspecialchars($p['name'] ?? '') ?>" title="Settings"><i class="bi bi-sliders2"></i><span class="cp-label">Settings</span></button>
                  <button type="button" class="btn btn-outline-secondary btn-sm cp-action-btn js-open-change-password" data-partner-id="<?= (int)$p['id'] ?>" data-partner-name="<?= htmlspecialchars($p['name'] ?? '') ?>" title="Change Password"><i class="bi bi-key-fill"></i><span class="cp-label">Password</span></button>
                </div>
                <!-- Keep existing forms for status toggle and password change (used by JS) -->
                <form method="post" action="/admin/management/partners/toggle_status" class="d-inline align-middle cp-switch-form">
                  <input type="hidden" name="csrf" value="<?= htmlspecialchars($csrf ?? '') ?>">
                  <input type="hidden" name="id" value="<?= (int)$p['id'] ?>">
                  <div class="form-check form-switch m-0" title="Enable/Disable Partner">
                    <?php $isActive = ($p['status'] === 'Active'); ?>
                    <input class="form-check-input cp-status-switch" type="checkbox" role="switch" <?= $isActive ? 'checked' : '' ?> aria-label="Toggle status">
                  </div>
                </form>
              </div>
              <form method="post" action="/admin/management/partners/reset_password" class="d-inline js-hidden-reset-form">
                <input type="hidden" name="csrf" value="<?= htmlspecialchars($csrf ?? '') ?>">
                <input type="hidden" name="id" value="<?= (int)$p['id'] ?>">
                <input type="hidden" name="new_password" value="">
                <input type="hidden" name="master_password" value="">
                <!-- No visible button here; dropdown triggers the modal via JS -->
                <button type="button" class="btn btn-outline-dark btn-sm d-none js-ask-pass-partner" data-action="change password for <?= htmlspecialchars($p['name'] ?? 'this partner') ?>">
                  <i class="bi bi-key me-1"></i> Change Password
                </button>
              </form>
              <button type="button" class="btn btn-outline-success btn-sm d-none js-partner-settings" data-partner-id="<?= (int)$p['id'] ?>" data-partner-name="<?= htmlspecialchars($p['name'] ?? '') ?>">
                <i class="bi bi-sliders"></i> Settings
              </button>
            </td>
          </tr>
        <?php endforeach; endif; ?>
      </tbody>
    </table>
  </div>
  <div class="d-flex justify-content-between align-items-center mt-2">
    <div class="small text-muted" id="partnerCount"></div>
    <nav>
      <ul class="pagination pagination-sm mb-0" id="partnerPager"></ul>
    </nav>
  </div>
</div>

<script>
(function(){
  const table = document.querySelector('table');
  const tbody = table.querySelector('tbody');
  const rows = Array.from(tbody.querySelectorAll('tr'));
  const cardsWrap = document.getElementById('cpCards');
  const cards = Array.from(cardsWrap ? cardsWrap.querySelectorAll('.cp-card') : []);
  const search = document.getElementById('partnerSearch');
  const rowsSel = document.getElementById('partnerRows');
  const statusSel = document.getElementById('partnerStatus');
  const pager = document.getElementById('partnerPager');
  const count = document.getElementById('partnerCount');
  const exportBtn = document.getElementById('partnerExportCsv');
  const exportXlsBtn = document.getElementById('partnerExportXls');
  const statTotal = document.getElementById('statTotal');
  const statActive = document.getElementById('statActive');
  const statInactive = document.getElementById('statInactive');
  const statWallet = document.getElementById('statWallet');
  // dedicated page handles agent listing now

  // Build a combined dataset of table rows + corresponding mobile cards
  const data = rows.map(tr => {
    const idCell = tr.querySelector('td:first-child');
    const id = idCell ? parseInt(idCell.textContent.trim(), 10) : NaN;
    const card = cards.find(c => parseInt(c.getAttribute('data-id'), 10) === id);
    return { id, tr, card };
  });

  let filtered = data.slice();
  let page = 1;
  let perPage = parseInt(rowsSel.value, 10) || 25;

  function normalize(s){ return (s||'').toString().toLowerCase(); }
  function rowStatusFromTr(tr){
    const badge = tr.querySelector('td:nth-child(10) .badge');
    return badge ? (badge.textContent || '').trim() : '';
  }
  function rowStatus(item){
    // Prefer table badge; fallback to card badge
    const fromTr = rowStatusFromTr(item.tr);
    if (fromTr) return fromTr;
    const cardBadge = item.card ? item.card.querySelector('.cp-card-sub .badge') : null;
    return cardBadge ? (cardBadge.textContent||'').trim() : '';
  }
  function applyFilter(){
    const q = normalize(search.value);
    const wantStatus = (statusSel && statusSel.value) ? statusSel.value : '';
    filtered = data.filter(item => {
      const trTxt = normalize(item.tr.innerText);
      const cardTxt = item.card ? normalize(item.card.innerText) : '';
      const matchesText = q ? (trTxt.includes(q) || cardTxt.includes(q)) : true;
      const matchesStatus = wantStatus ? (rowStatus(item) === wantStatus) : true;
      return matchesText && matchesStatus;
    });
    page = 1; render();
  }
  function computeStats(){
    const total = rows.length;
    let act = 0, inact = 0, wallet = 0;
    rows.forEach(tr => {
      const st = rowStatusFromTr(tr);
      if (st === 'Active') act++; else inact++;
      const wtd = tr.querySelector('td:nth-child(11) .badge');
      if (wtd){
        const txt = (wtd.textContent||'').split('·').pop().trim().replace(/[,\s]/g,'');
        const val = parseFloat(txt);
        if (!isNaN(val)) wallet += val;
      }
    });
    if (statTotal) statTotal.textContent = total.toString();
    if (statActive) statActive.textContent = act.toString();
    if (statInactive) statInactive.textContent = inact.toString();
    if (statWallet) statWallet.textContent = wallet.toLocaleString(undefined, { minimumFractionDigits:2, maximumFractionDigits:2 });
  }
  // Debounce search for smoother UX
  let tSearch;
  function onSearch(){ clearTimeout(tSearch); tSearch = setTimeout(applyFilter, 150); }
  function render(){
    rows.forEach(r => r.style.display = 'none');
    cards.forEach(c => c.style.display = 'none');
    const total = filtered.length;
    const pages = Math.max(1, Math.ceil(total / perPage));
    if (page > pages) page = pages;
    const start = (page - 1) * perPage;
    filtered.slice(start, start + perPage).forEach(item => {
      if (item.tr) item.tr.style.display = '';
      if (item.card) item.card.style.display = '';
    });
    // pager
    pager.innerHTML = '';
    const prev = document.createElement('li');
    prev.className = 'page-item' + (page<=1?' disabled':'');
    prev.innerHTML = '<a class="page-link" href="#" aria-label="Previous">&laquo;</a>';
    prev.onclick = (e)=>{ e.preventDefault(); if(page>1){ page--; render(); } };
    pager.appendChild(prev);
    const windowSize = 7;
    let startPage = Math.max(1, page - Math.floor(windowSize/2));
    let endPage = Math.min(pages, startPage + windowSize - 1);
    startPage = Math.max(1, endPage - windowSize + 1);
    for (let n = startPage; n <= endPage; n++){
      const li = document.createElement('li');
      li.className = 'page-item' + (n===page?' active':'');
      li.innerHTML = '<a class="page-link" href="#">'+n+'</a>';
      li.onclick = (e)=>{ e.preventDefault(); page=n; render(); };
      pager.appendChild(li);
    }
    const next = document.createElement('li');
    next.className = 'page-item' + (page>=pages?' disabled':'');
    next.innerHTML = '<a class="page-link" href="#" aria-label="Next">&raquo;</a>';
    next.onclick = (e)=>{ e.preventDefault(); if(page<pages){ page++; render(); } };
    pager.appendChild(next);
    count.textContent = total + ' result' + (total===1?'':'s') + (pages>1? (' • page '+page+'/'+pages):'');
  }
  function exportCsv(){
    const headers = Array.from(table.querySelectorAll('thead th')).map(th => th.textContent.trim());
    const visibleRows = filtered.map(item => Array.from(item.tr.children).map(td => '"' + (td.innerText||'').replaceAll('"','""') + '"'));
    const csv = [headers.join(','), ...visibleRows.map(cols => cols.join(','))].join('\n');
    const blob = new Blob([csv], {type: 'text/csv;charset=utf-8;'});
    const url = URL.createObjectURL(blob);
    const a = document.createElement('a');
    a.href = url; a.download = 'channel_partners.csv'; a.click();
    URL.revokeObjectURL(url);
  }

  function exportXls(){
    // Collect headers and determine if there's an Actions column to exclude
    const headersAll = Array.from(table.querySelectorAll('thead th')).map(th => th.textContent.trim());
    const idxActions = headersAll.findIndex(h => h.toLowerCase() === 'actions');
    const headers = headersAll.filter((_,i)=> i !== idxActions);
    // Build rows from currently filtered items
    const rowsHtml = filtered.map(item => {
      const tds = Array.from(item.tr.children).map(td => (td.innerText||'').trim());
      const cols = tds.filter((_,i)=> i !== idxActions).map(txt => `<td>${escapeHtml(txt)}</td>`).join('');
      return `<tr>${cols}</tr>`;
    }).join('');
    const thead = `<thead><tr>${headers.map(h=>`<th>${escapeHtml(h)}</th>`).join('')}</tr></thead>`;
    const tbody = `<tbody>${rowsHtml}</tbody>`;
    const html = `<!DOCTYPE html><html><head><meta charset="utf-8"><meta http-equiv="X-UA-Compatible" content="IE=edge"><title>Channel Partners</title></head><body><table border="1">${thead}${tbody}</table></body></html>`;
    const blob = new Blob([html], { type: 'application/vnd.ms-excel' });
    const url = URL.createObjectURL(blob);
    const a = document.createElement('a'); a.href = url; a.download = 'channel_partners.xls'; a.click(); URL.revokeObjectURL(url);
  }

  function escapeHtml(s){
    return (s||'').replace(/&/g,'&amp;').replace(/</g,'&lt;').replace(/>/g,'&gt;').replace(/\"/g,'&quot;').replace(/'/g,'&#39;');
  }

  search.addEventListener('input', onSearch);
  statusSel.addEventListener('change', applyFilter);
  rowsSel.addEventListener('change', function(){ perPage = parseInt(this.value,10)||25; render(); });
  exportBtn.addEventListener('click', function(e){ e.preventDefault(); exportCsv(); });
  exportXlsBtn.addEventListener('click', function(e){ e.preventDefault(); exportXls(); });
  applyFilter();
  computeStats();

  // Switch-style enable/disable: submit on change
  document.addEventListener('change', function(e){
    const sw = e.target.closest('.cp-status-switch');
    if (!sw) return;
    const form = sw.closest('form');
    if (!form) return;
    sw.disabled = true;
    if (typeof form.requestSubmit === 'function') form.requestSubmit(); else form.submit();
    // Re-enable after a short delay in case of SPA-like behavior; page will usually redirect
    setTimeout(()=>{ sw.disabled = false; }, 1500);
  });

  // Delegated quick actions (dropdown) for both table rows and mobile cards
  document.addEventListener('click', function(e){
    const aSettings = e.target.closest('.js-open-settings');
    if (aSettings) {
      e.preventDefault();
      const scope = aSettings.closest('.cp-card') || aSettings.closest('tr') || document;
      const btn = scope.querySelector('.js-partner-settings');
      if (btn) btn.click();
      return;
    }
    const aPwd = e.target.closest('.js-open-change-password');
    if (aPwd) {
      e.preventDefault();
      const scope = aPwd.closest('.cp-card') || aPwd.closest('tr') || document;
      const form = scope.querySelector('.js-hidden-reset-form');
      if (form) {
        // Open lightweight password modal targeting this row/card's form
        targetForm = form;
        ensurePwModal();
        const name = aPwd.getAttribute('data-partner-name') || 'this partner';
        if (pwDesc) pwDesc.textContent = 'Change password for ' + name;
        if (pwModal && typeof pwModal.show === 'function') pwModal.show();
      }
      return;
    }
  });

  // Flip dropdown upward if near bottom of viewport
  (function(){
    document.addEventListener('shown.bs.dropdown', function(ev){
      const toggle = ev.relatedTarget || ev.target;
      const dd = toggle && toggle.closest ? toggle.closest('.cp-dd') : null;
      if (!dd) return;
      const rect = dd.getBoundingClientRect();
      const viewportH = window.innerHeight || document.documentElement.clientHeight;
      const estimatedMenuHeight = 220; // approx
      if (rect.bottom + estimatedMenuHeight > viewportH) dd.classList.add('dropup'); else dd.classList.remove('dropup');
    });
  })();

  // Lightweight password modal (similar to vendors delete) for Change Password
  let pwOverlay=null, pwModal=null, pwNew=null, pwMaster=null, pwConfirm=null, pwCancel=null, pwDesc=null, targetForm=null;
  function ensurePwModal(){
    if (pwOverlay) return;
    pwOverlay = document.createElement('div'); pwOverlay.style.cssText='position:fixed;inset:0;background:rgba(0,0,0,.45);display:none;z-index:21000;';
    pwModal = document.createElement('div'); pwModal.style.cssText='position:fixed;left:50%;top:50%;transform:translate(-50%,-50%);background:#fff;border-radius:8px;box-shadow:0 10px 30px rgba(0,0,0,.2);width:min(92vw,420px);z-index:21001;display:none;';
    const hdr=document.createElement('div'); hdr.style.cssText='padding:10px 12px;border-bottom:1px solid #eee;font-weight:600;display:flex;justify-content:space-between;align-items:center;'; hdr.textContent='Change Partner Password';
    const x=document.createElement('button'); x.type='button'; x.textContent='×'; x.style.cssText='border:0;background:transparent;font-size:20px;line-height:1;cursor:pointer;'; hdr.appendChild(x);
    const body=document.createElement('div'); body.style.cssText='padding:12px;';
    pwDesc=document.createElement('p'); pwDesc.className='small'; pwDesc.style.margin='0 0 8px 0'; pwDesc.textContent='Enter a new password (min 6 chars) and your master password to confirm.';
    pwNew=document.createElement('input'); pwNew.type='password'; pwNew.placeholder='New Password (min 6)'; pwNew.className='form-control mb-2'; pwNew.autocomplete='new-password';
    pwMaster=document.createElement('input'); pwMaster.type='password'; pwMaster.placeholder='Master Password'; pwMaster.className='form-control'; pwMaster.autocomplete='current-password';
    body.appendChild(pwDesc); body.appendChild(pwNew); body.appendChild(pwMaster);
    const ftr=document.createElement('div'); ftr.style.cssText='padding:10px 12px;border-top:1px solid #eee;display:flex;justify-content:flex-end;gap:8px;';
    pwCancel=document.createElement('button'); pwCancel.type='button'; pwCancel.className='btn btn-outline-secondary btn-sm'; pwCancel.textContent='Cancel';
    pwConfirm=document.createElement('button'); pwConfirm.type='button'; pwConfirm.className='btn btn-dark btn-sm'; pwConfirm.textContent='Update Password';
    ftr.appendChild(pwCancel); ftr.appendChild(pwConfirm);
    pwModal.appendChild(hdr); pwModal.appendChild(body); pwModal.appendChild(ftr);
    document.body.appendChild(pwOverlay); document.body.appendChild(pwModal);
    function show(){ pwOverlay.style.display='block'; pwModal.style.display='block'; setTimeout(()=>pwNew.focus(), 50); }
    function hide(){ pwOverlay.style.display='none'; pwModal.style.display='none'; }
    pwOverlay.addEventListener('click', hide); x.addEventListener('click', hide); pwCancel.addEventListener('click', hide);
    pwConfirm.addEventListener('click', ()=>{
      if (!targetForm) return;
      const np = (pwNew.value||'').trim(); const mp = (pwMaster.value||'').trim();
      if (np.length < 6) { pwNew.focus(); return; }
      if (!mp) { pwMaster.focus(); return; }
      targetForm.querySelector('input[name="new_password"]').value = np;
      targetForm.querySelector('input[name="master_password"]').value = mp;
      setTimeout(()=>{ if (typeof targetForm.requestSubmit==='function') targetForm.requestSubmit(); else targetForm.submit(); hide(); },0);
    });
    document.addEventListener('keydown', (e)=>{ if(e.key==='Escape') hide(); });
    pwModal.show = show; pwModal.hide = hide;
  }
  function openPwModal(label, form){ ensurePwModal(); targetForm=form; pwNew.value=''; pwMaster.value=''; if(pwDesc) pwDesc.textContent='Enter a new password and master password to '+label+'.'; pwModal.show(); }

  document.addEventListener('click', (ev)=>{
    const btn = ev.target.closest('.js-ask-pass-partner');
    if (!btn) return;
    let form = btn.closest('form'); if (!form) return;
    const action = btn.getAttribute('data-action') || 'change password';
    openPwModal(action, form);
  });

  // ================= Partner Settings Modal =================
  let setOverlay=null,setModal=null,setForm=null,setMaster=null;
  let fldAllowWallet=null,fldReqTx=null,fldDailyLimit=null,fldAllowAgent=null,fldAgentLimit=null,fldAllowAgentPw=null,fldApi=null,fldExtraMargin=null,fldMaxMarginPct=null,fldMaxFlat=null,fldTxPass=null,fldTxKeyOverride=null;
  function ensureSettingsModal(){
    if (setOverlay) return;
    setOverlay = document.createElement('div'); setOverlay.style.cssText='position:fixed;inset:0;background:rgba(0,0,0,.45);display:none;z-index:21000;';
    setModal = document.createElement('div'); setModal.style.cssText='position:fixed;left:50%;top:50%;transform:translate(-50%,-50%);background:#fff;border-radius:8px;box-shadow:0 10px 30px rgba(0,0,0,.2);width:min(95vw,620px);max-height:90vh;overflow:auto;z-index:21001;display:none;';
    const hdr=document.createElement('div'); hdr.style.cssText='padding:10px 12px;border-bottom:1px solid #eee;font-weight:600;display:flex;justify-content:space-between;align-items:center;'; hdr.innerHTML='<span>Channel Partner Settings</span>';
    const x=document.createElement('button'); x.type='button'; x.textContent='×'; x.style.cssText='border:0;background:transparent;font-size:20px;line-height:1;cursor:pointer;'; hdr.appendChild(x);
    const body=document.createElement('div'); body.style.cssText='padding:12px;';
    setForm=document.createElement('form'); setForm.method='post'; setForm.action='/admin/management/partners/settings';
    setForm.innerHTML = `
      <input type="hidden" name="csrf" value="<?= htmlspecialchars($csrf ?? '') ?>">
      <input type="hidden" name="id" value="">
      <div class="row g-3">
        <div class="col-12">
          <label class="form-label d-flex justify-content-between align-items-center">
            <span>Set/Change Transaction Password</span>
            <span class="small text-muted">PIN only</span>
          </label>
          <div class="input-group">
            <input type="password" class="form-control" name="transaction_password" placeholder="Leave blank to keep unchanged" autocomplete="new-password" inputmode="numeric" pattern="\\d{6}" maxlength="6">
            <button class="btn btn-outline-secondary" type="button" id="btnGenTxPin" title="Generate secure PIN">Generate PIN</button>
            <button class="btn btn-outline-secondary" type="button" id="btnViewTxPin" title="View (requires Master Password)">View</button>
          </div>
          <div class="form-text">Used for Partner → Agent transfers (when required). Exactly 6-digit PIN is required.</div>
        </div>
        <div class="col-md-6">
          <div class="form-check form-switch">
            <input class="form-check-input" type="checkbox" name="allow_wallet_transfer" id="ps_allow_wallet_transfer">
            <label class="form-check-label" for="ps_allow_wallet_transfer">Allow Wallet Transfer</label>
          </div>
        </div>
        <div class="col-md-6">
          <div class="form-check form-switch">
            <input class="form-check-input" type="checkbox" name="require_tx_password" id="ps_require_tx_password">
            <label class="form-check-label" for="ps_require_tx_password">Require Transaction Password</label>
          </div>
        </div>
        <div class="col-md-6">
          <label class="form-label">Daily Wallet Transfer Limit (THB)</label>
          <input type="number" step="0.01" class="form-control" name="wallet_transfer_daily_limit" placeholder="e.g. 50000">
        </div>
        <div class="col-md-6">
          <div class="form-check form-switch">
            <input class="form-check-input" type="checkbox" name="api_enabled" id="ps_api_enabled">
            <label class="form-check-label" for="ps_api_enabled">Enable API Access</label>
          </div>
        </div>
        <div class="col-md-6">
          <div class="form-check form-switch">
            <input class="form-check-input" type="checkbox" name="allow_agent_creation" id="ps_allow_agent_creation">
            <label class="form-check-label" for="ps_allow_agent_creation">Allow Agent Creation</label>
          </div>
        </div>
        <div class="col-md-6">
          <label class="form-label">Agent Creation Limit</label>
          <input type="number" class="form-control" name="agent_creation_limit" placeholder="e.g. 10">
        </div>
        <div class="col-md-6">
          <div class="form-check form-switch">
            <input class="form-check-input" type="checkbox" name="allow_agent_password_change" id="ps_allow_agent_pw">
            <label class="form-check-label" for="ps_allow_agent_pw">Allow Agent Password Change</label>
          </div>
        </div>
        <div class="col-md-6">
          <div class="form-check form-switch">
            <input class="form-check-input" type="checkbox" name="allow_extra_margin" id="ps_allow_extra_margin">
            <label class="form-check-label" for="ps_allow_extra_margin">Enable Extra Margin for Agents</label>
          </div>
        </div>
        <div class="col-md-6">
          <label class="form-label">Max Margin Percent (%)</label>
          <input type="number" step="0.01" class="form-control" name="max_margin_percent" placeholder="e.g. 10">
        </div>
        <div class="col-md-6">
          <label class="form-label">Max Flat Markup (per booking)</label>
          <input type="number" step="0.01" class="form-control" name="max_flat_markup" placeholder="e.g. 200">
        </div>
        <div class="col-12">
          <label class="form-label">Master Password</label>
          <input type="password" class="form-control" name="master_password" placeholder="Confirm with Admin Master Password">
        </div>
        <?php
          $allowOverride = in_array(strtolower((string)env('ALLOW_TX_KEY_OVERRIDE','false')), ['1','true','yes'], true);
          if ($allowOverride):
        ?>
        <div class="col-12">
          <label class="form-label">TX Key Override (base64, optional)</label>
          <input type="text" class="form-control" name="tx_key_override" placeholder="Dev/test only. Leave blank normally.">
          <div class="form-text">Used only for testing without server restart. Must be base64 for a 32-byte key.</div>
        </div>
        <?php endif; ?>
      </div>
    `;
    body.appendChild(setForm);
    // inline status area
    const status=document.createElement('div'); status.className='small'; status.style.cssText='padding:8px 12px;display:none;';
    body.appendChild(status);
    const ftr=document.createElement('div'); ftr.style.cssText='padding:10px 12px;border-top:1px solid #eee;display:flex;justify-content:flex-end;gap:8px;';
    const cancel=document.createElement('button'); cancel.type='button'; cancel.className='btn btn-outline-secondary btn-sm'; cancel.textContent='Cancel';
    const save=document.createElement('button'); save.type='button'; save.className='btn btn-success btn-sm js-settings-save'; save.textContent='Save Settings';
    ftr.appendChild(cancel); ftr.appendChild(save);
    setModal.appendChild(hdr); setModal.appendChild(body); setModal.appendChild(ftr);
    document.body.appendChild(setOverlay); document.body.appendChild(setModal);
    function show(){ setOverlay.style.display='block'; setModal.style.display='block'; }
    function hide(){ setOverlay.style.display='none'; setModal.style.display='none'; }
    setOverlay.addEventListener('click', hide); x.addEventListener('click', hide); cancel.addEventListener('click', hide);
    setModal.show = show; setModal.hide = hide;
    // Cache fields
    fldTxPass = setForm.querySelector('input[name="transaction_password"]');
    fldAllowWallet = setForm.querySelector('input[name="allow_wallet_transfer"]');
    fldReqTx = setForm.querySelector('input[name="require_tx_password"]');
    fldDailyLimit = setForm.querySelector('input[name="wallet_transfer_daily_limit"]');
    fldAllowAgent = setForm.querySelector('input[name="allow_agent_creation"]');
    fldAgentLimit = setForm.querySelector('input[name="agent_creation_limit"]');
    fldAllowAgentPw = setForm.querySelector('input[name="allow_agent_password_change"]');
    fldApi = setForm.querySelector('input[name="api_enabled"]');
    fldExtraMargin = setForm.querySelector('input[name="allow_extra_margin"]');
    fldMaxMarginPct = setForm.querySelector('input[name="max_margin_percent"]');
    fldMaxFlat = setForm.querySelector('input[name="max_flat_markup"]');
    setMaster = setForm.querySelector('input[name="master_password"]');
    fldTxKeyOverride = setForm.querySelector('input[name="tx_key_override"]');
    // AJAX submit to avoid page refresh
    setForm.addEventListener('submit', async function(ev){
      ev.preventDefault();
      status.style.display='none'; status.textContent=''; status.className='small';
      const fd = new FormData(setForm);
      const btn = document.querySelector('.js-settings-save');
      if (btn) { btn.disabled = true; btn.textContent = 'Saving…'; }
      try{
        const res = await fetch(setForm.action, { method:'POST', body: fd, headers:{ 'Accept':'application/json','X-Requested-With':'XMLHttpRequest' } });
        const data = await res.json().catch(()=>({ ok:false, error:'Invalid JSON' }));
        if (!res.ok || !data.ok){
          const msg = (data && (data.error || (data.errors && data.errors.join(' ')))) || ('HTTP '+res.status);
          status.textContent = msg || 'Failed to save.';
          status.style.display='block'; status.style.color='#b02a37';
        } else {
          status.textContent = data.message || 'Saved.';
          status.style.display='block'; status.style.color='#0a7d38';
        }
      } catch(err){
        status.textContent = 'Network error while saving.';
        status.style.display='block'; status.style.color='#b02a37';
      } finally {
        if (btn) { btn.disabled = false; btn.textContent = 'Save Settings'; }
      }
    });
  }

  async function openSettings(partnerId, partnerName){
    ensureSettingsModal();
    // Reset form
    setForm.reset();
    setForm.querySelector('input[name="id"]').value = partnerId;
    try {
      const res = await fetch(`/admin/management/partners/settings?id=${partnerId}`, { headers: { 'Accept':'application/json' }});
      if (!res.ok) throw new Error('Failed to load');
      const s = await res.json();
      fldAllowWallet.checked = !!Number(s.allow_wallet_transfer);
      fldReqTx.checked = !!Number(s.require_tx_password);
      fldDailyLimit.value = s.wallet_transfer_daily_limit ?? '';
      fldAllowAgent.checked = !!Number(s.allow_agent_creation);
      fldAgentLimit.value = s.agent_creation_limit ?? '';
      fldAllowAgentPw.checked = !!Number(s.allow_agent_password_change);
      fldApi.checked = !!Number(s.api_enabled);
      fldExtraMargin.checked = !!Number(s.allow_extra_margin);
      fldMaxMarginPct.value = s.max_margin_percent ?? '';
      fldMaxFlat.value = s.max_flat_markup ?? '';
    } catch (e) {
      // Leave defaults
    }
    setModal.show();
  }

  document.addEventListener('click', (ev)=>{
    const btn = ev.target.closest('.js-partner-settings');
    if (!btn) return;
    const pid = btn.getAttribute('data-partner-id');
    const pname = btn.getAttribute('data-partner-name') || '';
    openSettings(pid, pname);
  });

  // ===== Secure Generate PIN and gated View logic =====
  function secureRandomDigits(length){
    const arr = new Uint32Array(length);
    window.crypto.getRandomValues(arr);
    let s='';
    for (let i=0;i<length;i++) s += String(arr[i] % 10);
    // ensure first digit not zero
    if (s[0] === '0') s = String((arr[0] % 9) + 1) + s.slice(1);
    return s;
  }
  function generateTxPin(){
    if (!fldTxPass) return;
    // Generate exactly 6 digits
    const pin = secureRandomDigits(6);
    fldTxPass.value = pin;
    fldTxPass.dispatchEvent(new Event('input'));
  }
  function canReveal(){
    if (!setMaster) return false;
    if (!setMaster.value){
      setMaster.focus();
      setMaster.classList.add('is-invalid');
      setTimeout(()=>setMaster.classList.remove('is-invalid'), 1500);
      return false;
    }
    return true;
  }
  async function fetchStoredPinIfEmpty(){
    if (!fldTxPass || fldTxPass.value) return; // nothing to fetch
    const id = setForm.querySelector('input[name="id"]').value;
    const csrf = setForm.querySelector('input[name="csrf"]').value;
    const mpw = setMaster ? setMaster.value : '';
    if (!id || !csrf || !mpw) return;
    try{
      const formData = new FormData();
      formData.append('id', id);
      formData.append('csrf', csrf);
      formData.append('master_password', mpw);
      if (typeof fldTxKeyOverride !== 'undefined' && fldTxKeyOverride && fldTxKeyOverride.value) {
        formData.append('tx_key_override', fldTxKeyOverride.value.trim());
      }
      const res = await fetch('/admin/management/partners/settings/view_pin', { method:'POST', body: formData, headers:{ 'Accept':'application/json','X-Requested-With':'XMLHttpRequest' } });
      if (!res.ok) return;
      const data = await res.json();
      if (data && data.pin && /^\d{6}$/.test(data.pin)) { fldTxPass.value = data.pin; }
    } catch(e){ /* ignore */ }
  }

  let txVisible = false;
  async function toggleViewTx(){
    if (!fldTxPass) return;
    if (!txVisible){
      if (!canReveal()) return;
      await fetchStoredPinIfEmpty();
      fldTxPass.setAttribute('type','text');
      txVisible = true;
    } else {
      fldTxPass.setAttribute('type','password');
      txVisible = false;
    }
  }
  // Delegate button events (created dynamically)
  document.addEventListener('click', (e)=>{
    if (e.target && e.target.id === 'btnGenTxPin'){ e.preventDefault(); generateTxPin(); }
    if (e.target && e.target.id === 'btnViewTxPin'){ e.preventDefault(); toggleViewTx(); }
    if (e.target && e.target.classList && e.target.classList.contains('js-settings-save')){ e.preventDefault(); if (setForm) { setForm.dispatchEvent(new Event('submit', { cancelable:true })); } }
  });
})();
</script>
