<?php /** @var array $partner */ /** @var string $csrf */ ?>
<div class="container py-3">
  <div class="d-flex justify-content-between align-items-center mb-3">
    <h4 class="mb-0">Edit Channel Partner</h4>
    <a class="btn btn-sm btn-secondary" href="/admin/management/partners"><i class="bi bi-arrow-left"></i> Back</a>
  </div>

  <?php if (!empty($_SESSION['errors'])): ?>
    <div class="alert alert-danger py-2">
      <ul class="mb-0 small">
        <?php foreach ((array)$_SESSION['errors'] as $e): ?>
          <li><?= htmlspecialchars((string)$e) ?></li>
        <?php endforeach; unset($_SESSION['errors']); ?>
      </ul>
    </div>
  <?php endif; ?>

  <form method="post" action="/admin/management/partners/update" class="card">
    <input type="hidden" name="csrf" value="<?= htmlspecialchars($csrf) ?>">
    <input type="hidden" name="id" value="<?= (int)$partner['id'] ?>">
    <div class="card-body">
      <div class="row g-3">
        <div class="col-md-6">
          <label class="form-label">Partner Name</label>
          <input type="text" name="name" class="form-control" value="<?= htmlspecialchars($partner['name'] ?? '') ?>" required>
        </div>
        <div class="col-md-6">
          <label class="form-label">Contact Email</label>
          <input type="email" name="contact_email" class="form-control" value="<?= htmlspecialchars($partner['contact_email'] ?? '') ?>">
        </div>
        <div class="col-md-6">
          <label class="form-label">Contact Person</label>
          <input type="text" name="contact_person" class="form-control" value="<?= htmlspecialchars($partner['contact_person'] ?? '') ?>">
        </div>
        <div class="col-md-6">
          <label class="form-label">Mobile</label>
          <input type="text" name="contact_mobile" class="form-control" value="<?= htmlspecialchars($partner['contact_mobile'] ?? '') ?>">
        </div>
        <div class="col-md-6">
          <label class="form-label">WhatsApp</label>
          <input type="text" name="contact_whatsapp" class="form-control" value="<?= htmlspecialchars($partner['contact_whatsapp'] ?? '') ?>">
        </div>
        <div class="col-md-6">
          <label class="form-label">LINE</label>
          <input type="text" name="contact_line" class="form-control" value="<?= htmlspecialchars($partner['contact_line'] ?? '') ?>">
        </div>
        <div class="col-12">
          <label class="form-label">Address</label>
          <input type="text" name="address_line" class="form-control" value="<?= htmlspecialchars($partner['address_line'] ?? '') ?>" required>
        </div>
        <div class="col-md-4">
          <label class="form-label">City</label>
          <input type="text" name="city" class="form-control" value="<?= htmlspecialchars($partner['city'] ?? '') ?>" required>
        </div>
        <div class="col-md-4">
          <label class="form-label">State</label>
          <input type="text" name="state" class="form-control" value="<?= htmlspecialchars($partner['state'] ?? '') ?>">
        </div>
        <div class="col-md-4">
          <label class="form-label">Pincode</label>
          <input type="text" name="pincode" class="form-control" value="<?= htmlspecialchars($partner['pincode'] ?? '') ?>">
        </div>
        <div class="col-md-6">
          <label class="form-label">Country</label>
          <input type="text" name="country" class="form-control" value="<?= htmlspecialchars($partner['country'] ?? '') ?>" required>
        </div>
      </div>
    </div>
    <div class="card-footer d-flex justify-content-between">
      <div></div>
      <button type="submit" class="btn btn-primary"><i class="bi bi-save"></i> Save Changes</button>
    </div>
  </form>
</div>
